.286
;================================================
; invoke st2ft, real, string
;
; Convert an ascii string to a REAL10
; where string is '+(or -)integers[.decimals]',0
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

st2ft         proc    near  real:NPR10, string:NPB
              local   exp:SWORD, t:REAL10, r:REAL10

              pusha                             ;
              mov     si, string                ;
              mov     di, real                  ;
              cld                               ;

              invoke  load1, di                 ; real = 1.0

              .WHILE (1)                        ; skip whitespace
                 lodsb                          ;
                 .BREAK .IF (al != ' ')         ;
              .ENDW                             ;

              .IF (al == '-')                   ; if negative
                 or      word ptr [di]+8, 8000h ;
              .ELSEIF ((al != '+') && (al != '-'))
                 dec     si                     ;
              .ENDIF                            ;
;------------------------------------------------
; process integers
;------------------------------------------------
              xor     dx, dx                    ; DX = 0

              .WHILE (1)                        ;
                 lodsb                          ;
                 .BREAK .IF ((al < '0') || (al > '9'))
                 xor     ah, ah                 ;
                 sub     al, '0'                ; make binary word
                 invoke  itoft, addr t, ax      ; convert word to REAL10
                 invoke  ftmuli, di, +10        ; real * 10
                 invoke  ftadd, di, addr t      ; add digit

                 .IF (dx == 0)                  ;
                    invoke  ftsubi, di, +10     ;
                 .ENDIF                         ;
                 or      dx, 1                  ; once only
              .ENDW
;------------------------------------------------
; exit if no decimal point
;------------------------------------------------
              .IF (al != '.')
                 jmp     exit
              .ENDIF
;------------------------------------------------
; process decimals
;------------------------------------------------
              mov     exp, 0                    ; exp == 0
              invoke  load1, addr r             ; r[] = 1.00

              .WHILE (1)                        ;
                 lodsb                          ; load byte
                 .BREAK .IF ((al < '0') || (al > '9'))
                 xor     ah, ah                 ;
                 sub     al, '0'                ; make binary word
                 invoke  itoft, addr t, ax      ; convert word to REAL10
                 inc     exp                    ; exp++
                 mov     bx, exp                ; save exp

                 .WHILE (exp > 0)               ;
                    dec     exp                 ;
                    invoke  ftdivi, addr t, +10 ; t /= 10
                 .ENDW                          ;
                 mov     exp, bx                ; recover exp
                 invoke  ftadd, addr r, addr t  ; r[] += t[]
              .ENDW

              invoke  ftsubi, addr r, +1        ; r[] -= 1.00
              invoke  ftadd, di, addr r         ; real += r[]
exit:
              popa

              ret
st2ft         endp

cseg          ends
              end
