.286
;================================================
; invoke st2int, string
;
; Convert an ascii string to an INTEGER
; where string is '+(or -)integers',0
;
; Returns AX = integer.
;         AX = 0, if word overflow
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

st2int        proc    near uses bx cx dx si di, string:NPB

              mov     si, string                ;
              xor     cx, cx                    ;

              .WHILE (1)                        ; goto string end
                 .BREAK .IF (byte ptr [si] == 0);
                 inc     si                     ;
                 inc     cx                     ;
              .ENDW                             ;
              dec     si                        ;
              std                               ; reverse direction

              .WHILE (cx)                       ; find numerals
                 lodsb                          ;
                 inc     si                     ;
                 .BREAK .IF ((al >= '0') && (al <= '9'))
                 dec     si                     ;
                 dec     cx                     ;
              .ENDW                             ;

              mov     di, 1                     ;
              xor     bx, bx                    ;
              .WHILE (cx)                       ;
                 lodsb
                 .BREAK .IF ((al <= '0') || (al >= '9'))
                 xor     ah, ah                 ;
                 sub     al, '0'                ; AX = binary
                 mul     di                     ; AX *= DI
                 add     bx, ax                 ; add to result

                 .IF (CARRY?)                   ; if overflow
                    xor     ax, ax              ; AX = 0
                    jmp     exit                ;
                 .ENDIF                         ;

                 mov     ax, di                 ; next power of 10
                 mov     dx, 10                 ;
                 mul     dx                     ;
                 mov     di, ax                 ;

                 dec     cx                     ;
              .ENDW                             ;

              .IF (al == '-')                   ;
                 neg     bx                     ;
              .ENDIF                            ;

              mov     ax, bx
exit:
              ret
st2int        endp

cseg          ends
              end
