stdlib		segment	para public 'slcode'
		assume	cs:stdlib
;
; Keyboard input routines:
;
;
; InpVector- Points at the current keyboard input routine.
;
GetcAdrs	dd	sl_GetcStdIn
GetcStkIndx	dw	0
GetcStk		dd	16 dup (sl_GetcStdIn)
GSIsize		=	$-GetcStk
;
;
;
		public	sl_Getc
sl_Getc		proc	far
		jmp	dword ptr cs:GetcAdrs
sl_Getc		endp
;
;
; SetInAdrs- Stores ES:DI into InpVector which sets the new keyboard vector.
;
		public	sl_SetInAdrs
sl_SetInAdrs	proc	far
		mov	word ptr GetcAdrs, di
		mov	word ptr GetcAdrs+2, es
		ret
sl_SetInAdrs	endp
;
;
; GetInAdrs-	Returns the address of the current output routine in ES:DI.
;
		public	sl_GetInAdrs
sl_GetInAdrs	proc	far
		les	di, cs:GetcAdrs
		ret
sl_GetInAdrs	endp
;
;
;
; PushInAdrs-	Pushes the current input address onto the input stack
;		and then stores the address in es:di into the input address
;		pointer.  Returns carry clear if no problems.  Returns carry
;		set if there is an address stack overflow.  Does NOT modify
;		anything if the stack is full.
;
		public	sl_PushInAdrs
sl_PushInAdrs	proc	far
		push	ax
		push	di
		cmp	cs:GetcStkIndx, GSIsize
		jae	BadPush
		mov	di, cs:GetcStkIndx
		add	cs:GetcStkIndx, 4
		mov	ax, word ptr cs:GetcAdrs
		mov	word ptr cs:GetcStk[di], ax
		mov	ax, word ptr cs:GetcAdrs+2
		mov	word ptr cs:GetcStk+2[di], ax
		pop	di
		mov	word ptr cs:GetcAdrs, di
		mov	word ptr cs:GetcAdrs+2, es
		pop	ax
		clc
		ret
;
BadPush:	pop	di
		pop	ax
		stc
		ret
sl_PushInAdrs	endp
;
;
; PopInAdrs-	Pops an input address off of the stack and stores it into
;		the GetcAdrs variable.
;
		public	sl_PopInAdrs
sl_PopInAdrs	proc	far
		push	ax
		mov	di, cs:GetcStkIndx
		sub	di, 4
		jns	GoodPop
;
; If this guy just went negative, set it to zero and push the address
; of the stdout routine onto the stack.
;
		xor	di, di			
		mov	word ptr cs:GetcStk, offset sl_GetcStdIn
		mov	word ptr cs:GetcStk+2, seg sl_GetcStdIn
;
GoodPop:	mov	cs:GetcStkIndx, di
		mov	es, word ptr GetcAdrs+2
		mov	ax, word ptr cs:GetcStk+2[di]
		mov	word ptr cs:GetcAdrs+2, ax
		mov	ax, word ptr cs:GetcStk[di]
		xchg	word ptr cs:GetcAdrs, ax
		mov	di, ax
		pop	ax
		ret
sl_PopInAdrs	endp
;
;	
;
; GetcBIOS- 	Reads a character from the keyboard using the BIOS routines.
;
		public	sl_GetcBIOS
sl_GetcBIOS	proc	far
		mov	ah, 0
		int	16h
		ret		
sl_GetcBIOS	endp
;
;
;
; GetcStdIn- 	Reads a character from DOS' standard input.
;         
		public	sl_GetcStdIn                                                
sl_GetcStdIn	proc	far
		mov	ah, 7
		int	21h
		mov	ah, 0
		cmp	al, 0
		jnz	DOS_GetcX
;
; If DOS returned zero, get scan code and return in AX
;
		mov	ah, 7
		int	21h
		mov	ah, al
		mov	al, 0
DOS_GetcX:	ret
sl_GetcStdIn	endp
stdlib		ends
		end
