; ROOTS  Copyright (C) 1992-1994 by Celso Minnitti Jr. All Rights Reserved.
;
; Version:  0.2 (September-18-1994)
;
; Compile:  TASM /m2 example
;           TLINK /t /3 /x example
;
; I just wrote this program because I found quite interesting two new
; algorithms that developed to find N^2 and N^3 only using additions.
; To compute N^2 we need two registers and two ADDs.
; To compute N^3 we need three registers and three ADDs.
;
; Please note that:
;
;    1	 4   9	16  25	36  49
;     \-/ \-/ \-/ \-/ \-/ \-/
;      3   5   7   9   11  13	    (subtract 4-1, 9-4,...)
;	\-/ \-/ \-/ \-/ \-/
;	 2   2	 2   2	 2	    (2!) 2 factorial...
;
;
;    1	 8  27	64 125 216
;     \-/ \-/ \-/ \-/ \-/
;      7  19   37  61  91	    7 = 8-1    19 = 27-8    37 = 64-27
;	\-/  \-/  \-/  \-/
;	 12  18   24   30	    12=19-7    18 = 37-19   30 = 91-61
;	   \-/	\-/  \-/
;	    6	 6    6 	    (3!) 3 factorial...
;
; N^4 will require 4 additions and the constant to add is 24 (4!)...
; N^5 will require 5 additions and the constant to add is 120 (5!)...
; N^6 will require 6 additions and the constant to add is 720 (6!)...etc...
;
; If you find these algorithms interesting please let me know... If you
; have any questions or comments, please contact me at:
;
; Celso Minnitti Jr
; 139 Linden St
; Wellesley, MA 02181
; Home phone #: 617-235-4018
; email: celsomj@world.std.com


_TEXT   segment byte public 'CODE'
	assume cs:_TEXT, ds:_TEXT
	org    100h
.386

ANY_NUMBER	=	10000			;can be any number from
						;1 to 429101525 (0FFC3B3C9h)

start:		mov	ax,13h			;320x200x256
		int	10h

		cld				;just to be safe...
		mov	es,[vidseg]		;A000
		mov	di,150*320+10		;x = 10, y = 150
		mov	al,1			;color = blue
		mov	bx,140			;draw 140 pixels

draw_x1:	mov	es:[di],al		;draw y = x
		sub	di,319
		dec	bx
		jnz	draw_x1

		call	getch			;wait for a key

		mov	si,1
		mov	dx,1
		mov	bx,17			;draw 17 segments...
		mov	al,2			;color = green
		mov	di,150*320+10		;x = 10, y = 155

draw_x2:	mov	cx,si
		rep	stosb			;draw y = x^2
		add	si,2			;si=1,3,5,7,9...
		sub	di,320
		dec	bx
		jnz	draw_x2

		call	getch

                mov     dx,1                    ;
		mov	si,6			;3 factorial...
		mov	bx,6			;draw 6 segments
		mov	al,3			;color = cyan
		mov	di,150*320+10		;x = 10, y = 160

draw_x3:	mov	cx,dx			;
		rep	stosb			;draw y = x^3
		add	dx,si			;dx=1,7,19,37,61...
		add	si,6
		sub	di,320
		dec	bx
		jnz	draw_x3

		call	getch

		mov	ax,3			;return to 80x25
		int	10h

		mov	si,offset copyRight
                call    prints
                mov     si,offset message_1
                call    prints
		mov	eax,ANY_NUMBER
                call    print2d
                mov     si,offset message_11
                call    prints

		call	root22			;eax = sqrt, edx = reminder
                call    print2d
                mov     si,offset message_12
                call    prints
                mov     eax,edx
                call    print2d

                call    print_crlf
                mov     si,offset message_2
                call    prints
		mov	eax,ANY_NUMBER
                call    print2d
                mov     si,offset message_21
                call    prints

		call	root32			;eax = cubic_rt, edx = reminder
                call    print2d
                mov     si,offset message_22
                call    prints
                mov     eax,edx
                call    print2d

		int	20h			;exit to DOS

;**************************************************************************
;				 ROOT22
; enter:   EAX = 1 - 0FFFE0001h (4294836225=65535*65535)
; return:  EAX = square root
;	   EDX = reminder
;**************************************************************************
root22		proc	near
		push	ecx
		push	ebx

		xor	ecx,ecx
		inc	cx
		mov	edx,ecx
		mov	ebx,ecx 		 ;ecx=edx=ebx=1

root22_loop:	cmp	edx,eax
		je	short root22_ret
		ja	short root22_ret0

		add	ebx,2			 ;ebx=1,3,5,7 ,9 ,11,13...
		add	edx,ebx 		 ;edx=1,4,9,16,25,36,49...
		inc	ecx			 ;ecx=1,2,3,4 ,5 ,6 ,7 ...
		jmp	short root22_loop

root22_ret0:	dec	ecx
		sub	edx,ebx
root22_ret:	sub	edx,eax
		neg	edx
		mov	eax,ecx
		pop	ebx
		pop	ecx
		ret
root22		endp


;**************************************************************************
;				 ROOT32
; enter:   EAX = 1 - 0FFC3B3C9h (4291015625=1625*1625*1625)
; return:  EAX = cubic root
;	   EDX = reminder
;**************************************************************************
root32		proc	near
		push	ecx
		push	ebx
		push	esi

		xor	ecx,ecx
		inc	cx
		mov	edx,ecx
		mov	ebx,ecx 		 ;ecx=edx=ebx=1
		mov	esi,6

root32_loop:    cmp     edx,eax
		je	short root32_ret
		ja	short root32_ret0

		add	ebx,esi 		 ;ebx=7 ,19,37,61...
		add	esi,6			 ;esi=12,18,24,30...
		add	edx,ebx 		 ;edx=8 ,27,64,125...
		inc	ecx			 ;ecx=2 , 3, 4, 5
		jmp	root32_loop

root32_ret0:	dec	ecx
		sub	edx,ebx
root32_ret:	sub	edx,eax
		neg	edx
		mov	eax,ecx

		pop	esi
		pop	ebx
		pop	ecx
		ret
root32		endp


;**************************************************************************
;				PRINT2D
; enter:   EAX = # to print in decimal
;**************************************************************************
print2d 	proc	near
		push	eax
                push    cx
                push    edx
		push	ebx
		push	si

		xor	cx,cx
		mov	si,offset pbuff
		mov	ebx,10

pri21d: 	xor	edx,edx
		div	ebx
		add	dl,30h
		mov	[si],dl
		inc	si
		inc	cx
		or	eax,eax
		jnz	short pri21d

pri22d: 	dec	si
		mov	al,[si]
                call    putchar
		dec	cx
		jnz	pri22d

		pop	si
		pop	ebx
		pop	edx
		pop	cx
		pop	eax
		ret
print2d 	endp


;**************************************************************************
;				  PRINTS
; enter:   DS:SI = address of string
;**************************************************************************
prints		proc	near
		push	ax
		push	si
prints1:	mov	al,[si]
		inc	si
		or	al,al
		jz	prints_ret
		call	putchar
		jmp	prints1
prints_ret:	pop	si
		pop	ax
		ret
prints		endp


;**************************************************************************
;				 PUTCHAR
; enter:   AL = character to write
;**************************************************************************
putchar         proc    near
		push	ax
		push	cx
		push	bx
		mov	ah,0eh			 ;Teletype Output
		mov	cx,1			 ;# times
		mov	bh,0			 ;page number
		int	10h
		pop	bx
		pop	cx
		pop	ax
		ret
putchar         endp

;**************************************************************************
;				  GETCH
; return:  AH = scancode
;	   AL = character
;**************************************************************************
getch		proc	near
		mov	ah,0
		int	16h
		ret
getch		endp

print_crlf:     mov     si,offset crlf
                call    prints
                ret

copyRight	db	'ROOTS 0.2 (C) Copyright 1994  Celso Minnitti Jr',13,10,10,0
message_1       db      'The square root of ',0
message_11      db      ' is: ',0
message_12      db      '  .Reminder = ',0

message_2       db      'The cubic root of ',0
message_21      db      ' is: ',0
message_22      db      '  .Reminder = ',0
crlf            db      13,10,0

vidseg		dw	0a000h

pbuff		label	byte

_TEXT	ends
end	start

