 TITLE SHUNT:  Console to Auxiliary (RS232) Shunt

                .XLIST

DIVISOR_LATCH   EQU     003F8H    ;only if DIVSR_ENA active
TRANSMIT        EQU     003F8H    ;only if DIVSR_ENA inactive
RECIEVE         EQU     003F8H    ;only if DIVSR_ENA inactive

DIVIDE_BY_0     EQU     000H
SINGLE_STEP     EQU     001H
NON_MASKABLE    EQU     002H
BREAKPOINT      EQU     003H
OVERFLOW        EQU     004H
PRINT_SCREEN    EQU     005H
TIMER_INT       EQU     008H
KEYBOARD        EQU     009H
COM2_INT        EQU     00BH
COM1_INT        EQU     00CH
PRINTER         EQU     017H
BOOTSTRAP       EQU     019H
TIME_OF_DAY     EQU     01AH
KEY_BREAK       EQU     01BH
TIMER_TICK      EQU     01CH
VIDEO_INIT      EQU     01DH
MONO_GRAFICS    EQU     01FH

INTERUPT_ENA    EQU     003F9H
RECIEVE_INT     EQU     00000001B
TRANSMIT_INT    EQU     00000010B
ERROR_INT       EQU     00000100B
MODEM_INT       EQU     00001000B

LINE_CONTROL    EQU     003FBH
WORDLEN_LOW     EQU     00000001B
WORDLEN_HIGH    EQU     00000010B
STOP_BITS       EQU     00000100B
PARITY_ENA      EQU     00001000B
EVEN_PARITY     EQU     00010000B
STICK_PARITY    EQU     00100000B
SET_BREAK       EQU     01000000B
DIVISR_ENA      EQU     10000000B

MODEM_CONTROL   EQU     003FCH
DTR             EQU     00000001B
RTS             EQU     00000010B
OUT1            EQU     00000100B
OUT2            EQU     00001000B
TST_LOOP        EQU     00010000B

LINE_STATUS     EQU     003FDH
RECIEVE_FULL    EQU     00000001B
OVERRUN_BIT     EQU     00000010B
PARITY_BIT      EQU     00000100B
FRAMING_BIT     EQU     00001000B
BREAK_INT       EQU     00010000B
TRANS_EMPTY     EQU     00100000B
SHIFT_EMPTY     EQU     01000000B

MODEM_STATUS    EQU     003FEH
DELTA_CTS       EQU     00000001B
DELTA_DSR       EQU     00000010B
T_E_RING_DET    EQU     00000100B
DELTA_RX        EQU     00001000B
CTS             EQU     00010000B
DSR             EQU     00100000B
RING_INDICATOR  EQU     01000000B
REC_LINE_DET    EQU     10000000B

X_ON            EQU     011H
X_OFF           EQU     013H
EOF             EQU     01AH
CR              EQU     00DH
LF              EQU     00AH
BELL            EQU     007H

DOS_FUNCTION    EQU     021H
TERMINATE       EQU     000H
KEY_IN          EQU     001H
PRINT_CHAR      EQU     002H
AUX_IN          EQU     003H
AUX_OUT         EQU     004H
PRINTER_OUT     EQU     005H
DIR_CON_IO      EQU     006H
DIR_CON_IN      EQU     007H
KEY_IN_NOECHO   EQU     008H
PRINT_STRING    EQU     009H
BUFFERED_IN     EQU     00AH
CHECK_KEYBOARD  EQU     00BH
CANCEL_GET_KEY  EQU     00CH
DISK_RESET      EQU     00DH
SELECT_DISK     EQU     00EH
OPEN_FILE       EQU     00FH
CLOSE_FILE      EQU     010H
FIND_FILE       EQU     011H
FIND_NEXT       EQU     012H
DELETE_FILE     EQU     013H
READ_SEQUEN     EQU     014H
WRITE_SEQUEN    EQU     015H
CREATE_FILE     EQU     016H
RENAME_FILE     EQU     017H
CURRENT_DISK    EQU     019H
SET_DISK_TRANS  EQU     01AH
READ_RANDOM     EQU     021H
WRITE_RANDOM    EQU     022H
FILE_SIZE       EQU     023H
SET_INTERUPT    EQU     025H
READ_RAND_BLK   EQU     027H
WRITE_RAND_BLK  EQU     028H
PARSE_FILENAME  EQU     029H
GET_DATE        EQU     02AH
SET_DATE        EQU     02BH
GET_TIME        EQU     02CH
SET_TIME        EQU     02DH
SET_VERIFY      EQU     02EH
GET_DTA         EQU     02FH
GET_DOS_VERS    EQU     030H
GET_INTERUPT    EQU     035H

STACK           SEGMENT PARA STACK
                DB      64 DUP('STACK   ')
STACK           ENDS

CSEG            SEGMENT PARA
                ASSUME  CS:CSEG,DS:CSEG,ES:NOTHING
                .LIST
;*****
SHUNT:          JMP     START
;*****
                DB      03FEH DUP (0)

PUT_POINTER     DW      00000H
GET_POINTER     DW      00000H
COUNTER         DW      00000H
MAXIMUM         DW      003F0H
MINIMUM         DW      000FFH
ERRORS          DB      000H

ECHO_ERR        DB      LF
                DB      "Echoing Error"
                DB      LF, "$"
OVERRUN_ERR     DB      LF
                DB      "Overrun Error"
                DB      LF, "$"
FRAMING_ERR     DB      LF
                DB      "Framing Error"
                DB      LF, "$"
OUT_HANG_ERR    DB      LF
                DB      "Cannot Transmit"
                DB      LF, "$"

;********************************************************************

;receive buffer full interupt service routine

;************
GET_CHARACTER   PROC    FAR
;************
                STI
                PUSH    ES
                PUSH    AX
                PUSH    DX
                PUSH    DI
                PUSH    DS

                MOV     AX, CS
                MOV     DS, AX
                MOV     ES, AX

                MOV     AX, [COUNTER]
                CMP     AX, [MAXIMUM]
                JB      NO_HALT

                MOV     DX, MODEM_CONTROL
                MOV     AL, DTR + OUT2
                OUT     DX, AL

NO_HALT:        MOV     DX, LINE_STATUS
                IN      AL, DX
                MOV     AH, AL
                OR      [ERRORS], AL
                TEST    AL, FRAMING_BIT+PARITY_BIT+OVERRUN_BIT
                MOV     DI, [PUT_POINTER]
                MOV     DX, RECIEVE
                JZ      NO_ERRS

                MOV     AL, BELL
                STOSB
                AND     DI, 0000001111111111B
                MOV     AL, "{"
                STOSB
                AND     DI, 0000001111111111B
                MOV     AL, AH
                AND     AL, 00FH
                OR      AL, 030H
                STOSB
                AND     DI, 0000001111111111B
                MOV     AL, "}"
                STOSB
                AND     DI, 0000001111111111B
                ADD     [COUNTER], 4

NO_ERRS:        IN      AL, DX
                STOSB
                AND     DI, 0000001111111111B
                MOV     [PUT_POINTER], DI
                INC     COUNTER

                MOV     AL, 01100100B
                OUT     020H, AL

                POP     DS
                POP     DI
                POP     DX
                POP     AX
                POP     ES

                IRET
;               ******************************

GET_CHARACTER   ENDP

;********************************************************************

;****
START           PROC    NEAR
;****
                CLD
                MOV     DX, CS
                MOV     DS, DX

                MOV     AL, COM1_INT
                MOV     DX, OFFSET GET_CHARACTER
                MOV     AH, SET_INTERUPT
                INT     DOS_FUNCTION

                MOV     AL, RECIEVE_INT
                MOV     DX, INTERUPT_ENA
                OUT     DX, AL

                MOV     DX, LINE_STATUS
                IN      AL, DX

                MOV     DX, RECIEVE
                IN      AL, DX

                IN      AL, 021H
                AND     AL, 11101111B
                OUT     021H, AL

                STI

BIG_LOOP:       MOV     AX, [MINIMUM]
                CMP     AX, [COUNTER]
                JB      DONT_START

                MOV     AL, DTR + RTS + OUT2
                MOV     DX, MODEM_CONTROL
                OUT     DX, AL

DONT_START:     CMP     [COUNTER], 00
                JZ      NONE_YET

                DEC     [COUNTER]
                MOV     SI, [GET_POINTER]
                LODSB
                AND     SI, 001111111111B
                MOV     [GET_POINTER], SI

                MOV     DL, AL
                MOV     AH, DIR_CON_IO
                INT     DOS_FUNCTION

NONE_YET:       MOV     DX, LINE_STATUS
                IN      AL, DX
                TEST    AL, TRANS_EMPTY
                JZ      BIG_LOOP

                MOV     AH, DIR_CON_IO
                MOV     DL, 0FFH
                INT     DOS_FUNCTION
                JZ      BIG_LOOP

                MOV     AH, AL
                OR      AL, AL
                JZ      ABORT
                CMP     AL, EOF
                JZ      ABORT

                MOV     AL, AH
                MOV     DX, TRANSMIT
                OUT     DX, AL                

                JMP     BIG_LOOP
;               ******************************

ABORT:          IN      AL, 021H
                OR      AL, 00010000B
                OUT     021H, AL

                MOV     AH, KEY_IN_NOECHO
                INT     DOS_FUNCTION

                PUSH    ES
                XOR     AX, AX
                PUSH    AX

FAKE            PROC    FAR
                RET
;               ******************************
FAKE            ENDP

START           ENDP

CSEG            ENDS

;********************************************************************

                END     SHUNT
                .XLIST
