;   The following library should be combined with XLIBB.LIB using the Borland
;TLIB utility.

               MASM51                        ;Enforce MASM 5.1 compatibility
               QUIRKS                        ;Allow MASM 5.1 quirks

PUSHW          MACRO IMMEDIATE16:REST        ;Macro to PUSH 16-bit constant
               IF (@WordSize EQ 4)
               DB             66H
               ENDIF
               DB             68H
               DW             IMMEDIATE16
               ENDM

PUSHD          MACRO IMMEDIATE32:REST        ;Macro to PUSH 32-bit constant
               IF (@WordSize EQ 2)
               DB             66H
               ENDIF
               DB             68H
               DD             IMMEDIATE32
               ENDM

               .MODEL         LARGE,PASCAL
               .386
               .387

               INCLUDE        XLIBB.INC

CSEG           SEGMENT PARA PUBLIC USE16 'CODE'
               ASSUME CS:CSEG, DS:DSEG

;Function to calculate linear address from segment address on stack.
;Returns linear address in EAX and DX:AX.
LINADR         PROC FAR, SEGADR:DWORD
               XOR            EAX,EAX        ;Clear high words
               XOR            EDX,EDX
               MOV            AX,WORD PTR SEGADR[2]
               MOV            DX,WORD PTR SEGADR[0]
               SHL            EAX,4         ;Calculate linear address
               ADD            EAX,EDX
               MOV            EDX,EAX
               SHR            EDX,16         ;Return linear address in DX:AX
               RET
LINADR         ENDP

;Structure defining control block for SUMARRAY.
ARRAYDATA      STRUC
  CONDCODE     DD             0              ;Condition code
  N            DD             0              ;Number of elements to sum
  ADDRESS      DD             0              ;Address of first element
  SUM          DD             0              ;Sum of array elements
ARRAYDATA      ENDS

;Real-mode interface to SUMARRAY32.  Segment address of control block having
;structure ARRAYDATA should be on the stack.
SUMARRAY       PROC FAR, CBSEGADR:DWORD
               MOV            EAX,CBSEGADR   ;Will convert to linear address
               PUSH           EAX
               CALL           LINADR         ;Will use linear address in EAX
               PUSHD          OFFSET SUMARRAY32
               CALL           ENTERPM        ;Execute SUMARRAY32 in protected
               RET
SUMARRAY       ENDP

CSEG           ENDS

TSEG           SEGMENT PARA PUBLIC USE32 'CODE'
               ASSUME CS:TSEG, SS:TSEG, DS:TSEG, ES:TSEG, FS:DSEG, GS:DGROUP

               LARGESTACK

;Sum the elements of a single precision array.  Array parameters are stored
;in a control block having structure of ARRAYDATA.  The linear address of the
;control block is contained in EAX.  An error code of -1 is returned in the
;condition code of the control block if the number of array elements is zero.
;Observe that this routine will be called with DS = FLATDSEL (flat-model data
;descriptor).
SUMARRAY32     PROC NEAR
               MOV            EDX,[EAX].ADDRESS             ;Get array address
               MOV            ESI,[EAX].N                   ;Get N
               SUB            ESI,1
               JB             NODATA                        ;Error:  N = 0
               FLDZ                                         ;Initialize sum
SUMLOOP:       FADD           DWORD PTR [EDX+4*ESI]
               SUB            ESI,1
               JAE            SUMLOOP
               FSTP           [EAX].SUM                     ;Save sum
               RET
NODATA:        MOV            [EAX].CONDCODE,-1             ;Record error code
               RET
SUMARRAY32     ENDP

TSEG           ENDS
               END
