
/* BUFFER.C Rutiner som skapar och administrerar FIFO buffert.  */
/* 1990 Jan Edmundson.                                          */
/* Rutinerna r fria att anvndas av vem som helst.             */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "global.h"

/* initierar en buffert anvnds bara till statiska buffertar */

void init_buf(BUF *p)
{
   p->begin = &(p->data[0]);
   p->end = &(p->data[BUFSIZE-1]);
   p->head = p->tail = p->begin;
   p->status = ZEROSTAT;
}


/* Skapar och initierar en buffert. Stller head och tail till    */
/* buffertens brjan. returvrdet r noll om efterfrgat utrymme  */
/* inte finns tillgngligt                                        */

BUF *make_buf(unsigned int n)
{
   BUF *p;

   p = NULL;
   if (n >= 1) {
      p = (BUF *)malloc(sizeof(BUF)+(n-1)*sizeof(int));
      if (p != NULL) {
         p->begin = p->data;
         p->end = p->data+(n-1)*sizeof(int);
         p->head = p->tail = p->begin;
         p->status = ZEROSTAT;
         }
      }
   return (p);
}


/* Lser ett tecken frn buffert. returvrdet r 0xffff om     */
/* om buffert r tom eller lst                                */

unsigned int read_buf(BUF *p)
{
   unsigned int c;

   c = 0xffff;
   if ((p != NULL) && ((p->status & READLOCK) == 0) && (p->tail != p->head)) {
      p->tail++;
      if (p->tail >= p->end)
         p->tail = p->begin;
      c = *p->tail;
      }
   return (c);
}


/* Skriver ett tecken till buffert. returvrdet r TRUE om  */
/* det lyckades annars FALSE                                */

int write_buf(BUF *p, unsigned int c)
{
   int *q;
   
   if ((p == NULL) || ((p->status & WRITELOCK) == WRITELOCK))
      return (FALSE);
   q = p->head;
   q++;
   if (q >= p->end)
      q = p->begin;
   if (q == p->tail) {
      return (FALSE);
      }
   else
      *q = c;
      p->head = q;
      return (TRUE);
}

/* Skriver en strng till bufferten, TRUE om det lyckades annars FALSE */

int write_buf_str(BUF *p, char *s)
{
   int flag;

   flag = TRUE;
   while (*s != '\0' && flag)
      flag = flag && write_buf(p, *s++);
   return (flag);
}

/* Nollstller bufferten */

int flush_buf(BUF *p)
{
   if (p != NULL) {
      p->head = p->tail = p->begin;
      }
   return (p != NULL);
}

/* stter eller terstller status p bufferten */

int status_buf(BUF *p, int stat, int f)
{
   if (p != NULL) {
      if (f)
         p->status |= stat;
      else
         p->status &= ~stat;
      }
   return (p != NULL);
}

/* tittar i bufferten och kopierar till strng */

int look_buf_str(BUF *p, char *s)
{
   int *q;

   *s = '\0';
   if (p != NULL && p->tail != p->head) {
      q = p->tail;
      do {
         q++;
         if (q >= p->end)
            q = p->begin;
         *s++ = (unsigned char)*q;
      } while (q != p->head);
      *s = '\0';
      }
   return (p != NULL && p->tail != p->head);
}
