/* DECLARE.H - Globala typdeklarationer. */
/* "AURORA" (c) 1989, 1990 Nils Hammar */

/*	Fr versttning av teckenuppsttningar, se p ungefr rad 380. */

/*	I do not guarantee that this program is free of errors.
	You may use it on your own risc.

	This code may be used complete or partly by anyone as long as
	i am credited for being involved in the source.
	The credits MUST appear possible to read when starting the derived
	program, and in the documentation and manual in the form:
	"Contains code (c) 1990 Nils Hammar" in any language of:
	Swedish, English or German preferably.

	It is free to spread this code and programs hereof both free
	and if code is added for money as long as i am credited for it.
	Excluding of code MUST be by comments, and when code is included
	there MUST be a comment which describes WHO has done it, WHY,
	and WHEN. All changes and additions should be reported to me
	to determine if they should be included in further versions.

	All necessary text translations will be in GLOBAL.H and
	possibly in PRIVS.H if translation to another language is necessary.

	Extensions of H-files in different languages:
	.SWE	Swedish
	.ENG	English
	.SUO	Finnish
	.GER	German

	Adding code to one file MUST be added to the others, in
	at least english.

	If you find any Bugs or Errors i would be grateful to recieve reports
	about them, and if there exists the corrected code.
*/

#define SYSTEMVERSION	"AURORA 1.34A"

#define TRUE 1
#define FALSE 0

/* #define ZONESEENBY	/* Uncomment this if zones is allowed in the SEEN-BY
			   lines. */

/* #define ZONEPATH	/* Uncomment this if zones is allowed in the ^APATH
			   lines. */

typedef struct
{
	long int
		moetstatus,
		lastread;
} moetdata;

typedef struct
{
	unsigned int		zone, region, net, hubnr, nodes, status;
	unsigned long int	startpos;
	char			netname[40];
} netlist;

/*
	Fr nodlistan gller fljande:

	Status:		Bit.	Funktion:
			0	Up/Down.
			1	Hold.
			2	Private.
			3	Hub.
			4	Host.
*/

typedef struct
{
	unsigned int	zone,
			region,
			net,
			hubnr,
			node,
			azone,
			aregion,
			anet,
			anode,
			status,
			packer;

	char		nodename[25],
			location[25],
			sysop[36],
			telnumber[25];
} nodelist;

typedef struct
{
	unsigned char		systemname[60];
	unsigned int		zone, region, net, node, point, moetstatus,
					operator;
	long int		lastread, maintprivs, fileprivs, textprivs;
	unsigned int		failtype, pointnet, sysflags, minpacks,
					packlimit, routeage;
	unsigned long int	packetnumber, timeout;
} systemdata;

typedef struct
{
	unsigned char	systemname[60];
	unsigned int	zone, region, net, node, point;

	moetdata
		memberinfo[256];
} nodestruct;

typedef struct
{
	unsigned int	zone, region, net, node, point;
} ncodestruct;

typedef struct
{
	char
		dummy[1],
		username[36],
		password[36],
		adress[30],
		postnr[12],
		postadress[30],
		tel[20],
		lastlogin[20],
		termtype[15];

	unsigned int
		terminal,
		colour,
		editor,
		lines,
		columns,
		charset,
		status,
		logins;

	unsigned long int
		maintprivs,
		fileprivs,
		textprivs;

	long int
		totaltime, maxlogintime;

	moetdata
		memberinfo[256];
} userrec;

typedef struct
{
	char
		dummy[2],
		username[36],
		password[36],
		adress[30],
		postnr[12],
		postadress[30],
		tel[20],
		lastlogin[20];

	unsigned int
		termmodel,
		colour,
		editor,
		commandmode,
		lines,
		columns,
		charset,
		status,
		logins;

	unsigned long int
		maintprivs,
		fileprivs,
		textprivs;

	long int
		totaltime, maxlogintime;

	moetdata
		memberinfo[256];
} userrec2;

typedef struct
{
	char		dummy[1],typ[2];
	long int	texts, firsttext, creator, parameters, defcharset;
	char		namn[80], echoarea[80];
} meetrec;

typedef struct
{
	int	pars;
	char	par[20][20];
} comnd;

typedef struct
{
	unsigned long int	startpos, cretime, kommptr, commlist[80];
	unsigned int		len, creator, kommusr, type,
				crenode, destnode, crenet, destnet,
				fromnet, fromnode;
	unsigned char		subject[80], creuser[40], touser[40],
				msgid[36];
	unsigned int		destzone, destpoint;
	unsigned char		tclinfo[36];
	unsigned int		crezone, crepoint;
} textindexstruct;

/*	Detta r en gammal version. Ny finns nedan.

	typedef struct
	{
		unsigned int	orignode, destnode, year, month, day, hour, minute,
			second, baud, idcode, orignet, destnet;
		unsigned char	pcode, filler[33];
	} packheader;
*/
/*	Enligt FTS-0001.014, denna lgger vi inte p, eftersom den r
	inkompatibel med tidigare versioner. */
/*
	typedef struct
	{
		unsigned int	orignode, destnode, year, month, day, hour,
					minute, second, baud, idcode, orignet,
					destnet;
		unsigned char	pcode, serialno, password[8], origzone,
					destzone, filler[18];
	} packheader;

*/

/*	Enligt FTS-0001.012 (Nstan, filler skall vara 16 bytes
	enligt den specen, men r i verkligheten 18! Dessutom
	r specen *MYCKET* felaktig strukturmssigt. */

/*	typedef struct
	{
		unsigned int	orignode, destnode, year, month, day, hour, minute,
					second, baud, idcode, orignet, destnet;
		unsigned char	pcode, serialno, password[8];
		unsigned int	origzone, destzone;
		unsigned char	filler[18];
	} packheader;
*/

/* Efter en text frn Tomas Stjernstrom! (Kontrollerat dataformatet)
   Det spelar dock ingen strre roll numera skulle jag tro, s lnge
   som vi r baktkompatibla.
   Fltet PASSWORD r egentligen inte 20 tecken stort, utan r en kombination
   av PASSWORD och utfyllnad. */

/*	typedef struct
	{
		unsigned int	orignode, destnode, year, month, day, hour,
				minute, second, baud, idcode, orignet, destnet;
		unsigned char	pcode, serialno, password[20];
		unsigned int	origzone, destzone;
		unsigned char	filler[8];
	} packheader;
/*

/*	Enligt definition i FSC-0039.001 (Kompatibel med tidigare version) */

typedef struct
{
	unsigned int	orignode,	/* 0 */
			destnode,	/* 2 */
			year,		/* 4 */
			month,		/* 6 */
			day,		/* 8 */
			hour,		/* 10 */
			minute,		/* 12 */
			second,		/* 14 */
			baud,		/* 16 */
			idcode,		/* 18 */
			orignet,	/* 20 */
			destnet;	/* 22 */

	unsigned char	pcode,		/* 24    LSB */
			serialno,	/* 25    Major */
			password[8];	/* 26 */

/* 		12 bytes med ny definition nedan */

	unsigned int	zorigzone,	/* 34 */
			zdestzone;	/* 36 */

	unsigned char	filler1[2];	/* 38 */

	unsigned int	capwordc;	/* 40 */

	unsigned char	pcodeh,		/* 42    MSB */
			serialnol;	/* 43    Minor */

	unsigned int	capword,	/* 44 */
			origzone,	/* 46 */
			destzone,	/* 48 */
			origpoint,	/* 50 */
			destpoint;	/* 52 */

	unsigned char	filler[4];	/* 54 */
} packheader;

typedef struct
{
	unsigned int	idcode, orignode, destnode, orignet, destnet,
			attribute, cost;
} packmessage;

typedef struct
{
	char	logdr[80];
	char	physdr[5];
	char	basepath[30];
	int	limit;
} logdrdata;

typedef struct
{
	char		filename[15];
	unsigned int	usernumber, group;
	char		descript[256];

/*	"group" r det mte man mste vara medlem i fr att f se filen.
	det gr dock att ladda ner den nd, men d mste man veta
	att den finns. */

} filerecstruct;

typedef struct
{
	char			flag;
	unsigned int		meet, zone, net, node;
	unsigned long int	lastread;
} areastruct;

#ifdef MSDOS
struct FILEINFO
{
	char		rsvd[21];
	char		attr;
	unsigned int	time;
	unsigned int	date;
	long		size;
	char		name[13];
	char		nill;
};
#endif
