/* EDIT.C - En radeditor fr kortare texter. */
/* (c) 1989, 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"  /* Deklaration av konstanter och texter. */

#ifndef MSDOS
#include <unistd.h>
#endif


/*	Packa texten, s att avslutande blanka erstts med CRLF */

void	packtext(textarea, lines)
char	*textarea;
int	lines;
{
	unsigned char	*sec_ptr,*prim_ptr;
	int		i;

	sec_ptr=textarea;

	for(i=0;i<lines;i++)
	{
		prim_ptr=textarea+user.columns*i;
		while((*sec_ptr++ = *prim_ptr++) !=0);

		if ((unsigned int) *(sec_ptr - 2) == 0x8d)
		{
			*(--sec_ptr)=0;
			*(--sec_ptr)=0;
			--sec_ptr;
		}
		else
		{
			*(--sec_ptr)=13;
		}
		sec_ptr++;
	}
	*sec_ptr=0;
}

/*	Lista text ur buffert p skrmen rad fr rad. */

void	listtext(textarea,line)
char	*textarea;
int	line;
{
	int	i;

	sprintf(fotxt, "\n\n");
	fpr(fotxt);
	for (i=0; i<line; i++)
	{
		sprintf(fotxt, "%3d%s%s\n",
			(i + 1), LISTPROMPT, (textarea + (i * user.columns)));
		fpr(fotxt);
	}
}

/*	Editera en rad i texten. */

int	changeline(textarea, param, line)
char	*textarea;
int	param, line;
{
	char	*oldval, *retval, prompt[40];
	int	i;

	if (param < 1 || param > line)
	{
		sprintf(fotxt, "\n%s\n", ILLPARAM);
		fpr(fotxt);
		return(line);
	}

	oldval=textarea+(param-1)*user.columns;
	sprintf(fotxt, "\n\n%3d%s%s", param, ORIGPROMPT, oldval);
	fpr(fotxt);

	sprintf(fotxt, "\n");
	fpr(fotxt);
	sprintf(prompt,"%3d%s", param, CHANGEPROMPT );
	retval=calloc(user.columns, sizeof(char));

	if (retval == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	i=lineed(retval , prompt, oldval, user.columns, 0);

	if (i >=0 && *retval != 0)
	{
		oldval=textarea+(param-1)*user.columns;
		for (i=0;(unsigned int)i<user.columns;i++)
			*(oldval + i) = *(retval + i);
	}
	newline();
	free(retval);
	return(line);
}

/*	Radera en rad i texten. */

int	deleteline(textarea, param, line)
char	*textarea;
int	param, line;
{
	char	*oldval, *newval;
	int	i;

	if (param < 1 || param > line)
	{
		sprintf(fotxt, "\n%s\n", ILLPARAM);
		fpr(fotxt);
		return(line);
	}

	oldval=textarea+(param-1)*user.columns;
	newval=textarea+param*user.columns;

	for(i=(param * user.columns);i < (line * user.columns); i++)
		*(oldval++) = *(newval++);

	return(line-1);
}

/*	Skjut in en rad i texten. */

int	insertline(textarea, param, line)
char	*textarea;
int	param, line;
{
	char	*oldval, *newval, prompt[40];
	int	i;

	if (param < 1 || param > line)
	{
		sprintf(fotxt, "\n%s\n", ILLPARAM);
		fpr(fotxt);
		return(line);
	}
	if (line >= MAXLINES)
	{
		sprintf(fotxt, "\n%s\n", INSNOTALL);
		fpr(fotxt);
		return(line);
	}

	sprintf(fotxt, "\n\n");
	fpr(fotxt);
	oldval=textarea+line*user.columns;
	newval=textarea+(line + 1)*user.columns;

	for(i=(line * user.columns);i >= ((param - 1) * user.columns); i--)
		*(newval--) = *(oldval--);

	sprintf(prompt,"%3d%s", param, INSERTPROMPT);
	oldval=textarea+(param - 1)*user.columns;
	i=lineed(oldval , prompt, "", user.columns, 0);

	return(line+1);
}

/*	Skjut in en rad i texten. */

int	insertfile(textarea, param, line)
char	*textarea, *param;
int	line;
{
	unsigned char	*oldval, *tmp;
	unsigned int	c, col;
	FILE		*f;

	while(*param == ' ') param++;

	if ((f=fopen(param, "r")) == NULL)
	{
		tmp=_strerror(param);
		fpr(tmp);
		return(line);
	}

	if (line >= MAXLINES)
	{
		sprintf(fotxt, "\n%s\n", INSNOTALL);
		fpr(fotxt);
		return(line);
	}

	sprintf(fotxt, "\n\n");
	fpr(fotxt);

	oldval=textarea+line*user.columns;
	col=1;

	while((c=fgetc(f)) != EOF && line < MAXLINES)
	{
		if (c >= ' ' && c != 0x8d)
		{
			*(oldval++)=(unsigned char)c;
			col++;
		}

		if (c == '\n')
		{
//			*(oldval++)='\r';
			*(oldval++)=0;
			line++;
			col=1;
			oldval=textarea+line*user.columns;
		}

		if (col >= user.columns - 4)
		{
			*(oldval++)=0;
			line++;
			col=1;
			oldval=textarea+line*user.columns;
		}
	}

	fclose(f);
	return(line+1);
}

/*	Lista editorkommandon. */

void	listcommand()
{
	sprintf(fotxt, "\n\n"); fpr(fotxt);
	sprintf(fotxt, "l = %s\n", LISTTEXT); fpr(fotxt);
	sprintf(fotxt, "c = %s\n", CHANGETEXT); fpr(fotxt);
	sprintf(fotxt, "d = %s\n", DELETETEXT); fpr(fotxt);
	sprintf(fotxt, "i = %s\n", INSERTTEXT); fpr(fotxt);
	sprintf(fotxt, "e = %s\n", SAVEIN); fpr(fotxt);
	sprintf(fotxt, "q = %s\n", ABORTTEXT); fpr(fotxt);
	sprintf(fotxt, "g = %s\n", INCLUDEFILE); fpr(fotxt);
	sprintf(fotxt, "%s\n", EDSYNTAX); fpr(fotxt);
	sprintf(fotxt, "%s\n", INFOLINE); fpr(fotxt);
}

/*	Tolka kommando givet i editor. */

int	commandline(textarea, cmnd, line)
char	*cmnd, *textarea;
int	line;
{
	char	komm[3], *par, tmp[3];
	int	param,retur;

	retur=line;

	*komm=*(cmnd+1);
	*(komm+1)=0;

	par=calloc(user.columns, sizeof(char));

	if (par == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	strcpy(par,(cmnd+2));
	param=atoi(par);
	free(par);

	lower(tmp, komm);

	switch (*tmp)
	{
		case	'l' : listtext(textarea,line);
			break;
		case	'c' : retur=changeline(textarea, param, line);
			break;
		case	'd' : retur=deleteline(textarea, param, line);
			break;
		case	'i' : retur=insertline(textarea, param, line);
			break;
		case	'e' : return(-2);
		case	'q' : return(-3);
		case	'g' : return(insertfile(textarea, (cmnd+2), line)-1);
		case	'?' : listcommand();
			break;

		default:     sprintf(fotxt, "\n%s\n", ILLCMD);
				fpr(fotxt);
				break;
	}
	return(--retur);
}

/*	Huvudrutin fr editering av text. */
/* JANNE */

int	edittext(textarea, maxlines, buffarea)
				     /* Adressen till textarean, samt antal */
char	*textarea, *buffarea[];
				     /* rader som texten fr ha. Textarean */
int	maxlines;		     /* mste minst ha plats till detta */
{				     /* rader. user.columns deklareras i */
	int	line=0,i,empty=0,r;  /* global.h */
	char	prompt[40], *tmp;

#ifdef MSDOS
	if (user.editor != 0)
	{
		return(edittext2(textarea, maxlines));

/*		startbuf = textarea;
		endbuf = startbuf+maxlines*user.columns;
		curloc = endloc = startbuf;

		w.X1 = 1; w.X2 = 79; w.Y1 = 20; w.Y2 = 24;
		for (i=0; i < w.Y2-w.Y1+1; i++)
		fpr("\n");

		if (ansiedit()) return (0);
		else return (-1); */
	}
	else
#endif
	{
		i=0;
		strcpy(textstore, "");

	   	while(line < maxlines && i == 0 && empty < MAXEMPTYLINES)
	   	{
   			tmp=textarea+line*user.columns;
   
	   		sprintf(fotxt, "\n");
   			fpr(fotxt);
   			sprintf(prompt,"%3d%s", line+1, NORMALPROMPT);
   
   			for (i=0;(unsigned int)i<user.columns;i++) *(tmp + i) = 0;
   
			if (maxlines < 20)
			{
	   			i=lineed( tmp , prompt, buffarea[line],
					user.columns-6, 2);
				if (i == 2) i=0;
			}
			else
			{
	   			i=lineed( tmp , prompt, buffarea[line],
					user.columns-6, 3);
				if (i == 2) i=0;
			}

   			if (*tmp == 0) empty++; else empty=0;

   			if (*tmp == '!' && i >= 0)
   			{
   				r=0;
   				r=commandline(textarea, tmp, line);
   				if (r >= -1) line=r; else line--;
   				if (r == -2) i=1;
   				if (r == -3) i=-1;
   				if (r == -4) i=-2;
   			}
   
	   		line++;
	   	}
   
	   	if (i < 0) return(i);
   
	   	packtext(textarea, line);

	   	return(0);
	}
}

void	mailfile()
{
	int		z, maxtext, i;
	char		*textarea, slask[80], filename[80], klocka[30];
	FILE		*f, *g;

	moetnumber=1;

	env=getenv("ADATA");
	sprintf(slask, "%sLOADFILE.CFG", env);

#ifdef MSDOS
	if ((f=fopen(slask, "rt")) == NULL)
#else
	if ((f=fopen(slask, "r")) == NULL)
#endif
	{
		sprintf(fotxt, SHOWFERR, slask);
		perror(fotxt);
		return;
	}

	printf(LOADINGFILES, slask);

	textarea=NULL;

#ifdef MSDOS
	textarea=halloc((unsigned long int)MAXLINES * 80, sizeof(char));
#else
	textarea=calloc(MAXLINES * 80, sizeof(char));
#endif

	if (textarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	i=0;

	while(fgets(filename, 78, f) != NULL)
	{

		i=0;
		while(*(filename + i) != 0 && i < 78)
		{
			if (*(filename + i) < ' ') *(filename + i)=0;
			i++;
		}

#ifdef MSDOS
		if ((g=fopen(filename, "rb")) != NULL)
#else
		if ((g=fopen(filename, "r")) != NULL)
#endif
		{
			maxtext=getmaxtext(1);
			z=gettextindex(1, maxtext);
			maxtext++;

			tiden(klocka);

			sprintf(textarea, TEXTHEAD1,
				maxtext+meetinf.firsttext,
				meetinf.namn, klocka);

			i=0;
			while(*(textarea+i) != 0) i++;

			sprintf((textarea + i), TEXTINFOHEAD2,
				"AURORA", 0, "Sysop", 1,
				" * AURORA file loader * ");

			i=0;
			while(*(textarea+i) != 0) i++;

			while(fgets((textarea + i), 160, g) != NULL)
			{
				i=0;
				while(*(textarea+i) != 0) i++;
			}

			fclose(g);

			printf(textarea);

			textindex.startpos=sistatextpos;
			textindex.len=i;
			textindex.fromnode=sysdata.node;
			textindex.fromnet=sysdata.net;
			textindex.destzone=sysdata.zone;
			textindex.destnet=sysdata.net;
			textindex.destnode=sysdata.node;
			textindex.destpoint=sysdata.point;
			textindex.creator=0;
			textindex.kommusr=1;

			for (i=0;i<79;i++) textindex.commlist[i]=0L;

			strcpy(textindex.subject, " * AURORA file loader * ");
			strcpy(textindex.creuser, "AURORA");
			strcpy(textindex.touser, "Sysop");

			textindex.type=5;

			storetext(textarea);
			z=puttextindex(maxtext);
			putmaxtext(1, maxtext);

			unlink(filename);
		}
		else
		{
			sprintf(fotxt, SHOWFERR, filename);
			perror(fotxt);
			return;
		}
	}

#ifdef MSDOS
	hfree(textarea);
#else
	free(textarea);
#endif

	fclose(f);
}
