/* FILES.C  Filhanteringsdelen (UP/DOWNLOAD, Dir, Del, Move... */
/* (c) 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#define INCL_DOS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "privs.h"

#include "global.h"

#ifndef MSDOS
#include <unistd.h>
#endif

#ifdef MSDOS

#include <dos.h>
#include <malloc.h>
#include <direct.h>

int	direntry(dta, name, times)
struct FILEINFO	*dta;
char		*name;
int		times;
{
	union REGS	r;

	r.x.dx = FP_OFF(dta);
	r.h.ah = 0x1a;
	intdos (&r, &r);
	r.x.bx = 0;
	r.x.cx = ~0x08;
	r.x.dx = FP_OFF(name);
	r.x.si = 0;
	r.x.di = 0;
	if (times == 0)
	{
		r.h.ah = 0x4e;
		intdos (&r, &r);
		dta->nill = '\0';
		if (r.x.cflag != 0)
		{
			dta->name[0] = '\0';
			return (1);
		}
		return (0);
	}
	else
	{
		r.h.ah = 0x4f;
		intdos (&r, &r);
		dta->nill = '\0';
		if (r.x.cflag != 0)
		{
			dta->name[0] = '\0';
			return (1);
		}
		return (0);
	}
}

int	dirlist(namn, sortarea)
char	*namn, *sortarea;
{
	struct FILEINFO dta[1];
	char		slask[30], tmp[30];
	int		z, i, j, n;

	i=0;
	j=0;
	z=direntry(dta, namn, i);
	strcpy(sortarea, "");

	while (z == 0)
	{
		if (strcmp(dta->name, ".") != 0 &&
			strcmp(dta->name, "..") != 0 &&
			('' != *dta->name ||
			(dta->attr & 16) == 0 ||
			(user.fileprivs & FIL_REMDISK) != 0))
		{
			dtidkonv(dta->time, dta->date, slask);

			strcpy(tmp, dta->name);

			n=0;
			while(*(tmp+n) != 0) n++;
			while(n<13)
			{
				*(tmp+n)=' ';
				n++;
				*(tmp+n)=0;
			}

			if ((dta->attr & 16) != 0)
				sprintf((sortarea + j*45),DIRENTRY, tmp);
			else
				sprintf((sortarea + j*45),"%s%9ld %s",
					tmp, dta->size, slask);

			j++;
			strcpy((sortarea + j*45), "");
		}

		i++;
		z=direntry(dta, namn, i);
	}

	qsort(sortarea, j, 45, strcmp);

	return(j);
}

int	getfileinfo(namn, infotxt, usernrp)
char	*namn, *infotxt;
int	*usernrp;
{
	FILE	*f;
	int	i, n;
	char	tmp[40];

	upper(tmp, namn);
	strcpy(namn, tmp);

	strcpy(infotxt, "");

	newline();

	if ((f=fopen("INFOFILE.###", "rb")) == NULL)
	{
		perror(INFOERR1);
		return(0);
	}

	while (fread((char *)&filerec, sizeof(filerecstruct), 1, f) != 0)
	{
		if (strcmp(namn, filerec.filename) == 0 &&
			strcmp(namn, "") != 0)
		{
			*usernrp=filerec.usernumber;

			i=0;
			n=1;

			strcpy(infotxt, filerec.descript);

			while(*(infotxt+i) != 0)
			{
				if (*(infotxt + i) == '\n') n++;
				i++;
			}

			fclose(f);
			return(n);
		}
	}

	fclose(f);
	return(0);
}

int	putfileinfo(namn, infotxt, usernr)
char	*namn, *infotxt;
int	usernr;
{
	FILE			*f;
	int			n;
	unsigned long int	position;
	char			tmp[40];

	upper(tmp, namn);
	strcpy(namn, tmp);

	newline();

	if ((f=fopen("INFOFILE.###", "rb+")) == NULL)
	{
		if ((f=fopen("INFOFILE.###", "wb+")) == NULL)
		{
			perror(INFOERR2);
			return(0);
		}
	}

/*	Leta efter frsta befintliga. */

	position=0L;

	while (fread((char *)&filerec, sizeof(filerecstruct), 1, f) != 0)
	{
		if (strcmp(namn, filerec.filename) == 0 &&
			strcmp(namn, "") != 0)
		{
			filerec.usernumber=usernr;
			strcpy(filerec.filename, namn);
			strcpy(filerec.descript, infotxt);

			fseek(f, position, SEEK_SET);

			fwrite((char *)&filerec, sizeof(filerecstruct), 1, f);

			fpr(INFOUPDATED);

			fclose(f);
			return(n);
		}
		position=ftell(f);
	}

/*	Leta efter frsta blankade. */

	position=0L;

	fseek(f, position, SEEK_SET);

	while (fread((char *)&filerec, sizeof(filerecstruct), 1, f) != 0)
	{
		if (strcmp(filerec.filename, "") == 0 &&
			strcmp(namn, "") != 0)
		{
			filerec.usernumber=usernr;
			strcpy(filerec.filename, namn);
			strcpy(filerec.descript, infotxt);

			fseek(f, position, SEEK_SET);

			fwrite((char *)&filerec, sizeof(filerecstruct), 1, f);

			fpr(INFONEW1);

			fclose(f);
			return(n);
		}
		position=ftell(f);
	}

	filerec.usernumber=usernr;
	strcpy(filerec.filename, namn);
	strcpy(filerec.descript, infotxt);

	fseek(f, 0L, SEEK_CUR);

	fwrite((char *)&filerec, sizeof(filerecstruct), 1, f);

	fpr(INFONEW2);

	fclose(f);
	return(0);
}

void	freefileinfo(namn)
char	*namn;
{
	FILE			*f;
	unsigned long int	position;
	char			tmp[40];

	upper(tmp, namn);
	strcpy(namn, tmp);

	newline();

	if ((f=fopen("INFOFILE.###", "rb+")) == NULL)
	{
		perror(INFOERR1);
		return;
	}

	position=0L;

	while (fread((char *)&filerec, sizeof(filerecstruct), 1, f) != 0)
	{
		if (strcmp(namn, filerec.filename) == 0 &&
			strcmp(namn, "") != 0)
		{
			strcpy(filerec.filename, "");
			strcpy(filerec.descript, "");

			fseek(f, position, SEEK_SET);

			fwrite((char *)&filerec, sizeof(filerecstruct), 1, f);

			fclose(f);
			return;
		}
		position=ftell(f);
	}

	fpr(NOTCLEARED);

	fclose(f);
	return;
}

void	editinfo(namn)
char	*namn;
{
	char		infotxt[512], *buffarea[8], *slask;
	int		z, i, j, n;
	unsigned int	usernr;

	slask=calloc(512, sizeof(char));

	if (slask == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	for (z=0;z<8;z++)
	{
		buffarea[z]=calloc(80, sizeof(char));

		if (buffarea[z] == NULL)
		{
			printf(ALLOCERROR);
			logg(ALLOCERROR, 0);
			exit(9);
		}

		strcpy(buffarea[z], "");
	}

	z=getfileinfo(namn, infotxt, &usernr);

	if (z>0)
	{
		i=0;
		n=0;
		j=0;

		while (*(infotxt + j) != 0)
		{
			if (*(infotxt + j) != '\n' && *(infotxt + j) != '\r')
				*(buffarea[i] + n)=*(infotxt + j);

			n++;

			if (*(infotxt + j) == '\n')
			{
				n=0;
				i++;
			}
			j++;
		}
	}

	if (usernr <= 0 || usernr > users) usernr=1;

	z=getuserinfo(usernr);

	if (strcmp(user2.username, "") == 0)
	{
		usernr=1;
		z=getuserinfo(usernr);
	}
	
	sprintf(fotxt, FILEOWNER, user2.username, usernr);
	fpr(fotxt);

	if ((user.fileprivs & FIL_FILEMSGS) == 0)
	{
		for (i=0;i<8;i++)
		{
			free(buffarea[i]);
		}
		free(slask);
		return;
	}

	if ((user.fileprivs & FIL_FILEMSGR) == 0 && usernr != usernumber)
	{
		for (i=0;i<8;i++)
		{
			free(buffarea[i]);
		}
		free(slask);
		return;
	}

	z=edittext(slask, 3, buffarea);

	for (i=0;i<8;i++)
	{
		free(buffarea[i]);
	}

	if (z<0)
	{
		free(slask);
		return;
	}

	strcpy(infotxt, slask);

	free(slask);

	z=putfileinfo(namn, infotxt, usernr);
}

int	fileinfo(namn, infotxt)
char	*namn, *infotxt;
{
	FILE	*f;
	int	i, n, z, r;

	strcpy(infotxt, "");

	if ((f=fopen("INFOFILE.###", "rb")) == NULL)
	{
		return(0);
	}

	while (fread((char *)&filerec, sizeof(filerecstruct), 1, f) != 0)
	{
		if (subcompstr(namn, filerec.filename) == 0)
		{
			z=getuserinfo(filerec.usernumber);

			sprintf(infotxt, FILEOWNER2,
				user2.username, filerec.usernumber,
				"                        ");

			i=0;
			n=1;
			r=0;

			while(*(infotxt+i) != 0) i++;

			while(*(filerec.descript + r) != 0)
			{
				*(infotxt + i)=*(filerec.descript + r);
				i++;
				*(infotxt + i)=0;

				if (*(filerec.descript + r) == '\n')
				{
					strcat(infotxt,
						"                        ");
					i=0;
					while(*(infotxt+i) != 0) i++;
				}
				r++;
			}

			i=0;

			while(*(infotxt+i) != 0)
			{
				if (*(infotxt + i) == '\n') n++;
				i++;
			}

			fclose(f);
			return(n);
		}
	}

	fclose(f);
	return(0);
}

void	listdir(namn)
char	*namn;
{
	char	*sortarea, slask[80], tmp[512];
	int	j, i, rad, z;

	sortarea=halloc(65535L, sizeof(char));

	if (sortarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

 	j=dirlist(namn, sortarea);

	rad=0;

	newline();
	newline();

	for (i=0;i<j;i++)
	{
		strcpy(slask, "");
		z=0;

		while(*(sortarea + 45*i + z) != ' ' &&
			*(sortarea + 45*i + z) != 0)
		{
			*(slask+z)=*(sortarea + 45*i + z);
			z++;
		}
		*(slask+z)=0;

		strcpy(tmp, "");

		if (strcmp(slask, "") != 0) z=fileinfo(slask, tmp);

		sprintf(fotxt, "%s  %s\n", (sortarea + i*45), tmp);
		fpr(fotxt);

/*		fpr(tmp); */

		if (z != 0)
		{
			rad=rad+z-1;
		}

		rad++;
		if ((unsigned int)rad > user.lines-4)
		{
			strcpy(fotxt, "");
			strcpy(slask, PRESSRETURN);
			if (ansi == 1) sprintf(slask, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

			if (ansi == 2) sprintf(slask, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			z=lineed(fotxt, slask, "", 20, 0);
			if (z < 0 || strcmp(fotxt, "") != 0)
			{
				hfree(sortarea);
				return;
			}
			newline();
			rad=0;
		}
	}

	hfree(sortarea);
}

#endif

void	loadunits()
{
	FILE	*f;
	int	i, n, r;
	char	tmp[80];

	i=LOGDR;

	env=getenv("ADATA");

	sprintf(fotxt, "%sDEVICES.CFG", env);

/*	Om filen DEVICES.CFG finns, kan vi anvnda definitionerna i den. */

	if ((f = fopen(fotxt, "r")) != NULL)
	{
		i=0;

		while(fgets(tmp, 78, f) != NULL)
		{
			if (*tmp != ';')
			{
				n=0;
				r=0;
				while(*(tmp + n) != ',' && (tmp + n) != 0)
				{
					*(drives[i].logdr + r)=*(tmp + n);
					n++;
					r++;
					*(drives[i].logdr + r)=0;
				}

				while(*(tmp + n) == ',' && (tmp + n) != 0)
					n++;

				r=0;
				while(*(tmp + n) != ',' && (tmp + n) != 0)
				{
					*(drives[i].physdr + r)=*(tmp + n);
					n++;
					r++;
					*(drives[i].physdr + r)=0;
				}

				while(*(tmp + n) == ',' && (tmp + n) != 0)
					n++;

				r=0;
				while(*(tmp + n) != ',' && (tmp + n) != 0)
				{
					*(drives[i].basepath + r)=*(tmp + n);
					n++;
					r++;
					*(drives[i].basepath + r)=0;
				}

				while(*(tmp + n) == ',' && (tmp + n) != 0)
					n++;

				drives[i].limit = atoi((tmp + n));

				i++;
			}
		}
		fclose(f);
	}
	logdrs=i;
}

void	showfile(parameters, fl)
char	*parameters;
int	fl;
{
	FILE	*f;
	char	tmp[162], tmp2[162], slask[80];
	int	rad, z;

	if (fl == 0) fl=0;
	if ((f=fopen(parameters, "r")) == NULL)
	{
		sprintf(tmp, SHOWFERR, parameters);
		fpr(tmp);
		return;
	}

	rad=0;

	while (fgets(tmp, 160, f) != 0)
	{

		strcpy(tmp2, tmp);

		fpr(tmp2);
		rad++;

		if ((unsigned int)rad > user.lines-4)
		{
			strcpy(fotxt, "");
			strcpy(slask, PRESSRETURN);
			if (ansi == 1) sprintf(slask, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

			if (ansi == 2) sprintf(slask, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			z=lineed(fotxt, slask, "", 20, 0);
			if (z < 0 || strcmp(fotxt, "") != 0)
			{
				fclose(f);
				return;
			}
			newline();
			rad=0;
		}
	}
	fclose(f);
}

void	strippath(utdata, indata)
char	*utdata, *indata;
{
	int	i, n;

	n=0;
	while(*(indata + n) != 0)
	{
		switch (*(indata + n))
		{
			case ':' :
			case '/'  :
			case '!'  : *(indata + n)='\\';
		}
		n++;
	}

	i=0;
	n=0;

	while (*(indata + i) != 0)
	{
		if (*(indata + i) == '\\') n=i+1;
		i++;
	}

	strcpy(utdata, (indata + n));
}

int	findunit()
{
	unsigned int	d;
	char		tmp[80], tmp2[80];

	getcwd(tmp, 58);

	strcpy(tmp2, tmp);

	d=0;
	while (d < logdrs && instring(drives[d].physdr, tmp) != 0) d++;
	if (d == logdrs)
	{
		return(65);
	}

	return((int)d);
}

void	changedir(directory)
char	*directory;
{
	char		indata[30], sumpath[60];
	int		n, r, x, d, z;

	newline();

/*	Kolla frst om det verkligen r tilltet att byta bibliotek. */

	if ((user.fileprivs & FIL_CHDIR) == 0)
	{
		fpr(NOCHDIRPRIV);
		logg(NOTCHDIRPRV, 1);
		return;
	}

	upper(indata, directory);


/*	Om det inte finns parametrar, eller parametern "?" finns,
	s visa de olika diskarna i systemet. */

	while(strcmp(indata, "") == 0)
	{
		fpr(DIRPARAMS);
		z=lineed(indata, ">", "", 70, 0);
		newline();
		if (z<0) return;

		if (strcmp(indata, "?") == 0)
		{
			newline();

			for (d=0;d<(int)logdrs;d++)
			{
				sprintf(fotxt, "%4s  %s\n",
					drives[d].physdr,
					drives[d].logdr);

				fpr(fotxt);
			}

			newline();
			strcpy(indata, "");
		}
	}

/*	verstt mjliga biblioteksseparatorer till "/". */

	n=0;
	while(*(indata + n) != 0)
	{
		switch (*(indata + n))
		{
			case '\\' : *(indata + n)='/';
		}
		n++;
	}

/*	Kolla om ngon disk har angivits. */

	d=0;
	while (d < (int)logdrs && instring(drives[d].physdr, indata) != 0) d++;

	x=0;

/*	'x' stts till sann om enhet var angiven, eller om path inleddes med
	att peka p roten p aktuell disk. D skall vi utnyttja
	virtuell rot. */

	r=0;
	if (d < (int)logdrs) {r=strlen(drives[d].physdr); x=1;} /* Enhet var
								   angiven. */

	else d=(findunit() & 63);	 /* Enhet var inte angiven -
					    ta reda p aktuell! */

/*	Om det var negativt enhetsnummer blev det ngot fel. */

	if (d < 0) return;

	while (*(indata + r) == '/') { r++; x=1; }

/*	Om limit > 1 r den valda enheten begrnsad fr vanliga anvndare. */

	if (drives[d].limit > 1 && (user.fileprivs & FIL_REMDISK) == 0)
	{
		fpr(NOREMDISKPRIV);
		logg(NOTREMDISK, 1);
		return;
	}

/*	G till vald disk. */

	strcpy(fotxt, (indata + r));

/*	if ( strcmp( (indata + r), "") != 0 && x == 1)
		sprintf(fotxt, "/%s", (indata + r)); */

	if (x == 1)	sprintf(sumpath, "%s%s", drives[d].basepath, fotxt);
	else		sprintf(sumpath, "%s", fotxt);

	sprintf(fotxt, "\nDrive : %s  Path : %s\n", drives[d].physdr, sumpath);
	fpr(fotxt);

 	system(drives[d].physdr);

 	if (chdir(sumpath) != 0)
	{
		newline();
		fpr(NOCHDIRPRIV);
		newline();
	}
}

void	directory(param1, param2)
char	*param1, *param2;
{
	char	tmp1[80], tmp2[60];

	newline();

	if ((user.fileprivs & FIL_DIR) == 0)
	{
		fpr(NODIRPRIV);
		logg(NOTDIRPRV, 1);
		return;
	}

	strippath(tmp1, param1);
	strippath(tmp2, param2);

#ifndef MSDOS
	sprintf(fotxt, "ls %s %s > %s", tmp1, tmp2, tempfile);
	lower(tmp1, fotxt);

	system(tmp1);

	showfile(tempfile, 0);
#else
	if (strcmp(tmp2, "") != 0)
	{
		listdir(tmp2);
		return;
	}

	if (strcmp(tmp1, "") != 0)
	{
		listdir(tmp1);
		return;
	}

	listdir("*.*");
#endif

}

void	searchfile(parameters)
char	*parameters;
{
	char	tmp[60];

	newline();

	if ((user.fileprivs & FIL_SEEK) == 0)
	{
		fpr(NOSEARCHPRIV);
		logg(NOTSEARCHPRV, 1);
		return;
	}

	strippath(tmp, parameters);

	if (strcmp(tmp, "") == 0)
	{
		fpr(NOPATTERN);
		return;
	}

	sprintf(fotxt, "SEARCH  %s%s /name %s /ls > %s",
		drives[0].physdr, drives[0].basepath, tmp, tempfile);
	lower(tmp, fotxt);
	system(tmp);

	showfile(tempfile, 2);
}

void	typefile(parameters)
char	*parameters;
{
	int	z;
	char	tmp[60];

	newline();

	if ((user.fileprivs & FIL_SEND) == 0)
	{
		fpr(NOSENDPRIV);
		logg(NOTSENDPRV, 1);
		return;
	}

	while(strcmp(parameters, "") == 0)
	{
		z=lineed(parameters, TYPEPARAMS, "", 70, 0);
		newline();
		if (z<0) return;
	}

	strippath(tmp, parameters);
	showfile(tmp, 0);
}

/*	"direction" kan vara "LIST", "PACK" eller "UNPACK" */

void	archandle(param1, param2, direction, param3)
char	*param1, *param2, *direction, *param3;
{
	int	i, n, r, z, ok1, ok2;
	char	tmp[60], tmp2[128], types[20][3], name[20][20],
		desc[20][80], func[20][80], dir[20][10];
	FILE	*f;

	updateuser(1);

	newline();

	env=getenv("ADATA");

	sprintf(fotxt, "%sARCHIVE.CFG", env);

	if ((f = fopen(fotxt, "rt")) == NULL)
	{
		fpr(NODIRPRIV);
		logg(NOTDIRPRV, 1);
		return;
	}

	i=0;

	while(fgets(tmp2, 126, f) != NULL)
	{
		if (*tmp2 != ';')
		{
			n=0;
			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<18)
			{
				*(name[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(name[i]+r)=0;

/*	Om namnet skulle vara fr lngt! */

			while (*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n') n++;

			if (*(tmp2+n) == '|') n++;

			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<8)
			{
				*(dir[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(dir[i]+r)=0;

/*	Om namnet skulle vara fr lngt! */

			while (*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n') n++;

			if (*(tmp2+n) == '|') n++;

			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<78)
			{
				*(desc[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(desc[i]+r)=0;

/*	Om beskrivningen skulle vara fr lng! */
			while (*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n') n++;

			if (*(tmp2+n) == '|') n++;

			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<2)
			{
				*(types[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(types[i]+r)=0;

/*	Om typbeskrivningen skulle vara fr lng! */
			while (*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n') n++;

			if (*(tmp2+n) == '|') n++;

			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<78)
			{
				*(func[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(func[i]+r)=0;

			if (strcmp(dir[i], direction) == 0) i++;
		}
	}

	fclose(f);

	if ((user.fileprivs & FIL_DIR) == 0)
	{
		fpr(NODIRPRIV);
		logg(NOTDIRPRV, 1);
		return;
	}

	ok1=1;
	ok2=1;

	while (strcmp(param1, "") == 0)
	{
		ok1=0;

		if (strcmp("LIST", direction) == 0) fpr(LISTARCSYNTAX);
		if (strcmp("PACK", direction) == 0) fpr(CONVERTSYNTAX);
		if (strcmp("UNPACK", direction) == 0) fpr(CONVERTSYNTAX);

		newline();

		r=0;

		while (r<i)
		{
			sprintf(fotxt, "%20s : %s\n",
				name[r], desc[r]);
			fpr(fotxt);
			r++;
		}

		newline();

		if (strcmp("LIST", direction) == 0)
			z=lineed(param1, ARCHPAR1, "", 70, 0);

		if (strcmp("PACK", direction) == 0)
			z=lineed(param1, ARCHPAR2, "", 70, 0);

		if (strcmp("UNPACK", direction) == 0)
			z=lineed(param1, ARCHPAR2, "", 70, 0);

		newline();
		if (z<0) return;
	}

	r=0;
	while(instring(param1, name[r]) != 0 && r < i) r++;

	n=atoi(types[r]);

	while (strcmp(param2, "") == 0)
	{
		ok2=0;
		if (ok1 != 0)
		{
			if (strcmp("LIST", direction) == 0) fpr(LISTARCSYNTAX);
			if (strcmp("PACK", direction) == 0) fpr(CONVERTSYNTAX);
			if (strcmp("UNPACK", direction) == 0)
				fpr(CONVERTSYNTAX);

			r=0;

			while (r<i)
			{
				sprintf(fotxt, "%20s : %s\n",
					name[r], desc[r]);
				fpr(fotxt);
				r++;
			}

		}

		z=lineed(param2, ARCHPAR4, "", 70, 0);

		newline();
		if (z<0) return;
	}

	if (r >= i)
	{
		fpr(BADPROTOCOL);
		logg(BADPROT, 2);
		return;
	}

	strippath(tmp, param2);

	switch (n)
	{
		case 1 : sprintf(fotxt, func[r], tmp, tempfile); break;
		case 2 : sprintf(fotxt, func[r], param2, param3, tempfile);
			 break;
	}

#ifdef MSDOS
	if(baud > 0)
	{
		deinitfossil();
	}
#endif
	system(fotxt);
#ifdef MSDOS
	if(baud > 0)
	{
		initfossil();
	}
#endif
	showfile(tempfile, 0);
}

void	listarc(param1, param2)
char	*param1, *param2;
{
	archandle(param1, param2, "LIST", "");
}

void	convert(param1, param2, param3)
char	*param1, *param2, *param3;
{
	unsigned int	d;

/*	TEMPDIR r ett bibliotek som innehller blandade temporrfiler
	vid t.ex. ompackning av filer. */

	if (*(tempdir + strlen(tempdir)) == '\\')
		*(tempdir + strlen(tempdir))=0;

	sprintf(fotxt, "rm -f %s\\*.* > %s", tempdir, tempfile);
	system(fotxt);
	showfile(tempfile, 0);

	archandle(param1, param3, "UNPACK", tempdir);

	d=0;
	while(drives[d].limit != 1 && drives[d].limit != 3 && d<logdrs) d++;

	changedir(drives[d].physdr);

	archandle(param2, param3, "PACK", tempdir);
}

/*	"direction" r antingen "UP" eller "DOWN" */

void	transfer(param1, param2, direction)
char	*param1, *param2, *direction;
{
	unsigned int		d;
	int			i, n, r, z;
	unsigned long int	temppriv;
	char			tmp[60], tmp2[128], types[20][3], name[20][20],
				desc[20][80], func[20][80], dir[20][10];
	FILE			*f;

	updateuser(1);

	newline();

	env=getenv("ADATA");

	sprintf(fotxt, "%sPROTOCOL.CFG", env);

	if ((f = fopen(fotxt, "rt")) == NULL)
	{
		fpr(NORECPRIV);
		logg(NOTRECPRV, 1);
		return;
	}

	i=0;

	while(fgets(tmp2, 126, f) != NULL)
	{
		if (*tmp2 != ';')
		{
			n=0;
			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<18)
			{
				*(name[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(name[i]+r)=0;

/*	Om namnet skulle vara fr lngt! */
			while (*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n') n++;

			if (*(tmp2+n) == '|') n++;

			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<8)
			{
				*(dir[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(dir[i]+r)=0;

/*	Om riktningen skulle vara fr lng! */
			while (*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n') n++;

			if (*(tmp2+n) == '|') n++;

			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<78)
			{
				*(desc[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(desc[i]+r)=0;

/*	Om beskrivningen skulle vara fr lng! */
			while (*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n') n++;

			if (*(tmp2+n) == '|') n++;

			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<2)
			{
				*(types[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(types[i]+r)=0;

/*	Om typbeskrivningen skulle vara fr lng! */
			while (*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n') n++;

			if (*(tmp2+n) == '|') n++;

			r=0;
			while(*(tmp2+n) != '|' && *(tmp2+n) != 0 &&
				*(tmp2+n) != '\n' && r<78)
			{
				*(func[i]+r)=*(tmp2+n);
				r++;
				n++;
			}
			*(func[i]+r)=0;

			if (strcmp(dir[i], direction) == 0) i++;
		}
	}

	fclose(f);

	if ((user.fileprivs & FIL_REC) == 0)
	{
		fpr(NORECPRIV);
		logg(NOTRECPRV, 1);
		return;
	}

	while (strcmp(param1, "") == 0)
	{
		if (strcmp("UP", direction) == 0) fpr(RECSYNTAX);
		else fpr(SENDSYNTAX);

		newline();

		r=0;

		while (r<i)
		{
			sprintf(fotxt, "%20s : %s\n",
				name[r], desc[r]);
			fpr(fotxt);
			r++;
		}


		newline();

		z=lineed(param1, TRANSPAR1, "", 70, 0);
		newline();
		if (z<0) return;
	}


/*	Vid UPLOAD fr alla komma t UPLOAD-biblioteket! */

	if (strcmp("UP", direction) == 0)
	{
		d=0;
		while(drives[d].limit != 1 &&
			drives[d].limit != 3 && d<logdrs) d++;

		temppriv=user.fileprivs;
		user.fileprivs=(user.fileprivs | FIL_CHDIR | FIL_REMDISK);
		changedir(drives[d].physdr);
		user.fileprivs=temppriv;
	}

	r=0;
	while(instring(param1, name[r]) != 0 && r < i) r++;

	n=atoi(types[r]);

	while (strcmp(param2, "") == 0 && n==2 && strcmp("UP", direction) == 0)
	{
		fpr(RECXSYNTAX);

		d=0;
		while(drives[d].limit > 1 && d<logdrs) d++;
		changedir(drives[d].physdr);

		z=lineed(param2, TRANSPAR2, "", 70, 0);
		newline();
		if (z<0) return;
	}

	if (strcmp(param2, "") != 0 && n!=2 && strcmp("UP", direction) == 0)
	{
		fpr(RECSYNTAX);

		d=0;
		while(drives[d].limit > 1 && d<logdrs) d++;
		changedir(drives[d].physdr);

		return;
	}

	while (strcmp(param2, "") == 0 && strcmp("UP", direction) != 0)
	{
		fpr(SENDSYNTAX);

		z=lineed(param2, TRANSPAR3, "", 70, 0);
		newline();
		if (z<0) return;
	}

	if (r >= i)
	{
		fpr(BADPROTOCOL);
		logg(BADPROT, 2);

		if (strcmp("UP", direction) == 0)
		{
			d=0;
			while(drives[d].limit > 1 && d<logdrs) d++;
			changedir(drives[d].physdr);
		}
		return;
	}

	strippath(tmp, param2);

	switch (n)
	{
		case 1 : sprintf(fotxt, func[r], env, baud); break;
		case 2 : sprintf(fotxt, func[r], tmp); break;
		case 3 : sprintf(fotxt, func[r]); break;
		case 4 : sprintf(fotxt, func[r], env, baud, tmp); break;
	}

#ifdef MSDOS
	if(baud > 0)
	{
		deinitfossil();
	}
#endif
	system(fotxt);
#ifdef MSDOS
	if(baud > 0)
	{
		initfossil();
	}
#endif

	if (strcmp("UP", direction) == 0)
	{
		d=0;
		while(drives[d].limit > 1 && d<logdrs) d++;
		changedir(drives[d].physdr);
	}
}

void	upload(param1, param2)
char	*param1, *param2;
{
	transfer(param1, param2, "UP");
}

void	download(param1, param2)
char	*param1, *param2;
{
	transfer(param1, param2, "DOWN");
}

void	movefile(par1, par2)
char	*par1, *par2;
{
	int	z;

	newline();

	if ((user.fileprivs & FIL_MOVE) == 0)
	{
		fpr(NOMOVEPRIV);
		logg(NOTMOVEPRV, 1);
		return;
	}

	while (strcmp(par1, "") == 0)
	{
		z=lineed(par1, MOVEPAR1, "", 70, 0);
		newline();
		if (z<0) return;
	}

	while (strcmp(par2, "") == 0)
	{
		z=lineed(par2, MOVEPAR1, "", 70, 0);
		newline();
		if (z<0) return;
	}

	sprintf(fotxt,"Moving \"%s\" to \"%s\"\n", par1, par2);
	fpr(fotxt);

/*	if (rename(par1, par2) != 0)
	{
		sprintf(fotxt, "%s not moved to %s!\r\n", par1, par2);
		fpr(fotxt);
	} */

	sprintf(fotxt, "MV %s %s > %s", par1, par2, tempfile);
	system(fotxt);
	showfile(tempfile, 0);
}

void	deletefile(parameters)
char	*parameters;
{
	int	z;
	char	tmp1[60];

	newline();

	if ((user.fileprivs & FIL_DELETE) == 0)
	{
		fpr(NODELETEPRIV);
		logg(NOTDELETEPRV, 1);
		return;
	}

	while (strcmp(parameters, "") == 0)
	{
		z=lineed(parameters, DELPAR1, "", 70, 0);
		newline();
		if (z<0) return;
	}

	strippath(tmp1, parameters);

	sprintf(fotxt, "rm -f %s > %s", tmp1, tempfile);
	system(fotxt);
	showfile(tempfile, 0);
}

void	makedir(parameters)
char	*parameters;
{
	int	z;
	char	tmp1[60];

	newline();

	if ((user.fileprivs & FIL_MAKEDIR) == 0)
	{
		fpr(NOMKDIRPRIV);
		logg(NOTMKDIRPRV, 1);
		return;
	}

	while (strcmp(parameters, "") == 0)
	{
		z=lineed(parameters, MKDIRPAR1, "", 70, 0);
		newline();
		if (z<0) return;
	}

	strippath(tmp1, parameters);
	sprintf(fotxt, "MD %s > %s", tmp1, tempfile);
	system(fotxt);
	showfile(tempfile, 0);
}

void	removedir(parameters)
char	*parameters;
{
	int	z;
	char	tmp1[60];

	newline();

	if ((user.fileprivs & FIL_DELDIR) == 0)
	{
		fpr(NORMDIRPRIV);
		logg(NOTRMDIRPRV, 1);
		return;
	}

	while (strcmp(parameters, "") == 0)
	{
		z=lineed(parameters, RMDIRPAR1, "", 70, 0);
		newline();
		if (z<0) return;
	}

	strippath(tmp1, parameters);
	sprintf(fotxt, "RD %s > %s", tmp1, tempfile);
	system(fotxt);
	showfile(tempfile, 0);
}

void	pathway()
{

/*	sprintf(fotxt, "CD > %s", tempfile);
	system(fotxt);
	newline();
	showfile(tempfile, 1); */

	newline();
	getcwd(fotxt, 80);
	fpr(fotxt);
	newline();
}

void	checkdisk()
{
#ifdef MSDOS

	union REGS		in, ut;

	in.h.ah=0x36;
	in.h.dl=0;

 	intdos(&in, &ut);

	newline();

	sprintf(fotxt, FREEDISC, ((unsigned long int)ut.x.ax *
				(unsigned long int)ut.x.cx *
				(unsigned long int)ut.x.bx));
	fpr(fotxt);

	sprintf(fotxt, TOTALDISC, ((unsigned long int)ut.x.ax *
				(unsigned long int)ut.x.cx *
				(unsigned long int)ut.x.dx));
	fpr(fotxt);

	newline();

#else
	sprintf(fotxt, "DF > %s", tempfile);
	system(fotxt);
	newline();
	showfile(tempfile, 1);
	newline();
#endif
}

void	volume()
{
	sprintf(fotxt, "vol > %s", tempfile);
	system(fotxt);
	newline();
	showfile(tempfile, 0);
	newline();
}

void	syscmd(kommando)
char	*kommando;
{
	if ((user.maintprivs & SYS_SHELL) == 0)
	{
		fpr(NOSHELLPRIV);
		logg(NOTSHELLPRV, 1);
		return;
	}

	sprintf(fotxt, "%s > %s", kommando, tempfile);
	system(fotxt);
	showfile(tempfile, 0);
}

void	request(param, file)
char	*param, *file;
{
	int	i, netmail, z, ask;
	char	filename[80], tmp[80];
	FILE	*f;

	newline();

	ask=0;

	if ((user.maintprivs & SYS_NETWORK) == 0)
	{
		fpr(NONETPRIV);
		logg(NOTNETPRV, 1);
		return; 
	}

	while (strcmp(param, "") == 0)
	{
		z=lineed(param, REQUESTNODE, "", 70, 0);
		newline();
		if (z<0) return;
		ask=-1;
	}

	while (strcmp(file, "") == 0)
	{
		z=lineed(file, REQUESTFILE, "", 70, 0);
		newline();
		if (z<0) return;
	}

	if (ask == 0) i=getmnodeinfo(param);
	else i=getnodeinfo(param);

	netmail=getnode();

	if (netmail < 0)
	{
		sprintf(fotxt, BADNODEID, nodecode.zone,
			nodecode.net, nodecode.node);
		fpr(fotxt);
		return;
	}

	if (nodecode.zone == sysdata.zone)
	{
		sprintf(filename, "%s%04x%04x.FLO",
			outbound, nodecode.net, nodecode.node);
	}
	else
	{
		strcpy(tmp, outbound);
		z=0;
		while(*(tmp + z) != 0) z++;
		z--;
		*(tmp + z)=0;
		sprintf(filename, "%s.%03x\\%04x%04x.FLO",
			tmp, nodecode.zone, nodecode.net, nodecode.node);
	}

	if ((f = fopen(filename, "at")) == NULL)
	{
		sprintf(fotxt, REQCREERR, filename);
		fpr(fotxt);
		return;
	}

	fclose(f);

	if (nodecode.zone == sysdata.zone)
	{
		sprintf(filename, "%s%04x%04x.REQ",
			outbound, nodecode.net, nodecode.node);
	}
	else
	{
		strcpy(tmp, outbound);
		z=0;
		while(*(tmp + z) != 0) z++;
		z--;
		*(tmp + z)=0;
		sprintf(filename, "%s.%03x\\%04x%04x.REQ",
			tmp, nodecode.zone, nodecode.net, nodecode.node);
	}

	if ((f = fopen(filename, "at")) == NULL)
	{
		sprintf(fotxt, REQCREERR, filename);
		fpr(fotxt);
		return;
	}

	fprintf(f, "%s\n", file);

	sprintf(fotxt, REQUESTINFO, file, nodecode.net, nodecode.node);
	fpr(fotxt);
	fclose(f);
}

int	fortune()
{
	FILE			*f, *g;
	unsigned long int	t, n, xx[1];
	int			texts, i, j;
	char			val[40], text[512], fil2[80],
					fil1[80], tmp[80];

	env=getenv("ADATA");
	t=time(xx);
	n=(t & 2047L);

	strcpy(tmp, env);
	strcat(tmp, "FORTUNES.TXT");

	if ((f=fopen(tmp, "r")) == NULL)
	{
		printf("No fortunes...\n");
		return(0);
	}

	fgets(val, 38, f);
	texts=atoi(val);

	if(texts == 0)
	{
		printf(FORTUNEREADERR);
		fclose(f);
		exit(9);
	}

	while(n >= (unsigned long int)texts) n=n-texts;

	fgets(text, 510, f);

	while(n>0)
	{
		fgets(text, 510, f);
		n--;
	}

	for (i=0;i<4;i++) val[i]=text[i];
	val[4]=0;

	if (strcmp(val, "<FIL") != 0)
	{
		i=0;
		j=strlen(text);

		while(i < j)
		{
			if (*(text + i) == '<')
			{
				while(*(text + i) != '>' && i < j) i++;
				i++;
			}

			fosputch(*(text + i));
			i++;
		}
	}
	else
	{
		i=4;
		j=0;

		while(text[i] == ' ') i++;

		while (text[i] != '>' && text[i] != 0)
		{
			fil2[j]=text[i];
			i++;
			j++;
		}

		fil2[j]=0;

		strcpy(fil1, env);
		strcat(fil1, fil2);

		if ((g=fopen(fil1, "r")) == NULL)
		{
			printf(FORTUNEERR2, fil1);
			exit(9);
		}

		while(fgets(text, 510, g) != NULL)
		{
			sprintf(fotxt, "%s", text);
			fpr(fotxt);
		}

		fclose(g);
	}

	fclose(f);
	return(0);
}
