/* FILHANT.C - Rutiner fr att hmta och lagra texter. */
/* ((c) 1989, 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

/* Konvertera till stora tecken frn sm. */

void	upper(outbuff, inbuff)
char	*outbuff, *inbuff;
{
	char	upcase[256], lowcase[256];
	int	i;

	strcpy(upcase, UPPERCASE);
	strcpy(lowcase, LOWERCASE);

	while(*inbuff != 0)
	{
		i=0;
		while(*(lowcase + i) != *inbuff && *(lowcase + i) !=0) i++;
		if (*(lowcase + i) !=0) *outbuff=*(upcase + i);
		else *outbuff=*inbuff;

		outbuff++;
		inbuff++;
	}
	*outbuff=0;
}

/*	Konvertera till sm bokstver. */

void	lower(outbuff, inbuff)
char	*outbuff, *inbuff;
{
	char	upcase[256], lowcase[256];
	int	i;

	strcpy(lowcase, UPPERCASE);
	strcpy(upcase, LOWERCASE);

	while(*inbuff != 0)
	{
		i=0;
		while(*(lowcase + i) != *inbuff && *(lowcase + i) !=0) i++;
		if (*(lowcase + i) !=0) *outbuff=*(upcase + i);
		else *outbuff=*inbuff;

		outbuff++;
		inbuff++;
	}
	*outbuff=0;
}

/*	Konvertera till vettigt namnformat. */

int	nameconv(outbuff, inbuf)
char	*outbuff, *inbuf;
{
	char	upcase[256], lowcase[256];
	int	i, c, e;
	char	tmp1[80], *inbuff;

	strcpy(tmp1, inbuf);
	i=0;
	c=0;
	while(*(tmp1+i) != 0)
	{
		while(*(tmp1+i) != ' ' && *(tmp1+i) != 0)
		{
			*(tmp1+c)=*(tmp1+i);
			c++;
			i++;
		}
		if (*(tmp1+i) == ' ')
		{
			*(tmp1+c)=' ';
			c++;
		}

		while(*(tmp1+i) == ' ' && *(tmp1+i) != 0) i++;
	}

	*(tmp1+c)=0; /* Slut p strngen... */

	inbuff=tmp1;

	strcpy(upcase, UPPERCASE);
	strcpy(lowcase, LOWERCASE);

	c=1;
	e=0;

	while(*inbuff != 0)
	{
		if (c != 0)
		{
			i=0;
			while(*(lowcase + i) != *inbuff && *(lowcase + i) !=0)
				i++;
			if (*(lowcase + i) !=0) *outbuff=*(upcase + i);
			else *outbuff=*inbuff;
			e++;
		}
		else
		{
			i=0;
			while(*(upcase + i) != *inbuff && *(upcase + i) !=0)
				i++;
			if (*(upcase + i) !=0) *outbuff=*(lowcase + i);
			else *outbuff=*inbuff;
		}

		c=0;
		if (*inbuff == ' ') c=1;
		if (*inbuff == '-') c=1;

		outbuff++;
		inbuff++;
	}
	*outbuff=0;
	return(e);
}

/*	Ta reda p antalet mten i systemet. */

int	getmoeten()
{
	FILE	*f;
	int	moeten;
	long int	position;

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "MEET.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb")) == NULL)
#else
	if ((f=fopen(fotxt,"r")) == NULL)
#endif
	{
		perror(GETMOETERR1);
		logg(GETMOETERR1, 0);
		exit(9);
	}

	position=0L;

	if (fseek(f, position, SEEK_SET) != 0)
	{
		perror(GETMOETERR2);
		logg(GETMOETERR2, 0);
		fclose(f);
		exit(9);
	}

	if (fread((char *) &moeten, sizeof(int), 1, f) == 0)
	{
		perror(GETMOETERR3);
		logg(GETMOETERR3, 0);
		fclose(f);
		exit(9);
	}

	fclose(f);
	return(moeten);
}

/*	Skriv ner nytt antal mten i systemet. */

void	putmoeten(moeten)
int	moeten;
{
	FILE	*f;
	long int	position;

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "MEET.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"r+b")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(PUTMOETERR1);
		logg(PUTMOETERR1, 0);
		exit(9);
	}

	position=0L;

	if (fseek(f, position, SEEK_SET) != 0)
	{
		perror(PUTMOETERR2);
		logg(PUTMOETERR2, 0);
		fclose(f);
		exit(9);
	}

	if (fwrite((char *) &moeten, sizeof(int), 1, f) == 0)
	{
		perror(PUTMOETERR3);
		logg(PUTMOETERR3, 0);
		fclose(f);
		exit(9);
	}
	fclose(f);
}

/*	Hmta hgsta fysiska textnumret i ett mte. */

int	getmaxtext(moetnr)
int	moetnr;
{
	FILE	*f;
	long int	position;


	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "MEET.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb")) == NULL)
#else
	if ((f=fopen(fotxt,"r")) == NULL)
#endif
	{
		perror(GETMAXERR1);
		logg(GETMAXERR1, 0);
		exit(9);
	}

	position=(unsigned int) moetnr * (unsigned int) sizeof(meetrec);

	if (fseek(f, position, SEEK_SET) != 0)
	{
		perror(GETMAXERR2);
		logg(GETMAXERR2, 0);
		fclose(f);
		exit(9);
	}

	if (fread((char *) &meetinf, sizeof(meetrec), 1, f) == 0)
	{
		perror(GETMAXERR3);
		logg(GETMAXERR3, 0);
		fclose(f);
		sprintf(fotxt, ERRORDESC1,
			position, moetnr);
		fpr(fotxt);
		exit(9);
	}

	fclose(f);
	return((unsigned int) meetinf.texts);
}

/*	Lagra hgsta fysiska textnumret i ett mte. */

void	putmaxtext(moetnr,textnr)
int	moetnr, textnr;
{
	FILE	*f;
	long int	position;

	meetinf.texts=textnr;

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "MEET.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"r+b")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(PUTMAXERR1);
		logg(PUTMAXERR1, 0);
		exit(9);
	}

	position=(unsigned int) moetnr * (unsigned int) sizeof(meetrec);
	if (fseek(f, position, SEEK_SET) != 0)
	{
		perror(PUTMAXERR2);
		logg(PUTMAXERR2, 0);
		fclose(f);
		exit(9);
	}

	if (fwrite((char *) &meetinf, sizeof(meetrec), 1, f) == 0)
	{
		perror(PUTMAXERR3);
		logg(PUTMAXERR3, 0);
		fclose(f);
		exit(9);
	}
	fclose(f);
}

/*	Hmta information om viss text i ett mte. */

int	gettextindex(moetnr, textnr) /* textnr r fysiskt textnummer. */
int	moetnr, textnr;
{
	FILE			*f;
	int			texter, i;
	unsigned long int	position;
	char			filnamn[40], tmp[80];

	texter=getmaxtext(moetnr);

	textindex.startpos=0L;
	textindex.len=0;
	textindex.creator=0;
	textindex.kommptr=0;
	textindex.kommusr=0;
	textindex.type=0;
	sistatextpos=0;

	for(i=0;i<80;i++) textindex.commlist[i]=0;
	
	strcpy(textindex.subject, "");

	if (textnr > 0 && textnr <= texter)
	{
		sprintf(filnamn, "M%d.IDX", moetnr);

		env=getenv("ADATA");
		strcpy(fotxt, env);
		strcat(fotxt, filnamn);

#ifdef MSDOS
		if ((f=fopen(fotxt, "rb")) == NULL)
#else
		if ((f=fopen(fotxt, "r")) == NULL)
#endif
		{
			sprintf(tmp, GETIDXERR1, moetnr);
			perror(tmp);
			logg(tmp, 0);
			exit(9);
		}

		position=(unsigned long int) textnr *
				(unsigned long int) sizeof(textindexstruct);

		if (fseek(f, position, SEEK_SET) != 0)
		{
			sprintf(tmp, GETIDXERR2, moetnr);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}

		if (fread((char *) &textindex,
			(unsigned int) sizeof(textindexstruct), 1, f) == 0)
		{
			sprintf(tmp, GETIDXERR3, moetnr);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}
		fclose(f);

		sistatextpos=textindex.startpos+textindex.len;

		return(0);
	}
	else
	{
		return(-1);
	}
}

/*	Lagra information om viss text i ett mte. */

int	puttextindex(textnr) /* textnr r fysiskt textnummer */
int	textnr;
{
	FILE			*f;
	unsigned long int	position;
	char			filnamn[40], tmp[80];


	if (textnr > 0)
	{
		sprintf(filnamn, "M%d.IDX", moetnumber);

		env=getenv("ADATA");
		strcpy(fotxt, env);
		strcat(fotxt, filnamn);

#ifdef MSDOS
		if ((f=fopen(fotxt, "r+b")) == NULL)
#else
		if ((f=fopen(fotxt, "r+")) == NULL)
#endif
		{
			sprintf(tmp, PUTIDXERR1, moetnumber);
			perror(tmp);
			logg(tmp, 0);
			exit(9);
		}

		position=(unsigned long int) textnr *
				(unsigned long int) sizeof(textindexstruct);

		if (fseek(f, position, SEEK_SET) != 0)
		{
			sprintf(tmp, PUTIDXERR2, moetnumber);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}

		if (fwrite((char *) &textindex,
			sizeof(textindexstruct), 1, f) == 0)
		{
			sprintf(tmp, PUTIDXERR3, moetnumber);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}
		fclose(f);
		return(0);
	}
	else
	{
		fpr(BADTEXT);
		return(-1);
	}
}

/*	Lagra text i textfilen. */

void	storetext(textarea)
char	*textarea;
{
	FILE	*f;
	char	filnamn[40], tmp[80];

	sprintf(filnamn, "M%d.DAT", moetnumber);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, filnamn);

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		sprintf(tmp, STORTXTERR1, moetnumber);
		perror(tmp);
		logg(tmp, 0);
#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
		exit(9);
	}

	if (fseek(f, textindex.startpos, SEEK_SET) != 0)
	{
		sprintf(tmp, STORTXTERR2, moetnumber);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
		exit(9);
	}

	if (fwrite((char *) textarea, textindex.len, 1, f) == 0)
	{
		sprintf(tmp, STORTXTERR3, moetnumber);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
		exit(9);
	}
	fclose(f);
}

void		gettxt(textarea, textnr) /* textnr r fysiskt textnummer */
unsigned char	*textarea;
int		textnr;
{
	FILE	*f;
	char	filnamn[40], tmp[80];
	int	z;

	z=gettextindex(moetnumber, textnr);

	sprintf(filnamn, "M%d.DAT", moetnumber);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, filnamn);

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb")) == NULL)
#else
	if ((f=fopen(fotxt,"r")) == NULL)
#endif
	{
		sprintf(tmp, GETTXTERR1, moetnumber);
		perror(tmp);
		logg(tmp, 0);
#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
		exit(9);
	}

	if (fseek(f, textindex.startpos, SEEK_SET) != 0)
	{
		sprintf(tmp, GETTXTERR2, moetnumber);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
		exit(9);
	}

	if (fread((unsigned char *) textarea, textindex.len, 1, f) == 0)
	{
		sprintf(tmp, GETTXTERR3, moetnumber);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
		exit(9);
	}

	fclose(f);
}

/*	Visa en text ur textfilen. */

void	showtext(textnr, extended) /* textnr r fysiskt textnummer */
int	textnr, extended;
{
	char		*textarea, inrad[20], utrad[160], tmp[160];
	int		z, n, r, sb=0, i, k, col0;
	unsigned int	c;

#ifdef MSDOS
	textarea=halloc((unsigned long int)MAXLINES *
		(unsigned long int)LINELENGTH, sizeof(char));
#else
	textarea=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

	if (textarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	gettxt(textarea, textnr);

	z=0;
	r=0;
	n=0;
	c=1;
	strcpy(inrad,"");

	strcpy(utrad, "");

/*	Alla texter brjar i frsta kolumnen! */

	col0=-1;

	while((c=(unsigned int)*(textarea + z))  != 0 && r >= 0 && *inrad == 0
		&& c != 0)
	{
		if ((unsigned int)n >= user.lines - 3)
		{
			strcpy(fotxt, PRESSRETURN);

			if (ansi == 1) sprintf(fotxt, "%s%s%s",
					ansicol[14],
					PRESSRETURN,
					ansicol[7]);

			if (ansi == 2) sprintf(fotxt, "%s%s%s",
					ansicol[21],
					PRESSRETURN,
					ansicol[20]);

			r=lineed(inrad, fotxt, "", 3, 0);
			newline();
			n=0;
		}

		if (sb == -2)
		{
			c=0;
			*(textarea + z)=0;
			*(textarea + z + 1)=0;
			*(textarea + z + 2)=0;
			*(textarea + z + 3)=0;
		}

/*	Om vi vill lsa texten "extended" med alla kludge-parametrar,
	s ignorerar vi CTRL+A genom att ndra den till SPACE. */

		if (extended == 1 && c == 1) c=' ';

/*	Hoppa ver alla rader som inleds med ^A */

		k=0;

		if (c == 1 && col0 == -1)
		{
			while(*(textarea + z) != '\r' &&
				*(textarea + z) != 0) z++;
			k=-1;
			c=13;
		}

		if (c != 13 && c != 10 && (c & 0xff) != 0x8d)
		{
			col0=0;
		}

		if (c == 13)
		{
			col0=-1;
		}

		if ((c & 0xff) == 0x8d || c == '\n') k=-1;

		if (k == 0)
		{
			if (c == '\r' || c >= 32)
			{
				if (c == '\r') c='\n';
				sprintf(fotxt, "%c", c);
				strcat(utrad, fotxt);
			}

/*	Kontrolltecken vi inte knner skriver vi ut som
	en tv-teckens kombination, i stllet fr att skicka
	dem till terminalen, vilket kan f olustiga fljder. */

			if (c > 0 && c < 32 && c != 2 && c != '\n')
			{
				sprintf(fotxt, "^%c", c+64);
				strcat(utrad, fotxt);
			}

			if (strlen(utrad) >= 155 ||
				(strlen(utrad) >= user.columns &&
				user.columns > 25) ||
				(strlen(utrad) >= 20 &&
				user.columns <= 25) ||
				c == '\n')
			{
				i=strlen(utrad);

				while(*(utrad+i) != ' ' && i>0 && c != '\n')
					i--;

				if (*(utrad + i) == ' ') i++;

				if (i == 0 && user.columns > 25 && c != '\n')
				{
					strcpy(tmp, (utrad + user.columns));
					*(utrad+user.columns)=0;
					fpr(utrad);
					newline();
					strcpy(utrad, tmp);
					n++;
				}

				if (c == '\n')
				{
					fpr(utrad);
					strcpy(utrad, "");
					n++;
				}

				if (i > 0 && user.columns > 25 && c != '\n')
				{
					strcpy(tmp, (utrad + i));
					*(utrad+i)=0;
					fpr(utrad);
					newline();
					strcpy(utrad, tmp);
					n++;
				}

				if (user.columns <= 25 && c != '\n')
				{
					strcpy(tmp, (utrad + 20));
					*(utrad+20)=0;
					fpr(utrad);
					newline();
					strcpy(utrad, tmp);
					n++;
				}
			}

			if (c == '\n')
			{
				if (sb == -1)
				{
					sb=-2;
				}

/*	SUBCOMPSTR tar litet krm, s vi aktiverar den bara nr det behvs. */

				if (subcompstr("\r * Origin: ",
					(textarea + z)) == 0 && extended != 1)
				{
					sb=-1;
				}

				if (subcompstr("\r\n * Origin: ",
					(textarea + z)) == 0 && extended != 1)
				{
					sb=-1;
				}
			}
		}

		z++;
	}
	fpr(utrad);
	newline();

#ifdef MSDOS
	hfree(textarea);
#else
	free(textarea);
#endif

	if ((unsigned int)n >= user.lines - 13 &&
		(user.status & 8) == 0)
	{
		strcpy(fotxt, PRESSRETURN);

		if (ansi == 1) sprintf(fotxt, "%s%s%s",
				ansicol[14],
				PRESSRETURN,
				ansicol[7]);

		if (ansi == 2) sprintf(fotxt, "%s%s%s",
				ansicol[21],
				PRESSRETURN,
				ansicol[20]);

		r=lineed(inrad, fotxt, "", 3, 0);
		newline();
		n=0;
	}
}

/*	Skapa ett nytt mte. */

int	skapamoete()
{
	FILE	*f;
	int	z, i, moeten, moetnr, n, charset;
	char	moettype[3], moetnamn[80], areanamn[80], slask[80], tmp[80];

	fpr(CREATEMEET);

	/* Kontrollera tilltna mtestyper vid inmatning.

	O = ppet.
	C = Slutet.
	E = Echo Mail.
	R = Slutet ECHO-Mail.

	Framtida:
	H = Dolt, slutet.

	*/

	if ((user.textprivs & (MSG_CREM | MSG_CRECM | MSG_CRENM)) == 0)
	{
		sprintf(fotxt, NOCREM);
		fpr(fotxt);
		return(0);
	}

	z=-1;
	while(z != 0)
	{
		if (lineed(moettype, MOETTYPPROMPT, "O", 3, 0) < 0) return(0);
		i=0;

		upper(moetnamn, moettype);
		strcpy(moettype, moetnamn);

		if (*moettype == '?')
		{
			sprintf(fotxt, NEWMEETHELP1);
			fpr(fotxt);
			sprintf(fotxt, NEWMEETHELP2);
			fpr(fotxt);
			sprintf(fotxt, NEWMEETHELP3);
			fpr(fotxt);
			sprintf(fotxt, NEWMEETHELP4);
			fpr(fotxt);
/*	Fr vidare utbyggnad. */
/*			sprintf(fotxt, NEWMEETHELP5);
			fpr(fotxt);
			sprintf(fotxt, NEWMEETHELP6);
			fpr(fotxt); */
		}

		while(*(ALLOWEDTYPES + i) != 0 && z != 0)
		{
			if (*moettype == *(ALLOWEDTYPES + i++)) z=0;
		}
		newline();

		switch(*moettype)
		{
			case 'H' :
			case 'C' : if ((user.textprivs & MSG_CRECM) == 0)
				{
					sprintf(fotxt, NOCREM);
					fpr(fotxt);
					z=-1;
				}
				break;

			case 'E' : if ((user.textprivs & MSG_CRENM) == 0)
				{
					sprintf(fotxt, NOCREM);
					fpr(fotxt);
					z=-1;
				}
				break;
			case 'R' : if ((user.textprivs & MSG_CRENM) == 0
					|| (user.textprivs & MSG_CRECM) == 0)
				{
					sprintf(fotxt, NOCREM);
					fpr(fotxt);
					z=-1;
				}
				break;
		}
	}

	if (lineed(moetnamn, MOETNAMNPROMPT, "", 80, 0) < 0) return(0);
	newline();

	strcpy (areanamn, "");
	if (*moettype == 'E' || *moettype == 'R')
	{	
		if (lineed(areanamn, AREANAMNPROMPT, "", 80, 0) < 0) return(0);
		newline();

		fpr(CHARSETS);

		for (i=0;i<=10;i++)
		{
			if (user2.charset != (unsigned int)i)
			{
				sprintf(fotxt, "   %2d = %s\n", i+1,
					teckendef[i]);
			}
			else
			{
				sprintf(fotxt, "*  %2d = %s\n", i+1,
					teckendef[i]);

				if (ansi == 1)
					sprintf(fotxt,
						"%s*  %2d = %s%s\n",
						ansicol[12],
						i+1, teckendef[i],
						ansicol[7]);

				if (ansi == 2)
					sprintf(fotxt,
						"%s*  %2d = %s%s\n",
						ansicol[21],
						i+1, teckendef[i],
						ansicol[20]);
			}

			fpr(fotxt);
		}

		n = -1;
		while (n < 1 || n > 4)
		{
			newline();
			sprintf(tmp, "%d", 3);
			z=lineed(slask, ECHOCHARSET, tmp, 58, 2);
			if (z<0)
			{
				fclose(f);
				return(0);
			}
			if (z >= 0 && *slask != 0)
			{
				n=atoi(slask);
			}
		}
		charset=n-1;
	}

	moeten=getmoeten();

	moetnr=moeten;

	i=3;

	while (i <= moeten && meetinf.creator != 0)
	{
		z=getmaxtext(i);
		moetnr=i;
		i++;
	}

	i--;

	if (i == moeten) moetnr++;

	*(moettype+1)=0;

	strcpy(meetinf.dummy,"\376");
	strcpy(meetinf.typ, moettype);
	strcpy(meetinf.namn, moetnamn);
	upper(meetinf.echoarea, areanamn);

	meetinf.texts=0;
	meetinf.firsttext=0;
	meetinf.creator=usernumber;
	meetinf.defcharset=charset;

	sprintf(moetnamn, "M%d.IDX", moetnr);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, moetnamn);

#ifdef MSDOS
	if ((f=fopen(fotxt,"wb")) == NULL)
#else
	if ((f=fopen(fotxt,"w")) == NULL)
#endif
	{
		sprintf(tmp, CREMEETERR1, moetnr);
		perror(tmp);
		logg(tmp, 0);
		exit(9);
	}
	if (fwrite((char *) &moetnr, sizeof(int), 1, f) == 0)
	{
		sprintf(tmp, CREMEETERR2, moetnr);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}
	fclose(f);

	sprintf(moetnamn, "M%d.DAT", moetnr);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, moetnamn);

#ifdef MSDOS
	if ((f=fopen(fotxt,"wb")) == NULL)
#else
	if ((f=fopen(fotxt,"w")) == NULL)
#endif
	{
		sprintf(tmp, CREMEETERR3, moetnr);
		perror(tmp);
		logg(tmp, 0);
		exit(9);
	}
	if (fwrite((char *) &moetnr, sizeof(int), 1, f) == 0)
	{
		sprintf(tmp, CREMEETERR4, moetnr);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}
	fclose(f);

	user.memberinfo[moetnr].lastread=0;
	user.memberinfo[moetnr].moetstatus=3;
	putmaxtext(moetnr,0);
	if (moeten < moetnr) moeten=moetnr;
	putmoeten(moeten);
	newline();
	return(0);
}

/*	Ta reda p om texten som inval pekar p ingr i compval
	med brjan p frsta tecknet. */

int	instring(inval, compval)
char	*inval, *compval;
{
	int	z, diff;
	char	tmp1[80], tmp2[80];

/*	Jmfrelse sker bara p stora bokstver, s att vi r oberoende
	av hur anvndaren har knpat in sin text. */

	upper(tmp1, inval);
	upper(tmp2, compval);

	z=0;
	diff=0;

	while( diff == 0 && *(tmp1 + z) != 0)
	{
		diff= *(tmp1 + z) - *(tmp2 + z);
		z++;
	}
	return(diff);
}

/*	Ta reda p mtets nummer utifrn mtets namn.
	Brja med det mte som finns i 'r' eftersom vi oftast inte
	vill ha med brevldan. */

int	getmoetnumber(moetnamn,r)
char	*moetnamn;
int	r;
{
	int	n, i;
	char	tmp[80];
	FILE	*f;

	if (strcmp(moetnamn, "") == 0) return(-1);

	n=getmoeten();

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb")) == NULL)
#else
	if ((f=fopen(fotxt,"r")) == NULL)
#endif
	{
		perror(GETMAXERR1);
		logg(GETMAXERR1, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int) r *
		(unsigned long int) sizeof(meetrec), SEEK_SET) != 0)
	{
		perror(GETMAXERR2);
		logg(GETMAXERR2, 0);
		fclose(f);
		exit(9);
	}

	for (i=r;i<=n;i++)
	{
/*		z=getmaxtext(i); */

		if (fread((char *) &meetinf, sizeof(meetrec), 1, f) == 0)
		{
			perror(GETMAXERR3);
			logg(GETMAXERR3, 0);
			fclose(f);
			fpr(fotxt);
			exit(9);
		}

		strcpy(tmp, meetinf.namn);

		if (instring(moetnamn, tmp) == 0)
		{
			fclose(f);
			return(i);
		}
	}
	fclose(f);
	return(-1);
}

/*	Ta reda p antalet anvndare i systemet. */

int	getusers()
{
	int	userid;
	FILE	*f;
	char	tmp[80];

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

/*	Frsta position! - Ondigt, men i alla fall. */

	if (fseek(f, 0L, SEEK_SET) != 0)
	{
		sprintf(tmp, UPDATEUSRERR1);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}

/*	Ls frsta position, fr att veta hur mnga anvndare systemet har */

	if (fread((char *) &userid, sizeof(int), 1, f) == 0)
	{
		sprintf(tmp, UPDATEUSRERR2);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}
	fclose(f);
	return(userid);
}

/*	Ta fram anvndarinformation om en anvndare. */

int	getuserinfo(userid)
int	userid;
{
	FILE	*f;
	char	tmp[80];

	if (userid < 1 || (unsigned int)userid > users) return(-1);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int)userid *
		(unsigned long int)sizeof(userrec), SEEK_SET) != 0)
	{
		sprintf(tmp, GETUSERERR1);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}

/*	Ls anvndarinformation. */

	if (fread((char *) &user2, sizeof(userrec), 1, f) == 0)
	{
		sprintf(tmp, GETUSERERR2);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}
	fclose(f);
	return(0);
}

/*	Lagra anvndarinformation. */

int	putuserinfo(userid)
int	userid;
{
	FILE	*f;
	char	tmp[80];

	if (userid < 1 || (unsigned int)userid > users) return(-1);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(tmp, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int) userid *
			(unsigned long int) sizeof(userrec)*1L, SEEK_SET) != 0)
	{
		sprintf(tmp, PUTUSERERR1);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}

/*	Skriv anvndarinformation. */

	if (fwrite((char *) &user2, sizeof(userrec), 1, f) == 0)
	{
		sprintf(tmp, PUTUSERERR1);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}
	fclose(f);
	return(0);
}

void		logg(message, typ)
unsigned char	*message;
unsigned int	typ;
{
	char	tid[20], *slask, tmp[80], slask2[160];

	if (typ <= (unsigned int)sysdata.failtype)
	{
		tiden(tid);

		sprintf(slask2,"%d %s %s(%d) %s\n",
			typ, tid, user.username, usernumber, message);

		if (strlen(slask2)<80)
		{
			fprintf(logf, slask2);
		}
		else
		{
		sprintf(slask2,"%d %s %s(%d)\n",
			typ, tid, user.username, usernumber);
		fprintf(logf, slask2);

		sprintf(slask2,"  %s\n\n",
			message);
		fprintf(logf, slask2);
		}

		if (typ == 0)
		{
			strcpy(tmp, "< Autolog >");
			slask=_strerror(tmp);
			fprintf(logf, slask);
		}

		fflush(logf);
	}
}
