/* FOSSIL.C  In/Utmatning p en rad med editeringsfunktioner. */
/* (c) 1989, 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

/*	Denna del anvnds fr in och utmatning i MS-DOS.
	I andra operativsystem lr denna fil ej vara ndvndig.
*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "global.h"

/*	Initiera FOSSIL-drivrutinen. */

unsigned int	initfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=4;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.ax);
}

/*	Deaktivera FOSSIL-drivrutinen. */

unsigned int	deinitfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=5;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.ax);
}

/*	Stt verfringsparametrar. */

unsigned int	baudfossil(speed, par, stop, chlen)
unsigned int	speed, par, stop, chlen;
{
	union REGS in,ut;
	struct SREGS  segregs;
	int	code;

	code=0;

	switch (speed)
	{
		case	  300 : code=64;	break;
		case	  600 : code=96;	break;
		case	 1200 : code=128;	break;
		case	 2400 : code=160;	break;
		case	 4800 : code=192;	break;
		case	 9600 : code=224;	break;
		case	19200 : code=0;		break;
		default	      : code=-1;	break;
	}

	if (code < 0)
	{
		printf(BADBAUD);
		logg(BADBAUD, 2);
		exit(255);
	}

	switch (par)
	{
		case	0 : 			break;
		case	1 :	code=code | 8;	break;
		case	2 :	code=code | 24;	break;
		default	  :	code=-1;	break;
	}

	if (code < 0)
	{
		printf(BADPARITY);
		logg(BADPARITY, 2);
		exit(255);
	}

	switch (stop)
	{
		case	1 :			break;
		case	2 :	code=code | 4;	break;
		default	  :	code=-1;	break;
	}

	if (code < 0)
	{
		printf(BADSTOPBITS);
		logg(BADSTOPBITS, 2);
		exit(255);
	}

	switch (chlen)
	{
		case	5 :			break;
		case	6 :	code=code | 1;	break;
		case	7 :	code=code | 2;	break;
		case	8 :	code=code | 3;	break;
		default	  :	code=-1;	break;
	}

	if (code < 0)
	{
		printf(BADCHARLEN);
		logg(BADCHARLEN, 2);
		exit(255);
	}

	in.h.ah=0;
	in.h.al=(unsigned char)(code & 255);
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.ax);
}
 
/*	Returnera FOSSIL-drivrutinens status. */

unsigned int	statusfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=3;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.ax);
}

/*	Snd ett tecken p serieporten. Vnta om bufferten r full. */

void	txchwfossil(tkn)
unsigned char	tkn;
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=1;
	in.h.al=tkn;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Hmta ett tecken frn serieporten. Vnta om det saknas. */

unsigned int	rxchwfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=2;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.h.al);
}

/*	Ta emot ett tecken frn serieporten utan att vnta p tecken.
	Buffertrknaren rknas inte ner. Icke destruktiv lsning.
	returnerar 0xffff om det inte fanns ngot. */

unsigned int	rxchfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x0c;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.ax);
}

/*	Aktivera DTR p serieporten. */

void	dtronfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=6;
	in.h.al=1;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Deaktivera DTR p serieporten. */

void	dtroffossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=6;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Tm inputbufferten p serieporten. */

void	puinfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x0a;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Ls tangentbordet utan att vnta. 0xffff i retur om
	ingen tangent tryckt. */

unsigned int	kbdrdfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x0d;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.ax);
}

/*	Ls tangentbordet , vnta p tangent. */

unsigned int	kbdrdwfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x0e;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.ax);
}

/*	Stt FLOW-CONTROL. Fljande konstanter finns.

	XONTX	1
	CTSRTS	2
	XONRX	8
*/


void	fcfossil(mode)
int	mode;
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x0f;
	in.h.al=(unsigned char)mode;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Deaktivera CTRL-C kontrollen i FOSSIL-drivern. */

int	noctrlcfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x10;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.ax);
}

/*	Positionera markren p skrmen. */

void	curfossil(row,col)
int	row,col;
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x11;
	in.h.al=0;
	in.h.dh=(unsigned char)row;
	in.h.dl=(unsigned char)col;

	int86x(0x14, &in, &ut, &segregs);
}

/*	Hmta makrkrens position. Returneras i formen 0xRRCC . */

int	getcurfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x12;
	in.h.al=0;

	int86x(0x14, &in, &ut, &segregs);

	return(ut.x.dx);
}

/*	Skriv ut p skrmen via ANSI-drivrutinen. */

void	ansiwritefossil(tkn)
int	tkn;
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x13;
	in.h.al=(unsigned char)tkn;

	int86x(0x14, &in, &ut, &segregs);
}

/*	Skriv ut p bildskrmen via BIOS-rutinen. */

void	bioswritefossil(tkn)
int	tkn;
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x15;
	in.h.al=(unsigned char)tkn;

	int86x(0x14, &in, &ut, &segregs);
}

/*	Aktivera watchdog, som bootar om maskinen. */

void	wdonfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x14;
	in.h.al=1;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Deaktivera Watchdog. */

void	wdoffossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x14;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Boota om maskinen mode=0 -> kallstart , mode=1 -> varmstart. */

void	rebootfossil(mode)
int	mode;
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x17;
	in.h.al=(unsigned char)mode;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Brja med BREAK-signal. */

void	startbrkfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x1a;
	in.h.al=1;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

/*	Avsluta BREAK-signal. */

void	stopbrkfossil()
{
	union REGS in,ut;
	struct SREGS  segregs;

	in.h.ah=0x1a;
	in.h.al=0;
	in.x.dx=(port-1);

	int86x(0x14, &in, &ut, &segregs);
}

int	keytest()
{
	int	c;

	if ((kbdrdfossil() & 0xFF) != 0xFF)
	{
		c=kbdrdwfossil();
		if (c == 3 || c == 25) return(-1);
		return(1);
	}

	if ((rxchfossil() & 0xFF) == 0xFF) return(0);

	c=(rxchwfossil() & 0xFF);
	if (c == 3 || c == 25) return(-1);
	return(1);
}
