/* INTERPRE.C - En kommandotolk, vilken anropar de vriga modulerna */
/* "AURORA" (c) 1989, 1990 Nils Hammar */

/*	This code may be used complete or partly by anyone as long as
	i am credited for being involved in the source.
	The credits MUST appear possible to read when starting the derived
	program, and in the documentation and manual in the form:
	"Contains code (c) 1990 Nils Hammar" in any language of:
	Swedish, English or German preferably.

	It is free to spread this code and programs hereof both free
	and if code is added for money as long as i am credited for it.
	Excluding of code MUST be by comments, and when code is included
	there MUST be a comment which describes WHO has done it, WHY,
	and WHEN. All changes and additions should be reported to me
	to determine if they should be included in further versions.

	All necessary text translations will be in GLOBAL.H and
	possibly in PRIVS.H if translation to another language is necessary.

	Extensions of H-files in different languages:
	.SWE	Swedish
	.ENG	English
	.SUO	Finnish
	.GER	German

	Adding code to one file MUST be added to the others, in
	at least english.
*/

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <time.h>

#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

/*	Ta reda p vilket kommando det var. */

int	searchcmnd(command)
char	*command;
{
	int	count, count2, cmnd, diff, start, i;
	char	tmp[80];

	cmnd=-2;

	/* Skippa om kommentarsrad */
	if (*command == ';') return(0);

	/* Kommandot var kort information om kommandon. */
	if (*command == '?' && *(command+1) == NUL) return(99);

	/* Skippa om tomrad eller mindre n 2 tecken i kommandot. */
	count=0;
	while(*(command + count++) != 0);
	if (count <= 2) return(0);

	/* Skippa inledande blanka. */
	start=0;
	while(*(command + start) == 32) start++;

	/* Skippa om bara blanka */
	if (*(command + start) == 0) return(0);

/*	Skippa om kommandot mindre n 2 tecken. */
	count=0;
	while(*(command + start + count) != 32 && 
		*(command + start + count) != 0) count++;
	if (count < 2) return(0);

	cmnd=-1;
	diff=-1;

	upper(tmp, (command + start));
	count2=0;
	while(*(tmp + count2) != 32 && *(tmp + count2) != 0) count2++;
	*(tmp + count2)=0;

	while(cmnd < 30 && diff != 0)
	{
		cmnd++;
		if (strcmp(kommandon[area][cmnd], "") != 0)
		{
			diff=instring(tmp, kommandon[area][cmnd]);
		}
		else
		{
			/* Kr hr vid slut p kommandon */
			cmnd=-2;
			sprintf(fotxt, "\n\n%s\n", NOCOMMAND);
			fpr(fotxt);
			return(-1);
		}
	}

	cmnd++;

	if (cmnd < 0) return (-1);

/*	Se till att vi inte har ngra konstiga parametrar. */
	for (i=0;i<20;i++) strcpy(comndpar.par[i],"");

	count2=start;
	count=0;
	/* Leta efter frsta blanka efter kommandot */
	while(*(command + count2) != 0 &&
		 *(command + count2) != 32) count2++;

	diff=count2;
/*	Leta efter frsta icke blanka. */
	while(*(command + diff) != 0 &&
		*(command + diff) == 32) diff++;

	strcpy( parameters, (command + diff));

	diff=0;

	while(*(command + count2) != 0)
	{
/*	Leta efter frsta icke blanka. */
		while(*(command + count2) != 0 &&
			*(command + count2) == 32) count2++;

/*	Kopiera in alla parametrar i strngen PARAMETERS */

/*	Om det inte var slut p texten br det finnas minst en parameter */

		if (*(command + count2) != 0 && *(command + count2) != 32)
		{
			count=0;
			while(*(command + count2) != 32 &&
				*(command + count2) != 0)
				*(comndpar.par[diff] + count++) =
					*(command + count2++);
			*(comndpar.par[diff] + count)=0;
			diff++;

			comndpar.pars=diff;
		}
	}
	return(cmnd);
}

/*	Tolkdel fr filkommandon. */

int	maincommands(cmnd)
int	cmnd;
{
	switch (cmnd)
	{
		/* Kommandon fr MAIN.CMD Nummer 1 skall alltid vara EXIT */
		/* Om man har synonymer till EXIT kan man ndra
		   cmnd till 1, s avslutas kommandonivn */

		case 3 : 
			area=0;
			break;

		case 4 :
			moetnumber=0;
			msgdefault=2;
			area=1;
			break;

		case 5  : operator(); break;
		case 6  : changedir(comndpar.par[0]); break;
		case 7  : directory(comndpar.par[0],comndpar.par[1]); break;
		case 8  : searchfile(comndpar.par[0]); break;
		case 9  : typefile(comndpar.par[0]); break;
		case 10 : convert(comndpar.par[0],comndpar.par[1],
			  comndpar.par[2]); break;
		case 11 : listarc(comndpar.par[0],comndpar.par[1]); break;
		case 12 : upload(comndpar.par[0],comndpar.par[1]); break;
		case 13 : download(comndpar.par[0],comndpar.par[1]); break;
		case 14 : movefile(comndpar.par[0],comndpar.par[1]); break;
		case 15 : deletefile(comndpar.par[0]); break;
		case 16 : makedir(comndpar.par[0]); break;
		case 17 : removedir(comndpar.par[0]); break;
#ifdef MSDOS
		case 18 : freefileinfo(comndpar.par[0]); break;
#endif
		case 19 : pathway(); break;
		case 20 : checkdisk(); break;
		case 21 : volume(); break;
		case 22 : request(comndpar.par[0],comndpar.par[1]); break;
#ifdef MSDOS
		case 23 : editinfo(comndpar.par[0]); break;
#endif
	}
	return(0);
}

/*	Tolkdel fr underhllskommando. */

int	maintcommands(cmnd)
int	cmnd;
{


	switch (cmnd)
	{
		/* Kommandon fr MAINT.CMD Nummer 1 skall alltid vara EXIT */
		/* Om man har synonymer till EXIT kan man ndra
		   cmnd till 1, s avslutas kommandonivn */

		case 3 : 
			area=2;
			break;

		case 4 :
			moetnumber=0;
			msgdefault=2;
			area=1;
			break;

		case 5 : operator(); break;
		case 6 : edituser(parameters); break;
		case 7 : show(parameters, comndpar.par[0]); break;
		case 8 : listusers(parameters); break;
		case 9 : setpassword(parameters); break;
		case 10 : connect(parameters, 0); break;
		case 11 : connect(parameters, 1); break;

		case 12 :
			setpar(parameters,comndpar.par[0],comndpar.par[1]);
			break;

		case 13 :
			clearpar(parameters,comndpar.par[0],comndpar.par[1]);
			break;

		case 14 : packmeet(comndpar.par[0], parameters); break;
		case 15	: scanlist(); break;
		case 16 : listnodes(comndpar.par[0]); break;
		case 17 : listnets(comndpar.par[0]); break;
		case 18 : sysedit(); break;
		case 19 : meetedit(parameters); break;
		case 20 : scanareas(); break;
		case 21 : listareas(); break;
		case 22 : whoami(); break;
		case 23 : deleteusr(parameters); break;
		case 24 : syscmd(parameters); break;
		case 25 : cleanusers(); break;
	}
	return(0);
}

/*	Tolkdel fr mtessystemskommandon. */

int	msgcommands(cmnd)
int	cmnd;
{
	int	slask;

	switch (cmnd)
	{
		/* Kommandon fr MSG.CMD Nummer 1 skall alltid vara EXIT */
		/* Om man har synonymer till EXIT kan man ndra
		   cmnd till 1, s avslutas kommandonivn */

		case 3 : 
			area=2;
			break;

		case 4 :
			moetnumber=0;
			msgdefault=2;
			area=0;
			break;

		case 5 : operator(); break;
		case 6 : listmeetings(comndpar.par[0]); break;
		case 7 : writetext(); break;
		case 8 : readtext(comndpar.par[0]); break;
		case 9 : slask=skapamoete(); break;
		case 10 : kommtext(comndpar.par[0]); break;
		case 11 : deletemoete(parameters); break;
		case 12 : deletetext(comndpar.par[0]); break;
		case 13 : gotomoete(parameters); break;
		case 14 : whereami(); break;
		case 15 : member(parameters); break;
		case 16 : nomember(parameters); break;
		case 17 : endast(comndpar.par[0]); break;
		case 18 : questiontext(); break;
		case 19 : personaltext(parameters); break;
		case 20 : persquesttext(parameters); break;
		case 21 : subjectlist(); break;
		case 22 : adduser(1, parameters); break;
		case 23 : adduser(0, parameters); break;
		case 24 : status(comndpar.par[0],
			comndpar.par[1], parameters); break;
		case 25 : break; /* Ls alla texter ! - extern kodning */
                case 26 : readtext(comndpar.par[0]); break;
		case 27 : perskommtext(comndpar.par[0]); break;
		case 28 : pubquest(); break;
		case 29 : movetext(parameters); break;
		case 30 : savetext(comndpar.par[0]);
	}
	return(0);
}

/*	Lista kommandon i aktuell kommandoarea. */

void	listcommands()
{
	char	inrad[80], slask[80];
	int	count, z, i;

	newline();

	fpr(termfunk[user.terminal][1]); /* Clear screen. */
	fpr(termfunk[user.terminal][2]); /* Home */

	i=0;
	z=0;
	count=0;
	*inrad=0;
	while (*inrad == 0 && strcmp(kommandon[area][i], "") != 0
		&& i < 30 && z >= 0)
	{
		strcpy(inrad,"");

		sprintf(fotxt, "%s\n", kommandon[area][i]);
		fpr(fotxt);
		count++;
		i++;

		if (count >= (int) user.lines - 3 && user.lines > 3)
		{
			strcpy(slask, PRESSRETURN);
			if (ansi == 1) sprintf(slask, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

			if (ansi == 2) sprintf(slask, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			z=lineed(inrad, slask, "", 3, 0);
			newline();
			if (z<0) return;
			count=0;
		}
	}
}

void	listcommands2()
{
	char	inrad[80], slask[80];
	int	count, z, i, j, count2;

	newline();

	if (ansi == 1) fpr(ansicol[6]);
	if (ansi == 2) fpr(ansicol[22]);

	i=0;
	z=0;
	count=0;
	count2=0;
	*inrad=0;

	while (*inrad == 0 && strcmp(kommandon[area][i], "") != 0
		&& i < 30 && z >= 0)
	{
		strcpy(inrad,"");

		for(j=0;j<15;j++)
		{
			*(fotxt+j)=*(kommandon[area][i]+j);
		}
		*(fotxt + 15)=0;
		fpr(fotxt);
		count2++;
		if ((unsigned int)(count2+1)*16 > user.columns)
		{
			newline();
			count2=0;
			count++;
		}

		i++;

		if (count >= (int) user.lines - 3 && user.lines > 3)
		{
			strcpy(slask, PRESSRETURN);
			if (ansi == 1) sprintf(slask, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[6]);

			if (ansi == 2) sprintf(slask, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			z=lineed(inrad, slask, "", 3, 0);
			newline();
			if (z<0) return;
			count=0;
		}
	}

	if (ansi == 1)	fpr(ansicol[7]);
	if (ansi == 2)	fpr(ansicol[20]);

	newline();
}

/*	Default-kommandon att utfra i mtessystemet. */

void	msgdefaultact()
{
	switch (msgdefault)
	{
		/* Kommandon fr MAINT.CMD Nummer 1 skall alltid vara EXIT */
		/* Om man har synonymer till EXIT kan man ndra
		   cmnd till 1, s avslutas kommandonivn */

		case 1 :
			comndpar.pars=1; /* NEXT_TEXT */
			readtext("0");
			break;
		case 0 :
		case 2 :
			comndpar.pars=0; /* NEXTMEETING */
			nastamoete();
			break;
		case 3 :
			comndpar.pars=1; /* REPLY_TEXT */
			kommtext("0");
			break;
		case 4 : readmail(); break;
		case 5 :
			comndpar.pars=1; /* REPLY_TEXT */
			perskommtext("0");
			break;
	}
}

int	maxtime()
{
	long int	stoptime, diff;

	if ((user.maintprivs & SYS_SUSR) != 0) return(0);

	time(&stoptime);
	diff=stoptime-starttime;

	diff=3600-diff;

	if (diff < 120 && timewarn < 7)
	{
		timewarn=7;
		sprintf(fotxt, MINUTELEFT);
		fpr(fotxt);
	}

	if (diff < 300 && timewarn < 6)
	{
		timewarn=6;
		sprintf(fotxt, MINUTESLEFT, diff/60);
		fpr(fotxt);
	}

	if (diff < 600 && timewarn < 5)
	{
		timewarn=5;
		sprintf(fotxt, MINUTESLEFT, diff/60);
		fpr(fotxt);
	}

	if (diff < 900 && timewarn < 4)
	{
		timewarn=4;
		sprintf(fotxt, MINUTESLEFT, diff/60);
		fpr(fotxt);
	}

	if (diff < 1800 && timewarn < 3)
	{
		timewarn=3;
		sprintf(fotxt, MINUTESLEFT, diff/60);
		fpr(fotxt);
	}

	if (diff < 2700 && timewarn < 2)
	{
		timewarn=2;
		sprintf(fotxt, MINUTESLEFT, diff/60);
		fpr(fotxt);
	}

	if (diff < 3000 && timewarn < 1)
	{
		timewarn=1;
		sprintf(fotxt, MINUTESLEFT, diff/60);
		fpr(fotxt);
	}

	if ((diff) > 3600 &&
		(user.maintprivs & SYS_SUSR) == 0)
	{
		fpr(EXCEEDEDTIME);
		return(1);
	}
	return(0);
}

/*	Huvudslinga nr man r inloggad i systemet.
	alla kommandoanrop gr via den hr slingan i brjan. */

int	interpret()
{
	char		cmndarea[LINELENGTH+1], chkbuff[LINELENGTH+1],
				slask[80], slask2[80];
	int		z,cmnd, kp, memlines;
	
	if (moetnumber == 0 && area == 1) msgdefault=2;

	newline();

	cmnd=0;
	while(cmnd != 1 && cmnd != 2)
	{
		if (area == 1 &&
			inputemails > 0 && msgdefault != 3) msgdefault=4;

		z=getmaxtext(moetnumber);

		ansi=0;

		if (user.terminal < 3 && user.colour != 0) ansi=1;
		if (user.terminal < 3 && user.colour == 0) ansi=2;

		if ((user.status & 8) == 0)
		{
			listcommands2();
		}

		switch (area)
		{
			case 0 : strcpy(messageprompt, MAINTPROMPT);
				break;
			case 1 : switch (msgdefault)
				{
					case 0 : strcpy(messageprompt,
						NO_MORE_TEXTS);
						break;
					case 1 : sprintf(messageprompt,
						READ_TEXT,
				user.memberinfo[moetnumber].lastread+1,
				meetinf.firsttext+meetinf.texts);
						break;
					case 2 : strcpy(messageprompt,
						NEXTMEETING);
						break;
					case 3 : strcpy(messageprompt,
						REPLY_TEXT);
						break;
					case 4 : strcpy(messageprompt,
						READMAIL);
						break;
					case 5 : strcpy(messageprompt,
						REPLY_TEXT2);
						break;
				}
				break;
			case 2 : strcpy(messageprompt, MAINPROMPT);
				break;
		}
		strcpy(fotxt, messageprompt);

		strcpy(slask, "");

		if ((user.status & 2) == 2)
		{
			tiden(slask);
			if ((user.status & 4) == 0) *(slask + 10)=0;
		}

		if ((user.status & 6) == 4)
		{
			tiden(slask2);
			strcpy(slask, (slask2 + 11));
		}


		if (strcmp(slask, "") != 0)
			sprintf(slask2, "%s %s", slask, fotxt);
		else
			strcpy(slask2, fotxt);

		if (maxtime() != 0) return(0);

		if (ansi == 1)
		{
			sprintf(slask, "%s%s%s",
				ansicol[13],
				slask2,
				ansicol[7]);
			strcpy(slask2, slask);
		}

		if (ansi == 2)
		{
			sprintf(slask, "%s%s%s",
				ansicol[21],
				slask2,
				ansicol[20]);
			strcpy(slask2, slask);
		}

		z=lineed(cmndarea, slask2, lastcmnd, LINELENGTH, 0);

		newline();

/*	Tm inbufferten, s att vi kan stoppa om det rkade vara litet
	"overflow" p input. */

#ifdef MSDOS
		if (baud > 0)
		{
			puinfossil();
		}
#endif

		if (strlen(cmndarea) >=2 ) strcpy(lastcmnd, cmndarea);

		if ( z == 0 )
		{
/*			upper(chkbuff, cmndarea); */
			strcpy(chkbuff, cmndarea);
			cmnd=searchcmnd(chkbuff);

			z=1;

			if (area == 0 && z > 0 && cmnd < 99 && cmnd > 0)
				z=maintcommands(cmnd);

			if (area == 1 && z > 0 && cmnd < 99)
			{

/*				Funktionen lista alla texter. */

				if (cmnd == 25)
				{
					kp=0;
					z=0;

/*	Vi sparar anvndarens sidstorlek, samt stter den tillflligt
	till 12000 rader, s att det inte blir stopp nr man lser
	texter. */

					memlines=user.lines;
					user.lines=12000;

					while((msgdefault == 1 ||
						msgdefault == 2) &&
						kp >= 0 && z < 4)
					{
						msgdefaultact();
#ifdef MSDOS
						kp=keytest();
#endif
						if (msgdefault == 2) z++;
						else z=0;
					}

					cmnd=-1;
					user.lines=memlines;
				}

				if (cmnd > 0) z=msgcommands(cmnd);
				if (cmnd == 0) msgdefaultact();
			}

			if (area == 2 && z > 0 && cmnd < 99 && cmnd > 0)
				z=maincommands(cmnd);

			if (cmnd == 99) listcommands();
		}
	}
	if (cmnd == 2) return(1);
	return(0);
}
