/* LINEED.C  In/Utmatning p en rad med editeringsfunktioner. */
/* (c) 1989, 1990 Nils Hammar */

/* VMS is a trademark of Digital Equipment Corporation. */
/* FOSSIL is a Fido-Opus-Seadog .... */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#include <stdio.h>

#ifdef MSDOS
#include <conio.h>
#include <dos.h>
#else
#include <curses.h>
#endif

#include <time.h>
#include <string.h>

#include "global.h"

#ifndef MSDOS
#include <unistd.h>
#endif

int ansi_flag = FALSE;
int ansi_code = 0;

/*	verstt mellan teckenuppsttningarna!
	Endast de tecken som behver versttas finns lagrade.
	Teckenset
	0	7-bitars ASCII.
	1	IBM PC 8-Bitars.
	2	DEC Multinational.
	3	MAC 8-bitars.
*/

unsigned char	transchar(c, from, to)
unsigned char	c;
int		from, to;
{
	int	i;
	unsigned char	cx;

	i=0;

	while (*(teckenset[from] + i) != c && *(teckenset[from] + i) != 0) i++;

	if (*(teckenset[from] + i) == c && *(teckenset[from] + i) != ' ')
		return(*(teckenset[to] + i));

 	cx=c;

	return(cx);
}

/*	Ls ett tecken frn antingen tangentbord eller serieport
	via FOSSIL-drivrutinen. */

int		fosgetch()
{
	unsigned int	c, z;
	long int	klocka1, klocka2;

#ifdef MSDOS
	if (baud > 0)
	{
		time(&klocka1);

		while(TRUE)
		{
			process_kbd();
			process_ser();
			if ((c = read_buf(&kbd_buf)) != 0xffff) return (c);
			if ((c = read_buf(&ser_buf)) != 0xffff) return (c);
			time(&klocka2);

/*	Om terminalen varit inaktiv lngre n viss tid skall anndaren
	loggas ut. */

			if ((unsigned long int)(klocka2-klocka1) >
				sysdata.timeout) logoff(1);

			z=statusfossil();
			if ((z & 128) == 0 && baud > 0) logoff(2); /* DCD saknas */
		}
	}
	else
	{
		c=getch();
		return(c);
	}
#else
	c=getch();
	return(c);
#endif
}

#ifdef MSDOS
void process_kbd(void)
{
	unsigned int	cx, c, s;

	cx = kbdrdfossil();
	if (cx != 0xffff)
	{
		cx = kbdrdwfossil();
		c = (cx & 0xff);     /* extraherar ascii koden */
		s = (cx >> 8);       /* extraherar scan koden */
		write_buf(&kbd_buf, c);
		if (c == 0) write_buf(&kbd_buf, s);
	}
}

void process_ser(void)
{
   unsigned int	cx, c;
   char s[80];

   cx=statusfossil();
   if ((cx & 128) != 0) {
      cx = rxchfossil();
      c = (cx & 0xff);
      if (cx != 0xffff) { /* ndrat frn 8-bit till 16-bit kontroll! /NH */
         cx = rxchwfossil();
         if (ansi_flag) {
            write_buf(&ser_buf, c);
            look_buf_str(&ser_buf, s);
            if (!ansi_check(s)) {
               ansi_flag = FALSE;
               status_buf(&ser_buf, READLOCK, FALSE);
               }
            }
         else {
            if (c == '\x1b') {
               write_buf(&ser_buf, c);
               ansi_flag = TRUE;
               status_buf(&ser_buf, READLOCK, TRUE);
               }
            else {
               c=(unsigned int)transchar((unsigned char)c,
                  user.charset, BASECHARSET);
               write_buf(&ser_buf, c);
               }
            }
         }
      }
}

#endif

int ansi_check(s)
char	*s;
{
	if (s == NULL) return(FALSE);
	return(FALSE);
}

void	fosputch(tk)
unsigned char	tk;
{
	unsigned int	cx, c, tkn, z;

	tkn=tk;

	if (tkn == 0x8d) tkn=' ';

#ifdef MSDOS
	if (baud > 0)
	{
		z=statusfossil();
		if ((z & 128) == 0 && baud > 0) logoff(2); /* DCD saknas */

		cx=statusfossil();
		if ((cx & 128) != 0)
		{
			c=(int)transchar((unsigned char)tkn,
				BASECHARSET, user.charset);
			txchwfossil((unsigned char)c);
		}

		ansiwritefossil(tkn);
	}
	else
	{
		printf("%c", tkn);
	}
#else
	c=transchar(tkn, BASECHARSET, user.charset);
	printf("%c", c);
#endif
}

void	fpr(tkns)
char	*tkns;
{
	while (*tkns != 0)
	{
		if (*tkns == '\n') fosputch('\r');
		if (*tkns != 0x8d) fosputch(*tkns);
		tkns++;
	}
}

void	efosputch(tkn)
unsigned char	tkn;
{
#ifdef MSDOS
	unsigned int	cx, c, z;

	if (baud > 0)
	{
		z=statusfossil();
		if ((z & 128) == 0 && baud > 0) logoff(2); /* DCD saknas */

		cx=statusfossil();
		if ((cx & 128) != 0)
		{
			c=tkn;
			txchwfossil((unsigned char)c);
		}

		ansiwritefossil(tkn);
	}
	else
	{
		printf("%c", tkn);
	}
#else
	printf("%c", tkn);
#endif
}

void	efpr(tkns)
char	*tkns;
{
	while (*tkns != 0)
	{
		if (*tkns == '\n') efosputch('\r');
		efosputch(*tkns);
		tkns++;
	}
}

void	newline()
{
	fpr("\n");
}

/*	Radera ett tecken p en rad. */

int	delchar(uttext, count)
char	*uttext;
int	count;
{
	if(count<=0) return(0);
	*(uttext + --count)=0;
	fpr(termfunk[user.terminal][6]);

	if (*termfunk[user.terminal][6] != '#')
	{
		fosputch(SPACE);
		fpr(termfunk[user.terminal][6]);
	}
	return(count);
}

/*	Radera allt till vnster om markren p raden. */

int	dellin(uttext, count)
char	*uttext;
int	count;
{
	int	i;
	
	i=count;
	while(i>0) i=delchar(uttext, i);
	return(i);
}

/*	Rita om raden. */

void	redispline(prompt, uttext, count, secret)
char	*prompt, *uttext;
int	count, secret;
{
	int	i;

	if (secret != 1)
	{
		sprintf(fotxt, "%c%s%s", CR, prompt, uttext);
		fpr(fotxt);
	}
	else
	{
		sprintf(fotxt, "%c%s",CR , prompt);
		fpr(fotxt);
		for(i=0;i<count;i++) fosputch('*');
	}
}

/*	Hr kan man lgga in specialhantering fr PC-funktionstangenter. */

int	pcfunktan()
{
	int	intkn;

	intkn=fosgetch();

	return(0);
}

/*	Hr kan man lgga in specialfunktioner fr ESC-sekvenser frn t.ex
	en ANSI eller VT-terminal. */

int	termfunktan()
{
	int	intkn;

	intkn=fosgetch();

	return(0);
}

void	showuserinfo()
{
	char	uttid[25], tid[25];
	long int	stoptime;

	time(&stoptime);
	tidkonv2(stoptime-starttime,uttid);

	tiden(tid);

	sprintf(fotxt, "\n%s CPU : %s  %s\n", tid, uttid, user.username);
	fpr(fotxt);
}

/*	Huvudrutin fr editering av enskild rad.
	Denna rutinen r enda stllet som tangentbordsinmatning sker.
	Detta gr det enkelt att ndra inmatningen, medan dremot
	utmatning mot bildskrm normalt skts med "printf"
	Det br dock inte vara allt fr betungande att modifiera
	framver.

	secret har f.n. 3 olika betydelser.

	0.	Visa texten som den matas in.
	1.	Visa enbart en "*" fr varje tecken som r giltigt.
	2.	Lgg hela 'inbuff' i 'uttext' som default-vrde.
*/

int	lineed(uttext, prompt, inbuff, maxlen, secret)
char	*uttext, *prompt, *inbuff;
int	maxlen, secret;
{
	int	count=0, intkn=0, inct=0, margin, z, i;
	
	*uttext=0;
	margin=15;

	if (maxlen < 55) margin=0;
	
/*	Om det skall vara defaultvrde skall inbufferten matas in. */

	sprintf(fotxt, "%s", prompt);
	fpr(fotxt);

	if (secret == 2)
	{
		while (*(inbuff + inct) != 0 && inct < (maxlen - 1))
		{
			fosputch(*(inbuff + inct));
			*(uttext + count++)=*((inbuff + inct++));
		}
		*(uttext + count)=0;
	}

	if (secret == 3)
	{
		while (*(textstore + inct) != 0 && inct < (maxlen - 1))
		{
			fosputch(*(textstore + inct));
			*(uttext + count++)=*((textstore + inct++));
		}
		*(uttext + count)=0;
	}

	while (intkn != 13 && count < maxlen)
	{
		intkn=fosgetch();

		*(uttext + count) = 0;
		*(uttext + count + 1) = 0;

/*	Om det var en trolig PC-funktionstangent. */

		if (intkn == 0)
		{
			z=pcfunktan();
		}

/*	Om det var ETX, d.v.s. CTRL+C. */

		if (intkn == 3)
		{
			*(uttext + count) = 0;
			return(-2);
		}

/*	Om det var CTRL+E skall resten av inbufferten matas in. */

		while (intkn == 5 && *(inbuff + inct) != 0)
		{
			if(secret != 1) fosputch(*(inbuff + inct));
			else fosputch('*');
			*(uttext + count++)=*((inbuff + inct++));
			*(uttext + count)=0;
		}

/*	Om det var BS eller DEL skall tecknet nrmast till vnster om
	markren raderas, och markren flyttas ett steg till vnster. */

		if (intkn == 8 || intkn == 127) count=delchar(uttext, count);

/*	Om det r TAB, skall ett tecken frn inbufferten skjutas
	in i utbuffert. */

		if (intkn == 9 && *(inbuff + inct) != 0)
		{
			if(secret != 1) fosputch(*(inbuff + inct));
			else fosputch('*');
			*(uttext + count++)=*((inbuff + inct++));
			*(uttext + count)=0;
		}

/*	Om det var CTRL+R skall raden ritas om. */

		if (intkn == 18) redispline(prompt, uttext, count, secret);

/*	Om det var CTRL+T skall vi visa anvndarinformation. */

		if (intkn == 20)
		{
			showuserinfo();
			redispline(prompt, uttext, count, secret);
		}

/*	Om det var CTRL+X skall raden raderas. */

		if (intkn == 24) count=dellin(uttext, count);

/*	Om det var CTRL+Y r det frgan om ett avbrott.
	Detta avbrott kan lngre fram skiljas frn CTRL+C, men behandlas
	normalt lika. CTRL+Y r hmtat frn VAX/VMS. */

		if (intkn == 25)
		{
			*(uttext + count) = 0;
			return(-1);
		}

/*	Om det var CTRL+Z. */

		if (intkn == 26)
		{
			*(uttext + count) = 0;
			return(1);
		}

/*	Om escape. */

		if (intkn == 27)
		{
			z=termfunktan();
		}

		if ((intkn >= 32 && intkn < 127) || intkn >= 128)
		{
			if(secret != 1) fosputch((unsigned char)intkn);
			else fosputch('*');
			*(uttext + count++)=(unsigned char)intkn;
			*(uttext + count)=0;
		}
	}

	*(uttext + count) = 0;

	if (intkn != 13)
	{
		i=strlen(uttext);
		while(i > 0 && *(uttext+i) != ' ') i--;

		if (i>0)
		{
			if (*(uttext + i) == ' ') i++;
			strcpy(textstore, (uttext+i));

			*(uttext + i)=0x8D; /* Lgger p en Soft CR hr. */

			*(uttext + i + 1)=0;
			z=strlen(textstore);

			while (z > 0)
			{
				fpr(termfunk[user.terminal][6]);

				if (*termfunk[user.terminal][6] != '#')
				{
					fosputch(SPACE);
					fpr(termfunk[user.terminal][6]);
				}

				z--;
			}
		}
		else
		{
			strcpy(textstore, "");
		}
		return(2);
	}

	strcpy(textstore, "");
	return(0);
}

void	operator()
{
#ifdef MSDOS
	int	i, z, c, cx;
	char	slask[80];

	if (baud <= 0) return;

	z=0;
	i=0;
	newline();

	while ((unsigned int)i < sysdata.operator && z == 0)
	{
		cx = kbdrdfossil();
		c = (cx & 0xff);
		if (c == 27) z=-1;
		if (c == 3 || c == 25) return;

		cx = rxchfossil();
		c = (cx & 0xff);
		if (c == 3 || c == 25) return;

		if (z == 0)
		{
			fpr("\007.");
			sleep(1);
		}
		i++;
	}

	if (z == 0) return;

	*textstore=0;

	z=0;
	while (z >= 0)
	{
		newline();
		z=lineed(slask, "OP>", "", 76, 3);
	}
#endif
}
