/* LOGIN.C - Inloggningsrutin, vilken anropar funktioner i INTERPRE.C. */
/* "AURORA" (c) 1989, 1990 Nils Hammar */

/*	This code may be used complete or partly by anyone as long as
	i am credited for being involved in the source.
	The credits MUST appear possible to read when starting the derived
	program, and in the documentation and manual in the form:
	"Contains code (c) 1990 Nils Hammar" in any language of:
	Swedish, English or German preferably.

	It is free to spread this code and programs hereof both free
	and if code is added for money as long as i am credited for it.
	Excluding of code MUST be by comments, and when code is included
	there MUST be a comment which describes WHO has done it, WHY,
	and WHEN. All changes and additions should be reported to me
	to determine if they should be included in further versions.

	All necessary text translations will be in GLOBAL.H and
	possibly in PRIVS.H if translation to another language is necessary.

	Extensions of H-files in different languages:
	.SWE	Swedish
	.ENG	English
	.SUO	Finnish
	.GER	German

	Adding code to one file MUST be added to the others, in
	at least english.
*/

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#define LOGIN

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <signal.h>

#ifdef MSDOS
#include <dos.h>
#else
#include <curses.h>
#endif

#include <time.h>
#include <stdlib.h>
#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

/*	Anropa denna rutin nr en ny anvndare skall lggas in. */

void	newuser()
{
	int		z, i, rad, usernr;
	char		slask[80], tmp[160], tmp2[160];
	FILE		*f;

	i=0;
	strcpy(user2.username, "x");
	user2.status=0;

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int)sizeof(userrec), SEEK_SET) != 0)
	{
		sprintf(tmp, GETUSERERR1);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}

/*	Leta reda p frsta lediga USER. */

	while ((unsigned int)i < users && strcmp(user2.username, "") != 0)
	{
		i++;

		if (fread((char *) &user2, sizeof(userrec), 1, f) == 0)
		{
			sprintf(tmp, GETUSERERR2);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}
	}

	fclose(f);

/*	Om det sista kontot inte var sprrat, s ka numret igen. */

	if ((unsigned int)i == users && strcmp(user2.username, "") != 0) i++;

	usernr=i;

	newline(); newline();

	strcpy(tmp2, env);
	strcat(tmp2, "NEWUSER.TXT");

#ifdef MSDOS
	if ((f=fopen(tmp2, "rt")) != NULL)
#else
	if ((f=fopen(tmp2, "r")) != NULL)
#endif
	{
		rad=0;

		while (fgets(tmp, 160, f) != 0)
		{
			fpr(tmp);
			rad++;

			if (rad > 15)
			{
				strcpy(fotxt, "");
				strcpy(slask, PRESSRETURN);

				if (ansi == 1) sprintf(slask,"%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

				if (ansi == 2) sprintf(slask,"%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

				z=lineed(fotxt, slask, "", 20, 0);
				if (z < 0 || strcmp(fotxt, "") != 0)
				{
					fclose(f);
					return;
				}
				newline();
				rad=0;
			}
		}
		fclose(f);

		newline(); newline();
	}

	i=-1;
	while(i != 0)
	{
		z=lineed(user2.username, USERNAME, "", 28, 0);	
		if (z<0) return;

		z=nameconv(slask, user2.username);
		strcpy(tmp, slask);

		if (z >= 2)
		{
			i=userfind(slask);
			if (i != 0)
			{
				fpr(DUPUSERID);
			}
		}
		else
		{
			i=-1;
			fpr(FULLNAME);
		}
	}

	strcpy(user2.dummy,"\376");

	nameconv(user2.username, tmp);

	newline();
	strcpy(user2.password, "X");
	strcpy(tmp, "");

	while(strcmp(tmp, user2.password) != 0)
	{
		z=lineed(user2.password, PASSWORD, "", 28, 1);
		if (z<0) return;
		newline();
		upper(slask, user2.password);
		strcpy(user2.password, slask);

		z=lineed(tmp, PASSWORD2, "", 28, 1);
		if (z<0) return;
		newline();
		upper(slask, tmp);
		strcpy(tmp, slask);
	}

	z=lineed(user2.adress, ADDRESS2, "", 28, 0);	
	if (z<0) return;
	newline();
	z=lineed(user2.postnr, ZIPCODE, "", 10, 0);	
	if (z<0) return;
	newline();
	z=lineed(user2.postadress, CITY, "", 28, 0);	
	if (z<0) return;
	newline();
	z=lineed(user2.tel, PHONE, "", 28, 0);	
	if (z<0) return;
	newline();
	strcpy(user2.lastlogin,"");

	*user2.termtype=31;
	*(user2.termtype + 1)=0;

/*	z=lineed(user2.termtype, TERMTYPE, "", 18, 0);	
	if (z<0) return;
	newline(); */

/*	Vlj Editor, Frg och Terminal i stllet fr
	enbart terminalbeteckning. */

/*------------------------------------------------------*/

	z=-1;
	strcpy(slask, "X");

	fpr(EDITORS);

	i=0;
	while(*editors[i] != 0)
	{
		if (user2.editor != (unsigned int)i)
		{
			sprintf(fotxt, "   %2d = %s\n", i+1,
				editors[i]);
		}
		else
		{
			sprintf(fotxt, "*  %2d = %s\n", i+1,
				editors[i]);

			if (ansi == 1)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[12],
					i+1, editors[i],
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[21],
					i+1, editors[i],
					ansicol[20]);
		}

		fpr(fotxt);
		i++;
	}

	while (z < 0 || z > 10)
	{
		z=lineed(slask, EDITOR, "", 28, 0);
		newline();
		if (z < 0) return;
		z=atoi(slask)-1;
	}
	if (z >=0 && z <= 3) user2.editor=z;

/*------------------------------------------------------*/

	z=-1;
	strcpy(slask, "X");

	fpr(TERMTYPE2);

	i=0;
	while(i<12)
	{
		if (user2.terminal != (unsigned int)i)
		{
			sprintf(fotxt, "   %2d = %s\n", i+1,
				termfunk[i][0]);
		}
		else
		{
			sprintf(fotxt, "*  %2d = %s\n", i+1,
				termfunk[i][0]);

			if (ansi == 1)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[12],
					i+1, termfunk[i][0],
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[21],
					i+1, termfunk[i][0],
					ansicol[20]);

		}

		fpr(fotxt);
		i++;
	}

	if (baud > 0) fpr(DETECTTERMINAL);

	newline();

	strcpy(tmp, "");
	strcpy(slask, "");
	z=-1;

	while (z < 0 || z > 11)
	{
		if (*slask == '?' && baud > 0)
		{
			sprintf(tmp, "%d", inquireterminal());
		}
		z=lineed(slask, TERMTYPE, tmp, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask)-1;
	}
	if (z >=0 && z <= i) user2.terminal=z;

	if (user2.terminal < 3)
	{
		z=-1;
		while ((z < 0 || z > 1) && *slask != 0)
		{
			z=lineed(slask, TERMCOLOUR, "", 28, 0);
			newline();
			if (z < 0) return;
			z=-1;
			if (*slask == YES1 ||
				*slask == YES2) z=1;
			if (*slask == 'N' ||
				*slask == 'n') z=0;
		}
		user2.colour=z;
	}
	else
	{
		user2.colour=0;
	}

/*------------------------------------------------------*/



	user2.lines=0;
	while (user2.lines < 7 || user2.lines > 255)
	{
		z=lineed(slask, TERMLINES, "", 28, 0);
		if (z<0) return;
		newline();
		user2.lines=atoi(slask);
	}

	user2.columns=0;
	while (user2.columns < 20 || user2.columns > 255)
	{
		z=lineed(slask, TERMCOLS, "", 28, 0);	
		if (z<0) return;
		newline();
		user2.columns=atoi(slask);
	}

	fpr(CHARSETS);

	for (i=0;i<=10;i++)
	{
		sprintf(fotxt, "%2d = %s\n", i+1, teckendef[i]);
		fpr(fotxt);
	}

	newline();
	newline();

	i=-1;
	while (i < 0 || i > 10)
	{
		z=lineed(slask, TERMCHARS, "", 28, 0);	
		if (z<0) return;
		newline();
		i=atoi(slask)-1;
	}

	user2.charset=(unsigned int) i;

	newline(); newline();

/*	Hr stter man privilegierna som beskrivs i filen PRIVS.H */

	user2.maintprivs=sysdata.maintprivs;

	user2.fileprivs=sysdata.fileprivs;

	user2.textprivs=sysdata.textprivs;

	user2.totaltime=0L;

/*	Kontot r PPET som ny anvndare! */

	user2.status=0;

	for(i=0;i<256;i++)
	{
		user2.memberinfo[i].moetstatus=0;
		user2.memberinfo[i].lastread=0;
	}

	user2.memberinfo[1].moetstatus=1;
	user2.memberinfo[2].moetstatus=1;

/*	ppna anvndarfilen */

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");
 
#ifdef MSDOS
	if ((f=fopen(fotxt, "rb+")) == NULL)
#else
	if ((f=fopen(fotxt, "r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	sprintf(fotxt, NEWUSERNUMBER, usernr);
	fpr(fotxt);

	if (fseek(f, (unsigned long int) usernr *
		(unsigned long int) sizeof(userrec), SEEK_SET) != 0)
	{
		perror(UPDATEUSR1);
		fclose(f);
		logg(UPDATEUSR1, 0);
		exit(9);
	}

/*	Skriv in den nya anvndaren i systemet */

	if (fwrite((char *) &user2, sizeof(userrec), 1, f) == 0)
	{
		perror(UPDATEUSR2);
		fclose(f);
		logg(UPDATEUSR2, 0);
		exit(9);
	}

/*	Sk upp frsta position i registret igen, och skriv ner det nya
	antalet anvndare. */

	if (fseek(f, 0L, SEEK_SET) != 0)
	{
		perror(UPDATEUSR1);
		fclose(f);
		logg(UPDATEUSR1, 0);
		exit(9);
	}

	if ((unsigned int)usernr > users)
	{
		users=usernr;

		if (fwrite((char *) &users, sizeof(int), 1, f) == 0)
		{
			perror(UPDATEUSR2);
			fclose(f);
			logg(UPDATEUSR2, 0);
			exit(9);
		}
	}

	fclose(f);

	sprintf(fotxt, NEWUSERINFO1, usernr, user2.username);
	logg(fotxt, 1);

	sprintf(fotxt, NEWUSERINFO2, usernr);
	fpr(fotxt);
	newline();

	sprintf(fotxt, NEWUSERINFO3, usernr);
	fpr(fotxt);
	newline();
}

/*	Inloggningssekvens. Kolla anvndarID och lsenord. */

int	login()
{
	FILE		*f;
	int		i, j, k, z, usernr;
	long int	position;
	char		username[30], password[30], slask[80], chkpwd[30];

	newline();
	*username=0;
	while(*username == 0)
	{
		z=lineed(username, LOGINNAME, "", 30, 0);
		newline();
		upper(username, username);
		if (strcmp(username, "NEW") == 0)
		{
			newuser();
			*username=0;
		}
	}
	z=lineed(password, PASSWORD, "", 30, 1);
	upper(slask,password);
	strcpy(password,slask);

	j=atoi(username);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");
 
#ifdef MSDOS
	if ((f=fopen(fotxt,"rb")) == NULL)
#else
	if ((f=fopen(fotxt,"r")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, 0L, SEEK_SET) != 0)
	{
		perror(LOGINERR1);
		fclose(f);
		logg(LOGINERR1, 0);
		exit(9);
	}

	z=fread((char *) &users, sizeof(int), 1, f);

	if (j == 0)
	{
		usernr=1;

		position=(unsigned long int) usernr *
			(unsigned long int) sizeof(userrec);

		if (fseek(f, position, SEEK_SET) != 0)
		{
			perror(LOGINERR1);
			fclose(f);
			logg(LOGINERR1, 0);
			exit(9);
		}

		k=0;

		nameconv(slask, username);
		strcpy(username, slask);

		for(i=1;i<=(int)users;i++)
		{
			z=fread((char *) &user, sizeof(userrec), 1, f);
			if (instring( username, user.username) == 0)
			{
				j=i;
				k++;
			}
		}

		if (k > 1)
		{
			sprintf(fotxt, "\nAmbigous username!\n");
			fpr(fotxt);
			return(-1);
		}

		if (k == 1)
		{
			usernr=j;

			position=(unsigned long int) usernr *
				(unsigned long int) sizeof(userrec);

			if (fseek(f, position, SEEK_SET) != 0)
			{
				perror(LOGINERR1);
				fclose(f);
				logg(LOGINERR1, 0);
				exit(9);
			}

			z=fread((char *) &user, sizeof(userrec), 1, f);

			printf("%s\n", user.username);

			upper(chkpwd, user.password);

			if (strcmp( chkpwd, password) == 0 &&
			    (user.status & 128) == 0)
			{
				fclose(f);
				return(usernr);
			}
		}
	}
	else
	{
		if ( j > (int)users) return(0);
		usernr=j;

		if (fseek(f, (unsigned long int) j *
			(unsigned long int) sizeof(userrec), SEEK_SET) != 0)
		{
			perror(LOGINERR1);
			fclose(f);
			logg(LOGINERR1, 0);
			exit(9);
		}


		z=fread((char *) &user, sizeof(userrec), 1, f);
		if (z == 0)
		{
			perror(LOGINERR2);
			fclose(f);
			logg(LOGINERR2, 0);
			exit(9);
		}

		upper(chkpwd, user.password);

		if (strcmp(chkpwd, password) == 0 &&
			strcmp(user.username, "") != 0 &&
			(user.status & 128) == 0)
		{
			fclose(f);
			return(usernr);
		}
	}
	fclose(f);
	return(0);
}

/*	Uppdatera dina parametrar, som t.ex. inloggad tid. */

void	updateuser(fl)
int	fl;
{
	char	uttid[25];
	long int	stoptime;
	FILE	*f;


	if (fl == 0)
	{
		time(&stoptime);
		user.totaltime=user.totaltime+stoptime-starttime;

		sprintf(fotxt, LOGOUTMESSAGE, user.username);
		fpr(fotxt);

		tidkonv2(stoptime-starttime,uttid);
		sprintf(fotxt, LOGINTIME, uttid);
		fpr(fotxt);

		sprintf(fotxt, LOGGED_OUT, uttid);
		logg(fotxt, 4);

		tidkonv2(user.totaltime,uttid);
		sprintf(fotxt, TOTALTIME, uttid);
		fpr(fotxt);
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");
 
#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int) usernumber *
		(unsigned long int) sizeof(userrec), SEEK_SET) != 0)
	{
		perror(UPDATEUSR1);
		fclose(f);
		logg(UPDATEUSR1, 0);
		exit(9);
	}

	if (fwrite((char *) &user, sizeof(userrec), 1, f) == 0)
	{
		perror(UPDATEUSR2);
		fclose(f);
		logg(UPDATEUSR2, 0);
		exit(9);
	}
	fclose(f);
}

void	logoff(flag)
int	flag;
{
/*	Om vi skriver ner systemdata under inloggningssekvensen
	blir det inget vidare! Vi gr det sledes enbart om vi
	har en inloggad anvndare, eftersom annars fr vi trasiga
	systemdata. */

	if (usernumber > 0) updateuser(0);

	env=getenv("ADATA");

	strcpy(fotxt, env);

	switch (flag)
	{
		case 0 : strcat(fotxt, "LOGOUT.TXT"); break;
		case 1 : strcat(fotxt, "INACTIVE.TXT"); break;
		case 2 : printf(LOSTCARR);
	}

	if (flag >= 0 && flag <= 1) showfile(fotxt, 0);

	if (flag == 1 || flag == 2)
	{
		exitprogram();
		exit(1);
	}
}

void	loadeditors(dir)
char	*dir;
{
	char	tmp[80];
	int	i;
	FILE	*f;

	strcpy(tmp, dir);
	strcat(tmp, "EDITORS.CFG");
	i=1;

	strcpy(editors[0], BUILTINEDITOR);
	*editors[1]=0;

	if ((f=fopen(tmp, "rt")) == NULL)
	{
		return;
	}

	while(fgets(editors[i++], 78, f) != NULL);
	*editors[i]=0;

	fclose(f);
	return;
}

/*	Huvudslinga i programmet. */

int	mainloop()
{
	char	uttid[25], tmp[10], tmp2[80], slask[80];
	int	i, go, z;
	FILE	*f;

	usernumber=0;

	i=0;

	env=getenv("ADATA");
	loadeditors(env);

	while(usernumber == 0 && i++ <= MAXRETRY)
	{
		usernumber=login();

		if (usernumber == 0)
		{
			sprintf(fotxt, "\n%s\n", WRONGUSERID);
			fpr(fotxt);
			logg(BADUSERID, 1);
		}

		if ((user.status & 1 ) != 0 && usernumber > 1)
		{
			sprintf(fotxt, DISCONNECTED);
			fpr(fotxt);
			logg(DISCONNACCT, 1);
			usernumber=0;
		}

		if (usernumber == -1)
		{
			sprintf(fotxt, DUPUSERID);
			fpr(fotxt);
			logg(DUPLICATEUID, 4);
			usernumber=0;
		}
	}

	if (i >= MAXRETRY)
	{
		env=getenv("ADATA");

		strcpy(fotxt, env);
		strcat(fotxt, "NOLOGIN.TXT");
		user.lines=24;
		showfile(fotxt, 0);
 	}

	if (usernumber == 0) return(0);

	tiden(uttid);

	sprintf(fotxt, WELCOMEUSER,user.username);
	fpr(fotxt);
	sprintf(fotxt, LASTLOGIN, user.lastlogin);
	fpr(fotxt);

	sprintf(fotxt, USERLOGIN, user.lastlogin);
	logg(fotxt,1);

	time(&starttime);
	timewarn=0;


	sprintf(fotxt, WELCOMEMESS, sysdata.systemname);
	fpr(fotxt);

	env=getenv("ADATA");

	strcpy(fotxt, env);
	strcat(fotxt, "WELCOME.TXT");
	showfile(fotxt, 0);
 
	strcpy(tmp2, env);
	strcat(tmp2, "LASTLOG.TXT");
#ifdef MSDOS
	if ((f=fopen(tmp2, "wt")) != NULL)
#else
	if ((f=fopen(tmp2, "w")) != NULL)
#endif
	{
		fprintf(f, LASTLOGGED, user.username);
		fclose(f);
	}

	sprintf(fotxt, SCANNINGMAIL);
	fpr(fotxt);

	inputemails=0;
	sprintf(tmp, "%d", usernumber);
	scanmail(tmp);

	strcpy(fotxt, "");
	strcpy(slask, PRESSRETURN);

	if (ansi == 1) sprintf(slask,"%s%s%s",
			ansicol[14],
			PRESSRETURN,
			ansicol[7]);

	if (ansi == 2) sprintf(slask,"%s%s%s",
			ansicol[21],
			PRESSRETURN,
			ansicol[20]);

	z=lineed(fotxt, slask, "", 20, 0);

	newline();

	z=fortune();

	strcpy(lastcmnd, "");

	msgdefault=2;
	moetnumber=0;
	area=1;
	strcpy(user.lastlogin, uttid);
	user.logins++;

	if (*user.termtype != 31)
	{
		user.editor=0;
		user.colour=0;
		user.terminal=0;
		*user.termtype=31;
	}

	go=interpret();

	logoff(0);

	return(go);
}

void	enterprogram()
{
	int	z;

#ifdef MSDOS
/*	Hantera watchdog on! */
	if (baud > 0)
	{
		dtronfossil();

		if ((sysdata.sysflags & 4) == 0)
		{
			wdonfossil();
		}

		if ((sysdata.sysflags & 8) == 0)
		{
			fpr(TESTINGTERM);
			z=inquireterminal();
			sprintf(fotxt, USETERM, termfunk[z][0], z+1);
			fpr(fotxt);
		}

/*	Hantera XON/XOFF. */
		fcfossil(3); /* 1 fr Xon/Xoff, 2 fr CTS/RTS. */

/*	Baud, paritet, stopbitar och teckenlngd. */
		z=baudfossil(baud,0,1,8);
	}

#endif

	sprintf(fotxt, CONNMESS, baud);
	fpr(fotxt);

}

void	exitprogram()
{
	sleep(2);
	fclose(logf);

#ifdef MSDOS
/*	Deaktivera WatchDog, och slpp DTR. */

	if (baud > 0)
	{
		wdoffossil();
		dtroffossil();
		deinitfossil();
		sleep(1);
	}
#endif
}

/*	Programstart! */

int	main(argc, argv)
int	argc;
char	*argv[];
{
	int	z, go;
	FILE	*f;

/* JANNE { */

/* skapa buffertar fr inhmtningen av tecken frn tangentbord
   och serieport och fr inhmtningen internt i fosgetch()     */

#ifdef MSDOS
	init_buf(&kbd_buf);
	init_buf(&ser_buf);
#endif

/* JANNE } */

/*	Stng av CTRL+C. */

	signal(SIGINT, SIG_IGN);

/*	Stll in p 7 bitars ASCII som default, innan vi vet vad som
	r uppringt. */

	user.charset=0;
	strcpy(user.username, "");

	ansi=0;

	if ((tempfile = getenv("TEMPFILE")) == NULL)
	{
		printf(TEMPFILEERR);
		exit(9);
	}

	if ((tempdir = getenv("TEMPDIR")) == NULL)
	{
		printf(TEMPDIRERR);
		exit(9);
	}

	if ((env=getenv("ADATA")) == NULL)
	{
		printf(ADATAERR);
		exit(9);
	}

	if ((outbound=getenv("OUTBOUND")) == NULL)
	{
		outbound=calloc(80, sizeof(char));

		if (outbound == NULL)
		{
			printf(ALLOCERROR);
			logg(ALLOCERROR, 0);
			exit(9);
		}

		strcpy(outbound, "C:\\BINKLEY\\OUTBOUND\\");
	}

	if ((inmail=getenv("INPACKS")) == NULL)
	{
		inmail=calloc(80, sizeof(char));

		if (inmail == NULL)
		{
			printf(ALLOCERROR);
			logg(ALLOCERROR, 0);
			exit(9);
		}

		strcpy(inmail, "C:\\INPACKS\\");
	}

	strcpy(fotxt, env);
	strcat(fotxt, "AURORA.LOG");
 
#ifdef MSDOS
	if ((logf=fopen(fotxt, "at")) == NULL)
#else
	if ((logf=fopen(fotxt, "a")) == NULL)
#endif
	{
		perror(fotxt);
		exit(9);
	}

	if (argc >= 2) baud=atoi(argv[1]);
	else baud=0;

	if (argc >= 3) port=atoi(argv[2]);
	else port=1;

#ifdef MSDOS
	if (baud > 0)
	{
		if (initfossil() != 0x1954)
		{
			fprintf(stderr, "%s\n\n", NOFOSSIL);
			logg(NOFOSSIL, 2);
			exit(255);
		}
	}

#endif

/*	Hr tilldelas antalet logiska drivar i systemet. */

	loadunits();

/*	Krning av speciella rutiner. */

	if ((env=getenv("ADATA")) == NULL)
	{
		fpr(ADATAERR);
		logg(UPDATEUSR1, 2);
		exit(9);
	}

	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");
 
#ifdef MSDOS
	if (( f = fopen(fotxt,"rb")) == NULL)
#else
	if (( f = fopen(fotxt,"r")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int) sizeof(int), SEEK_SET) != 0)
	{
		perror(MAINERR1);
		fclose(f);
		logg(MAINERR1, 0);
		exit(9);
	}

	z=fread((char *) &sysdata, sizeof(systemdata), 1, f);

	fclose(f);

/*	Om timeoutgrnsen r orimlig stter vi upp den till sextio
	sekunder, vilket rcker tills man har hunnit justera den. */

	if (sysdata.timeout < 10) sysdata.timeout=60;

/*	Initiera variabeln "tzdiff", s att vi kan anvnda den om vi
	vill hantera bde GMT och lokal tid. */

	timediff();

	users=getusers();

	if (baud == -1)
	{
		user.maintprivs=255;
		user.textprivs=255;
		user.fileprivs=255;
		logg(PACKING2, 3);
		packecho();
		logg(PACKEDOK, 3);
		logg(LOADING, 3);
		loadecho();
		logg(LOADEDOK, 3);
		exit(0);
	}

	if (baud == -2)
	{
		extractmail();
		logg(EXTRACTING1, 3);
		extractecho();
		logg(EXTRACTEDOK1, 3);
		exit(0);
	}

	if (baud == -3)
	{
		logg(EXTRACTING2, 3);
		extractmail();
		logg(EXTRACTEDOK2, 3);
		exit(0);
	}

	if (baud == -4)
	{
		routelist();
		exit(0);
	}

	if (baud == -5)
	{
		packlist();
		exit(0);
	}

	if (baud == -6)
	{
		mailfile();
		exit(0);
	}

	if (baud == -7)
	{
		user.maintprivs=255;
		user.textprivs=255;
		user.fileprivs=255;
		logg(LOADING, 3);
		loadecho();
		logg(LOADEDOK, 3);
		exit(0);
	}

	if (baud == -8)
	{
		user.maintprivs=255;
		user.textprivs=255;
		user.fileprivs=255;
		logg(PACKING2, 3);
		packecho();
		logg(PACKEDOK, 3);
		exit(0);
	}

	if (baud > 0) enterprogram();

	go=-1;

	while(go)
	{
		ansi=0;

		if ((env=getenv("ADATA")) == NULL)
		{
			fpr(ADATAERR);
			logg(ADATAERR, 0);
			exit(9);
		}

		strcpy(fotxt, env);
		strcat(fotxt, "PUBLIC.TXT");
		user.lines=24;
		showfile(fotxt, 0);
 
		strcpy(fotxt, env);
		strcat(fotxt, "LASTLOG.TXT");
		user.lines=24;
		showfile(fotxt, 0);
 
		sprintf(fotxt, PRELOGIN, SYSTEMVERSION);
		fpr(fotxt);

		loadcommands();

		go=mainloop();
	}
	exitprogram();
	return(0);
}

void	loadcommands()
{
	FILE	*f1;
	unsigned char	tmp[160];
	unsigned int	i, j;

	strcpy(fotxt, env);
	strcat(fotxt, "COMMANDS.CFG");

	if ((f1=fopen(fotxt, "rt")) == NULL)
	{
		perror(fotxt);
	}

	i=0;
	j=0;

	while(fgets(tmp, 158, f1) != NULL)
	{
		*(tmp+strlen(tmp)-1)=0;

		kommandon[i][j]=calloc(strlen(tmp)+1, sizeof(char));
		strcpy(kommandon[i][j], tmp);
		j++;

		if (j==30)
		{
			i++;
			j=0;
		}
	}

	*tmp=0;
	kommandon[i][j]=calloc(strlen(tmp)+1, sizeof(char));
	strcpy(kommandon[i][j], tmp);

	fclose(f1);
}
