/*  MAINT1.C - Systemunderhllsrutiner. */
/* "AURORA" (c) 1989, 1990 Nils Hammar */

/*	This code may be used complete or partly by anyone as long as
	i am credited for being involved in the source.
	The credits MUST appear possible to read when starting the derived
	program, and in the documentation and manual in the form:
	"Contains code (c) 1990 Nils Hammar" in any language of:
	Swedish, English or German preferably.

	It is free to spread this code and programs hereof both free
	and if code is added for money as long as i am credited for it.
	Excluding of code MUST be by comments, and when code is included
	there MUST be a comment which describes WHO has done it, WHY,
	and WHEN. All changes and additions should be reported to me
	to determine if they should be included in further versions.

	All necessary text translations will be in GLOBAL.H and
	possibly in PRIVS.H if translation to another language is necessary.

	Extensions of H-files in different languages:
	.SWE	Swedish
	.ENG	English
	.SUO	Finnish
	.GER	German

	Adding code to one file MUST be added to the others, in
	at least english.
*/


#define MAINT

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

/*	Konvertera frn anvndarnamn till anvndarnummer. */

int	userfind(userid)
char	*userid;
{
	int	i, diff;
	FILE	*f;
	char	tmp[80];

	i=0;
	diff=-1;

	users=getusers();

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int)sizeof(userrec), SEEK_SET) != 0)
	{
		sprintf(tmp, GETUSERERR1);
		perror(tmp);
		logg(tmp, 0);
		fclose(f);
		exit(9);
	}

	while((unsigned int)i < users && diff != 0)
	{
		i++;

		if (fread((char *) &user2, sizeof(userrec), 1, f) == 0)
		{
			sprintf(tmp, GETUSERERR2);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}

		diff=instring(userid, user2.username);
	}

	if (diff != 0 || (unsigned int)i > users) i=0;

	fclose(f);
	return(i);
}

/*	ndra annan anvndares parametrar. */

void	editother(usernr)
int	usernr;
{
	int		z, i;
	char		slask[80], slask2[80];

	if ((user.maintprivs & SYS_SETPAR) == 0)
	{
		fpr(NOEDITPRIV);
		logg(NOEDITPRIV, 1);
		return; 
	}

	z=getuserinfo(usernr);

	sprintf(fotxt, EDITOTHERUSER, usernr, user2.username);
	logg(fotxt, 3);
	sprintf(fotxt, EDITUSERDATA, user2.username);
	fpr(fotxt);

	newline();
	z=lineed(slask, USERNAME, user2.username, 28, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) i=nameconv(user2.username, slask);

	newline();
	z=lineed(slask, ADDRESS2, user2.adress, 28, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user2.adress, slask);

	newline();
	z=lineed(slask, ZIPCODE, user2.postnr, 10, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user2.postnr, slask);

	newline();
	z=lineed(slask, CITY, user2.postadress, 28, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user2.postadress, slask);

	newline();
	z=lineed(slask, PHONE, user2.tel, 28, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user2.tel, slask);

/*	newline();
	z=lineed(slask, TERMTYPE, user2.termtype, 18, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user2.termtype, slask); */

/*	Vlj Editor, Frg och Terminal i stllet fr
	enbart terminalbeteckning. */

/*------------------------------------------------------*/

	z=-1;
	strcpy(slask, "X");

	fpr(EDITORS);

	i=0;
	while(*editors[i] != 0)
	{
		if (user2.editor != (unsigned int)i)
		{
			sprintf(fotxt, "   %2d = %s\n", i+1,
				editors[i]);
		}
		else
		{
			sprintf(fotxt, "*  %2d = %s\n", i+1,
				editors[i]);

			if (ansi == 1)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[12],
					i+1, editors[i],
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[21],
					i+1, editors[i],
					ansicol[20]);
		}

		fpr(fotxt);
		i++;
	}

	sprintf(slask2, "%d", user2.editor+1);

	while ((z < 0 || z > 10) && *slask != 0)
	{
		z=lineed(slask, EDITOR, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask)-1;
	}
	if (z >=0 && z <= 3) user2.editor=z;

/*------------------------------------------------------*/

	z=-1;
	strcpy(slask, "X");

	fpr(TERMTYPE2);

	i=0;
	while(i<12)
	{
		if (user2.terminal != (unsigned int)i)
		{
			sprintf(fotxt, "   %2d = %s\n", i+1,
				termfunk[i][0]);
		}
		else
		{
			sprintf(fotxt, "*  %2d = %s\n", i+1,
				termfunk[i][0]);

			if (ansi == 1)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[12],
					i+1, termfunk[i][0],
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[21],
					i+1, termfunk[i][0],
					ansicol[20]);
		}

		fpr(fotxt);
		i++;
	}

	sprintf(slask2, "%d", user2.terminal+1);
	newline();
	z=-1;

	while ((z < 0 || z > 11) && *slask != 0)
	{
		z=lineed(slask, TERMTYPE, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask)-1;
	}
	if (z >=0 && z <= i) user2.terminal=z;

	strcpy(slask2, "N");
	if (user2.colour != 0)
	{
		*slask2=YES1;
		*(slask2+1)=0;
	}

	if (user2.terminal < 3)
	{
		z=-1;
		while ((z < 0 || z > 1) && *slask != 0)
		{
			z=lineed(slask, TERMCOLOUR, slask2, 28, 2);
			newline();
			if (z < 0) return;
			z=-1;
			if (*slask == YES1 ||
				*slask == YES2) z=1;
			if (*slask == 'N' ||
				*slask == 'n') z=0;
		}
		user2.colour=z;
	}
	else
	{
		user2.colour=0;
	}

/*------------------------------------------------------*/


	z=0;
	strcpy(slask, "X");
	sprintf(slask2, "%d", user2.lines);

	while ((z < 7 || z > 255) && *slask != 0)
	{
		z=lineed(slask, TERMLINES, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask);
	}
	if (z > 7) user2.lines=z;

	z=0;
	strcpy(slask, "X");
	sprintf(slask2, "%d", user2.columns);

	while ((z < 20 || z > 255) && *slask != 0)
	{
		z=lineed(slask, TERMCOLS, slask2, 28, 2);	
		newline();
		if (z < 0) return;
		z=atoi(slask);
	}
	if (z > 20) user2.columns=z;

	z=-1;
	strcpy(slask, "X");

	fpr(CHARSETS);

	for (i=0;i<=10;i++)
	{
		if (user2.charset != (unsigned int)i)
		{
			sprintf(fotxt, "   %2d = %s\n", i+1,
				teckendef[i]);
		}
		else
		{
			sprintf(fotxt, "*  %2d = %s\n", i+1,
				teckendef[i]);

			if (ansi == 1)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[12],
					i+1, teckendef[i],
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[21],
					i+1, teckendef[i],
					ansicol[20]);
		}

		fpr(fotxt);
	}

	sprintf(slask2, "%d", user2.charset+1);
	newline();

	while ((z < 0 || z > 10) && *slask != 0)
	{
		z=lineed(slask, TERMCHARS, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask)-1;
	}
	if (z >=0 && z <= 3) user2.charset=z;

	z=putuserinfo(usernr);
}

/*	ndra egna parametrar. */

void	editmyself()
{
	int		z, i;
	char		slask[80], slask2[80];

	if (( user.maintprivs & SYS_SETOWNPAR) == 0)
	{
		fpr(NOEDITOWNPRIV);
		logg(NOEDITOWNPRIV, 1);
		return;
	}

	sprintf(fotxt, EDITOWNDATA);
	fpr(fotxt);

/*	I FIDO-Net r anvndarnamnet en identifierare som skall vara unik i
	varje fall fr varje nod, drfr fr inte ditt eget namn ndras
	hur som helst.
	Det r dock fortfarande lmpligt att SYSOP kan ndra namnet.
*/

/*	newline();
	z=lineed(slask, USERNAME, user.username, 28, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) i=nameconv(user.username, slask);
*/
	newline();
	z=lineed(slask, ADDRESS2, user.adress, 28, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user.adress, slask);

	newline();
	z=lineed(slask, ZIPCODE, user.postnr, 10, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user.postnr, slask);

	newline();
	z=lineed(slask, CITY, user.postadress, 28, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user.postadress, slask);

	newline();
	z=lineed(slask, PHONE, user.tel, 28, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user.tel, slask);

/*	newline();
	z=lineed(slask, TERMTYPE, user.termtype, 18, 2);
	if (z < 0) return;
	if (z >= 0 && *slask != 0) strcpy(user.termtype, slask); */

/*	Vlj Editor, Frg och Terminal i stllet fr
	enbart terminalbeteckning. */

/*------------------------------------------------------*/

	z=-1;
	strcpy(slask, "X");

	fpr(EDITORS);

	i=0;
	while(*editors[i] != 0)
	{
		if (user.editor != (unsigned int)i)
		{
			sprintf(fotxt, "   %2d = %s\n", i+1,
				editors[i]);
		}
		else
		{
			sprintf(fotxt, "*  %2d = %s\n", i+1,
				editors[i]);

			if (ansi == 1)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[12],
					i+1, editors[i],
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[21],
					i+1, editors[i],
					ansicol[20]);
		}

		fpr(fotxt);
		i++;
	}

	sprintf(slask2, "%d", user.editor+1);

	while ((z < 0 || z > 10) && *slask != 0)
	{
		z=lineed(slask, EDITOR, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask)-1;
	}
	if (z >=0 && z <= 3) user.editor=z;

/*------------------------------------------------------*/

	z=-1;
	strcpy(slask, "X");

	fpr(TERMTYPE2);

	i=0;
	while(i<12)
	{
		if (user.terminal != (unsigned int)i)
		{
			sprintf(fotxt, "   %2d = %s\n", i+1,
				termfunk[i][0]);
		}
		else
		{
			sprintf(fotxt, "*  %2d = %s\n", i+1,
				termfunk[i][0]);

			if (ansi == 1)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[12],
					i+1, termfunk[i][0],
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[21],
					i+1, termfunk[i][0],
					ansicol[20]);

		}

		fpr(fotxt);
		i++;
	}

	if (baud > 0) fpr(DETECTTERMINAL);

	sprintf(slask2, "%d", user.terminal+1);
	newline();

	while ((z < 0 || z > 11) && *slask != 0)
	{
		if (*slask == '?' && baud > 0)
		{
			sprintf(slask2, "%d", inquireterminal()+1);
		}
		z=lineed(slask, TERMTYPE, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask)-1;
	}

	if (z >=0 && z <= i) user.terminal=z;

	strcpy(slask2, "N");
	if (user.colour != 0)
	{
		*slask2=YES1;
		*(slask2+1)=0;
	}

	if (user.terminal < 3)
	{
		z=-1;
		while ((z < 0 || z > 1) && *slask != 0)
		{
			z=lineed(slask, TERMCOLOUR, slask2, 28, 2);
			newline();
			if (z < 0) return;
			z=-1;
			if (*slask == YES1 ||
				*slask == YES2) z=1;
			if (*slask == 'N' ||
				*slask == 'n') z=0;
		}
		user.colour=z;
	}
	else
	{
		user.colour=0;
	}

/*------------------------------------------------------*/

	z=0;
	strcpy(slask, "X");
	sprintf(slask2, "%d", user.lines);

	while ((z < 7 || z > 255) && *slask != 0)
	{
		z=lineed(slask, TERMLINES, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask);
	}
	if (z > 7) user.lines=z;

	z=0;
	strcpy(slask, "X");
	sprintf(slask2, "%d", user.columns);

	while ((z < 20 || z > 255) && *slask != 0)
	{
		z=lineed(slask, TERMCOLS, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask);
	}
	if (z > 20) user.columns=z;

	z=-1;
	strcpy(slask, "X");

	fpr(CHARSETS);

	for (i=0;i<=10;i++)
	{
		if (user.charset != (unsigned int)i)
		{
			sprintf(fotxt, "   %2d = %s\n", i+1,
				teckendef[i]);
		}
		else
		{
			sprintf(fotxt, "*  %2d = %s\n", i+1,
				teckendef[i]);

			if (ansi == 1)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[12],
					i+1, teckendef[i],
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s*  %2d = %s%s\n",
					ansicol[21],
					i+1, teckendef[i],
					ansicol[20]);
		}

		fpr(fotxt);
	}

	sprintf(slask2, "%d", user.charset+1);
	newline();

	while ((z < 0 || z > 10) && *slask != 0)
	{
		z=lineed(slask, TERMCHARS, slask2, 28, 2);
		newline();
		if (z < 0) return;
		z=atoi(slask)-1;
	}
	if (z >=0 && z <= 3) user.charset=z;
}

/*	Editera en anvndare, och anropa ngon av de fregende rutinerna. */

void	edituser(userid)
char	*userid;
{
	int	z, usernr;

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);
	if (usernr < 0 || (unsigned int)usernr > users) usernr=0;

	if (usernr != 0) z=getuserinfo(usernr);

	if ((usernr == 0 && strcmp(userid, "") == 0) ||
		(unsigned int)usernr == usernumber) editmyself();
	else
		if (usernr != 0 && (unsigned int)usernr != usernumber)
			editother(usernr);
		else
		{
			sprintf(fotxt, "\n%s\n", WRONGUSERID);
			fpr(fotxt);
		}
}

char	*getuserid(inarea, skips)
char	*inarea;
int	skips;
{
	int	i;

	i=0;
	while(i < skips && *inarea != 0)
	{
		while(*inarea != 32 && *inarea !=0) inarea++;
		if (*inarea != 0) i++;
		while(*inarea == 32 && *inarea !=0) inarea++;
	}

	return(inarea);
}

/*	Visa anvndarparametrar. */

void	showuser(parameters)
char	*parameters;
{
	int		z, usernr;
	char		*userid, tmp[80];

	userid=getuserid(parameters, 1);
	
	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);
	if (usernr == 0 && strcmp(userid, "") == 0) usernr=usernumber;
	
	if (usernr <= 0 || (unsigned int)usernr > users)
	{
		sprintf(fotxt, WRONGUSERID);
		fpr(fotxt);
		return;
	}

	if ((unsigned int)usernr != usernumber &&
		(user.maintprivs & SYS_SHOWUSR) == 0)
	{
		fpr(NOSHOWUSER);
		logg(NOTSHOWUSER, 1);
		return;
	}

	if (usernr != 0)
	{
		newline(); newline();

		z=getuserinfo(usernr);

		sprintf(fotxt, "%s%d\n", USERNUMBER, usernr);fpr(fotxt);
		sprintf(fotxt, "%s%s\n", USERNAME, user2.username);fpr(fotxt);
		sprintf(fotxt, "%s%s\n", ADDRESS2, user2.adress);fpr(fotxt);
		sprintf(fotxt, "%s%s\n", ZIPCODE, user2.postnr);fpr(fotxt);
		sprintf(fotxt, "%s%s\n", CITY, user2.postadress);fpr(fotxt);
		sprintf(fotxt, "%s%s\n", PHONE, user2.tel);fpr(fotxt);
		sprintf(fotxt, "%s%s\n", LASTLOGIN2, user2.lastlogin);
		fpr(fotxt);
		tidkonv2(user2.totaltime, tmp);
		sprintf(fotxt, "%s%s\n", USEDTIME, tmp); fpr(fotxt);
		sprintf(fotxt, "%s%s\n", TERMTYPE, termfunk[user2.terminal][0]);fpr(fotxt);
		if (user2.colour != 0)
		{
			fpr(COLOURTERMINAL);
		}
		else
		{
			fpr(MONOCHROMETERM);
		}
		sprintf(fotxt, "%s%s\n", EDITOR, editors[user2.editor]);fpr(fotxt);
		sprintf(fotxt, "%s%d\n", TERMLINES, user2.lines);fpr(fotxt);
		sprintf(fotxt, "%s%d\n", TERMCOLS, user2.columns);fpr(fotxt);
		sprintf(fotxt, "%s%s\n", TERMCHARS, teckendef[user2.charset]);
		fpr(fotxt);
	}
	else
	{
		sprintf(fotxt, "\n%s\n", WRONGUSERID);
		fpr(fotxt);
	}
}

/*	Lista anvndare i kort format. */

void	listusers(userid)
char	*userid;
{
	int		z, i, usernr, p;
	unsigned int	rad;
	char		slask[160];

/* Kolla om personen har tilltelse att se andra anvndare i systemet. */

	if ((user.maintprivs & SYS_LISTUSR) == 0)
	{
		fpr(NOLISTUSER);
		logg(NOTLISTUSR, 1);
		return;
	}

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	if (usernr < 1) usernr=1;

	if ((unsigned int)usernr > users) usernr=(int)users;

	rad=0;

	strcpy(slask, "");

	newline();
	newline();

	for(i=usernr;i<=(int)users;i++)
	{
		z=getuserinfo(i);

		if ((user2.status & 128) == 0)
		{
			sprintf(fotxt, "%5d%30s  %30s\n",
				i, user2.username, user2.postadress);
			p=1;
		}
		else
		{
			if (usernr > 1)
			{
				sprintf(fotxt, DELETED, i);
				p=1;
			}
			else
			{
				*fotxt=0;
				p=0;
			}
		}

		if (ansi == 1)
		{
			if ((user2.status & 128) == 0)
			{
				sprintf(slask, "%s%s%s",
					ansicol[12],
					fotxt,
					ansicol[7]);
			}
			else
			{
				sprintf(slask,"%s%s%s",
					ansicol[11],
					fotxt,
					ansicol[7]);
			}

			strcpy(fotxt, slask);
		}

		if (ansi == 2)
		{
			if ((user2.status & 128) == 0)
			{
				sprintf(slask, "%s%s%s",
					ansicol[21],
					fotxt,
					ansicol[20]);
				strcpy(fotxt, slask);
			}
		}

		if (p == 1)
		{
			fpr(fotxt);
			rad++;
		}

		strcpy(slask, "");
		z=0;


		if (rad > user.lines - 5)
		{
			rad=0;
			newline();
			strcpy(fotxt, PRESSRETURN);

			if (ansi == 1)
			{
				sprintf(fotxt, "%s%s%s",
					ansicol[14],
					PRESSRETURN,
					ansicol[7]);
			}

			if (ansi == 2)
			{
				sprintf(fotxt, "%s%s%s",
					ansicol[21],
					PRESSRETURN,
					ansicol[20]);
			}

			z=lineed(slask, PRESSRETURN, "", 20, 0);
			newline();
		}
		if ((*slask != 0) || (z < 0)) i=users;
	}
	newline();
}

/*	Stt lsenord p anvndare. */

void	setpassword(userid)
char	*userid;
{
	int		z, usernr;
	char		slask[80], slask2[80], slask3[80];

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	if (usernr == 0 && strcmp(userid, "") == 0) usernr=usernumber;
	
	if (usernr <= 0 || (unsigned int)usernr > users)
	{
		sprintf(fotxt, WRONGUSERID);
		fpr(fotxt);
		return;
	}

/*	Stt antingen eget lsenord, eller annans lsenord. */
	if ((unsigned int)usernr == usernumber &&
		(user.maintprivs & SYS_SETOWNPASS) != 0)
	{
		sprintf(fotxt, YOURPASSWD);
		fpr(fotxt);
		z=lineed(slask, OLDPASSWORD, "", 30, 1);
		upper(slask2, slask);
		if (strcmp( user.password, slask2) == 0 && z >= 0)
		{
			newline();
			z=lineed(slask, NEWPASSWORD1, "", 30, 1);
			if (z >= 0)
			{
				upper(slask2, slask);
				newline();
				z=lineed(slask, NEWPASSWORD2, "", 30, 1);
				upper(slask3, slask);
				if (strcmp(slask2, slask3) == 0 && z >= 0)
				{
					strcpy(user.password, slask2);
					sprintf(fotxt, CHANGEDPASSWD);
					fpr(fotxt);
				}
				else if (z >= 0)
				{
					sprintf(fotxt, DIFFPASSWD);
					fpr(fotxt);
				}
			}
		}
		else if (z >= 0 && (user.maintprivs & SYS_SETOWNPASS) != 0)
		{
			sprintf(fotxt, WRONGPASSWD);
			fpr(fotxt);
		}
		else
		{
			sprintf(fotxt, NOOWNPASSPRIV);
			fpr(fotxt);
		}
	}
	else if ((user.maintprivs & SYS_SETPASS) != 0)
	{
		z=getuserinfo(usernr);
		sprintf(fotxt, USERPASSWD, user2.username);
		fpr(fotxt);

/*	Kolla om du har rtt att stta andras lsen.
	Om den andra anvndaren har hgre privilegier n dig, och du
	inte r SUPERUSER fr du inte gra det.*/

		if ( z >= 0 &&
		(user.maintprivs & SYS_SUSR) !=0 ||
		user.maintprivs >= user2.maintprivs &&
		user.fileprivs >= user2.fileprivs &&
		user.textprivs >= user2.textprivs)
		{
			sprintf(fotxt, CHANGEPASSWD, usernr , user2.username);
			logg(fotxt, 3);

			newline();
			z=lineed(slask, NEWPASSWORD1, "", 30, 1);
			if (z >= 0)
			{
				upper(slask2, slask);
				newline();
				z=lineed(slask, NEWPASSWORD2, "", 30, 1);
				upper(slask3, slask);
				if (strcmp(slask2, slask3) == 0 && z >= 0)
				{
					strcpy(user2.password, slask2);
					sprintf(fotxt, CHANGEDPASSWD);
					fpr(fotxt);
					z=putuserinfo(usernr);
				}
				else if (z >= 0)
				{
					sprintf(fotxt, DIFFPASSWD);
					fpr(fotxt);
				}
			}
		}
		else
		{
			sprintf(fotxt, NOPASSPRIV);
			fpr(fotxt);
			logg(NOTPASSPRV, 1);
		}
	}
	else
	{
		fpr(NOPASSPRIV);
		logg(NOTPASSPRV, 1);
	}
}

/*	Ls ut eller aktivera anvndare. */

void	connect(userid, flag)
char	*userid;
int	flag;
{
	int		z, usernr;

	if ((user.maintprivs & SYS_DISCONN ) == 0)
	{
		fpr(NODISCPRIV);
		logg(NOTDISCPRV, 1);
		return;
	}

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);
	if ((unsigned int)usernr != usernumber &&
		usernr > 0 && (unsigned int)usernr <= users)
	{
		z=getuserinfo(usernr);

		if ((user2.maintprivs & SYS_SUSR) == 0)
		{
			if (flag == 0)
				sprintf(fotxt,
					LOCKOUT, usernr, user2.username);
			else
				sprintf(fotxt,
					LOCKIN, usernr, user2.username);
			logg(fotxt, 3);

			if (flag != 0) user2.status = (user2.status | 1);
			else user2.status = (user2.status & 0xFE);

			z=putuserinfo(usernr);
		}
		else
		{
			sprintf(fotxt, NODISCPRIV);
			logg(NOTDISCPRV, 1);
			fpr(fotxt);
		}
	}
	else if ((unsigned int)usernr == usernumber && flag > 0)
	{
		sprintf(fotxt, NOTONMYSELF);
		fpr(fotxt);
	}
	else
	{
		sprintf(fotxt, WRONGUSERID);
		fpr(fotxt);
	}
}

/*	Lista privilegier. (Egna och andras.) */

void	privlist(privgrp, userid, flag)
int	privgrp, flag;
char	*userid;
{
	unsigned int	z, i;
	int		diff, usernr;

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	if (usernr == 0 && strcmp(userid, "") == 0) usernr=usernumber;
	
	if (usernr < 0 || (unsigned int)usernr > users)
	{
		sprintf(fotxt, WRONGUSERID);
		fpr(fotxt);
		return;
	}

	if ((unsigned int)usernr != usernumber)
	{
		switch (privgrp)
		{
			case 1 : if ((user.maintprivs &
				(unsigned int) SYS_SETPRV ) == 0)
			{
				fpr(NOSEEPRIV);
				logg(NOTSEEPRV, 1);
				return;
			} break;

			case 2 : if ((user.textprivs &
				(unsigned int) MSG_SETPRV ) == 0)
			{
				fpr(NOSEEPRIV);
				logg(NOTSEEPRV, 1);
				return;
			} break;

			case 3 : if ((user.fileprivs &
				(unsigned int) FIL_SETPRV ) == 0)
			{
				fpr(NOSEEPRIV);
				logg(NOTSEEPRV, 1);
				return;
			} break;
		}
	}

	z=getuserinfo(usernr);

	if ((unsigned int)usernr == usernumber)
	{
		sprintf(fotxt, OWNRIGHTS);
		fpr(fotxt);
	}
	else
	{
		sprintf(fotxt, LISTRIGHTS, usernr, user2.username);
		logg(fotxt, 3);
		sprintf(fotxt, USERRIGHTS, user2.username);
		fpr(fotxt);
	}

	newline();
	z=1;
	i=16*(privgrp - 1);

	if (flag == 1) fpr(ALLPRV);

	while(i < (unsigned int)privgrp * 16)
	{
		diff=-1;
		switch (privgrp)
		{
			case 1 :
				if ((user2.maintprivs & z) == 0) diff=0;
				break;

			case 2 :
				if ((user2.textprivs & z) == 0) diff=0;
				break;

			case 3 :
				if ((user2.fileprivs & z) == 0) diff=0;
				break;
		}
		z=z*2;
		if (diff != 0)
		{
			sprintf(fotxt, "%s\n", privs[i]);
			fpr(fotxt);
		}
		i++;
	}
	newline();
}

/*	Lista defaultprivilegier. */

void	defprivlist(grp)
int	grp;
{
	unsigned int	z, i;
	int		diff, privgrp;

	privgrp=grp-6;

	switch (privgrp)
	{
		case 1 : if ((user.maintprivs &
			(unsigned int) SYS_SETPRV ) == 0)
		{
			fpr(NOSEEPRIV);
			logg(NOTSEEPRV, 1);
			return;
		} break;

		case 2 : if ((user.textprivs &
			(unsigned int) MSG_SETPRV ) == 0)
		{
			fpr(NOSEEPRIV);
			logg(NOTSEEPRV, 1);
			return;
		} break;

		case 3 : if ((user.fileprivs &
			(unsigned int) FIL_SETPRV ) == 0)
		{
			fpr(NOSEEPRIV);
			logg(NOTSEEPRV, 1);
			return;
		} break;
	}

	newline();

	z=1;
	i=16*(privgrp - 1);
	while(i < (unsigned int)privgrp * 16)
	{
		diff=-1;
		switch (privgrp)
		{
			case 1 :
				if ((sysdata.maintprivs & z) == 0) diff=0;
				break;

			case 2 :
				if ((sysdata.textprivs & z) == 0) diff=0;
				break;

			case 3 :
				if ((sysdata.fileprivs & z) == 0) diff=0;
				break;
		}
		z=z*2;
		if (diff != 0)
		{
			sprintf(fotxt, "%s\n", privs[i]);
			fpr(fotxt);
		}
		i++;
	}
	newline();
}

/*	Stt eller lista privilegier. */

void	priv(privgrp, parameters, privname, flag)
int	privgrp;
char	*parameters, *privname, *flag;
{
	unsigned long int	j;
	int			usernr, z, i, diff, flagnr;
	char			slask[80], *userid;

	flagnr=-1;
	if (strcmp(flag, "1") == 0) flagnr=1;
	if (strcmp(flag, "0") == 0) flagnr=0;

	switch (privgrp)
	{
		case 1 : if ((user.maintprivs &
			(unsigned int) SYS_SETPRV ) == 0)
		{
			fpr(NOSETPRIV);
			logg(NOTSETPRV, 1);
			return;
		} break;

		case 2 : if ((user.textprivs &
			(unsigned int) MSG_SETPRV ) == 0)
		{
			fpr(NOSETPRIV);
			logg(NOTSETPRV, 1);
			return;
		} break;

		case 3 : if ((user.fileprivs &
			(unsigned int) FIL_SETPRV ) == 0)
		{
			fpr(NOSETPRIV);
			logg(NOTSETPRV, 1);
			return;
		} break;
	}

	userid=getuserid(parameters, 2);	

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	if (usernr < 0 || (unsigned int)usernr > users) usernr = 0;

	if (usernr == 0)
	{
		privlist(privgrp, user.username, 1);
		return;
	}

	if (flagnr < 0)
	{
		sprintf(fotxt, PRIVSWFAIL);
		fpr(fotxt);
		return;
	}

	sprintf(fotxt, SETRIGHTS, usernr, user2.username);
	logg(fotxt, 3);

	upper(slask, privname);
	strcpy(privname, slask);
	
	i=16*(privgrp - 1);

	if (instring(privname, "ALL") == 0)
	{
		switch (privgrp)
		{
			case 1 :
				j=user.maintprivs;
				break;

			case 2 :
				j=user.textprivs;
				break;

			case 3 :
				j=user.fileprivs;
				break;
		}

		diff=0;
	}
	else
	{
		diff=-1;
		j=1;
		while (i < privgrp*16 && diff != 0)
		{
			diff=instring(privname, privs[i]);
			switch (privgrp)
			{
				case 1 :
					if ((user.maintprivs & j) == 0)
						diff=-1;
					break;

				case 2 :
					if ((user.textprivs & j) == 0) diff=-1;
					break;

				case 3 :
					if ((user.fileprivs & j) == 0) diff=-1;
					break;
			}
			j=j*2;
			i++;
		}

		i--;
		j=j/2;
	}

	if (diff == 0)
	{
		z=getuserinfo(usernr);

		switch (privgrp)
		{
			case 1 : user2.maintprivs=
					((user2.maintprivs & ~(unsigned int)j)
					| (flagnr * (unsigned int)j));
				break;

			case 2 : user2.textprivs=
					((user2.textprivs & ~(unsigned int)j)
					| (flagnr * (unsigned int)j));
				break;

			case 3 : user2.fileprivs=
					((user2.fileprivs & ~(unsigned int)j)
					| (flagnr * (unsigned int)j));
				break;
		}

		z=putuserinfo(usernr);
	}
	else
	{
		sprintf(fotxt, NOPRIV);
		fpr(fotxt);
	}
}

void	cleanusers()
{
	unsigned int	users, i, j, n, moeten;
	int		z;
	unsigned long	lastlog;

	users=getusers();

	i=2;
	j=0;

	while(i < users)
	{
		getuserinfo(i);

		lastlog=itimetol(user2.lastlogin);

		if ((time(NULL)-lastlog) > (86400L*90) &&
			*user2.username != 0 &&
			(user2.maintprivs & SYS_SUSR) == 0 &&
			(user2.status & POINT) == 0 &&
			(user2.status & 128) == 0)
		{
			sprintf(fotxt, "%d %36s %20s %d\n", i,
				user2.username, user2.lastlogin,
				user2.logins);
			fpr(fotxt);
			logg(fotxt, 0);

			user2.status = (user2.status | 128);
			strcpy(user2.username, "");

			n=1;
			moeten=getmoeten();

			while(n <= moeten)
			{
				user2.memberinfo[n].moetstatus=0;
				user2.memberinfo[n].lastread=0;
				n++;
			}

			putuserinfo(i);

			n=1;
			moetnumber=1;

			getmaxtext(1);

			while (n < (int) meetinf.texts)
			{
				gettextindex(1, n);

				if (textindex.kommusr == (unsigned int) i)
				{
					textindex.kommusr=0;
					textindex.type=0;
					z=puttextindex(n);
				}
				n++;
			}

			j++;
		}
		i++;
	}
	sprintf(fotxt, "Cleaned %d/%d\n", j, i);
	fpr(fotxt);
}
