/* MAINT2.C - Systemunderhllsrutiner. */
/* "AURORA" (c) 1989, 1990 Nils Hammar */

/*	This code may be used complete or partly by anyone as long as
	i am credited for being involved in the source.
	The credits MUST appear possible to read when starting the derived
	program, and in the documentation and manual in the form:
	"Contains code (c) 1990 Nils Hammar" in any language of:
	Swedish, English or German preferably.

	It is free to spread this code and programs hereof both free
	and if code is added for money as long as i am credited for it.
	Excluding of code MUST be by comments, and when code is included
	there MUST be a comment which describes WHO has done it, WHY,
	and WHEN. All changes and additions should be reported to me
	to determine if they should be included in further versions.

	All necessary text translations will be in GLOBAL.H and
	possibly in PRIVS.H if translation to another language is necessary.

	Extensions of H-files in different languages:
	.SWE	Swedish
	.ENG	English
	.SUO	Finnish
	.GER	German

	Adding code to one file MUST be added to the others, in
	at least english.
*/

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <stdlib.h>
#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

/*	Stt eller lista defaultprivilegier. */

void	defpriv(grp, privname, flag)
int	grp;
char	*privname, *flag;
{
	unsigned long int	j;
	unsigned int		flagnr;
	int			i, diff, privgrp;
	char			slask[80];
	FILE			*f;

	if ((user.maintprivs & SYS_SUSR) == 0)
	{
		logg(NOTSYSPRV, 3);
		fpr(NOSYSPRIV);
		return;
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if (( f = fopen(fotxt,"rb+")) == NULL)
#else
	if (( f = fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int) sizeof(int), SEEK_SET) != 0)
	{
		perror(DEFPRIV1);
		fclose(f);
		logg(DEFPRIV1, 0);
		exit(9);
	}

	if (fread((char *) &sysdata, sizeof(systemdata), 1, f) == 0)
	{
		perror(DEFPRIV3);
	}

	privgrp=grp-6;

	flagnr=-1;
	if (strcmp(flag, "1") == 0) flagnr=1;
	if (strcmp(flag, "0") == 0) flagnr=0;

	upper(slask, privname);
	strcpy(privname, slask);
	
	if (strcmp(privname, "") == 0)
	{
		privlist((privgrp), user.username, 1);
		return;
	}

	switch (privgrp)
	{
		case 1 : if ((user.maintprivs &
			(unsigned int) SYS_SETPRV ) == 0)
		{
			logg(NOTSETPRV, 1);
			fpr(NOSETPRIV);
			return;
		} break;

		case 2 : if ((user.textprivs &
			(unsigned int) MSG_SETPRV ) == 0)
		{
			logg(NOTSETPRV, 1);
			fpr(NOSETPRIV);
			return;
		} break;

		case 3 : if ((user.fileprivs &
			(unsigned int) FIL_SETPRV ) == 0)
		{
			logg(NOTSETPRV, 1);
			fpr(NOSETPRIV);
			return;
		} break;
	}

	i=16*(privgrp - 1);

	diff=-1;
	j=1;
	while (i < privgrp*16 && diff != 0)
	{
		diff=instring(privname, privs[i]);
		switch (privgrp)
		{
			case 1 :
				if ((user.maintprivs & j) == 0) diff=-1;
				break;

			case 2 :
				if ((user.textprivs & j) == 0) diff=-1;
				break;

			case 3 :
				if ((user.fileprivs & j) == 0) diff=-1;
				break;
		}
		j=j*2;
		i++;
	}

	i--;
	j=j/2;

	if (diff == 0)
	{
		switch (privgrp)
		{
			case 1 : sysdata.maintprivs=
				((sysdata.maintprivs & ~(unsigned int)j) |
					(flagnr * (unsigned int)j));
				break;

			case 2 : sysdata.textprivs=
				((sysdata.textprivs & ~(unsigned int)j) |
					(flagnr * (unsigned int)j));
				break;

			case 3 : sysdata.fileprivs=
				((sysdata.fileprivs & ~(unsigned int)j) |
					(flagnr * (unsigned int)j));
				break;
		}

	}
	else
	{
		sprintf(fotxt, NOPRIV);
		fpr(fotxt);
	}

	if (fseek(f, (unsigned long int) sizeof(int), SEEK_SET) != 0)
	{
		perror(DEFPRIV1);
		fclose(f);
		logg(DEFPRIV1, 0);
		exit(9);
	}

	if (fwrite((char *) &sysdata, sizeof(systemdata), 1, f) == 0)
	{
		perror(DEFPRIV2);
		fclose(f);
		return;
	}

	logg(SYSDATAUPDATED, 3);

	fclose(f);
}

void	showmeetpar(parameters)
char	*parameters;
{
	int	z, j, mem, moeten;
	char	*moete;

	moete=getuserid(parameters, 1);
	
	moeten=getmoeten();

	mem=moetnumber;

	moetnumber=atoi(moete)+1;

	if (moetnumber == 1)
	{
		moetnumber=getmoetnumber(moete, 2);
	}

	if (moetnumber <= 1 || moetnumber > (unsigned int)moeten)
	{
		sprintf(fotxt, WRONGMEET);
		fpr(fotxt);
		moetnumber=mem;
		z=getmaxtext(moetnumber);
		return;
	}

	newline();

	z=getmaxtext(moetnumber);

	z=1;

	sprintf(fotxt, MEETPARS, moetnumber-1, meetinf.namn);
	fpr(fotxt);

	for (j=0;j<4;j++)
	{
		if ((meetinf.parameters & z) == z)
		{
			sprintf(fotxt, "%2d  %s\n", z, meetpars[j]);
			fpr(fotxt);
		}
		z=z*2;
	}

	moetnumber=mem;
	z=getmaxtext(moetnumber);
}

void	setmeetpar(flag, parameters, privnam)
int	flag;
char	*parameters, *privnam;
{
	char		*moete;
	int		z, mem, moeten, diff, j;

	moeten=getmoeten();

	moete=getuserid(parameters, 2);
	
	mem=moetnumber;

	moetnumber=atoi(moete)+1;

	if ((user.textprivs & MSG_SETPRV) == 0 &&
		(user.memberinfo[moetnumber].moetstatus & ADMINISTRATOR) == 0)
	{
		logg(NOTSYSPRV, 1);
		fpr(NOSYSPRIV);
		return;
	}


	if (strcmp(moete, "") == 0)
	{
		newline(); newline();
		for (z=0;z<4;z++)
		{
			sprintf(fotxt, "%s\n", meetpars[z]);
			fpr(fotxt);
		}
		moetnumber=mem;
		z=getmaxtext(moetnumber);
		return;
	}

	if (moetnumber == 1)
	{
		moetnumber=getmoetnumber(moete, 2);
	}

	if (moetnumber == 1)
	{
		moetnumber=mem;
		getmaxtext(moetnumber);
		return;
	}

	z=getmaxtext(moetnumber);

	z=1;
	diff=-1;
	j=0;

	while (diff != 0 && j < 4)
	{
		diff=instring(privnam, meetpars[j]);
		z=z*2;
		j++;
	}

	z=z/2;

	if (diff != 0)
	{
		logg(NOTVALIDPRV, 1);
		fpr(NOPRIV);
		moetnumber=mem;
		z=getmaxtext(moetnumber);
		return;
	}

	j=getmaxtext(moetnumber);

	newline();

	sprintf(fotxt, MODIFYMEETPAR, moetnumber-1, meetinf.namn);
	logg(fotxt, 3);
	fpr(fotxt);
	newline();

	if (flag == 0) meetinf.parameters = meetinf.parameters & ~z;
	if (flag != 0) meetinf.parameters = meetinf.parameters | z;

	j=(unsigned int) meetinf.texts;

	putmaxtext(moetnumber, j);

	moetnumber=mem;
	z=getmaxtext(moetnumber);
}

void	setuserpar(flag, parameters, privnam)
int	flag;
char	*parameters, *privnam;
{
	int	z, j, moetnr, diff, usernr;
	char	slask[80], *userid;

	userid=getuserid(parameters, 2);
	
	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	if (strcmp(privnam, "") == 0)
	{
		newline(); newline();
		for (j=0;j<6;j++)
		{
			sprintf(fotxt, "%s\n", userpars[j]);
			fpr(fotxt);
		}
		newline();
		return;
	}

	if (usernr <= 0 || (unsigned int)usernr > users)
	{
		sprintf(fotxt, WRONG_USER);
		fpr(fotxt);
		return;
	}

	z=getuserinfo(usernr);

	strcpy(slask, "X");
	diff=-1;

	newline(); newline();

	z=lineed(slask, WHICH_MEET, "", 78, 0);

	if (z < 0) return;

	newline(); newline();

	moetnr=atoi(slask)+1;

	if (moetnr == 1 && strcmp(slask, "") != 0)
		moetnr=getmoetnumber(slask, 2);

	z=getmoeten();

	if (moetnr <= 1 || moetnr > z)
	{
		sprintf(fotxt, WRONGMEET);
		fpr(fotxt);
		return;
	}

	if ((user.maintprivs & SYS_SETPAR) == 0 &&
		(user.memberinfo[moetnr].moetstatus & ADMINISTRATOR) == 0)
	{
		logg(NOTSETPRV, 1);
		fpr(NOSETPRIV);
		return;
	}

	z=getmaxtext(moetnr);

	diff=-1;
	z=1;
	j=0;
	while ( j < 6 && diff != 0)
	{
		diff=instring(privnam, userpars[j]);
		j++;
		z=z*2;
	}

	z=z/2;

	if ( j >= 6 && diff != 0)
	{
		sprintf(fotxt, ILLPARAM);
		fpr(fotxt);
		return;
	}

	sprintf(fotxt, MODUSERMEETPAR, usernr, user2.username,
		moetnr, meetinf.namn);
	logg(fotxt, 3);

	if ((unsigned int)usernr != usernumber)
	{
		if (flag == 0) user2.memberinfo[moetnr].moetstatus =
			user2.memberinfo[moetnr].moetstatus & ~z;
	
		if (flag != 0) user2.memberinfo[moetnr].moetstatus =
			user2.memberinfo[moetnr].moetstatus | z;

		z=putuserinfo(usernr);
	}
	else
	{
		if (flag == 0) user.memberinfo[moetnr].moetstatus =
			user.memberinfo[moetnr].moetstatus & ~z;
	
		if (flag != 0) user.memberinfo[moetnr].moetstatus =
			user.memberinfo[moetnr].moetstatus | z;
	}
}

void	showallow(parameters)
char	*parameters;
{
	int	j, z, usernr, moetnr;
	char	slask[80], *userid;

	userid=getuserid(parameters, 1);

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	if (usernr <= 0 || (unsigned int)usernr > users)
	{
		sprintf(fotxt, WRONG_USER);
		fpr(fotxt);
		return;
	}

	z=getuserinfo(usernr);

	strcpy(slask, "X");

	newline(); newline();

	z=lineed(slask, WHICH_MEET, "", 78, 0);

	if (z < 0) return;

	newline(); newline();

	if (z < 0)
	{
		return;
	}

	moetnr=atoi(slask)+1;

	if (moetnr == 1 && strcmp(slask, "") != 0)
		moetnr=getmoetnumber(slask, 2);

	z=getmoeten();

	if (moetnr <= 1 || moetnr > z)
	{
		sprintf(fotxt, WRONGMEET);
		fpr(fotxt);
		return;
	}

	z=1;
	j=0;
	while ( j < 6)
	{
		if ((user2.memberinfo[moetnr].moetstatus & z) != 0)
		{
			sprintf(fotxt, "%s\n", userpars[j]);
			fpr(fotxt);
		}
		j++;
		z=z*2;
	}
}

void	show(parameters, command)
char	*parameters, *command;
{
	int	i, diff;
	char	*userid;

	userid=getuserid(parameters, 1);

	i=0;
	diff=-1;
	while(diff != 0 && i < 9 && strcmp(command, "") != 0)
	{
		diff=instring(command, subcmnd[i]);
		i++;
	}

	if (diff == 0)
	{
		switch (i)
		{
			case 1 :
			case 2 :
			case 3 : privlist(i, userid, 0); break;
			case 4 : showmeetpar(parameters); break;
			case 5 : showallow(parameters); break;
			case 6 : showuser(parameters); break;
			case 7 :
			case 8 :
			case 9 : defprivlist(i); break;
		}
	}
	else if (strcmp(command, "") == 0)
	{
		newline();
		for (i=0; i<9; i++)
		{
			sprintf(fotxt, "%s\n", subcmnd[i]);
			fpr(fotxt);
		}
	}
	else
	{
		sprintf(fotxt, PRIVSWFAIL);
		fpr(fotxt);
	}
}

void	prompt(flag, params)
int	flag;
char	*params;
{
	int	i, n;

	if (strcmp(params, "") == 0)
	{
		newline();
		newline();

		for (i=0;i<4;i++)
		{
			sprintf(fotxt, "%s\n", prompter[i]);
			fpr(fotxt);
		}
		return;
	}

	i=0;
	n=2;

	while (i<4 && instring(params, prompter[i]) != 0)
	{
		i++;
		n=n*2;
	}

	if (i >= 4)
	{
		fpr(ILLPARAM);
		return;
	}

	if (flag == 0) user.status = user.status & ~n;
	if (flag != 0) user.status = user.status | n;
}

void	point(flag, usertext)
unsigned int	flag;
char		*usertext;
{
	int	z, usernr;
	char	*userid;

	userid=getuserid(usertext, 1);

	usernr=atoi(userid);

	if (usernr == 0) usernr=userfind(userid);

	if (usernr <= 0)
	{
		fpr(ILLPARAM);
		return;
	}

	if ((user.maintprivs & (unsigned int) SYS_SETPRV ) == 0)
	{
		fpr(NOSETPRIV);
		logg(NOTSETPRV, 1);
		return;
	}

	z=getuserinfo(usernr);

	if (flag == 0) user2.status = user2.status & ~POINT;
	if (flag != 0) user2.status = user2.status | POINT;

	z=putuserinfo(usernr);

	logg(SYSDATAUPDATED, 3);
}

void	setpar(parameters, command, privnam)
char	*parameters, *command, *privnam;
{
	int	i, diff;

	i=0;
	diff=-1;
	while(diff != 0 && i < 11 && strcmp(command, "") != 0)
	{
		diff=instring(command, subcmnd[i]);
		i++;
	}

	if (diff == 0)
	{
		switch (i)
		{
			case 1  :
			case 2  :
			case 3  : priv(i, parameters, privnam, "1"); break;
			case 4  : setmeetpar(1, parameters, privnam); break;
			case 5  : setuserpar(1, parameters, privnam); break;
			case 7  :
			case 8  :
			case 9  : defpriv(i, privnam, "1"); break;
			case 10 : prompt(1, privnam); break;
			case 11 : point(1, parameters);
		}
	}
	else
	{
		if (strcmp(command, "") == 0)
		{
			newline();
			for (i=0; i<11; i++)
			{
				sprintf(fotxt, "%s\n", subcmnd[i]);
				if (i != 5) fpr(fotxt);
			}
		}
		else
		{
			sprintf(fotxt, PRIVSWFAIL);
			fpr(fotxt);
		}
	}
}

void	clearpar(parameters, command, privnam)
char	*parameters, *command, *privnam;
{
	int	i, diff;

	i=0;
	diff=-1;
	while(diff != 0 && i < 11 && strcmp(command, "") != 0)
	{
		diff=instring(command, subcmnd[i]);
		i++;
	}

	if (diff == 0)
	{
		switch (i)
		{
			case 1  :
			case 2  :
			case 3  : priv(i, parameters, privnam, "0"); break;
			case 4  : setmeetpar(0, parameters, privnam); break;
			case 5  : setuserpar(0, parameters, privnam); break;
			case 7  :
			case 8  :
			case 9  : defpriv(i, privnam, "0"); break;
			case 10 : prompt(0, privnam); break;
			case 11 : point(0, parameters);
		}
	}
	else if (strcmp(command, "") == 0)
	{
		newline();
		for (i=0; i<11; i++)
		{
			sprintf(fotxt, "%s\n", subcmnd[i]);
			if (i != 5) fpr(fotxt);
		}
	}
	else
	{
		sprintf(fotxt, PRIVSWFAIL);
		fpr(fotxt);
	}
}

/*	Indata: Hur mnga texter som skall vara kvar i aktuellt mte. */

void	packmeet(texts, parameters)
char	*texts, *parameters;
{
	int			maxtext, i, moetnr, firsttext, mem, textnr;
	unsigned int		texter;
	long int		startpos;
	char			*textarea, *tmp, filnamn[40], tmp2[80],
				filnamn2[40];
	FILE			*f, *g1;
	unsigned long int	position;

	texter=atoi(texts);

	if ((user.textprivs & MSG_DELALL) == 0)
	{
		logg(NOTPACKING, 1);
		fpr(NODELTXTSPRIV);
		return;
	}

	if (texter == 0)
	{
		sprintf(fotxt, PACKPAR);
		fpr(fotxt);
		return;
	}

	if (texter < sysdata.minpacks)
	{
		sprintf(fotxt, LEAVETEN);
		fpr(fotxt);
		return;
	}

#ifdef MSDOS
	textarea=halloc((unsigned long int)MAXLINES * 
		(unsigned long int)LINELENGTH, sizeof(char));
#else
	textarea=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

	if (textarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	tmp=getuserid(parameters, 1);

	moetnr=atoi(tmp)+1;

	if (moetnr == 1 && strcmp(tmp, "") != 0)
	{
		moetnr=getmoetnumber(tmp,1);
	}

	if (moetnr <= 0 || moetnr == 1 && strcmp(tmp, "") == 0)
	{
		newline();
		sprintf(fotxt, ILLPARAM);
		fpr(fotxt);
		newline();
#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
		return;
	}

	mem=moetnumber;

	moetnumber=moetnr;

	maxtext=getmaxtext(moetnr);

	printf(MEETIDENT, moetnr, meetinf.namn);

	if (texter > (unsigned int)maxtext)
		texter = (unsigned int)maxtext;

	textnr=maxtext-texter;
	firsttext=textnr;
	textnr++;

	i=1;
	startpos=0L;

	logg(PACKING, 3);
	fpr(PACKTEXTS);

/*	PACKA TEXTER!
	============= */

	env=getenv("ADATA");
	sprintf(filnamn, "M%d.DAT", moetnumber);

	strcpy(fotxt, env);
	strcat(fotxt, filnamn);

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		sprintf(tmp2, "Packmeet 1 - %s", filnamn);
		perror(tmp2);
		logg(tmp2, 0);
#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
		exit(9);
	}

	sprintf(filnamn2, "M%d.IDX", moetnumber);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, filnamn2);

#ifdef MSDOS
	if ((g1=fopen(fotxt, "rb+")) == NULL)
#else
	if ((g1=fopen(fotxt, "r+")) == NULL)
#endif
	{
		sprintf(tmp2, "Packmeet 1B - %s", filnamn2);
		perror(tmp2);
		logg(tmp2, 0);
		exit(9);
	}

	while((unsigned int)i <= texter)
	{
/*	Hmta Text och indexinformation till denna. */
/*		gettxt(textarea, z);
		textindex.startpos=startpos;
		startpos=startpos+textindex.len;
		storetext(textarea);
		puttextindex(i); */

/*		z=gettextindex(moetnumber, textnr); */

		position=(unsigned long int) textnr *
				(unsigned long int) sizeof(textindexstruct);

		if (fseek(g1, position, SEEK_SET) != 0)
		{
			sprintf(tmp, GETIDXERR2, moetnr);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}

		if (fread((char *) &textindex,
			(unsigned int) sizeof(textindexstruct), 1, g1) == 0)
		{
			sprintf(tmp, GETIDXERR3, moetnr);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}

		if (fseek(f, textindex.startpos, SEEK_SET) != 0)
		{
			sprintf(tmp2, "Packmeet 2 - %s", filnamn);
			perror(tmp2);
			logg(tmp2, 0);
			fclose(f);
#ifdef MSDOS
			hfree(textarea);
#else
			free(textarea);
#endif
			exit(9);
		}

		if (fread((unsigned char *) textarea, textindex.len, 1, f) == 0)
		{
			sprintf(tmp2, "Packmeet 3 - %s", filnamn);
			perror(tmp2);
			logg(tmp2, 0);
			fclose(f);
#ifdef MSDOS
			hfree(textarea);
#else
			free(textarea);
#endif
			exit(9);
		}

		textindex.startpos=startpos;
		startpos=startpos+textindex.len;

		if (fseek(f, textindex.startpos, SEEK_SET) != 0)
		{
			sprintf(tmp2, "Packmeet 4 - %s", filnamn);
			perror(tmp2);
			logg(tmp2, 0);
			fclose(f);
#ifdef MSDOS
			hfree(textarea);
#else
			free(textarea);
#endif
			exit(9);
		}

		if (fwrite((unsigned char *) textarea, textindex.len, 1, f) == 0)
		{
			sprintf(tmp2, "Packmeet 5 - %s", filnamn);
			perror(tmp2);
			logg(tmp2, 0);
			fclose(f);
#ifdef MSDOS
			hfree(textarea);
#else
			free(textarea);
#endif
			exit(9);
		}

		position=(unsigned long int) i *
				(unsigned long int) sizeof(textindexstruct);

		if (fseek(g1, position, SEEK_SET) != 0)
		{
			sprintf(tmp, PUTIDXERR2, moetnumber);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}

		if (fwrite((char *) &textindex,
			sizeof(textindexstruct), 1, g1) == 0)
		{
			sprintf(tmp, PUTIDXERR3, moetnumber);
			perror(tmp);
			logg(tmp, 0);
			fclose(f);
			exit(9);
		}

/*		puttextindex(i); */

		i++;
		textnr++;
	}

	fclose(g1);
	fclose(f);

	meetinf.firsttext=meetinf.firsttext+firsttext;

	putmaxtext(moetnr, texter);

#ifdef MSDOS
	hfree(textarea);
#else
	free(textarea);
#endif

	moetnumber=mem;
	getmaxtext(moetnumber);
}

int	numedit(prompt, preval, len)
char	*prompt;
int	preval, len;
{
	int	n, z;
	char	tmp[80], slask[160];

	n = -1;
	while (n < 0)
	{
		newline();
		sprintf(tmp, "%d", preval);
		z=lineed(slask, prompt, tmp, len, 2);

		if (z<0) return(-9);

		if (z >= 0 && *slask != 0)
		{
			n=atoi(slask);
		}
	}
	return(n);
}

void	sysedit()
{
	char	slask[80];
	int	z;
	FILE	*f;

	if ((user.maintprivs & SYS_SUSR) == 0)
	{
		logg(NOTSYSPRV, 1);
		fpr(NOSYSPRIV);
		return;
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if (( f = fopen(fotxt,"rb+")) == NULL)
#else
	if (( f = fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int) sizeof(int), SEEK_SET) != 0)
	{
		perror(SYSEDIT1);
		fclose(f);
		logg(SYSEDIT1, 0);
		exit(9);
	}

	if (fread((char *) &sysdata, sizeof(systemdata), 1, f) == 0)
	{
		perror(SYSEDIT3);
	}

	newline();
	z=lineed(slask, SYSTEMNAME, sysdata.systemname, 58, 2);
	if (z<0)
	{
		fclose(f);
		return;
	}
	if (z >= 0 && *slask != 0) strcpy(sysdata.systemname, slask);

	if ((z=numedit(SYSTEMZONE, sysdata.zone, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.zone=z;

	if ((z=numedit(SYSTEMREGION, sysdata.region, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.region=z;

	if ((z=numedit(SYSTEMNET, sysdata.net, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.net=z;

	if ((z=numedit(SYSTEMNODE, sysdata.node, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.node=z;

	if ((z=numedit(SYSTEMPOINT, sysdata.point, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.point=z;

	if ((z=numedit(POINTNET, sysdata.pointnet, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.pointnet=z;

	if ((z=numedit(SYSFLAGS, sysdata.sysflags, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.sysflags=z;

	if ((z=numedit(OPERFUNC, sysdata.operator, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.operator=z;

	if ((z=numedit(SYSTEMFAIL, sysdata.failtype, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.failtype=z;

	if ((z=numedit(MINPACKS, sysdata.minpacks, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.minpacks=z;

	if ((z=numedit(PACKLIMIT, sysdata.packlimit, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.packlimit=z;

	if ((z=numedit(ROUTEAGE, sysdata.routeage, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.routeage=z;

	if ((z=numedit(TIMEOUT, (int)sysdata.timeout, 8)) == -9)
	{
		fclose(f);
		return;
	}
	sysdata.timeout=(unsigned long int)z;

	if (fseek(f, (unsigned long int) sizeof(int), SEEK_SET) != 0)
	{
		perror(SYSEDIT1);
		fclose(f);
		logg(SYSEDIT1, 0);
		exit(9);
	}

	if (fwrite((char *) &sysdata, sizeof(systemdata), 1, f) == 0)
	{
		perror(SYSEDIT2);
		fclose(f);
		return;
	}

	logg(SYSDATAUPDATED, 3);

	fclose(f);

	newline();
}

void	meetedit(moete)
char	*moete;
{
	int		moetnr, z, n, i;
	char		slask[80], tmp[80];

	newline();

	moetnr=atoi(moete) + 1;

	if (moetnr == 1 && strcmp(moete, "0") != 0)
		moetnr=getmoetnumber(moete, 1);

	if (moetnr <= 0 || moetnr > getmoeten())
	{
		newline();
		fpr(ILLPARAM);
		newline();
		return;
	}

	z=getmaxtext(moetnr);

	if ((user.textprivs & MSG_SETPRV) == 0 &&
		(user.memberinfo[moetnr].moetstatus & ADMINISTRATOR)==0 ||
		(user.textprivs & MSG_CRECM) == 0 &&
		(user.textprivs & MSG_CRENM) == 0 &&
		(user.textprivs & MSG_CREM) == 0)
	{
		logg(NOTSYSPRV, 1);
		fpr(NOSYSPRIV);
		newline();
		return;
	}

	newline();

	z=lineed(slask, MOETNAMNPROMPT, meetinf.namn, 75, 2);

	if (z<0) return;

	if (z >= 0 && *slask != 0) strcpy(meetinf.namn, slask);

	n=-1;

	while (n != 0)
	{
		newline();
		z=lineed(slask, MOETTYPPROMPT, meetinf.typ, 2, 2);

		if (z<0)
		{
			newline();
			return;
		}

		upper(tmp, slask);
		strcpy(slask,tmp);

		if (*slask == '?')
		{
			sprintf(fotxt, NEWMEETHELP1);
			fpr(fotxt);
			sprintf(fotxt, NEWMEETHELP2);
			fpr(fotxt);
			sprintf(fotxt, NEWMEETHELP3);
			fpr(fotxt);
/*	Fr vidare utbyggnad. */
/*			sprintf(fotxt, NEWMEETHELP4);
			fpr(fotxt);
			sprintf(fotxt, NEWMEETHELP5);
			fpr(fotxt);
			sprintf(fotxt, NEWMEETHELP6);
			fpr(fotxt); */
		}

		i=0;
		while(*(ALLOWEDTYPES + i) != 0 && n != 0)
		{
			if (*slask == *(ALLOWEDTYPES + i++)) n=0;
			if ((user.textprivs & MSG_CRECM) == 0 &&
				(user.memberinfo[moetnr].moetstatus &
					ADMINISTRATOR) == 0 &&
				*slask == 'C') n=-1;

			if ((user.textprivs & MSG_CRENM) == 0 &&
				(user.memberinfo[moetnr].moetstatus &
					ADMINISTRATOR) == 0 &&
				*slask == 'E') n=-1;

			if (((user.textprivs & MSG_CRENM) == 0 ||
				(user.textprivs & MSG_CRECM) == 0) &&
				(user.memberinfo[moetnr].moetstatus &
					ADMINISTRATOR) == 0 &&
				*slask == 'R') n=-1;
		}
	}

	if (z >= 0 && *slask != 0)
	{
		*meetinf.typ = *slask;
		*(meetinf.typ + 1) = 0;
	}

	if (*meetinf.typ == 'E' || *meetinf.typ == 'R')
	{
		newline();
		z=lineed(slask, AREANAMNPROMPT, meetinf.echoarea, 75, 2);

		if (z<0)
		{
			newline();
			return;
		}

		if (z >= 0 && *slask != 0) upper(meetinf.echoarea, slask);

		n = -1;
		while (n < 1 || n > 4)
		{
			fpr(CHARSETS);

			for (z=0;z<=10;z++)
			{
				if (meetinf.defcharset != z)
				{
					sprintf(fotxt, "   %2d = %s\n", z+1,
						teckendef[z]);
				}
				else
				{
					sprintf(fotxt, "*  %2d = %s\n", z+1,
						teckendef[z]);

					if (ansi == 1)
						sprintf(fotxt,
							"%s*  %2d = %s%s\n",
							ansicol[12],
							z+1, teckendef[z],
							ansicol[7]);

					if (ansi == 2)
						sprintf(fotxt,
							"%s*  %2d = %s%s\n",
							ansicol[21],
							z+1, teckendef[z],
							ansicol[20]);
				}

				fpr(fotxt);
			}

			newline();

			sprintf(tmp, "%d", meetinf.defcharset+1);
			z=lineed(slask, ECHOCHARSET, tmp, 58, 2);
			if (z<0)
			{
				newline();
				return;
			}
			if (z >= 0 && *slask != 0)
			{
				n=atoi(slask);
			}
		}
		meetinf.defcharset=n-1;
	}
	else strcpy(meetinf.echoarea, "");

	logg(MEETPARUPDATED, 3);

	i=(unsigned int) meetinf.texts;

	putmaxtext(moetnr, i);

	newline();
}

void	adduser(sw, userid)
int	sw;
char	*userid;
{
	int	usernr, z;

	while(strcmp(userid, "") == 0)
	{
		z=lineed(userid, USERMEMBERPAR, "", 70, 0);
		newline();
		if (z<0) return;
	}

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	newline();

	if (usernr == 0)
	{
		fpr(WRONGUSERID);
		return;
	}

	z=getuserinfo(usernr);

	if ((user.textprivs & (MSG_ADDUSR | MSG_ADDUSRC)) == 0)
	{
		logg(NOTSYSPRV, 1);
		fpr(NOSYSPRIV);
		return;
	}

	if (sw != 0) user2.memberinfo[moetnumber].moetstatus=
		user2.memberinfo[moetnumber].moetstatus | 1;
	else user2.memberinfo[moetnumber].moetstatus=
		user2.memberinfo[moetnumber].moetstatus & 254;

	z=putuserinfo(usernr);
}

void	whoami()
{
	newline();
	fpr(user.username);
	newline();
}

/*	Ls ut eller aktivera anvndare. */

void	deleteusr(userid)
char	*userid;
{
	int		z, usernr, moeten, i;
	char		tmp[80];

	newline();

	if ((user.maintprivs & SYS_DELUSR ) == 0)
	{
		fpr(NODELUSRPRIV);
		logg(NOTDELUSRPRV, 1);
		return;
	}

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);
	if ((unsigned int)usernr != usernumber && usernr > 0 &&
		(unsigned int)usernr <= users)
	{
		z=getuserinfo(usernr);

		sprintf(fotxt, OKTODELUSER, user2.username);
		newline();

		z=lineed(tmp, fotxt, "", 20, 0);
		newline();

		if (*tmp != YES1 && *tmp != YES2)
		{
			fpr(NOTDELETED);
			return;
		}

		if ((user2.maintprivs & SYS_SUSR) == 0)
		{
			sprintf(fotxt, REMUSER, usernr, user2.username);
			fpr(fotxt);
			logg(fotxt, 3);

			user2.status = (user2.status | 128);
			strcpy(user2.username, "");

			z=putuserinfo(usernr);

			i=1;
			moetnumber=1;

			z=getmaxtext(1);

			while (i < (int) meetinf.texts)
			{
				z=gettextindex(1, i);

				if (textindex.kommusr == (unsigned int) usernr)
				{
					textindex.kommusr=0;
					textindex.type=0;
					z=puttextindex(i);
				}
				i++;
			}

			i=1;
			moeten=getmoeten();

			while(i <= moeten)
			{
				user2.memberinfo[i].moetstatus=0;
				user2.memberinfo[i].lastread=0;
				i++;
			}

			z=putuserinfo(usernr);
		}
		else
		{
			logg(NOTDISCPRV, 1);
			fpr(NODISCPRIV);
		}
	}
	else if ((unsigned int)usernr == usernumber)
	{
		sprintf(fotxt, NOTONMYSELF);
		fpr(fotxt);
	}
	else
	{
		sprintf(fotxt, WRONGUSERID);
		fpr(fotxt);
	}
}

