/* NODES.C - FIDO-Net underhllsrutiner. */
/* (c) 1989, 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

void	stripout(uttext, intext, n, len)
unsigned char	*uttext, *intext;
int	n, len;
{
	int	i, p1, p2;

	len--;

	strcpy(uttext, "");

	i=0;
	p1=0;
	p2=0;

	while (i < n && p1<160)
	{
		while (*(intext + p1) != ',' && *(intext + p1) != 0) p1++;
		i++;
		if (*(intext + p1) != 0) p1++;
	}

	while (*(intext + p1) != ',' && *(intext + p1) != 0 &&
		p1 < 160 && p2 < len)
	{
		*(uttext + p2++)=*(intext+ p1++);
	}

	*(uttext + p2)=0;
}

void	scanlist()
{
	FILE		*f,
			*g,
			*g0;

	unsigned char	nodeline[162],
			tmp[162],
			par[20],
			zphone[30],
			rphone[30],
			hphone[30],
			uphone[30];

	int		write,
			iwrite,
			i,
			akaexist,
			zzone=0,
			znet=0,
			znode=0,
			rzone=0,
			rnet=0,
			rnode=0,
			hzone=0,
			hnet=0,
			hnode=0,
			uzone=0,
			unet=0,
			unode=0;

	strcpy(zphone, "");
	strcpy(rphone, "");
	strcpy(hphone, "");
	strcpy(uphone, "");

	if ((user.maintprivs & SYS_NETWORK) == 0)
	{
		fpr(NONETPRIV);
		logg(NOTNETPRV, 1);
		return; 
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "NODELIST.TXT");
 
#ifdef MSDOS
	if ((f=fopen(fotxt,"rb")) == NULL)
#else
	if ((f=fopen(fotxt,"r")) == NULL)
#endif
	{
		perror(SCANERROR1);
		logg(SCANERROR1, 0);
		exit(9);
	}

/*	Hr har vi en lista p ALLA noder.
	Sedan kommer det att finnas listor p ALLA nt, och ALLA
	regioner, som r extraherade ur den hr listan i efterhand. */

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "NODES.DAT");

#ifdef MSDOS 
	if ((g=fopen(fotxt,"wb")) == NULL)
#else
	if ((g=fopen(fotxt,"w")) == NULL)
#endif
	{
		fpr(SCANERROR2);
		fclose(f);
		return;
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "NODES.IDX");
 
#ifdef MSDOS
	if ((g0=fopen(fotxt,"wb")) == NULL)
#else
	if ((g0=fopen(fotxt,"w")) == NULL)
#endif
	{
		fpr(SCANERROR3);
		fclose(f);
		fclose(g);
		return;
 	}

	nets.zone=0;
	nets.region=0;
	nets.net=0;
	nets.hubnr=0;
	nets.nodes=0;
	nets.startpos=0L;

	nodes.zone=0;
	nodes.region=0;
	nodes.net=0;
	nodes.hubnr=0;
	nodes.node=0;

	while (fgets(nodeline, 160, f) != NULL)
	{
		strcpy(nodes.nodename, "");
		strcpy(nodes.location, "");
		strcpy(nodes.telnumber, "");
		strcpy(nodes.sysop, "");

/*	Vlj packare fr denna nod:
	0	ARC
	1	ZIP
	2	LHARC
	3	ARJ
	4	Compress	*/

		nodes.packer=0;

		iwrite=0;
		write=0;

		strcpy(par, "dummy");

		if (*nodeline != ';')
		{
			stripout(tmp, nodeline, 0, 24);

			if (strlen(tmp) > 19)
			{
				sprintf(fotxt, BADTAG, tmp);
				fpr(fotxt);
				logg(fotxt, 0);
				exit(255);
			}

			upper(par, tmp);

			if (strcmp(par, "ZONE") == 0)
			{
				stripout(tmp, nodeline, 1, 160);
				nets.zone=atoi(tmp);
				nets.region=atoi(tmp);
				nets.net=atoi(tmp);
				nets.hubnr=atoi(tmp);
				nets.status=64;
				stripout(nets.netname, nodeline, 2, 40);

				nodes.zone=atoi(tmp);
				nodes.region=atoi(tmp);
				nodes.net=atoi(tmp);
				nodes.hubnr=atoi(tmp);
				nodes.node=0;
				nodes.status=65;

				stripout(nodes.nodename, nodeline, 2, 25);
				stripout(nodes.location, nodeline, 3, 25);
				stripout(nodes.sysop, nodeline, 4, 36);
				stripout(nodes.telnumber, nodeline, 5, 25);

				strcpy(zphone, nodes.telnumber);

				iwrite=-1;
				write=-1;

				sprintf(fotxt,
					"ZONE=%d  Name=%s  Loc=%s  Sysop=%s\n",
					nodes.net,
					nodes.nodename, nodes.location,
					nodes.sysop);
				fpr(fotxt);
			}

			if (strcmp(par, "REGION") == 0)
			{
				stripout(tmp, nodeline, 1, 160);
				nets.region=atoi(tmp);
				nets.net=atoi(tmp);
				nets.hubnr=atoi(tmp);
				nets.status=32;
				stripout(nets.netname, nodeline, 2, 40);

				nodes.region=atoi(tmp);
				nodes.net=atoi(tmp);
				nodes.hubnr=atoi(tmp);
				nodes.node=0;
				nodes.status=33;

				stripout(nodes.nodename, nodeline, 2, 25);
				stripout(nodes.location, nodeline, 3, 25);
				stripout(nodes.sysop, nodeline, 4, 36);
				stripout(nodes.telnumber, nodeline, 5, 25);

				strcpy(rphone, nodes.telnumber);

				iwrite=-1;
				write=-1;

				sprintf(fotxt,
					"REGION=%d  Name=%s  Loc=%s  Sysop=%s\n",
					nodes.net,
					nodes.nodename, nodes.location,
					nodes.sysop);
				fpr(fotxt);
			}

			if (strcmp(par, "HOST") == 0)
			{
				stripout(tmp, nodeline, 1, 160);
				nets.net=atoi(tmp);
				nets.hubnr=atoi(tmp);
				nets.status=16;

				nodes.net=atoi(tmp);
				nodes.hubnr=atoi(tmp);
				nodes.node=0;

				stripout(nodes.nodename, nodeline, 2, 25);
				stripout(nodes.location, nodeline, 3, 25);
				stripout(nodes.sysop, nodeline, 4, 36);
				stripout(nodes.telnumber, nodeline, 5, 25);

				strcpy(hphone, nodes.telnumber);

				stripout(nets.netname, nodeline, 2, 40);
				nodes.status=17;

				iwrite=-1;
				write=-1;

				sprintf(fotxt,
					"HOST=%d  Name=%s  Loc=%s  Sysop=%s\n",
					nodes.net,
					nodes.nodename, nodes.location,
					nodes.sysop);
				fpr(fotxt);
			}

			if (strcmp(par, "HUB") == 0)
			{
				stripout(tmp, nodeline, 1, 160);
				nodes.hubnr=atoi(tmp);
				nodes.node=atoi(tmp);
				nodes.status=9;

				stripout(nodes.nodename, nodeline, 2, 25);
				stripout(nodes.location, nodeline, 3, 25);
				stripout(nodes.sysop, nodeline, 4, 36);
				stripout(nodes.telnumber, nodeline, 5, 25);

				strcpy(uphone, nodes.telnumber);

				write=-1;
				iwrite=0;
			}

			if (strcmp(par, "HOLD") == 0)
			{
				stripout(tmp, nodeline, 1, 160);
				nodes.node=atoi(tmp);

				stripout(nodes.nodename, nodeline, 2, 25);
				stripout(nodes.location, nodeline, 3, 25);
				stripout(nodes.sysop, nodeline, 4, 36);
				stripout(nodes.telnumber, nodeline, 5, 25);

				nodes.status=3;
				write=-1;
				iwrite=0;
			}

			if (strcmp(par, "DOWN") == 0)
			{
				stripout(tmp, nodeline, 1, 160);
				nodes.node=atoi(tmp);

				stripout(nodes.nodename, nodeline, 2, 25);
				stripout(nodes.location, nodeline, 3, 25);
				stripout(nodes.sysop, nodeline, 4, 36);
				stripout(nodes.telnumber, nodeline, 5, 25);

				nodes.status=0;
				write=-1;
				iwrite=0;
			}

			if (strcmp(par, "PVT") == 0)
			{
				stripout(tmp, nodeline, 1, 160);
				nodes.node=atoi(tmp);

				stripout(nodes.nodename, nodeline, 2, 25);
				stripout(nodes.location, nodeline, 3, 25);
				stripout(nodes.sysop, nodeline, 4, 36);
				stripout(nodes.telnumber, nodeline, 5, 25);

				nodes.status= 5;
				write=-1;
				iwrite=0;
			}

			if (strcmp(par, "") == 0)
			{
				stripout(tmp, nodeline, 1, 160);
				nodes.node=atoi(tmp);

				stripout(nodes.nodename, nodeline, 2, 25);
				stripout(nodes.location, nodeline, 3, 25);
				stripout(nodes.sysop, nodeline, 4, 36);
				stripout(nodes.telnumber, nodeline, 5, 25);

				nodes.status=1;
				write=-1;
				iwrite=0;
			}

			nodes.azone=nodes.zone;	/* Alternate nodenumber. */
			nodes.aregion=nodes.region;
			nodes.anet=nodes.net;	/* If node also is Zone, Region, */
			nodes.anode=nodes.node;	/* Host or Hub. */

			nets.startpos=ftell(g);

			akaexist=0;

			if (strcmp(nodes.telnumber, zphone) == 0 &&
				zphone != 0)
			{
				nodes.azone=nets.zone;
				nodes.aregion=nets.zone;
				nodes.anet=nets.zone;
				nodes.anode=0;
				akaexist=-1;
			}

			if (strcmp(nodes.telnumber, rphone) == 0 &&
				rphone != 0 && akaexist == 0)
			{
				nodes.azone=nets.zone;
				nodes.aregion=nets.region;
				nodes.anet=nets.region;
				nodes.anode=0;
				akaexist=-1;
			}

			if (strcmp(nodes.telnumber, hphone) == 0 &&
				hphone != 0 && akaexist == 0)
			{
				nodes.azone=nets.zone;
				nodes.aregion=nets.region;
				nodes.anet=nets.net;
				nodes.anode=0;
				akaexist=-1;
			}

			if (strcmp(nodes.telnumber, uphone) == 0 &&
				uphone != 0 && akaexist == 0)
			{
				nodes.azone=nets.zone;
				nodes.aregion=nets.region;
				nodes.anet=nets.net;
				nodes.anode=nodes.hubnr;
			}

			if (write == -1)
			{
/*	De hr slingorna som gr ZERO-padding r ondiga men frenklar
	nr man tittar i datafilerna. */

				*(nodes.nodename + 24)=0;
				i=0;
				while( *(nodes.nodename + i) != 0) i++;
				while( i<25)
				{
					*(nodes.nodename + i) = 0;
					i++;
				}

				*(nodes.location + 24)=0;
				i=0;
				while( *(nodes.location + i) != 0) i++;
				while( i<25)
				{
					*(nodes.location + i) = 0;
					i++;
				}

				*(nodes.sysop + 35)=0;
				i=0;
				while( *(nodes.sysop + i) != 0) i++;
				while( i<36)
				{
					*(nodes.sysop + i) = 0;
					i++;
				}

				*(nodes.telnumber + 24)=0;
				i=0;
				while( *(nodes.telnumber + i) != 0) i++;
				while( i<25)
				{
					*(nodes.telnumber + i) = 0;
					i++;
				}

				if (fwrite((char *) &nodes, sizeof(nodelist), 1, g) == 0)
				{
					fpr(SCANERROR4);
					fclose(f);
					fclose(g);
					fclose(g0);
					return;
				}
				nets.nodes++;
			}

			if (iwrite == -1)
			{
				i=0;
				while( *(nets.netname + i) != 0) i++;
				while( i<=40)
				{
					*(nets.netname + i) = 0;
					i++;
				}

				if (fwrite((char *) &nets, sizeof(netlist), 1, g0) == 0)
				{
					fpr(SCANERROR5);
					fclose(f);
					fclose(g);
					fclose(g0);
					return;
				}
				nets.nodes=0;
			}
		}
	}
 
	fclose(g);
	fclose(f);
	fclose(g0);
}

int	getnodeinfo(nodeid)
char	*nodeid;
{
	char	tmp[80];

	if (sscanf(nodeid, "%d:%d/%d.%d@%s",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node,
		&nodecode.point,
		tmp) == 5)
	{
		return(0);
	}

	if (sscanf(nodeid, "%d:%d/%d.%d",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node,
		&nodecode.point) == 4)
	{
		return(0);
	}

	if (sscanf(nodeid, "%d:%d/%d@%s",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node,
		tmp) == 4)
	{
		nodecode.point=0;
		return(0);
	}

	if (sscanf(nodeid, "%d/%d.%d@%s",
		&nodecode.net,
		&nodecode.node,
		&nodecode.point,
		tmp) == 4)
	{
		nodecode.zone=sysdata.zone;
		return(0);
	}

	if (sscanf(nodeid, "%d:%d/%d",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node) == 3)
	{
		nodecode.point=0;
		return(0);
	}

	if (sscanf(nodeid, "%d/%d.%d",
		&nodecode.net,
		&nodecode.node,
		&nodecode.point) == 3)
	{
		nodecode.zone=sysdata.zone;
		return(0);
	}

	if (sscanf(nodeid, "%d/%d@%s",
		&nodecode.net,
		&nodecode.node,
		tmp) == 3)
	{
		nodecode.zone=sysdata.zone;
		nodecode.point=0;
		return(0);
	}

	if (sscanf(nodeid, "%d/%d",
		&nodecode.net,
		&nodecode.node) == 2)
	{
		nodecode.zone=sysdata.zone;
		nodecode.point=0;
		return(0);
	}

	return(-1);
}

int	getmnodeinfo(nodeid)
char	*nodeid;
{
	char	tmp[80];

	if (sscanf(nodeid, "(%d:%d/%d.%d@%s)",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node,
		&nodecode.point,
		tmp) == 5)
	{
		return(0);
	}

	if (sscanf(nodeid, "(%d:%d/%d.%d)",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node,
		&nodecode.point) == 4)
	{
		return(0);
	}

	if (sscanf(nodeid, "(%d:%d/%d@%s)",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node,
		tmp) == 4)
	{
		nodecode.point=0;
		return(0);
	}

	if (sscanf(nodeid, "(%d/%d.%d@%s)",
		&nodecode.net,
		&nodecode.node,
		&nodecode.point,
		tmp) == 4)
	{
		nodecode.zone=sysdata.zone;
		return(0);
	}

	if (sscanf(nodeid, "(%d:%d/%d)",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node) == 3)
	{
		nodecode.point=0;
		return(0);
	}

	if (sscanf(nodeid, "(%d/%d.%d)",
		&nodecode.net,
		&nodecode.node,
		&nodecode.point) == 3)
	{
		nodecode.zone=sysdata.zone;
		return(0);
	}

	if (sscanf(nodeid, "(%d/%d@%s)",
		&nodecode.net,
		&nodecode.node,
		tmp) == 3)
	{
		nodecode.zone=sysdata.zone;
		nodecode.point=0;
		return(0);
	}

	if (sscanf(nodeid, "(%d/%d)",
		&nodecode.net,
		&nodecode.node) == 2)
	{
		nodecode.zone=sysdata.zone;
		nodecode.point=0;
		return(0);
	}

	return(-1);
}

int	getnodeinfo2(nodeid)
char	*nodeid;
{


	if (sscanf(nodeid, "%d:%d",
		&nodecode.zone,
		&nodecode.net) == 2)
	{
		nodecode.node=0;
		nodecode.point=0;
		return(0);
	}

	if (sscanf(nodeid, "%d",
		&nodecode.net) == 1)
	{
		nodecode.zone=sysdata.zone;
		nodecode.node=0;
		nodecode.point=0;
		return(0);
	}
	return(-1);
}

int	getnode()
{
	FILE	*g, *g0;
	int	n;

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "NODES.DAT");
 
#ifdef MSDOS
	if ((g=fopen(fotxt,"rb")) == NULL)
#else
	if ((g=fopen(fotxt,"r")) == NULL)
#endif
	{
		fpr(GETNODERR1);
		return(1);
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "NODES.IDX");
 
#ifdef MSDOS
	if ((g0=fopen(fotxt,"rb")) == NULL)
#else
	if ((g0=fopen(fotxt,"r")) == NULL)
#endif
	{
		fpr(GETNODERR2);
		fclose(g);
		return(1);
 	}

	nets.zone=0;
	nets.net=0;

	while((nets.zone != nodecode.zone || nets.net != nodecode.net) &&
		fread((char *) &nets, sizeof(netlist), 1, g0) != 0);

	if (nets.zone == nodecode.zone && nets.net == nodecode.net)
	{
		fseek(g, nets.startpos, SEEK_SET);

		n=fread((char *) &nodes,
				sizeof(nodelist), 1, g);

		while ((nodes.zone == nodecode.zone &&
			nodes.net == nodecode.net &&
			nodes.node != nodecode.node) &&
			n != 0)
		{
			n=fread((char *) &nodes,
				sizeof(nodelist), 1, g);
		}

		if (n == 0 || nodes.zone != nodecode.zone ||
			nodes.net != nodecode.net ||
			nodes.node != nodecode.node)
		{
			sprintf(fotxt, ILLNODE,
				nodecode.zone, nodecode.net, nodecode.node);
			fpr(fotxt);
			fpr(ILLPARAM);
			fclose(g0);
			fclose(g);

			return(-1);
		}
	}
	else
	{
		sprintf(fotxt, ILLZONE,
			nodecode.zone, nodecode.net);
		fpr(fotxt);
		fpr(ILLPARAM);
		fclose(g0);
		fclose(g);
		return(-1);
	}

	fclose(g0);
	fclose(g);

	return(0);
}

void	listnodes(nodeid)
char	*nodeid;
{
	FILE	*g, *g0;
	int	n, r, x;
	char	slask[160];

	if (getnodeinfo2(nodeid) != 0)
	{
		nodecode.zone=sysdata.zone;
		nodecode.net=sysdata.net;
	}

	if (nodecode.zone == 0 || nodecode.net == 0)
	{
		fpr("Listnodes : ");
		fpr(ILLPARAM);
		return;
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "NODES.DAT");
 
#ifdef MSDOS
	if ((g=fopen(fotxt,"rb")) == NULL)
#else
	if ((g=fopen(fotxt,"r")) == NULL)
#endif
	{
		fpr(LISTNODERR1);
		return;
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "NODES.IDX");
 
#ifdef MSDOS
	if ((g0=fopen(fotxt,"rb")) == NULL)
#else
	if ((g0=fopen(fotxt,"r")) == NULL)
#endif
	{
		fpr(LISTNODERR2);
		fclose(g);
		return;
 	}

	nets.zone=0;
	nets.net=0;

	sprintf(fotxt, NODELISTINF, nodecode.zone, nodecode.net);
	fpr(fotxt);

	while((nets.zone != nodecode.zone || nets.net != nodecode.net) &&
		fread((char *) &nets, sizeof(netlist), 1, g0) != 0);

	n=0;

	newline();
	newline();
	fpr(NODEHEADER);
	newline();

	fseek(g, nets.startpos, SEEK_SET);

	r=0;

	x=-1;

	while (-1)
	{
		nodes.net = 0;

		while (nodes.net != nodecode.net && nodecode.net != 0 ||
			nodes.zone != nodecode.zone)
		{
			if (fread((char *) &nodes, sizeof(nodelist), 1, g)
				== 0 ||
				x == 0 && (nodes.net != nodecode.net ||
					nodes.zone != nodecode.zone))
			{
				fclose(g);
				fclose(g0);
				return;
			}
		}

		x=0;

/*		sprintf(slask, "[%d:(%d)%d/%d] ",
				nodes.azone,
				nodes.aregion,
				nodes.anet,
				nodes.anode);

		fpr(slask); */

		sprintf(slask, "%d:(%d)%d/%d",
				nodes.zone,
				nodes.region,
				nodes.net,
				nodes.node);

		if (nodes.status == 65)
			sprintf(fotxt,
				ZONELINE,
				slask,
				nodes.nodename,
				nodes.location);

		if (nodes.status == 33)
			sprintf(fotxt,
				REGIONLINE,
				slask,
				nodes.nodename,
				nodes.location);

		if (nodes.status == 17)
			sprintf(fotxt,
				HOSTLINE,
				slask,
				nodes.nodename,
				nodes.location);

		if (nodes.status == 9)
			sprintf(fotxt,
				HUBLINE,
				slask,
				nodes.nodename,
				nodes.location);

		if (nodes.status == 5)
			sprintf(fotxt,
				PVTLINE,
				slask,
				nodes.nodename,
				nodes.location);

		if (nodes.status == 3)
			sprintf(fotxt,
				HOLDLINE,
				slask,
				nodes.nodename,
				nodes.location);

		if (nodes.status == 1)
			sprintf(fotxt,
				NORMALLINE,
				slask,
				nodes.nodename,
				nodes.location);

		if (nodes.status == 0)
			sprintf(fotxt,
				DOWNLINE,
				slask,
				nodes.nodename,
				nodes.location);

		if (ansi == 1)
		{
			strcpy(slask, fotxt);

			if (nodes.zone == sysdata.zone &&
				nodes.net == sysdata.net &&
				nodes.node == sysdata.node)
			{
				sprintf(fotxt, "%s%s%s",
					ansicol[13],
					slask,
					ansicol[7]);
			}
		}

		if (ansi == 2)
		{
			strcpy(slask, fotxt);

			if (nodes.zone == sysdata.zone &&
				nodes.net == sysdata.net &&
				nodes.node == sysdata.node)
			{
				sprintf(fotxt, "%s%s%s",
					ansicol[21],
					slask,
					ansicol[20]);
			}
		}

		fpr(fotxt);

		n++; r++;

		if ((unsigned int)n > (user.lines - 4))
		{
			strcpy (fotxt, "");
			strcpy(slask, PRESSRETURN);

			if (ansi == 1) sprintf(slask, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

			if (ansi == 2) sprintf(slask, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			if (lineed(fotxt, slask, "", 30, 1) < 0)
				return;
			if (*fotxt != 0)
			{
				fclose(g);
				fclose(g0);
				return;
			}

			newline();
			fpr(NODEHEADER);
			newline();
			n=0;
		}
	}
	fclose(g);
	fclose(g0);
}

void	listnets(zonenumber)
char	*zonenumber;
{
	FILE	*g;
	int	n, zonenr, zoneold, regionold, r;
	char	slask[160];

	zonenr=atoi(zonenumber);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "NODES.IDX");
 
#ifdef MSDOS
	if ((g=fopen(fotxt,"rb")) == NULL)
#else
	if ((g=fopen(fotxt,"r")) == NULL)
#endif
	{
		fpr(NETSERR1);
		return;
	}

	n=0;

	newline();
	newline();
	fpr(NETHEADER);
	newline();
	newline();

	zoneold=0;
	regionold=0;

	while (-1)
	{
		nets.zone=0;

		r=-1;

		while (nets.zone != (unsigned int)zonenr &&
			zonenr != 0 || r != 0)
		{
			if (fread((char *) &nets, sizeof(netlist), 1, g) == 0)
			{
				fclose(g);
				return;
			}
			r=0;
		}

		if (nets.zone != (unsigned int)zoneold)
		{
			fpr("\n----\n");
			zoneold=nets.zone;
			n++; n++;
		}

		if (nets.region != (unsigned int)regionold)
		{
			fpr("\n");
			regionold=nets.region;
			n++;
		}

		sprintf(fotxt,
			NETSLINE,
			nets.zone, nets.region, nets.net, nets.hubnr,
			nets.netname);

		if (ansi == 1 &&
			nets.zone == sysdata.zone &&
			nets.net == sysdata.net)
		{
			sprintf(slask, "%s%s%s",
				ansicol[13],
				fotxt,
				ansicol[7]);
			strcpy(fotxt, slask);
		}

		if (ansi == 2 &&
			nets.zone == sysdata.zone &&
			nets.net == sysdata.net)
		{
			sprintf(slask, "%s%s%s",
				ansicol[21],
				fotxt,
				ansicol[20]);
			strcpy(fotxt, slask);
		}

		fpr(fotxt);

		n++;

		if ((unsigned int)n > (user.lines - 4))
		{
			strcpy (fotxt, "");
			strcpy(slask, PRESSRETURN);
			if (ansi == 1) sprintf(slask, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

			if (ansi == 2) sprintf(slask, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			if (lineed(fotxt, slask, "", 30, 1) < 0)
			{
				fclose(g);
				return;
			}

			if (*fotxt != 0)
			{
				fclose(g);
				return;
			}

			newline();
			fpr(NETHEADER);
			newline();
			n=0;
		}
	}
	fclose(g);
}

int	getareainf(nodenr)
int	nodenr;
{
	FILE		*f;
	long int	position;
	char		tmp[80];

	env=getenv("ADATA");
	strcpy(tmp, env);
	strcat(tmp, "AREAS.DAT");
 
#ifdef MSDOS
	if ((f=fopen(tmp,"rb")) == NULL)
#else
	if ((f=fopen(tmp,"r")) == NULL)
#endif
	{
		printf("Checking : \"%s\"\n", tmp);
		perror(GETAREAERR1);
		return(-1);
	}

	position=(unsigned int) sizeof(areastruct) * (unsigned int) nodenr;

	if (fseek(f, position, SEEK_SET) != 0)
	{
		perror(GETAREAERR2);
		fclose(f);
		logg(GETAREAERR2, 0);
		exit(9);
	}

	if (fread((char *) &nodedata, sizeof(areastruct), 1, f) == 0)
	{
		fclose(f);
		return(-1);
	}

	fclose(f);
	return(nodenr);
}

int	putareainf(nodenr)
int	nodenr;
{
	FILE		*f;
	long int	position;

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "AREAS.DAT");
 
#ifdef MSDOS
	if ((f=fopen(fotxt,"rb+")) == NULL)
#else
	if ((f=fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(PUTAREAERR1);
		logg(PUTAREAERR1, 0);
		exit(9);
	}

	position=(unsigned int) sizeof(areastruct) * (unsigned int) nodenr;

	if (fseek(f, position, SEEK_SET) != 0)
	{
		perror(PUTAREAERR2);
		fclose(f);
		logg(PUTAREAERR2, 0);
		exit(9);
	}

	if (fwrite((char *) &nodedata, sizeof(areastruct), 1, f) == 0)
	{
		perror(PUTAREAERR3);
		fclose(f);
		logg(PUTAREAERR3, 0);
		exit(9);
	}

	fclose(f);
	return(0);
}

void		addnodes(intxt, areadat, areas, moete)
unsigned char	*intxt, *areadat;
unsigned int	*areas, moete;
{
	char		nodeid[30];
	int		i, n, j, old;
	areastruct	*areadata;

	i=0;
	while (*(intxt + i) != 0)
	{
		n=0;
		while (*(intxt + i) != 0 && *(intxt + i) != ',')
		{
			*(nodeid + n)=*(intxt + i);
			i++;
			n++;
		}
		*(nodeid + n)=0;
		if (*(intxt + i) != 0) i++;

		if (getnodeinfo(nodeid) != 0)
		{
			sprintf(fotxt, NODENRERR1, nodeid);
			fpr(fotxt);
			return;
		}

		if (nodecode.net != sysdata.pointnet)
		{
			if (getnode() != 0)
			{
				sprintf(fotxt, NODENRERR2,
					nodeid);
				fpr(fotxt);
				return;
			}
		}

		old=0;
		for (j = 0 ; j < (int)*areas ; j++)
		{
			areadata=(areastruct *)
				(areadat + sizeof(areastruct) * j);

			if (areadata->meet == moete &&
				areadata->zone  == nodecode.zone &&
				areadata->net   == nodecode.net &&
				areadata->node  == nodecode.node)
			{
				areadata->flag =
					(char)((int)areadata->flag | 1);
				old=-1;
			}
		}

		if (old==0)
		{
			j=(int)*areas;

			areadata=(areastruct *)
				(areadat + sizeof(areastruct) * j);

			areadata->flag     = 1;
			areadata->meet     = moete;
			areadata->zone     = nodecode.zone;
			areadata->net      = nodecode.net;
			areadata->node     = nodecode.node;
			areadata->lastread = meetinf.firsttext+meetinf.texts;

			*areas = *areas + 1;
		}
	}
}

int		areacomp(v1,v2)
areastruct	*v1, *v2;
{
	if (v1->meet < v2->meet) return(-1);
	if (v1->meet > v2->meet) return(1);
	if (v1->zone < v2->zone) return(-1);
	if (v1->zone > v2->zone) return(1);
	if (v1->net  < v2->net)  return(-1);
	if (v1->net  > v2->net)  return(1);
	if (v1->node < v2->node) return(-1);
	if (v1->node > v2->node) return(1);
	return(0);
}

void	scanareas()
{
	FILE			*f;
	unsigned char		intxt[512], *areadat, areaid[30];
	int			i, j, nodenr, new, moeten, areas,
				moete, zone, net, node;
	areastruct		*areadata;

	if ((user.maintprivs & SYS_NETWORK) == 0)
	{
		fpr(NONETPRIV);
		logg(NOTNETPRV, 1);
		return; 
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "AREAS.DAT");

	new=0;

#ifdef MSDOS
	if ((f=fopen(fotxt,"rb")) == NULL) new=-1;
#else
	if ((f=fopen(fotxt,"r")) == NULL) new=-1;
#endif

	areas=0;

	areadat=calloc(1024, sizeof(areastruct));

	if (areadat == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	if (new == 0)
	{
		while (fread((char *) (areadat+sizeof(areastruct)*areas),
			sizeof(areastruct), 1, f) != 0)
		{
			areadata=(areastruct *)
				(areadat+sizeof(areastruct)*areas);
			j=(int) areadata->flag;
			j=(j & 254);
			areadata->flag=(unsigned char) j;
			areas++;
		}

		fclose(f);
	}

/*	Nolla frsta biten i alla poster, och ettstll den igen
	om den fanns i den nya AREAS.CFG */

	newline();

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "AREAS.CFG");

#ifdef MSDOS
	if ((f=fopen(fotxt,"rt")) == NULL)
#else
	if ((f=fopen(fotxt,"r")) == NULL)
#endif
	{
		sprintf(fotxt, SCANARERR2);
		fpr(fotxt);
		free(areadat);
		return;
	}

	nodenr=0;

	while (fgets(intxt, 510, f) != NULL)
	{
		if (*intxt != ';')
		{
			i=0;

			*areaid=0;

			while(*(intxt + i) != 0 && *(intxt + i) != ',')
			{
				*(areaid + i)=*(intxt + i);
				i++;
			}
			*(areaid + i)=0;
			if (*(intxt + i) == ',') i++;

			moeten=getmoeten();
			j=1;
			getmaxtext(j);

			while(j <= moeten &&
				instring(areaid, meetinf.echoarea) != 0)
			{
				j++;
				getmaxtext(j);
			}

			if (j <= moeten && *(intxt + i) != 0)
				addnodes((intxt + i), areadat, &areas, j);
		}
	}
	fclose(f);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "AREAS.DAT");

#ifdef MSDOS
	if ((f=fopen(fotxt,"wb")) == NULL)
#else
	if ((f=fopen(fotxt,"w")) == NULL)
#endif
	{
		perror(SCANARERR1);
		logg(SCANARERR1, 0);
		exit(9);
	}

	qsort(areadat, areas, sizeof(areastruct), areacomp);

	j=0;
	while (j<areas)
	{
		areadata=(areastruct *) (areadat+sizeof(areastruct)*j);

		if ((areadata->flag & 1) != 0)
		{

/*	Kolla om vi frsker lagra en dublett. Stt i=1 om det var en dublett.
	Vi har en sorterad lista, s vi behver bara kolla fregende post. */

			i=0;
			if ((unsigned int) moete    == areadata->meet &&
				(unsigned int) zone == areadata->zone &&
				(unsigned int) net  == areadata->net &&
				(unsigned int) node == areadata->node) i=1;

			if (i == 0)
			{
				if (fwrite((char *)
					areadat+sizeof(areastruct)*j,
					sizeof(areastruct), 1, f) == 0)
				{
					perror(SCANARERR3);
					logg(SCANARERR3, 0);
					exit(9);
				}
			}

			moete = areadata->meet;
			zone  = areadata->zone;
			net   = areadata->net;
			node  = areadata->node;
		}

		j++;
	}

	fclose(f);
	free(areadat);
}

void	listareas()
{
	int		n, moeten, rad;
	unsigned int	meetold;

	if ((user.maintprivs & SYS_NETWORK) == 0)
	{
		fpr(NONETPRIV);
		logg(NOTNETPRV, 1);
		return; 
	}

	newline();

	moeten=getmoeten();

	rad=0;

	meetold=0;
	n=0;
	while(getareainf(n) >= 0)
	{
		if (meetold != nodedata.meet)
		{
			meetold=nodedata.meet;
			getmaxtext(meetold);

			newline();

			sprintf(fotxt, "%5d (%s) %s\n",
				meetold-1,
				meetinf.echoarea, meetinf.namn);

			if (ansi == 1)
				sprintf(fotxt, "%s%5d (%s) %s%s\n",
					ansicol[15],
					meetold-1,
					meetinf.echoarea, meetinf.namn,
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt, "%s%5d (%s) %s%s\n",
					ansicol[21],
					meetold-1,
					meetinf.echoarea, meetinf.namn,
					ansicol[20]);

			fpr(fotxt);
			rad++;
			rad++;
		}

		nodecode.zone=nodedata.zone;
		nodecode.net=nodedata.net;
		nodecode.node=nodedata.node;
		nodecode.point=0;

		if (nodecode.net != sysdata.pointnet)
		{
			if (getnode() != 0)
			{
				sprintf(fotxt, NODENRERR3,
						nodecode.zone,
						nodecode.net,
						nodecode.node,
						nodecode.point);
				fpr(fotxt);
				return;
			}

			sprintf(fotxt, "%d:%d/%d.%d %7ld %s\n",
					nodecode.zone,
					nodecode.net,
					nodecode.node,
					nodecode.point,
					nodedata.lastread,
					nodes.nodename);

/*	Gul frg fr noder i lokala ntet. */

			if (ansi == 1 &&
				nodecode.zone == sysdata.zone &&
				nodecode.net == sysdata.net) fpr(ansicol[13]);

			if (ansi == 2 &&
				nodecode.zone == sysdata.zone &&
				nodecode.net == sysdata.net) fpr(ansicol[21]);

/*	Grn frg fr noder utanfr lokala ntet, men i samma zon. */

			if (ansi == 1 &&
				nodecode.zone == sysdata.zone &&
				nodecode.net != sysdata.net) fpr(ansicol[12]);

			if (ansi == 2 &&
				nodecode.zone == sysdata.zone &&
				nodecode.net != sysdata.net) fpr(ansicol[18]);

/*	Rd frg fr noder utanfr denna zon. */

			if (ansi == 1 &&
				nodecode.zone != sysdata.zone)
				fpr(ansicol[11]);

			if (ansi == 1 &&
				nodecode.zone != sysdata.zone)
				fpr(ansicol[19]);
		}
		else
		{
			sprintf(fotxt, "Point : %d:%d/%d.%d %7ld\n",
					sysdata.zone,
					sysdata.net,
					sysdata.node,
					nodecode.node,
					nodedata.lastread);

/*	Cyan frg fr pointar. */

			if (ansi == 1) fpr(ansicol[16]);
			if (ansi == 2) fpr(ansicol[22]);
		}

		fpr(fotxt);

/*	terstll till vit frg. */

		if (ansi == 1) fpr(ansicol[7]);
		if (ansi == 2) fpr(ansicol[20]);
		rad++;
		rad++;

		n++;
	}
}

/*
	Olika filtyper p data i FIDO-Net

				    Packat   Ej Packat.
                     NORMAL ....... (.FLO or .OUT)
                     CRASH ........ (.CLO or .CUT)
                     HOLD ......... (.HLO or .HUT)
                     DIRECT ....... (.DLO or .DUT)
*/

void	translate(text, from, to)
char	*text;
int	from, to;
{
	int	i;

	i=0;
	while(*(text + i) != 0)
	{
		*(text + i)=transchar( *(text + i), from, to);
		i++;
	}
}

int	subcompstr(compval, string)
char	*compval, *string;
{
	int	i;

	if (strlen(compval) > strlen(string)) return(-1);

	i=0;
	while( *(compval + i) == *(string + i) && *(compval + i) != 0) i++;

	if (*(compval + i) == 0) return(0);

	return(1);
}

int	getaddinfo(nodeid)
char	*nodeid;
{
	if (sscanf(nodeid, "%d:%d/%d",
		&nodecode.zone,
		&nodecode.net,
		&nodecode.node) == 3)
	{
		nodecode.point=0;
		return(0);
	}

	if (sscanf(nodeid, "%d/%d",
		&nodecode.net,
		&nodecode.node) == 2)
	{
		nodecode.point=0;
		return(1);
	}

	if (sscanf(nodeid, "%d",
		&nodecode.node) == 1)
	{
		nodecode.point=0;
		return(2);
	}
	return(-1);
}

/*	Vi supportar faktiskt t.o.m. zoner i SEEN-BY raderna!
	Ngon annan som gr? */

void	addseens(rawline, seenbys, seens)
char	*rawline, *seenbys;
int	*seens;
{
	char		tmp[80];
	int		i, n;
	areastruct	*area1, *area2;

	i=0;
	while(*(rawline + i) != 0)
	{
		while(*(rawline + i) != 0 && *(rawline + i) == ' ') i++;

		n=0;
		while(*(rawline + i) != 0 && *(rawline + i) != ' ')
		{
			*(tmp + n)=*(rawline + i);
			i++;
			n++;
		}
		*(tmp + n)=0;

		n=getaddinfo(tmp);

		if (*seens != 0)
			area1=(areastruct *)
				(seenbys + sizeof(areastruct) *
				((*seens) - 1));

		area2=(areastruct *)
			(seenbys + sizeof(areastruct) * *seens);

		switch (n)
		{
			case 0: area2->zone=nodecode.zone;
				area2->net=nodecode.net;
				area2->node=nodecode.node;
				break;

			case 1: if (*seens == 0)
				{
					area2->zone=sysdata.zone;
				}
				else
				{
					area2->zone=area1->zone;
				}
				area2->net=nodecode.net;
				area2->node=nodecode.node;
				break;

			case 2: if (*seens == 0)
				{
					area2->zone=sysdata.zone;
					area2->net=sysdata.net;
				}
				else
				{
					area2->zone=area1->zone;
					area2->net=area1->net;
				}
				area2->node=nodecode.node;
				break;
		}

		if (n >= 0) *seens = *seens + 1;
	}
}

int		parseorigin(origin, zone, net, node, point)
char		*origin;
unsigned int	*zone, *net, *node, *point;
{
	int	k, z, n, p;
	char	tmp[80], tmp2[80];

	k=strlen(origin)+1;

	*zone=sysdata.zone;
	*net=sysdata.net;
	*node=sysdata.node;
	*point=0;

/*	Leta reda p slutparentesen som innesluter nodnumret. */

	while(*(origin+k) != ')' && k > 0) k--;
	*(origin+k)=0;

/*	Lp vidare tills vi hittar en siffra, d br det vara nodnummer. */

	while((*(origin+k) < '0' ||
		*(origin+k) > '9') &&
		k > 0) k--;

/*	Ls frbi alla tecken som r tilltna i ett nodnummer. */

	while( (*(origin+k) >= '0' && *(origin+k) <= '9' ||
		*(origin+k) == '.' ||
		*(origin+k) == '/' ||
		*(origin+k) == ':') &&
		k > 0) k--;

/*	Leta upp vnsterparentesen kring nodnumret. */

	z=k;
	p=0;

	while(z>0)
	{
		if (*(origin+z) == '(') p=1;
		z--;
	}
	if (*(origin+z) == '(') p=1;

/*	Med litet tur, s r det ett nodnummer som vi har hittat om
	vi har ftt ut bde nodnummerposition och vnsterparentesposition
	som r strre n noll. */

	k++;
	strcpy(tmp, (origin+k));

	if (p != 0)
	{
		printf("Origin = \"%s\" -> ", tmp);


		n=sscanf(tmp, "%d:%d/%d.%d@%s",
			zone, net, node, point, tmp2);

		if (n == 5)
		{
			printf("Alt 5:1 : %d:%d/%d.%d  \"%s\"\n",
				*zone, *net, *node, *point, tmp2);
			return(1);
		}

		n=sscanf(tmp, "%d:%d/%d@%s",
			zone, net, node, tmp2);

		if (n == 4)
		{
			printf("Alt 4:1 : %d:%d/%d  \"%s\"\n",
				*zone, *net, *node, tmp2);
			return(1);
		}

		n=sscanf(tmp, "%d:%d/%d.%d",
			zone, net, node, &point);

		if (n == 4)
		{
			printf("Alt 4:2 : %d:%d/%d.%d\n",
				*zone, *net, *node, point);
			return(1);
		}

		n=sscanf(tmp, "%d/%d.%d@%s",
			net, node, point, tmp2);

		if (n == 4)
		{
			printf("Alt 4:3 : %d/%d.%d  \"%s\"\n",
				*net, *node, *point, tmp2);
			return(1);
		}

		n=sscanf(tmp, "%d:%d/%d",
			zone, net, node);

		if (n == 3)
		{
			printf("Alt 3:1 : %d:%d/%d\n",
				*zone, *net, *node);
			return(1);
		}

		n=sscanf(tmp, "%d/%d@%s",
			net, node, tmp2);

		if (n == 3)
		{
			printf("Alt 3:2 : %d/%d  \"%s\"\n", *net, *node, tmp2);
			return(1);
		}

		n=sscanf(tmp, "%d/%d.%d",
			net, node, point);

		if (n == 3)
		{
			printf("Alt 3:3 : %d/%d.%d\n",
				*net, *node, *point);
			return(1);
		}

		n=sscanf(tmp, "%d/%d",net, node);

		if (n == 2)
		{
			printf("Alt 2:1 : %d/%d\n", *net, *node);
			return(1);
		}

	}

	printf(BADNODENUMBER, tmp);
	return(0);
}
