/* PACKETS2.C - FIDO-Net underhllsrutiner. */
/* (c) 1989, 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

void	filetext(zone, net, node, type, attribute, textnr, addseenby, adds)
unsigned int	zone, net, node, attribute, textnr, adds;
char		*type, *addseenby;
{
	FILE		*f;
	char		tmp[160], *textarea, *seenbys, *paths, tmp2[80];
	int		i, c, t, n, pa, new, msgcharset, seens,
			tempzone, tempnet, tempnode, kludge, ch;
	long int	klocka[1], test;
	areastruct	*area1;

/*	Generera ett filnamn som hnvisar till destinationsnod/nt. */

/*	Denna rutin skall anvndas s smningom,
	nr vi ftt in nya texter i systemet.
	Nr vi r i lokal zon r det OUTBOUND som gller, annars r det
	OUTBOUND.<zone> som gller. */

	if (zone == 0) zone=sysdata.zone;

	nodecode.zone=zone;
	nodecode.net=net;
	nodecode.node=node;

	if (getnode() != 0 &&
		(net != sysdata.pointnet || zone != sysdata.zone))
	{
		sprintf(fotxt, BADNODEID, zone, net, node);
		logg(fotxt, 1);
		printf(fotxt);
		return;
	}

/*	Om brevet vi skickar r normalt, d.v.s. ej ett CRASH mail, s
	skickar vi det till vr HOST fr distribution tillsammans med ECHOMAIL.
	Annars kontrollerar vi om noden vi skickar till r
	DOWN, HOLD eller PRIVAT. D skickar vi till nodens HOST i stllet
	fr att skicka direkt till noden. Detta r den mest vettiga lsning
	som jag kan komma p just nu. */

	if ((attribute & 1) == 1 &&
		(textindex.type & 32) == 0)
	{
		nodes.azone=sysdata.zone;
		nodes.anet=sysdata.net;
		nodes.anode=0;
	}
	else
	{
		if (nodes.status == 0 || nodes.status == 3 ||
			nodes.status == 5) nodes.anode=0;
	}

	if (net == sysdata.pointnet)
	{
		nodes.azone=zone;
		nodes.anet=net;
		nodes.anode=node;
	}

	if ((unsigned int) nodes.azone == sysdata.zone && moetnumber == 1 ||
		nodedata.zone == sysdata.zone && moetnumber > 1)
		sprintf(fotxt,"%s%04x%04x.%s", outbound,
			nodes.anet, nodes.anode, type);
	else
	{
		strcpy(tmp, outbound);
		i=strlen(tmp);
		*(tmp+i-1)=0;
		sprintf(fotxt, "%s.%03x\\%04x%04x.%s",
			tmp, nodes.azone, nodes.anet, nodes.anode, type);
	}

	newline();

/*	Ta reda p tiden just nu. */

	time(klocka);
	tid=localtime(klocka);

	new=0;

/*	Se efter om det rkar finnas en fil redan, som inte r
	skickad. Om det inte fanns det, s skapar vi en ny! */

#ifdef MSDOS
	if ((f = fopen(fotxt, "r+b")) == NULL)
#else
	if ((f = fopen(fotxt, "r+")) == NULL)
#endif
	{
		printf(NEWCREATE);
#ifdef MSDOS
		if ((f = fopen(fotxt, "w+b")) == NULL)
#else
		if ((f = fopen(fotxt, "w+")) == NULL)
#endif
		{
/*	Om det inte gick att skapa filen, s var antagligen zonen fel.
	I s fall stter vi zon 0, och tar hand om filen manuellt. */

			sprintf(fotxt, "%s.%03x\\%04x%04x.%s",
				tmp, 0, nodes.anet, nodes.anode, type);

			printf(NEWCREATE);
#ifdef MSDOS
			if ((f = fopen(fotxt, "w+b")) == NULL)
#else
			if ((f = fopen(fotxt, "w+")) == NULL)
#endif
			{
				sprintf(tmp, NEWCREERR, fotxt);
				perror(tmp);
				logg(NEWCREERR, 0);
				exit(9);
			}
		}

		if (net == sysdata.pointnet)
		{
			net=sysdata.net;
			node=sysdata.node;
		}

		new=1;

		packhd.orignode=sysdata.node;
		packhd.destnode=node;
		packhd.year=1900 + tid->tm_year;
		packhd.month=tid->tm_mon;
		packhd.day=tid->tm_mday;
		packhd.hour=tid->tm_hour;
		packhd.minute=tid->tm_min;
		packhd.second=tid->tm_sec;
		packhd.baud=0;
		packhd.idcode=0x0002;
		packhd.orignet=sysdata.net;
		packhd.destnet=net;
		packhd.pcode=0; /* Produktkod fr paketgenereraren. */
		packhd.serialno=0;
		strcpy(packhd.password, "");
		packhd.zorigzone=sysdata.zone;
		packhd.zdestzone=zone;
		strcpy(packhd.filler1, "  ");
		packhd.pcodeh=0; /* Produktkod fr paketgenereraren. */
		packhd.serialnol=0;
		packhd.capword=1;
		packhd.capwordc=(packhd.capword << 8) | (packhd.capword >> 8);
		packhd.origzone=sysdata.zone;
		packhd.destzone=zone;
		packhd.origpoint=sysdata.point;
		packhd.destpoint=0;	/* Vi kr med denna info
					   tills vi r klara med
					   hur FrontDoor hanterar POINTER. */

		strcpy(packhd.filler, "    ");

		fseek(f, 0L, SEEK_SET);
		fwrite((char *) &packhd, sizeof(packheader), 1, f);
		fflush(f);
	}
	else
	{
		printf(CHECKOLDFILE);

		if (net == sysdata.pointnet)
		{
			net=sysdata.net;
			node=sysdata.node;
		}

		if (fseek(f, 0L, SEEK_SET) != 0)
		{
			sprintf(tmp, SEEKERROR, fotxt);
			perror(tmp);
			fclose(f);
			logg(SEEKERROR, 0);
			exit(9);
		}

		if (fread((char *) &packhd, sizeof(packheader), 1, f) == 0)
		{
			packhd.orignode=sysdata.node;
			packhd.destnode=node;
			packhd.year=1900 + tid->tm_year;
			packhd.month=tid->tm_mon;
			packhd.day=tid->tm_mday;
			packhd.hour=tid->tm_hour;
			packhd.minute=tid->tm_min;
			packhd.second=tid->tm_sec;
			packhd.baud=0;
			packhd.idcode=0x0002;
			packhd.orignet=sysdata.net;
			packhd.destnet=net;
			packhd.pcode=0; /* Produktkod fr paketgenereraren. */
			packhd.serialno=0;
			strcpy(packhd.password, "        ");
			packhd.zorigzone=sysdata.zone;
			packhd.zdestzone=zone;
			strcpy(packhd.filler1, "    ");
			packhd.pcodeh=0; /* Produktkod fr paketgenereraren. */
			packhd.serialnol=0;
			packhd.capword=1;
			packhd.capwordc=(packhd.capword << 8) |
				(packhd.capword >> 8);
			packhd.origzone=sysdata.zone;
			packhd.destzone=zone;
			packhd.origpoint=sysdata.point;
			packhd.destpoint=0;	/* Vi kr med denna info
						   tills vi r klara med
						   hur FrontDoor hanterar
						   POINTER. */
			strcpy(packhd.filler, "    ");

			fseek(f, 0L, SEEK_SET);
			fwrite((char *) &packhd, sizeof(packheader), 1, f);
			fflush(f);
			new=1;
		}
	}

/*	Se efter om det var "Slut p texter" skriv ver detta i s fall. */

	if (new != 1)
	{
		printf(FIXTEXTEND);
		fseek(f, -4L, SEEK_END);
		fread((char *) &test, sizeof(long int), 1, f);
		if (test == 0L) fseek(f, -4L, SEEK_END);
	}

/*	Skapa ett texthuvud. */

	packmsg.idcode=0x0002;

	packmsg.orignet=textindex.crenet;
	packmsg.orignode=textindex.crenode;

/*	If we are working inside our own zone, we put the destination address
	dirctly into the header, otherwise, we put an invalid address into
	the header, and let the message be routed to the top level in
	this zone by other nodes. The top level will then look at the INTL
	kludge to route the message. */

	if (zone == sysdata.zone)
	{
		packmsg.destnode=node;
		packmsg.destnet=net;
	}
	else
	{
		packmsg.destnode=zone;
		packmsg.destnet=sysdata.zone;
	}

	packmsg.attribute=attribute;
	packmsg.cost=0;

	fseek(f, 0L, SEEK_CUR);

	fwrite((char *) &packmsg, sizeof(packmsg), 1, f);

	fflush(f);

	ftidkonv((long int *)&textindex.cretime, fotxt);

	fwrite((char *) fotxt, strlen(fotxt) + 1, 1, f);

	translate(textindex.touser, BASECHARSET, 0);

	fwrite((char *) textindex.touser,
		strlen(textindex.touser) + 1, 1, f);

	translate(textindex.creuser, BASECHARSET, 0);

	fwrite((char *) textindex.creuser,
		strlen(textindex.creuser) + 1, 1, f);

	translate(textindex.subject, BASECHARSET, 0);

	fwrite((char *) textindex.subject,
		strlen(textindex.subject) + 1, 1, f);

	if (moetnumber > 1)
	{
		sprintf(fotxt, AREALINE, meetinf.echoarea);
		fwrite((char *) fotxt, strlen(fotxt), 1, f);
	}

/*	Spara buffertar! */

	fflush(f);

/*	Hmta in texten, och verfr den till utbytesformat. */

#ifdef MSDOS
	textarea=halloc((unsigned long int)MAXLINES *
		(unsigned long int)LINELENGTH, sizeof(char));
#else
	textarea=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

	if (textarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	printf(GETTEXT, textnr);

	gettxt(textarea, textnr);

/*	printf(PROCESSTEXT, 1); */

	i=0;
	t=0;

	/* innehller textens teckenuppsttning. stts av ^ACHARSET. */
	msgcharset=(unsigned int)meetinf.defcharset;

/*	Ls frbi huvudet. Detta avslutas alltid med 2 radmatningar. */

	while (*(textarea + i) != '\r' ||
		*(textarea + i + 1) != '\n' ||
		*(textarea + i + 2) != '\r' ||
		*(textarea + i + 3) != '\n') i++;

/*	printf(PROCESSTEXT, 2); */

	if (*(textarea + i) == 0)
	{
		printf(SEEKERROR, fotxt);
		fclose(f);
		logg(SEEKERROR, 1);
		exit(9);
	}

	if (*(textarea + i) == '\r') i=i+4;

/*	printf(PROCESSTEXT, 3); */

/*	Fr SEEN-BY raderna. */

	seenbys=calloc(1024, sizeof(areastruct));

	if (seenbys == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	seens=0;

/*	Fr ^APATH raderna. */

	paths=calloc(1024, sizeof(areastruct));

	if (paths == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	pa=0;

/*	Lgg till vr egen nod, s r vi skra p att den r med!
	Vi kan trolla bort dubletter sedan! */

	sprintf(tmp, "%d:%d/%d", sysdata.zone, sysdata.net, sysdata.node);
	addseens(tmp, seenbys, &seens);

/*	Hr kan vi ha en del litet lustiga satser, men det r fr
	att snabba p det hela litet. */

	strcpy(tmp, "");

	ch=1;

	while ((unsigned int)i < textindex.len && *(textarea + i) != 0)
	{
		c=transchar( *(textarea + i), BASECHARSET, msgcharset);

		if (ch == 1)
		{
			if (subcompstr("AREA:", (textarea + i)) == 0) ch=0;
		}

/*	Skriv ut CHARSET-kludge med rtt information. */

		if (ch == 1)
		{
			ch=2;
			sprintf(tmp2, "\001CHRS: %s\r\n",
				charkludge[msgcharset]);

			printf(tmp2);
			fwrite((char *) tmp2, sizeof(char), strlen(tmp2), f);
		}

/*	Om vi hittar ett radslut skall vi kontrollera om nsta rad r
	en ORIGIN-rad. */

		if (c == '\r')
		{
			if (ch < 1) ch=1;

			if (subcompstr("\r\n * Origin:",
				(textarea + i)) == 0) t=1;

			if (subcompstr("\r * Origin:",
				(textarea + i)) == 0) t=1;
		}

		kludge=0;

		if (t == 1)
		{
/*			Se efter om det fanns en SEEN-BY rad. */

			if (subcompstr("\r\nSEEN-BY:", (textarea + i)) == 0)
			{
				i=i+10;
				n=0;
				*tmp=0;

				while(*(textarea + i) != '\r' &&
					*(textarea + i) != 0)
				{
					*(tmp+n)=*(textarea+i);
					n++;
					i++;
				}
				*(tmp+n)=0;

				addseens(tmp, seenbys, &seens);

				i--;
				kludge=-1;
			}

			if (subcompstr("\rSEEN-BY:", (textarea + i)) == 0)
			{
				i=i+9;
				n=0;
				*tmp=0;

				while(*(textarea + i) != '\r' &&
					*(textarea + i) != 0)
				{
					*(tmp+n)=*(textarea+i);
					n++;
					i++;
				}
				*(tmp+n)=0;

				addseens(tmp, seenbys, &seens);

				i--;
				kludge=-1;
			}

			if (subcompstr("\r\n\001SEEN-BY:", (textarea + i)) == 0)
			{
				i=i+11;
				n=0;
				*tmp=0;

				while(*(textarea + i) != '\r' &&
					*(textarea + i) != 0)
				{
					*(tmp+n)=*(textarea+i);
					n++;
					i++;
				}
				*(tmp+n)=0;

				addseens(tmp, seenbys, &seens);

				i--;
				kludge=-1;
			}

			if (subcompstr("\r\001SEEN-BY:", (textarea + i)) == 0)
			{
				i=i+10;
				n=0;
				*tmp=0;

				while(*(textarea + i) != '\r' &&
					*(textarea + i) != 0)
				{
					*(tmp+n)=*(textarea+i);
					n++;
					i++;
				}
				*(tmp+n)=0;

				addseens(tmp, seenbys, &seens);

				i--;
				kludge=-1;
			}

/*			Se efter om det fanns ne ^APATH - rad. */

			if (subcompstr("\r\n\001PATH:", (textarea + i)) == 0)
			{
				i=i+8;
				n=0;
				*tmp=0;

				while(*(textarea + i) != '\r' &&
					*(textarea + i) != 0)
				{
					*(tmp+n)=*(textarea+i);
					n++;
					i++;
				}
				*(tmp+n)=0;

				addseens(tmp, paths, &pa);

				i--;
				kludge=-1;
			}

			if (subcompstr("\r\001PATH:", (textarea + i)) == 0)
			{
				i=i+7;
				n=0;
				*tmp=0;

				while(*(textarea + i) != '\r' &&
					*(textarea + i) != 0)
				{
					*(tmp+n)=*(textarea+i);
					n++;
					i++;
				}
				*(tmp+n)=0;

				addseens(tmp, paths, &pa);

				i--;
				kludge=-1;
			}
		}

		if (kludge == 0)
		{
			fwrite((char *) &c, sizeof(char), 1, f);
		}

		i++;
	}

#ifdef MSDOS
	hfree(textarea);
#else
	free(textarea);
#endif

	fprintf(f, "\r\n");

/*	Vi skall kolla om vi sjlva r med sist i PATH, annars skall vi med! */

	if (pa > 0)
	{
		area1=(areastruct *)
			(paths + sizeof(areastruct) * (pa - 1));

		if (area1->zone != sysdata.zone ||
			area1->net != sysdata.net ||
			area1->node != sysdata.node)
		{
			sprintf(tmp, "%d:%d/%d",
				sysdata.zone, sysdata.net, sysdata.node);
			addseens(tmp, paths, &pa);
		}
	}
	else
	{
		sprintf(tmp, "%d:%d/%d",
			sysdata.zone, sysdata.net, sysdata.node);
		addseens(tmp, paths, &pa);
	}

/*	Hr lgger vi p noden vi skickar till. Vi kommenterar bort den
	eftersom det tydligen inte skall vara s. */

/*	if (sysdata.pointnet != (unsigned int)net)
	{
		sprintf(tmp, "%d:%d/%d", zone, net, node);
		addseens(tmp, paths, &pa);
	} */

/*	Hr hanterar vi SEEN-BY rader. */

/*	printf(PROCESSTEXT, 4); */

	i=0;
	t=seens * sizeof(areastruct);
	while((unsigned int)i < (adds * sizeof(areastruct)))
	{
		*(seenbys + t)=*(addseenby + i);
		t++;
		i++;
	}

	seens=seens+adds;

	qsort(seenbys, seens, sizeof(areastruct), areacomp);

/*	printf(PROCESSTEXT, 5); */

	i=0;
	tempzone=0;
	tempnet=0;
	tempnode=0;
	strcpy(tmp, "");
	strcpy(tmp2, "");

	while (i<seens && moetnumber > 1 && (sysdata.sysflags & 1) == 0)
	{
		area1=(areastruct *)
			(seenbys + sizeof(areastruct) * i);

/*	Hr har vi std fr zoner i SEEN-BY rader.
	Vi aktiverar det dock inte nnu, eftersom det kan stlla
	till strul fr andra. */

#ifdef ZONESEENBY
		sprintf(tmp2, " %d:%d/%d",
			area1->zone,
			area1->net,
			area1->node);

		if (area1->zone == (unsigned int)tempzone &&
			area1->net != (unsigned int)tempnet)
		{
			sprintf(tmp2, " %d/%d",
				area1->net,
				area1->node);
		}

		if (area1->zone == (unsigned int)tempzone &&
			area1->net == (unsigned int)tempnet &&
			area1->node != (unsigned int)tempnode)
		{
			sprintf(tmp2, " %d",
				area1->node);
		}

/*	Hr kollar vi om nodnumret var det samma som fregende.
	om det var det, s var det ondigt att skriva ut det 2 ggr. */

		if (area1->zone == (unsigned int)tempzone &&
			area1->net == (unsigned int)tempnet &&
			area1->node == (unsigned int)tempnode)
		{
			strcpy(tmp2, "");
		}

		tempzone=(int)area1->zone;
		tempnet=(int)area1->net;
		tempnode=(int)area1->node;
#else
		sprintf(tmp2, " %d/%d",
			area1->net,
			area1->node);

		if (area1->net == (unsigned int)tempnet &&
			area1->node != (unsigned int)tempnode)
		{
			sprintf(tmp2, " %d",
				area1->node);
		}

/*	Hr kollar vi om nodnumret var det samma som fregende.
	om det var det, s var det ondigt att skriva ut det 2 ggr. */

		if (area1->net == (unsigned int)tempnet &&
			area1->node == (unsigned int)tempnode)
		{
			strcpy(tmp2, "");
		}

		tempzone=(int)area1->zone;
		tempnet=(int)area1->net;
		tempnode=(int)area1->node;
#endif

		strcat(tmp, tmp2);

		if (strlen(tmp) > 55)
		{
			sprintf(fotxt, "SEEN-BY:%s\r", tmp);
			fwrite((char *) fotxt, strlen(fotxt), 1, f);
			strcpy(tmp, "");
			tempzone=0;
			tempnet=0;
		}

		i++;
	}

	if (moetnumber > 1 && (sysdata.sysflags & 1) == 0)
	{
		sprintf(fotxt, "SEEN-BY:%s\r", tmp);
		fwrite((char *) fotxt, strlen(fotxt), 1, f);
	}

	strcpy(tmp, "");

/*	printf(PROCESSTEXT, 6); */

	tempzone=0;
	tempnet=0;
	tempnode=0;

	pa--;

	i=0;
	while (i<=pa && moetnumber > 1 && (sysdata.sysflags & 2) == 0)
	{
		area1=(areastruct *)
			(paths + sizeof(areastruct) * i);

/*	Hr har vi std fr zoner i ^APATH rader.
	Vi aktiverar det dock inte nnu, eftersom det kan stlla
	till strul fr andra. */

#ifdef ZONEPATH
		sprintf(tmp2, " %d:%d/%d",
			area1->zone,
			area1->net,
			area1->node);

		if (area1->zone == (unsigned int)tempzone &&
			area1->net != (unsigned int)tempnet)
		{
			sprintf(tmp2, " %d/%d",
				area1->net,
				area1->node);
		}

		if (area1->zone == (unsigned int)tempzone &&
			area1->net == (unsigned int)tempnet)
		{
			sprintf(tmp2, " %d",
				area1->node);
		}

		tempzone=area1->zone;
		tempnet=area1->net;
#else
		sprintf(tmp2, " %d/%d",
			area1->net,
			area1->node);

		if (area1->net == (unsigned int)tempnet)
		{
			sprintf(tmp2, " %d",
				area1->node);
		}

		tempnet=area1->net;
#endif
		strcat(tmp, tmp2);

		if (strlen(tmp) > 55)
		{
			sprintf(fotxt, "\001PATH:%s\r", tmp);
			fwrite((char *) fotxt, strlen(fotxt), 1, f);
			strcpy(tmp, "");
			tempzone=0;
			tempnet=0;
		}

		i++;
	}

	if (moetnumber > 1 && (sysdata.sysflags & 2) == 0)
	{
		sprintf(fotxt, "\001PATH:%s\r", tmp);
		fwrite((char *) fotxt, strlen(fotxt), 1, f);
	}

	strcpy(tmp, "");
	tempzone=0;
	tempnet=0;

/*	printf(PROCESSTEXT, 7); */

	free(paths);
	free(seenbys);

/*	Lgg p slut p texten. */

	test=0L;
	fwrite((char *) &test, sizeof(char), 1, f);	

/*	Lgg p "Slut p texter" */

	test=0L;
	fwrite((char *) &test, sizeof(long int), 1, f);	
	fclose(f);
}

void	extractmail()
{
	int		z, mem, textnr;
	long int	n;
	FILE		*f;
	char		tmp[80];

	mem=moetnumber;
	moetnumber=1;
	newline();
	z=getmaxtext(1);
	n=sysdata.lastread;

	while(n < (int)(meetinf.texts+meetinf.firsttext))
	{
		n++;
		textnr=(unsigned int)(n-meetinf.firsttext);
		z=gettextindex(1, textnr);

		if ((textindex.type & 40) == 8 &&
			(textindex.destzone != sysdata.zone ||
			textindex.destnet != sysdata.net ||
			textindex.destnode != sysdata.node))
		{
			printf(PROCESSMAIL, n);
			filetext(textindex.destzone,
				textindex.destnet,
				textindex.destnode,
				"OUT", 1, textnr,
				tmp, 0);
		}

		if ((textindex.type & 40) == 40 &&
			(textindex.destzone != sysdata.zone ||
			textindex.destnet != sysdata.net ||
			textindex.destnode != sysdata.node))
		{
			printf(PROCESSMAIL, n);
			filetext(textindex.destzone,
				textindex.destnet,
				textindex.destnode,
				"CUT", 3, textnr,
				tmp, 0);
		}

		if ((textindex.type & 8) == 8 &&
			textindex.destzone == sysdata.zone &&
			textindex.destnet == sysdata.net &&
			textindex.destnode == sysdata.node &&
			textindex.destpoint != sysdata.point &&
			sysdata.point == 0)
		{
			printf(PROCESSMAIL, n);
			filetext(textindex.destzone,
				sysdata.pointnet,
				textindex.destpoint,
				"HUT", 1, textnr,
				tmp, 0);
		}

/*	Alla brev skickar vi via vr BOSS om vi r POINT. */

		if ((textindex.type & 8) == 8 &&
			textindex.destzone == sysdata.zone &&
			textindex.destnet == sysdata.net &&
			textindex.destnode == sysdata.node &&
			textindex.destpoint != sysdata.point &&
			sysdata.point != 0)
		{
			printf(PROCESSMAIL, n);
			filetext(sysdata.zone,
				sysdata.net,
				sysdata.node,
				"CUT", 1, textnr,
				tmp, 0);
		}
	}

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if (( f = fopen(fotxt,"rb+")) == NULL)
#else
	if (( f = fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(EXTRMAILERR1);
		logg(EXTRMAILERR1, 0);
		exit(9);
	}

	sysdata.lastread=n;

	if (fseek(f, 0L + (unsigned long int) sizeof(int), SEEK_SET) != 0)
	{
		perror(EXTRMAILERR2);
		fclose(f);
		logg(EXTRMAILERR2, 0);
		exit(9);
	}

	if (fwrite((char *) &sysdata, sizeof(systemdata), 1, f) == 0)
	{
		perror(EXTRMAILERR3);
		fclose(f);
		return;
	}

	logg(SYSDATAUPDATED, 3);

	fclose(f);

	moetnumber=mem;
}

void	textextract(n, addseenby, adds)
int	n, adds;
char	*addseenby;
{
	int	z, textnr;

	while((long int)nodedata.lastread <
		meetinf.texts + meetinf.firsttext &&
		(*meetinf.typ == 'E' || *meetinf.typ == 'R'))
	{
		nodedata.lastread++;
		textnr=(unsigned int)(nodedata.lastread
			-meetinf.firsttext);

		z=gettextindex(n,textnr);

/*	Vi extraherar alla texter som inte har sitt senaste ursprung p den nod
	som vi skickar till. Texter till andra nt n POINT-ntet r
	normala. Texter till POINT-ntet r HOLD som DEFAULT.
	Som POINT extraheras enbart de texter som r skapade dr, fr
	att undvika att pointar skapar dubletter fr oss. */

		if (sysdata.point == 0)
		{
			if ((textindex.fromnet != nodedata.net ||
				textindex.fromnode != nodedata.node) &&
				(textindex.type & 1) == 1 &&
				nodedata.net != sysdata.pointnet)
				filetext(nodedata.zone,
					nodedata.net,
					nodedata.node, "OUT", 0, textnr,
					addseenby, adds);

			if ((textindex.fromnet != nodedata.net ||
				textindex.fromnode != nodedata.node) &&
				(textindex.type & 1) == 1 &&
				nodedata.net == sysdata.pointnet &&
				textindex.crepoint != nodedata.node)
				filetext(nodedata.zone,
					nodedata.net,
					nodedata.node, "HUT", 0, textnr,
					addseenby, adds);
		}
		else
		{
/*	Om vi r POINT, s skall allt g till vr BOSS. */

			if (textindex.crenet == sysdata.net &&
				textindex.crenode == sysdata.node &&
				textindex.crepoint == sysdata.point &&
				(textindex.type & 1) == 1)
				filetext(sysdata.zone,
					sysdata.net,
					sysdata.node, "CUT", 0, textnr,
					addseenby, adds);
		}
	}
}

void	extractecho()
{
	int		i, z, mem, moetold, j, n;
	char		*addseenby;
	areastruct	*addrec;

	i=0;
	mem=moetnumber;
	moetold=0;

	addseenby=calloc(1024, sizeof(areastruct));

	if (addseenby == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	while (getareainf(i) >= 0)
	{
		moetnumber=nodedata.meet;

/*	Lagra nya SEEN-BY data i "addseenby"-arean fr att vi skall
	kunna lgga till dem p SEEN-BY rader till texten. */

		if (moetnumber != (unsigned int)moetold)
		{
			j=0;
			n=0;
			moetold=moetnumber;

			while(getareainf(j) >= 0)
			{
				if (nodedata.meet == (unsigned int)moetold &&
					nodedata.net != sysdata.pointnet)
				{
					addrec=(areastruct *)
						(addseenby+
						sizeof(areastruct)*n);

					addrec->zone=nodedata.zone;
					addrec->net=nodedata.net;
					addrec->node=nodedata.node;
					n++;
				}
				j++;
			}
			printf("--------\n");
		}

		z=getareainf(i);

		z=getmaxtext(nodedata.meet);

		printf("%d:%d/%d (%s) %s\n",
			nodedata.zone, nodedata.net, nodedata.node,
			meetinf.echoarea, meetinf.namn);

		textextract(moetnumber, addseenby, n);

		putareainf(i);
		i++;
	}
	moetnumber=mem;
	free(addseenby);
}

int	loadtexts(f, moeten, textarea, g1)
FILE	*f, *g1;
int	moeten;
char	*textarea;
{
	long int	startpos, reid, textnr, position;
	int		j, k, c, i, z, textnumber, userno, column, moetnr,
			msgcharset, rp, tempnet, tempnode, topoint, frompoint,
			texttype, topt, intlzone, intlnet, intlnode, zz[1],
			col0, baderror;
	unsigned char	tmp[85], touser[40], fromuser[40], subject[80],
			area[80], touser2[40], msgid[40], reply[40],
			tid[80], *inbuff, tclinfo[40], origin[160],
			tclinfo2[40], slask[160], firstarea[80],
			filnamn[40], tmp2[80];
	FILE		*f1;

	msgcharset=0;

	if (packmsg.idcode != 0x0002)
	{
		printf("Idcode : %d\n", packmsg.idcode);
		sprintf(fotxt, BADTYPE);
		fpr(fotxt);
		newline();
		logg(fotxt, 1);
		return(1);
	}

	sprintf(fotxt, TEXTINFORM, packmsg.orignet, packmsg.orignode);
	fpr(fotxt);

	if (packmsg.orignode == sysdata.node &&
		packmsg.orignet == sysdata.net &&
		sysdata.pointnet == 0)
	{
		sprintf(fotxt, ONTHISNODE);
		fpr(fotxt);
		newline();
		logg(fotxt, 2);
		i=0;
		c=1;

		while(i < 5)
		{
			c=fgetc(f);
			if (c == 0) i++;
		}
		return(0);
	}

/*	Brja ls in en text. */

/*	Nollstll textursprung. */

/*	Om vi inte kan ta reda p ursprungszon, s frutstter vi den
	lokala zonen. */

	textindex.crezone=sysdata.zone;
	textindex.crenet=0;
	textindex.crenode=0;
	textindex.crepoint=0;

/*	Datum. */

	i=0;

	while((c=fgetc(f)) > 0)
	{
		*(tid+i)=(unsigned char) c;
		i++;
		*(tid+i)=0;
	}

/*	Till anvndare: */

	i=0;
	while((c=fgetc(f)) > 0)
	{
		if (c == '@') c=0;

		c=(int)transchar((unsigned char) c,
			msgcharset, BASECHARSET);

		if (c == (int)'_') c=(int)' ';

		*(touser+i)=(unsigned char)c;
		i++;
		*(touser+i)=0;
	}

	i--;
	while(*(touser+i)==' ')
	{
		*(touser+i)=0;
		i--;
	}


/*	Frn anvndare: */

	i=0;
	while((c=fgetc(f)) > 0)
	{
		*(fromuser+i)=transchar((unsigned char) c,
			msgcharset, BASECHARSET);

		i++;
		*(fromuser+i)=0;
	}

/*	rende: */

	i=0;
	while((c=fgetc(f)) > 0)
	{
		*(subject+i)=transchar((unsigned char) c,
			msgcharset, BASECHARSET);

		i++;
		*(subject+i)=0;
	}

/*	Undersk texten, och placera den.
	Om det r en personlig text skall AREA: inte finnas, s d
	fortstter vi bara.
	Annars mste AREA: finnas fr att vi skall ta
	emot texten. Dessutom mste AREA: vara registrerad. */

	baderror=0;

	if ((packmsg.attribute & 1) == 1)
	{

/*		Brev. */

		moetnumber=1;
		textnumber=getmaxtext(1);
		z=gettextindex(moetnumber, textnumber);
		textnumber++;

	}
	else
	{

/*		Mtesinlgg - AREA: mste finnas. */

		i=0;
		c=fgetc(f);
		strcpy(firstarea, "");
		while(c != 0 && c != 13 && c != EOF)
		{
			*(area+i)=(unsigned char)c;
			i++;
			c=fgetc(f);
		}
		*(area+i)=0;

		if (subcompstr("AREA:", area) != 0)
		{
			sprintf(fotxt, MISSINGAREA);
			fpr(fotxt);
			newline();
			logg(fotxt, 1);

			if (c == EOF && feof(f))
			{
				return(0);
			}

			strcpy(area, "AREA:BAD_MESSAGES");
			baderror=1;
		}

		k=5;
		while(*(area+k) == ' ') k++;

		strcpy(fotxt, (area+k));
		strcpy(area, fotxt);

		i=2;
		moetnumber=i;
		textnumber=getmaxtext(i);

		while (i<moeten &&
			(strcmp(meetinf.echoarea, area) != 0 ||
			*meetinf.typ != 'E' &&
			*meetinf.typ != 'R'))
		{
			i++;
			moetnumber=i;
			textnumber=getmaxtext(i);
		}

		if (i >= moeten &&
			(strcmp(meetinf.echoarea, area) != 0 ||
			*meetinf.typ != 'E' &&
			*meetinf.typ != 'R'))
		{
			sprintf(fotxt, ILLEGALAREA, area);
			fpr(fotxt);
			newline();
			logg(fotxt, 1);

			strcpy(firstarea, area);
			strcpy(area, "BAD_MESSAGES");
			baderror=(baderror | 2);

			i=2;
			moetnumber=i;
			textnumber=getmaxtext(i);

			while (i<moeten &&
				(strcmp(meetinf.echoarea, area) != 0 ||
				*meetinf.typ != 'E' &&
				*meetinf.typ != 'R'))
			{
				i++;
				moetnumber=i;
				textnumber=getmaxtext(i);
			}

			if (i >= moeten &&
				(strcmp(meetinf.echoarea, area) != 0 ||
				*meetinf.typ != 'E' &&
				*meetinf.typ != 'R'))
			{
				while(fgetc(f) > 0);
				return(0);
			}
		}

		z=gettextindex(moetnumber, textnumber);
		textnumber++;
	}

	startpos=sistatextpos;

	msgcharset=(unsigned int)meetinf.defcharset;

/*	Brja med att lsa in texten som den r... */

	k=0;
#ifdef MSDOS
	inbuff=halloc((unsigned long int)MAXLINES *
		(unsigned long int)LINELENGTH, sizeof(char));
#else
	inbuff=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

	if (inbuff == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	while((c=fgetc(f)) > 0)
	{
		*(inbuff + k++)=(char)c;
	}
	*(inbuff + k)=0;

/*	Nollstll variablerna! */

	k=0;
	topoint=0;
	topt=0;
	frompoint=0;
	texttype=0;
	intlzone=sysdata.zone;
	intlnet=0;
	intlnode=0;
	strcpy(msgid, "");
	strcpy(reply, "");
	strcpy(tmp, "");
	strcpy(tclinfo, "");
	strcpy(tclinfo2, "");
	strcpy(origin, ""); /* Denna r bara ifall det skulle saknas en
				ORIGIN-rad av ngon anledning. */

	col0=-1;

	while((c=(unsigned int)*(inbuff + k++)) != 0)
	{
		if (c == 0x0D)
		{
			if (subcompstr("\n * Origin: ", (inbuff+k)) == 0)
			{
				j=k+11;
				i=0;
				while(*(inbuff+j) == 32) j++;

				while(*(inbuff+j) >= 32 && i < 158)
				{
					if (*(inbuff + j) < 127)
						*(origin + i++)=*(inbuff + j);
					j++;
				}

				*(origin + i)=0;

				k=j;
			}

			if (subcompstr(" * Origin: ", (inbuff+k)) == 0)
			{
				j=k+10;
				i=0;
				while(*(inbuff+j) == 32) j++;

				while(*(inbuff+j) >= 32 && i < 158)
				{
					if (*(inbuff + j) < 127)
						*(origin + i++)=*(inbuff + j);
					j++;
				}

				*(origin + i)=0;

				k=j;
			}
			col0=-1;
		}


/*	Kolla bara CTRL+A i frsta kolumnen, i andra kolumner r det fel. */

		if (c == 1 && col0 == -1)
		{
			if (subcompstr("MSGID:", (inbuff+k)) == 0)
			{
				j=k+6;
				i=0;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(msgid + i++)=*(inbuff + j);
					j++;
				}
				*(msgid + i)=0;
				k=j;
			}

			if (subcompstr("REPLY:", (inbuff+k)) == 0)
			{
				j=k+6;
				i=0;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(reply + i++)=*(inbuff + j);
					j++;
				}
				*(reply + i)=0;
				k=j;
			}

			if (subcompstr("EID:", (inbuff+k)) == 0)
			{
				j=k+4;
				i=0;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(tmp + i++)=*(inbuff + j);
					j++;
				}
				*(tmp + i)=0;
			}

			if (subcompstr("PATH:", (inbuff+k)) == 0)
			{
				j=k+5;
				i=0;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 80)
				{
					if (*(inbuff + j) < 127)
						*(tmp + i++)=*(inbuff + j);
					j++;
				}
				*(tmp + i)=0;
			}

			if (subcompstr("TCL1:", (inbuff+k)) == 0)
			{
				j=k+5;
				i=0;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(tclinfo + i++)=*(inbuff + j);
					j++;
				}
				*(tclinfo + i)=0;
			}

			if (subcompstr("TCL2:", (inbuff+k)) == 0)
			{
				j=k+5;
				i=0;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(tclinfo2 + i++)=
							*(inbuff + j);
					j++;
				}
				*(tclinfo2 + i)=0;
			}

			if (subcompstr("TOPT", (inbuff+k)) == 0)
			{
				j=k+4;
				i=0;
				if (*(inbuff+j) == ':') j++;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(tmp + i++)=
							*(inbuff + j);
					j++;
				}
				*(tmp + i)=0;
				topoint=atoi(tmp);
				topt=-1;
			}

			if (subcompstr("FMPT", (inbuff+k)) == 0)
			{
				j=k+4;
				i=0;
				if (*(inbuff+j) == ':') j++;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(tmp + i++)=
							*(inbuff + j);
					j++;
				}
				*(tmp + i)=0;
				frompoint=atoi(tmp);
			}

			if (subcompstr("INTL", (inbuff+k)) == 0)
			{
				j=k+4;
				i=0;
				if (*(inbuff+j) == ':') j++;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(tmp + i++)=
							*(inbuff + j);
					j++;
				}
				*(tmp + i)=0;

				if (sscanf(tmp, "%d:%d/%d %d:%d/%d",
				     (int *)zz, (int *)zz,
				     (int *)zz, (int *)&intlzone,
				     (int *)&intlnet, (int *)&intlnode) != 6)
				{
					intlzone=sysdata.zone;
					intlnet=0;
					intlnode=0;
				}
			}

			if (subcompstr("AUR:", (inbuff+k)) == 0)
			{
				j=k+4;
				i=0;
				while(*(inbuff+j) == 32) j++;
				while(*(inbuff+j) >= 32 && i < 38)
				{
					if (*(inbuff + j) < 127)
						*(tmp + i++)=*(inbuff + j);
					j++;
				}
				*(tmp + i)=0;
				if (sscanf(tmp, "%x", &texttype) != 1)
					texttype=0;
			}
		}

/*	Vi r inte i kolumn noll lngre. */
		if (c != 0x0d && c!= 0x0a) col0=0;
	}

/*	BRJA MED KOMMENTARSLNKNINGEN!
	=============================== */

/*	Kolla om vi hittar texten som den hr texten r kommentar till.
	Ta ven reda p vilket nodnummer som r skyldig till fregende
	text, s att vi direkt ser om vi skall titta i vr anvndarlista
	efter mottagarnamnet. */

	if (getnodeinfo(reply) == 0)
	{
		tempnet=nodecode.net;
		tempnode=nodecode.node;
	}
	else
	{
		tempnet=-1;
		tempnode=-1;
	}

	if (tempnet == -1 || tempnode == -1)
	{
		if (sscanf(tclinfo2, "%04x%04x%16s",
			&tempnet, &tempnode, tmp) != 3)
		{
			tempnet=-1;
			tempnode=-1;
		}
	}

	moetnr=0;
	textnr=0;

/*	Om texten kommenterar en text frn vr egen nod s
	processar vi det hr.
	Vi kan nmligen utlsa av serienumret i REPLY-identiteten
	vilken text som kommenterats. */

	if (tempnet == (int)sysdata.net && tempnode == (int)sysdata.node)
	{
		if (strcmp(reply, "") != 0)
		{
			i=0;
			while(*(reply + i) != ' ' && *(reply + i) > 0) i++;
			while(*(reply + i) == ' ') i++;
			if (sscanf((reply + i), "%02x%06X",
				&moetnr, &textnr) != 2)
			{
				moetnr=0;
				textnr=0;
			}
		}

		if (strcmp(tclinfo2, "") !=0 && (moetnr == 0 || textnr == 0))
		{
			if (sscanf(tclinfo2, "%8s%02x%06X",
				tmp, &moetnr, &textnr) != 3)
			{
				moetnr=0;
				textnr=0;
			}
		}
	}

	reid=0L;
	rp=1;

	if (textnr-meetinf.firsttext > 0L &&
		tempnet == (int)sysdata.net && tempnode == (int)sysdata.node
		&& moetnumber == (unsigned int)moetnr)
	{
		rp=(int)(textnr-meetinf.firsttext);
		z=gettextindex(moetnumber, rp);
		reid=rp+meetinf.firsttext;
		i=0;
		while(textindex.commlist[i] != 0L && i < 79) i++;
		textindex.commlist[i]=textnumber + meetinf.firsttext;
		puttextindex(rp);
	}

/*	Om texten inte var en kommentar till en text skapad p vr
	nod, s fr vi ska lnken sekventiellt.
	Lngsam metod! */

	sprintf(filnamn, "M%d.IDX", moetnumber);

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, filnamn);

#ifdef MSDOS
	if ((f1=fopen(fotxt, "rb+")) == NULL)
#else
	if ((f1=fopen(fotxt, "r+")) == NULL)
#endif
	{
		sprintf(tmp, GETIDXERR1, moetnr);
		perror(tmp);
		logg(tmp, 0);
		exit(9);
	}

	fseek(f1, sizeof(textindexstruct), SEEK_SET);

	while(rp <= (int)meetinf.texts &&
		(strcmp(reply, "") != 0 || strcmp(tclinfo2, "") != 0) &&
		reid == 0L)
	{
		position=ftell(f1);

		if (fread((char *) &textindex,
			(unsigned int) sizeof(textindexstruct), 1, f1) == 0)
		{
			sprintf(tmp2, GETIDXERR3, moetnr);
			perror(tmp2);
			logg(tmp2, 0);
			fclose(f1);
			exit(9);
		}

/*		Titta efter MSGID-rad. */

		if (strcmp(textindex.msgid, reply) == 0 &&
			reid == 0L && strcmp(reply, "") != 0)
		{
			reid=rp+meetinf.firsttext;
			i=0;
			while(textindex.commlist[i] != 0L && i < 79) i++;
			textindex.commlist[i]=textnumber + meetinf.firsttext;
			fseek(f1, position, SEEK_SET);
			if (fwrite((char *) &textindex,
				(unsigned int) sizeof(textindexstruct),
				1, f1) == 0)
			{
				sprintf(tmp2, "Cant write in %d", moetnr);
				perror(tmp2);
				logg(tmp2, 0);
				fclose(f1);
				exit(9);
			}
		}

/*		Titta efter TCL-rad. */

		if (strcmp(textindex.tclinfo, tclinfo2) == 0 &&
			reid == 0L && strcmp(tclinfo2, "") != 0)
		{
			reid=rp+meetinf.firsttext;
			i=0;
			while(textindex.commlist[i] != 0L && i < 79) i++;
			textindex.commlist[i]=textnumber + meetinf.firsttext;
			fseek(f1, position, SEEK_SET);
			if (fwrite((char *) &textindex,
				(unsigned int) sizeof(textindexstruct),
				1, f1) == 0)
			{
				sprintf(tmp2, "Cant write in %d", moetnr);
				perror(tmp2);
				logg(tmp2, 0);
				fclose(f1);
				exit(9);
			}
		}
		rp++;
	}

	fclose(f1);

/*	SLUT P KOMMENTARSLNKNINGEN!
	============================= */


/*	BRJA MED ADRESSTOLKNINGEN!
	=========================== */

/*	Om vi inte kan ta reda p ursprungszon, s frutstter vi den
	lokala zonen. */

	textindex.crezone=sysdata.zone;
	textindex.crenet=0;
	textindex.crenode=0;
	textindex.crepoint=frompoint;

/*	Kolla MSGID-rad. */

	if (getnodeinfo(msgid) == 0)
	{
		textindex.crezone=nodecode.zone;
		textindex.crenet=nodecode.net;
		textindex.crenode=nodecode.node;
		if (textindex.crepoint == 0)
			textindex.crepoint=nodecode.point;
	}

/*	Kolla TCL-rad, om ngon anvnder denna fortfarande!
	TCL-raderna har faktiskt bttre adressering n MSGID-raderna
	i FIDONET. */

	if (sscanf(tclinfo, "%04x%04x%12s%02x%02x",
		&nodecode.net, &nodecode.node,
		tmp, &nodecode.point, &nodecode.zone) == 5)
	{
		textindex.crezone=nodecode.zone;
		textindex.crenet=nodecode.net;
		textindex.crenode=nodecode.node;
		textindex.crepoint=nodecode.point;
	}

/*	Ntbrev fr sina adresser hr!
	INTL-kludgen gr fre informationen i meddelandehuvudet, eftersom
	INTL-kludgens information r mera korrekt!
	Point-nummer fr fi frn FMPT-informationen, och slunda fr vi
	en korrekt adress! */

	if ((packmsg.attribute & 1) == 1)
	{
		textindex.crezone=intlzone;
		textindex.crepoint=frompoint;

		if (intlnet != 0 && intlnode != 0)
		{
			textindex.crenet=intlnet;
			textindex.crenode=intlnode;
		}
		else
		{
			textindex.crenet=packmsg.orignet;
			textindex.crenode=packmsg.orignode;
		}
	}


/*	Hr lser vi av Origin-raden, och lter den f hgst prioritet,
	eftersom den enligt vissa teorier gller! Dock gller den
	ej till 100% eftersom personliga kommentarer till texter som
	passerat en gateway ej blir riktigt adresserade!
	Problemet r dock generellt! */

	if ((packmsg.attribute & 1) == 0)
	{
		if (parseorigin(origin, &nodecode.zone, &nodecode.net,
			&nodecode.node, &nodecode.point) == 1)
		{
			textindex.crezone=nodecode.zone;
			textindex.crenet=nodecode.net;
			textindex.crenode=nodecode.node;
			if (textindex.crepoint == 0)
				    textindex.crepoint=nodecode.point;
		}
	}

/*	SLUT P ADRESSTOLKNINGEN
	======================== */

/*	Leta efter namnet p personen som eventuellt skall f ett brev, eller
	ett svar p en kommentar. */

	userno=atoi(touser);

	strcpy(touser2, touser); /* Att spara om det blev fel... */

	z=nameconv(fotxt, touser);

	if (strcmp(fotxt, "Sysop") == 0
		&& (packmsg.destnet==sysdata.net
		&& packmsg.destnode==sysdata.node
		&& moetnumber == 1 ||
		(unsigned int) tempnet == sysdata.net &&
		(unsigned int) tempnode == sysdata.node))
	{
		userno=1;
	}

	if (z < 2 && userno == 0)
	{
		strcpy(fotxt, "");
		userno=-1;
	}

	strcpy(touser, fotxt);

/*	Om texten r adresserad till den hr noden, s tar vi
	fram nummer p anvndaren som skall f texten. I annat
	fall redovisar vi bara namnet p den mottagande personen. */

	if (userno == 0 &&
		(packmsg.destnet==sysdata.net &&
		packmsg.destnode==sysdata.node &&
		moetnumber == 1 ||
		(unsigned int) tempnet == sysdata.net &&
		(unsigned int) tempnode == sysdata.node))
	{
		userno=userfind(touser);

		if ((packmsg.attribute & 1) == 1 && userno <= 0) userno=-2;
	}

	if (userno > 0)
	{
		z=getuserinfo(userno);
		strcpy(touser, user2.username);

		if ((user2.status & POINT) != 0)
		{
			topoint=userno;
		}
	}

	if (userno == 0 && moetnumber == 1) userno=-2;

/*	Just for your information. Not necessary... */

	printf("Timestamp : %s\n", tid);
	printf("MSGID     : %s\n", msgid);
	printf(TEXTINFOHEAD8, fromuser, textindex.crezone, textindex.crenet,
		textindex.crenode, textindex.crepoint,
		touser, userno, subject);

	textindex.kommptr=reid;

	textindex.cretime=ftimetol(tid);

/*	Se till att vi sparar data som talar om vilken text vi kommenterar. */

	strcpy(textindex.msgid, msgid);
	strcpy(textindex.tclinfo, tclinfo);

	tidkonv((long int *)&textindex.cretime, fotxt);

	sprintf(textarea, TEXTHEAD1,
		textnumber + meetinf.firsttext,
		meetinf.namn, fotxt);

	i=0;
	while(*(textarea + i) !=0) i++;

	if (reid > 0L) sprintf((textarea + i), KOMMHEAD, reid);

	i=0;
	while(*(textarea + i) !=0) i++;

/*	Texten har avsndare och mottagare som ej har namn p denna nod. */

	if ((userno == 0 || userno == -2) && textindex.crepoint == 0)
		sprintf((textarea+i), TEXTINFOHEAD6,
			fromuser, textindex.crezone, textindex.crenet,
			textindex.crenode, touser, subject);

	if ((userno == 0 || userno == -2) && textindex.crepoint != 0)
		sprintf((textarea+i), TEXTINFOHEAD9,
			fromuser, textindex.crezone, textindex.crenet,
			textindex.crenode, textindex.crepoint, touser, subject);

/*	Texten har enbart avsndare. */

	if (userno == -1 && textindex.crepoint == 0)
	{
		sprintf((textarea+i), TEXTINFOHEAD4,
			fromuser, textindex.crezone, textindex.crenet,
			textindex.crenode, subject);

		userno=0;
		if (moetnumber == 1) userno=1;
	}

	if (userno == -1 && textindex.crepoint != 0)
	{
		sprintf((textarea+i), TEXTINFOHEAD7,
			fromuser, textindex.crezone, textindex.crenet,
			textindex.crenode, textindex.crepoint, subject);
		userno=0;
		if (moetnumber == 1) userno=1;
	}

/*	Texten har avsndare, och en mottagare som har namn p denna nod. */

	if (userno > 0 && textindex.crepoint == 0)
	{
		getuserinfo(userno);
		sprintf((textarea+i), TEXTINFOHEAD5,
			fromuser, textindex.crezone, textindex.crenet,
			textindex.crenode, touser,
			userno, subject);
	}

	if (userno > 0 && textindex.crepoint != 0)
	{
		getuserinfo(userno);
		sprintf((textarea+i), TEXTINFOHEAD8,
			fromuser, textindex.crezone, textindex.crenet,
			textindex.crenode, textindex.crepoint, touser,
			userno, subject);
	}

/*	Om det r en omlnkning av brev till en anvndare hr, och brevet inte
	hade en TOPT-kludge, s fr vi lgga p den! */

	if (topt == 0 && topoint != 0)
	{
		i=0;
		while(*(textarea + i) !=0) i++;

		sprintf((textarea+i), "\001TOPT: %d\r\n", topoint);
	}

	i=0;
	while(*(textarea + i) !=0) i++;

/*	Om det r ett brev som inte skall hit, eller har sitt ursprung
	hr, skall det returneras.
	D.v.s brevet r adresserat till fel nod. */

	if ((baderror & 1) == 1)
	{
		sprintf((textarea + i), "-----------------------------------------------------------------------\r");
		while(*(textarea + i) !=0) i++;
		sprintf((textarea + i), "%s\r", MISSINGAREA);
		while(*(textarea + i) !=0) i++;
		sprintf((textarea + i), "-----------------------------------------------------------------------\r\r");
		while(*(textarea + i) !=0) i++;
	}

	if ((baderror & 2) == 2)
	{
		sprintf((textarea + i), "-----------------------------------------------------------------------\r");
		while(*(textarea + i) !=0) i++;
		sprintf((textarea + i), "%s  AREA:%s\r",
			NOAREA, firstarea);
		while(*(textarea + i) !=0) i++;
		sprintf((textarea + i), "-----------------------------------------------------------------------\r\r");
		while(*(textarea + i) !=0) i++;
	}

/*	Om det kommit hit ett brev som var adresserat till en annan nod
	skall vi returnera det.
	Det kan kanske vara bra att konfigurera, eftersom man ibland vill
	kunna vidarebefordra brev frn andra noder nd. */

	if ((packmsg.attribute & 1) == 1 &&
		(packmsg.destnode != sysdata.node ||
		packmsg.destnet != sysdata.net) &&
		(packmsg.orignet != sysdata.net ||
		packmsg.orignode != sysdata.node))
	{
		sprintf(fotxt, BADDEST,
			packmsg.destnet, packmsg.destnode, touser2);

		strcpy((textarea+i), fotxt);

		userno=1;
		getuserinfo(userno);

		if (textindex.crenet > 0 && textindex.crenode > 0)
		{
			packmsg.destnet=textindex.crenet;
			packmsg.destnode=textindex.crenode;
		}
		else
		{
			packmsg.destnet=packmsg.orignet;
			packmsg.destnode=packmsg.orignode;
		}

		packmsg.orignet=sysdata.net;
		packmsg.orignode=sysdata.node;
		strcpy(touser, fromuser);

		i=0;
		while(*(textarea + i) !=0) i++;

		sprintf(fotxt, BADDEST2,
			sysdata.zone, sysdata.net,
			sysdata.node, "");

		strcpy((textarea+i), fotxt);

		i=0;
		while(*(textarea + i) !=0) i++;
	}

/*	Om det r ett brev som r adresserat hit, men anvndaren r oknd
	skall vi returnera det. (Kan i och fr sig bero p fel zon.) */

	if ((packmsg.attribute & 1) == 1 &&
		userno == -2 &&
		packmsg.orignet == sysdata.net &&
		packmsg.orignode == sysdata.node)
	{
		sprintf(fotxt, BADDESTUSR,
			packmsg.destnet, packmsg.destnode, touser2);

		strcpy((textarea+i), fotxt);

		userno=1;
		z=getuserinfo(userno);

		if (textindex.crenet > 0 && textindex.crenode > 0)
		{
			packmsg.destnet=textindex.crenet;
			packmsg.destnode=textindex.crenode;
		}
		else
		{
			packmsg.destnet=packmsg.orignet;
			packmsg.destnode=packmsg.orignode;
		}

		packmsg.orignet=sysdata.net;
		packmsg.orignode=sysdata.node;
		strcpy(touser, fromuser);

		i=0;
		while(*(textarea + i) !=0) i++;

		sprintf(fotxt, BADDEST2,
			sysdata.zone, sysdata.net,
			sysdata.node, "");

		strcpy((textarea+i), fotxt);

		i=0;
		while(*(textarea + i) !=0) i++;
	}

/*	Kolla i filen LOCK.CFG om det finns ngon nod som alla brev skall
	returneras till. Bra om man fr en hel hg med ovidkommande brev
	frn en nod. Strmmen upphr nrmast omgende! */

	if ((packmsg.attribute & 1) == 1 && g1 != NULL)
	{
		fseek(g1, 0L, SEEK_SET);

		nodecode.zone=0;
		nodecode.net=0;
		nodecode.node=0;

		while(textindex.crenet != nodecode.net &&
			textindex.crenode != nodecode.node &&
			fgets(slask, 155, g1) != NULL) getnodeinfo(slask);

		if (textindex.crenet == nodecode.net &&
			textindex.crenode == nodecode.node)
		{
			sprintf(fotxt, BADORIGIN,
				textindex.crenet, textindex.crenode);

			strcpy((textarea+i), fotxt);

			z=getuserinfo(userno);

			if (textindex.crenet > 0 && textindex.crenode > 0)
			{
				packmsg.destnet=textindex.crenet;
				packmsg.destnode=textindex.crenode;
			}
			else
			{
				packmsg.destnet=packmsg.orignet;
				packmsg.destnode=packmsg.orignode;
			}

			packmsg.orignet=sysdata.net;
			packmsg.orignode=sysdata.node;
			strcpy(touser, fromuser);

			i=0;
			while(*(textarea + i) !=0) i++;

			sprintf(fotxt, BADDEST2,
				sysdata.zone, sysdata.net,
				sysdata.node, "");

			strcpy((textarea+i), fotxt);

			k=0;
			while((unsigned int)*(inbuff + k) != 0)
			{
				if ((unsigned int)*(inbuff + k) == 1)
				{
					if (subcompstr("\001MSGID",
					   (inbuff + k)) == 0)
					   (unsigned int) *(inbuff + k + 1)='X';

					if (subcompstr("\001REPLY",
					   (inbuff + k)) == 0)
					   (unsigned int)*(inbuff + k + 1)='X';
				}
				k++;
			}
		}

		i=0;
		while(*(textarea + i) !=0) i++;
	}

/*	Kontrollera om avsndande nod verkligen finns! */

	nodecode.zone=textindex.crezone;
	nodecode.net=textindex.crenet;
	nodecode.node=textindex.crenode;

	if (getnode() != 0 && moetnumber == 1)
	{

		sprintf(fotxt, BADORIGIN,
			textindex.crenet, textindex.crenode, touser2);

		strcpy((textarea+i), fotxt);

		z=getuserinfo(userno);

		if (textindex.crenet > 0 && textindex.crenode > 0)
		{
			packmsg.destnet=textindex.crenet;
			packmsg.destnode=textindex.crenode;
		}
		else
		{
			packmsg.destnet=packmsg.orignet;
			packmsg.destnode=packmsg.orignode;
		}

		packmsg.orignet=sysdata.net;
		packmsg.orignode=sysdata.node;
		strcpy(touser, fromuser);

		i=0;
		while(*(textarea + i) !=0) i++;

		sprintf(fotxt, BADDEST2,
			sysdata.zone, sysdata.net,
			sysdata.node, "");

		strcpy((textarea+i), fotxt);

		i=0;
		while(*(textarea + i) !=0) i++;
	}

	column=0;

	k=0;

	while((c=(unsigned int)*(inbuff + k++)) != 0)
	{
/*	Nr vi lagrar texten fr Soft CR flja med, men jag vet inte
	vad jag skall gra med den <nnu>. Den skall dock med
	fr att texterna inte skall vara frndrade. */

/*		if (c == 0x8D) c=0x0A; /* Soft CR i ntet - maskas. */

		if (c == 1)
		{
			if (subcompstr("CHARSET:", (inbuff+k)) == 0)
			{
				k=k+8;
				while(*(inbuff+k) == ':' ||
					*(inbuff+k) == ' ') k++;

				j=0;
				while(*(inbuff+k) != '\r' &&
					*(inbuff+k) != 0)
				{
					*(tmp+j)=*(inbuff+k);
					k++;
					j++;
				}
				*(tmp+j)=0;

				k++;
				c=(unsigned int)*(inbuff + k++);

				if (subcompstr("ISO-11", tmp) == 0)
					msgcharset=0;

				if (subcompstr("SWEDISH", tmp) == 0)
					msgcharset=0;

				if (subcompstr("CP437", tmp) == 0)
					msgcharset=1;

				if (subcompstr("IBM", tmp) == 0)
					msgcharset=1;

				if (subcompstr("PC-8", tmp) == 0)
					msgcharset=1;

				if (subcompstr("ISO 8859-1", tmp) == 0)
					msgcharset=2;

				if (subcompstr("ISO8859-1", tmp) == 0)
					msgcharset=2;

				if (subcompstr("ISO Latin", tmp) == 0)
					msgcharset=2;

				if (subcompstr("Latin", tmp) == 0)
					msgcharset=2;

				if (subcompstr("ISO-6", tmp) == 0)
					msgcharset=2;

				if (subcompstr("AMIGA", tmp) == 0)
					msgcharset=2;

				if (subcompstr("MAC", tmp) == 0)
					msgcharset=3;

				if (subcompstr("FRENCH", tmp) == 0)
					msgcharset=4;

				if (subcompstr("ISO-69", tmp) == 0)
					msgcharset=4;

				if (subcompstr("GERMAN", tmp) == 0)
					msgcharset=5;

				if (subcompstr("ISO-21", tmp) == 0)
					msgcharset=5;

				if (subcompstr("BRITISH", tmp) == 0)
					msgcharset=6;

				if (subcompstr("DANISH", tmp) == 0)
					msgcharset=7;

				if (subcompstr("ITALIAN", tmp) == 0)
					msgcharset=8;

				if (subcompstr("SPANISH", tmp) == 0)
					msgcharset=9;

				if (subcompstr("JAPANESE", tmp) == 0)
					msgcharset=10;
			}

			if (subcompstr("CHRS:", (inbuff+k)) == 0)
			{
				k=k+5;
				while(*(inbuff+k) == ':' ||
					*(inbuff+k) == ' ') k++;

				j=0;
				while(*(inbuff+k) != '\r' &&
					*(inbuff+k) != 0)
				{
					*(tmp+j)=*(inbuff+k);
					k++;
					j++;
				}
				*(tmp+j)=0;

				k++;
				c=(unsigned int)*(inbuff + k++);

				if (subcompstr("ISO-11", tmp) == 0)
					msgcharset=0;

				if (subcompstr("SWEDISH", tmp) == 0)
					msgcharset=0;

				if (subcompstr("CP437", tmp) == 0)
					msgcharset=1;

				if (subcompstr("IBM", tmp) == 0)
					msgcharset=1;

				if (subcompstr("PC-8", tmp) == 0)
					msgcharset=1;

				if (subcompstr("ISO 8859-1", tmp) == 0)
					msgcharset=2;

				if (subcompstr("ISO8859-1", tmp) == 0)
					msgcharset=2;

				if (subcompstr("ISO Latin-1", tmp) == 0)
					msgcharset=2;

				if (subcompstr("ISO Latin", tmp) == 0)
					msgcharset=2;

				if (subcompstr("Latin", tmp) == 0)
					msgcharset=2;

				if (subcompstr("ISO-6", tmp) == 0)
					msgcharset=2;

				if (subcompstr("AMIGA", tmp) == 0)
					msgcharset=2;

				if (subcompstr("MAC", tmp) == 0)
					msgcharset=3;

				if (subcompstr("FRENCH", tmp) == 0)
					msgcharset=4;

				if (subcompstr("ISO-69", tmp) == 0)
					msgcharset=4;

				if (subcompstr("GERMAN", tmp) == 0)
					msgcharset=5;

				if (subcompstr("ISO-21", tmp) == 0)
					msgcharset=5;

				if (subcompstr("BRITISH", tmp) == 0)
					msgcharset=6;

				if (subcompstr("DANISH", tmp) == 0)
					msgcharset=7;

				if (subcompstr("ITALIAN", tmp) == 0)
					msgcharset=8;

				if (subcompstr("SPANISH", tmp) == 0)
					msgcharset=9;

				if (subcompstr("JAPANESE", tmp) == 0)
					msgcharset=10;
			}
		}

		if (c >= 32 || c == 0x0D || c == 1)
		{
			*(textarea+i)=transchar((unsigned char)c,
				msgcharset, BASECHARSET);
			i++;
			*(textarea+i)=0;
			column++;

			if (c == 0x0D)
			{
				*(textarea + i)=0x0A;
				i++;
				*(textarea+i)=0;
				column=0;
			}
		}
	}

/*	Maska bort ngra radmatningar. */

	i=i-2;

	*(textarea + i)=0;

/*	Spara alla vsentliga data. */

	textindex.startpos=startpos;
	textindex.len=i;
	textindex.fromnode=packmsg.orignode;
	textindex.fromnet=packmsg.orignet;
	textindex.destzone=sysdata.zone;
	textindex.destnet=packmsg.destnet;
	textindex.destnode=packmsg.destnode;
	textindex.destpoint=topoint;
	textindex.creator=0;
	textindex.kommusr=userno;

	for (i=0;i<79;i++) textindex.commlist[i]=0L;

	strcpy(textindex.subject, subject);
	strcpy(textindex.creuser, fromuser);
	strcpy(textindex.touser, touser);

	if (texttype != 0)
	{
		textindex.type=texttype;
	}
	else
	{
		if ((packmsg.attribute & 1) == 1)
		{
			textindex.type=13;
		}
		else
		{
			textindex.type=1;
		}
	}

	storetext(textarea);
	z=puttextindex(textnumber);
	putmaxtext(moetnumber, textnumber);

#ifdef MSDOS
	hfree(inbuff);
#else
	free(inbuff);
#endif

	return(0);
}

void	loadfile(filnamn)
char	*filnamn;
{
	FILE	*f, *g1;
	char	tmp[80], *textarea, tmp1[80];
	int	moeten, i, z;

	env=getenv("ADATA");
	strcpy(tmp1, env);
	strcat(tmp1, "LOCK.CFG");

#ifdef MSDOS
	g1=fopen(tmp1, "rt");
#else
	g1=fopen(tmp1, "r");
#endif


	moeten=getmoeten();

	sprintf(tmp, "%s%s", inmail, filnamn);

#ifdef MSDOS
	if ((f=fopen(tmp, "rb")) == NULL)
#else
	if ((f=fopen(tmp, "r")) == NULL)
#endif
	{
		sprintf(fotxt, SHOWFERR, tmp);
		perror(fotxt);
		if (g1 != NULL) fclose(g1);
		return;
	}

	fseek(f, 0L, SEEK_SET);

	if (fread((char *) &packhd, sizeof(packheader), 1, f) != 0)
	{
		sprintf(fotxt, ORIGINFORM, packhd.orignet, packhd.orignode);

		if (packhd.zorigzone != 0)
		{
			sprintf(fotxt, ORIGINFORM2,
				packhd.zorigzone, packhd.orignet,
				packhd.orignode);
		}

		if (packhd.origzone != 0 && packhd.origpoint == 0)
		{
			sprintf(fotxt, ORIGINFORM2,
				packhd.origzone, packhd.orignet,
				packhd.orignode);
		}

		if (packhd.origzone != 0 && packhd.origpoint != 0)
		{
			sprintf(fotxt, ORIGINFORM3,
				packhd.origzone, packhd.orignet,
				packhd.orignode, packhd.origpoint);
		}

		fpr(fotxt);

		if (packhd.orignode == sysdata.node &&
			packhd.orignet == sysdata.net &&
			packhd.zorigzone == 0 &&
			packhd.origzone == 0)
		{
			sprintf(fotxt, ONTHISNODE2,
				filnamn);
			fpr(fotxt);
			newline();
			logg(fotxt, 1);
		}

		if (packhd.orignode == sysdata.node &&
			packhd.orignet == sysdata.net &&
			(packhd.zorigzone == sysdata.zone ||
			packhd.origzone == sysdata.zone))
		{
			sprintf(fotxt, ONTHISNODE2,
				filnamn);
			fpr(fotxt);
			newline();
			logg(fotxt, 1);
		}

		if (packhd.idcode != 0x0002)
		{
			sprintf(fotxt, BADTYPE2, filnamn);
			fpr(fotxt);
			newline();
			logg(fotxt, 2);
			fclose(f);
			if (g1 != NULL) fclose(g1);
			return;
		}

		i=0;
		while((z=getareainf(i)) >= 0 &&
			packhd.orignet != nodedata.net &&
			packhd.orignode != nodedata.node) i++;

		if (z == -1)
		{
			fpr(UNKNOWNNODE);
			newline();
			logg(UNKNOWNNODE, 1);
		}

#ifdef MSDOS
		textarea=halloc((unsigned long int)MAXLINES *
			(unsigned long int)LINELENGTH, sizeof(char));
#else
		textarea=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

		if (textarea == NULL)
		{
			printf(ALLOCERROR);
			logg(ALLOCERROR, 0);
			exit(9);
		}

		z=0;
		while(fread((char *) &packmsg, sizeof(packmsg), 1, f) != 0
			&& z==0)
		{
			z=loadtexts(f, moeten, textarea, g1);
		}

#ifdef MSDOS
		hfree(textarea);
#else
		free(textarea);
#endif
	}
	fclose(f);
	if (g1 != NULL) fclose(g1);
}

void	packecho()
{
	char	tmp[160];
	int	i, n, z;

/*	Packa ECHO-mail mten. (Behll bara 50 texter,
	om det var mer n 50 texter i mtet frut. */

	i=1;
	n=getmoeten();

	while(i <= n)
	{
		z=getmaxtext(i);

		if ((unsigned int)meetinf.texts > sysdata.packlimit)
		{
			sprintf(tmp,"%d %s", sysdata.packlimit, meetinf.namn);
			sprintf(fotxt, "%d", sysdata.packlimit);
			packmeet(fotxt, tmp);
		}
		i++;
	}
}

void	loadecho()
{
	char	tmp[160], *sortarea;
	int	i, n, z, j;

/*	Ladda texter. */

#ifdef MSDOS
	sortarea=halloc(65535L, sizeof(char));
#else
	sortarea=calloc(65535L, sizeof(char));
#endif

	if (sortarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

/*	sprintf(fotxt, "ls -1 %s*.pkt > %s", inmail, tempfile);
	system(fotxt);
*/

	sprintf(tmp, "%s*.pkt", inmail);

#ifdef MSDOS
	n=dirlist(tmp, sortarea);
#endif
	
	for(j=0;j<n;j++)
	{
		i=0;
		z=0;

		strcpy(tmp, (sortarea + j*45));

		while(*(tmp + i) > ' ')
		{
/* 			Om det r ett bibliotek. */
			if (*tmp == ' ') z=1;
			i++;
		}

		*(tmp+i)=0;

		if (strlen(tmp) > 0 && z == 0)
		{
			sprintf(fotxt, LOADMAIL, tmp);
			fpr(fotxt);
			newline();
			loadfile(tmp);
		}
	}
#ifdef MSDOS
	hfree(sortarea);
#else
	free(sortarea);
#endif
}
