/* ROUTE.C Omdirigering av filer som r ldre */
/* (c) 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "privs.h"

#include "global.h"

#ifndef MSDOS
#include <unistd.h>
#endif

char	*weekday[8]={"SU","MO","TU","WE","TH","FR","SA",""};

/*	Den hr rutinen r anvndbar fr att analysera hur data skall
	omdirigeras till nya noder. Observera att enbart packade data
	kommer att omdirigeras. (d.v.s. kontrollfilerna.) */

int	nodeanalyze(zone, region, net, node)
int	zone, region, net, node;
{
	if (node != 0) return(1);

	if ((unsigned int)net == sysdata.net &&
		(unsigned int)zone == sysdata.zone) return(0);

	if ((unsigned int)region == sysdata.region &&
		(unsigned int)zone == sysdata.zone &&
		(unsigned int)net != sysdata.region) return(2);

	if ((unsigned int)region == sysdata.region &&
		(unsigned int)zone == sysdata.zone &&
		(unsigned int)net == sysdata.region) return(3);

	if ((unsigned int)net == sysdata.zone &&
		(unsigned int)zone == sysdata.zone) return(2);

	if (net == region && net != zone) return(4);

	if (net == zone) return(5);

	return(6);
}

void		reroute(file, zone, indirectory, extension)
char		*file, *indirectory, *extension;
unsigned int	zone;
{
	FILE		*g, *f1, *g1;
	unsigned int	net, node, action;
	char		tmp[80], slask[160], infil[80], utfil[80];

	if(sscanf(file, "%4x%4x", &net, &node) != 2)
	{
		sprintf(fotxt, ILLADDRNAM, file);
		logg(fotxt, 2);
		return;
	}

/*	Filer till vra POINTAR rr vi inte! */

	if (net == sysdata.pointnet)
	{
		sprintf(fotxt, SKIPPOINT);
		logg(fotxt, 4);
		return;
	}

	env=getenv("ADATA");
	strcpy(tmp, env);
	strcat(tmp, "NOROUTE.CFG");

#ifdef MSDOS
	if ((g=fopen(tmp, "rt")) != NULL)
#else
	if ((g=fopen(tmp, "r")) != NULL)
#endif
	{
		while(zone != nodecode.zone &&
			net != nodecode.net &&
			node != nodecode.node &&
			fgets(slask, 155, g) != NULL) getnodeinfo(slask);

		if (zone == nodecode.zone &&
			net == nodecode.net &&
			node == nodecode.node)
		{
			return;
		}

		fclose(g);
	}
	else
	{
		sprintf(fotxt, "Open error (%s)", tmp);
		perror(fotxt);
	}

	sprintf(fotxt, REROUTING, zone, net, node);
	logg(fotxt, 3);

	nodecode.zone=zone;
	nodecode.net=net;
	nodecode.node=node;

	if (getnode() != 0)
	{
		sprintf(fotxt, ROUTEERR, zone, net, node);
		logg(fotxt, 1);
		return;
	}

	sprintf(fotxt, ADDRCOMPARE,
		sysdata.zone, sysdata.region, sysdata.net, sysdata.node,
		nodes.zone, nodes.region, nodes.net, nodes.node);
	logg(fotxt, 3);

	action=nodeanalyze(nodes.zone, nodes.region, nodes.net, nodes.node);

	zone=nodes.zone;
	net=nodes.net;
	node=nodes.node;

	switch (action)
	{
		case 1: node=0; break;
		case 2: net=sysdata.region; break;
		case 3: net=sysdata.net; break;
		case 4: net=nodes.zone; break;
		case 5: node=nodes.zone;
			net=sysdata.zone;
			zone=sysdata.zone;
			break;
		case 6: net=nodes.region; break;
	}

	sprintf(infil, "%s\\%04x%04x.%s",
		indirectory, nodes.net, nodes.node, extension);

	if (zone == sysdata.zone)
	{
		sprintf(utfil, "%s%04x%04x.%s",
			outbound, net, node, extension);
	}
	else
	{
		sprintf(utfil, "%s\\%04x%04x.%s",
			indirectory, net, node, extension);
	}

	if (strcmp(infil, utfil) == 0)
	{
		printf(NOREDIR);
		logg(fotxt, 3);
		return;
	}

	if ((f1=fopen(infil, "rt")) == NULL)
	{
		sprintf(fotxt, "Error open %s for input", infil);
		perror(fotxt);
		return;
	}

	if ((g1=fopen(utfil, "at+")) == NULL)
	{
		sprintf(fotxt, "Error open %s for append", utfil);
		perror(fotxt);
		fclose(f1);
		return;
	}

	while(fgets(slask, 158, f1) != NULL)
	{
		fprintf(g1, "%s\n", slask);
	}

	fclose(g1);
	fclose(f1);
	unlink(infil);
}

void	checkfiles(indirectory, zone, extension)
char	*indirectory, *extension;
int	zone;
{
	struct FILEINFO 	dta[1];
	char			tmp[80], files[80];
	int			z, i;
	unsigned long int	n, klocka[1];

	i=0;

	sprintf(files, "%s\\*.%s", indirectory, extension);

	z=direntry(dta, files, i);

	while (z == 0)
	{
		if ((dta->attr & 16) == 0)
		{
			strcpy(tmp, dta->name);
			n=dtimetol(dta->time, dta->date);
			time(klocka);

			if ((klocka[0]-n)>
				((unsigned long int)sysdata.routeage * 3600L))
			{
				reroute(tmp, zone, indirectory, extension);
			}
		}

		i++;

		z=direntry(dta, files, i);
	}
}

void	checkdirs(extension)
char	*extension;
{
	struct FILEINFO dta[1];
	char		tmp[80], tmp2[80], tmp3[80], zonestr[15];
	int		z, i, zone, n;

	strcpy(tmp, outbound);
	*(tmp + strlen(tmp) - 1)=0; /* Strippa bort sista backslash. */

	sprintf(tmp2, "%s.*", tmp);

	i=strlen(tmp);
	while(*(tmp + i) != '\\' && *(tmp + i) != ':' && i > 0) i--;

	if (*(tmp + i) == '\\') *(tmp + i + 1)=0;

	i=0;

	z=direntry(dta, tmp2, i);

	while (z == 0)
	{
		if (strcmp(dta->name, ".") != 0 &&
			strcmp(dta->name, "..") != 0 &&
			(dta->attr & 16) != 0)
		{
			n=0;
			while(*(dta->name + n) != 0 &&
				*(dta->name + n) != '.') n++;

			strcpy(zonestr, "");
			if (*(dta->name + n) == '.')
			{
				n++;
				strcpy(zonestr, (dta->name + n));
			}

			zone=sysdata.zone;
			if (sscanf(zonestr, "%3x", &zone) != 1)
			{
				zone=sysdata.zone;
			}

			sprintf(tmp3, "%s%s", tmp, dta->name);
			checkfiles(tmp3, zone, extension);
		}

		i++;

		z=direntry(dta, tmp2, i);

	}
}

void	packfiles(files, zone, extension)
char	*files, *extension;
int	zone;
{
	FILE			*f;
	struct FILEINFO 	dta[1];
	char			tmp[80], newext[6], newfile[80],
					tempfile[80], packfile[80],
					tmp2[80], tmp3[80];
	int			z, i, j, t, vd, yd, exists;

	i=0;

	vd=dayofweek();
	yd=dayofyear();

	strcpy(newext, "HLO");

	*newext=*extension; /* Stt rtt extension! */

	if (*newext == 'O') *newext='F';

	t=0;
	switch (*newext)
	{
		case 'C' : t=1; break;
		case 'D' : t=2; break;
		case 'F' : t=3; break;
		case 'H' : t=4; break;
	}

	z=direntry(dta, files, i);

	while (z == 0)
	{
		if ((dta->attr & 16) == 0)
		{
			strcpy(tmp, dta->name);
			strcpy(newfile, tmp);
			
			j=0;
			while(*(newfile + j) != '.') j++;
			*(newfile + j + 1)=0;

			sprintf(tempfile, "%08lx.PKT",
				sysdata.packetnumber++);

/*			sprintf(packfile, "%s%s%x",
				newfile, weekday[vd],
				(hourofday()/2)); */

			sprintf(packfile, "%s%s0",
				newfile, weekday[vd]);

			strcat(newfile, newext);

			sprintf(tmp2, "%s%s", outbound, tmp);
			sprintf(tmp3, "%s%s", outbound, tempfile);

			if (rename(tmp2, tmp3) == 0)
			{
				exists=0;
				sprintf(fotxt, "%s%s", outbound, packfile);
				if ((f=fopen(fotxt, "r")) != NULL)
				{
					exists=-1;
					fclose(f);
				}

				sprintf(fotxt, "pkpak -a %s%s %s",
					outbound, packfile, tmp3); 

				system(fotxt);

				sprintf(fotxt, "%s%s", outbound, newfile);

				if (exists == 0)
				{
					f=fopen(fotxt, "a+");
					if (f == NULL)
					{
						perror(fotxt);
						exit(9);
					}
					fprintf(f, "^%s%s\n",
						outbound, packfile);
					fclose(f);
				}
				unlink(tmp3);
			}
		}

		i++;

		z=direntry(dta, files, i);
	}
}

void	packdirs(extension)
char	*extension;
{
	struct FILEINFO dta[1];
	char		tmp[80], tmp2[80], tmp3[80], zonestr[15];
	int		z, i, zone, n;

	strcpy(tmp, outbound);
	*(tmp + strlen(tmp) - 1)=0; /* Strippa bort sista backslash. */

	sprintf(tmp2, "%s.*", tmp);

	i=strlen(tmp);
	while(*(tmp + i) != '\\' && *(tmp + i) != ':' && i > 0) i--;

	if (*(tmp + i) == '\\') *(tmp + i + 1)=0;

	i=0;

	z=direntry(dta, tmp2, i);

	while (z == 0)
	{
		if (strcmp(dta->name, ".") != 0 &&
			strcmp(dta->name, "..") != 0 &&
			(dta->attr & 16) != 0)
		{
			n=0;
			while(*(dta->name + n) != 0 &&
				*(dta->name + n) != '.') n++;

			strcpy(zonestr, "");
			if (*(dta->name + n) == '.')
			{
				n++;
				strcpy(zonestr, (dta->name + n));
			}

			zone=sysdata.zone;
			if (sscanf(zonestr, "%3x", &zone) != 1)
			{
				zone=sysdata.zone;
			}

			sprintf(tmp3, "%s%s\\*.%s", tmp, dta->name, extension);

			packfiles(tmp3, zone, extension);
		}

		i++;

		z=direntry(dta, tmp2, i);

	}
}

void	routelist()
{
	checkdirs("CLO");
	checkdirs("DLO");
	checkdirs("FLO");
}

void	packlist()
{

	FILE	*f;

	env=getenv("ADATA");
	strcpy(fotxt, env);
	strcat(fotxt, "USER.DAT");

#ifdef MSDOS
	if (( f = fopen(fotxt,"rb+")) == NULL)
#else
	if (( f = fopen(fotxt,"r+")) == NULL)
#endif
	{
		perror(NOUSERFILE);
		logg(NOUSERFILE, 0);
		exit(9);
	}

	if (fseek(f, (unsigned long int) sizeof(int), SEEK_SET) != 0)
	{
		perror(SYSEDIT1);
		fclose(f);
		logg(SYSEDIT1, 0);
		exit(9);
	}

	if (fread((char *) &sysdata, sizeof(systemdata), 1, f) == 0)
	{
		perror(SYSEDIT3);
	}

/*	Opackade filer. */

	packdirs("CUT");
	packdirs("DUT");
	packdirs("OUT");
	packdirs("HUT");

	if (fseek(f, (unsigned long int) sizeof(int), SEEK_SET) != 0)
	{
		perror(SYSEDIT1);
		fclose(f);
		logg(SYSEDIT1, 0);
		exit(9);
	}

	if (fwrite((char *) &sysdata, sizeof(systemdata), 1, f) == 0)
	{
		perror(SYSEDIT2);
		fclose(f);
		return;
	}

	logg(SYSDATAUPDATED, 3);

	fclose(f);
}
