/* TEXT1.C - Rutiner fr att hmta och lagra texter. */
/* (c) 1989, 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <io.h>

#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

/*	Lista mten som ingr i systemet. */

void	listmeetings(startm)
char	*startm;
{
	int		moeten, i, tmp, z, sumtexts, sumleft, startmoete;
	unsigned int	count;
	char		slask[15], tmp2[160];
	
	moeten=getmoeten();

	startmoete=atoi(startm);

	if (startmoete == 0)
	{
		startmoete=getmoetnumber(startm, 1);
	}

	startmoete++;

	if (startmoete <= 1 || startmoete > moeten) startmoete=1;

	sprintf(fotxt, MEETS, moeten);
	fpr(fotxt);

	sprintf(fotxt, MEETSHD);
	fpr(fotxt);

	count=0;
	sumtexts=0;
	sumleft=0;

	for(i=startmoete;i<=moeten;i++)
	{
		strcpy(slask, "");

		if (count >= user.lines - 5 && user.lines > 5)
		{
			strcpy(fotxt, PRESSRETURN);
			if (ansi == 1) sprintf(fotxt, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

			if (ansi == 2) sprintf(fotxt, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			z=lineed(slask, fotxt, "", 3, 0);
			newline();
			count=0;
			if (z < 0 || *slask != 0) return;
		}

		tmp=getmaxtext(i);

		strcpy(slask,"     ");

		if ((user.memberinfo[i].moetstatus & 1) == 1)
			*slask='*';

		if ((user.memberinfo[i].moetstatus & 3) == 3)
			*slask='A';

		if ((user.memberinfo[i].moetstatus & 3) == 2)
			*slask='a';

		if ((meetinf.parameters & NO_READ) != 0)
			*(slask+1)='R';

		if ((meetinf.parameters & NO_WRITE) != 0)
			*(slask+2)='W';

		if ((meetinf.parameters & NO_COMMENT) != 0 )
			*(slask+3)='C';

		if ((meetinf.parameters & NO_QUESTION) != 0)
			*(slask+4)='Q';

		if (user.memberinfo[i].lastread > 
			meetinf.firsttext+meetinf.texts)
				user.memberinfo[i].lastread=meetinf.firsttext;

		if (meetinf.creator == 0 )
		{
			sprintf(fotxt, MEETLINE1,i-1);

/*	Om man r road av att se vilka mten som r raderade
	tar man bort kommentaren hr. */

/*			fpr(fotxt);  */
		}
		else
		if (meetinf.texts > 0 )
		{
			if (user.memberinfo[i].lastread < meetinf.firsttext)
			    user.memberinfo[i].lastread = meetinf.firsttext;

			sprintf(fotxt, MEETLINE2,i-1 ,
				meetinf.typ,
				meetinf.firsttext+1,
				meetinf.firsttext+meetinf.texts,
				meetinf.firsttext+meetinf.texts-
					user.memberinfo[i].lastread,
				slask,
				meetinf.namn);

			if (ansi == 1)
			{
				if (*slask == 'a')
					sprintf(tmp2, "%s%s%s",
						ansicol[11],
						fotxt,
						ansicol[7]);

				if (*slask == 'A')
					sprintf(tmp2, "%s%s%s",
						ansicol[12],
						fotxt,
						ansicol[7]);

				if (*slask == '*')
					sprintf(tmp2, "%s%s%s",
						ansicol[13],
						fotxt,
						ansicol[7]);

				if (*slask == ' ')
					sprintf(tmp2, "%s%s%s",
						ansicol[16],
						fotxt,
						ansicol[7]);

				strcpy(fotxt, tmp2);
			}

			if (ansi == 2)
			{
				if (*slask == 'a')
					sprintf(tmp2, "%s%s%s",
						ansicol[22],
						fotxt,
						ansicol[20]);

				if (*slask == 'A')
					sprintf(tmp2, "%s%s%s",
						ansicol[21],
						fotxt,
						ansicol[20]);

				if (*slask == '*')
					strcpy(tmp2, fotxt);

				if (*slask == ' ')
					sprintf(tmp2, "%s%s%s",
						ansicol[18],
						fotxt,
						ansicol[20]);

				strcpy(fotxt, tmp2);
			}

			if (i > 1)
			{
				sumtexts=sumtexts+
					(unsigned int)meetinf.texts;
				if (*slask == '*' || *slask == 'A')
					sumleft=sumleft+
					   (unsigned int)meetinf.firsttext+
					   (unsigned int)meetinf.texts-
					   (unsigned int)user.memberinfo[i].lastread;
			}

			fpr(fotxt);

			count++;
		}
		else
		{
			sprintf(fotxt,
				MEETLINE3,i-1 ,
				meetinf.typ,
				slask,
				meetinf.namn);
			fpr(fotxt);
			count++;
		}
	}
	sprintf(fotxt,
		MEETLINE4,
		sumtexts,
		sumleft);
	fpr(fotxt);

	if (count >= user.lines - 18 && user.lines > 5 &&
		(user.status & 8) == 0)
	{
		strcpy(fotxt, PRESSRETURN);
		if (ansi == 1) sprintf(fotxt, "%s%s%s",
					ansicol[14],
					PRESSRETURN,
					ansicol[7]);

		if (ansi == 2) sprintf(fotxt, "%s%s%s",
					ansicol[21],
					PRESSRETURN,
					ansicol[20]);

		z=lineed(slask, fotxt, "", 3, 0);
		newline();
		count=0;
		if (z < 0 || *slask != 0) return;
	}
}

/*	Bli medlem i ett mte. */

void	member(moete)
char	*moete;
{
	int	moetnr, tmp, moeten, z;

	while(strcmp(moete, "") == 0)
	{
		z=lineed(moete, MEMBERPAR, "", 70, 0);
		newline();
		if (z<0) return;
	}

	moetnr=atoi(moete)+1;

	if (moetnr == 1)
	{
		moetnr=getmoetnumber(moete, 2);
	}

	moeten=getmoeten();

	if (moetnr < 1 || moetnr > moeten) moetnr=0;

	tmp=getmaxtext(moetnr);

	if (moetnr == 0)
	{
		fpr(WRONGMEET);
		return;
	}

	if (meetinf.creator == 0)
	{
		fpr(DELETEDMEET);
		return;
	}

/*	Hr skall man kolla privilegier s smningom */

	if (moetnr != 0)
	{
		if ((user.textprivs & (MSG_MEMBER | MSG_CMEMBER)) != 0 &&
			(strcmp(meetinf.typ, "O") == 0 ||
			strcmp(meetinf.typ, "E") == 0 ||
			(user.memberinfo[moetnr].moetstatus & 2) == 2 ||
			(user.textprivs & MSG_CMEMBER) != 0))
		{
			user.memberinfo[moetnr].moetstatus =
				(user.memberinfo[moetnr].moetstatus | 1);
			sprintf(fotxt, NOWMEMBERIN, meetinf.namn);
			fpr(fotxt);
		}
		else
		{
			logg(NOTMEMBERPRV, 1);
			fpr(NOMEMBERPRIV);
		}
	}
}

/*	Uttrd ur ett mte. */

void	nomember(moete)
char	*moete;
{
	int	moetnr, moeten, tmp, z;
	
	while(strcmp(moete, "") == 0)
	{
		z=lineed(moete, NOMEMBERPAR, "", 70, 0);
		newline();
		if (z<0) return;
	}

	moetnr=atoi(moete)+1;

	if (moetnr == 1)
	{
		moetnr=getmoetnumber(moete, 2);
	}

	moeten=getmoeten();

	if (moetnr < 1 || moetnr > moeten) moetnr=0;

	if (moetnr == 0)
	{
		fpr(WRONGMEET);
		return;
	}

	tmp=getmaxtext(moetnr);

	if (meetinf.creator == 0)
	{
		fpr(DELETEDMEET);
		return;
	}

	user.memberinfo[moetnr].moetstatus =
		(user.memberinfo[moetnr].moetstatus & 126);
	sprintf(fotxt, NOWNOTMEMBER, meetinf.namn);
	fpr(fotxt);
}

/*	Tala om i vilket mte du r. */

void	whereami()
{
	int	tmp;
	
	if (moetnumber > 1)
	{
		tmp=getmaxtext(moetnumber);
		sprintf(fotxt, IN_MEET, meetinf.namn);
		fpr(fotxt);
	}
	else
	{
		sprintf(fotxt, NOT_IN_MEET);
		fpr(fotxt);
	}
}

/*	Returnera 0, eller felkoder beroende p om mtet
	fanns, du var medlem eller mtet var raderat.
	0	= Mtet fanns, allt OK.
		  msgdefault=1, Texter finns att lsa.
		  msgdefault=2, Texter slut.

	1	= Felaktigt nummer p mtet angivet.
	2	= Mtet fanns, men du var inte medlem.
	3	= Mtet r numera raderat.

*/

int	getgomoete(moetnr, moeten)
int	moetnr, moeten;
{
	int	tmp, mem;

	if ((user.memberinfo[moetnr].moetstatus & 1) != 1) return(2);

	mem=moetnumber;

	if (moetnr > moeten || moetnr <= 1) return(1);

	moetnumber=moetnr;
	tmp=getmaxtext(moetnumber);

	msgdefault=1;

	if (user.memberinfo[moetnumber].lastread >=
		meetinf.texts+meetinf.firsttext) msgdefault=2;


	if (*(meetinf.namn) == 0)
	{
		msgdefault=2;
		moetnumber=mem;
		return(3);
	}

	return(0);
}

/*	G till ett bestmt mte. */

void	gotomoete(moete)
char	*moete;
{
	int	moeten, moetnr, z;

	moeten=getmoeten();

	while(strcmp(moete, "") == 0)
	{
		z=lineed(moete, GOTOPAR, "", 70, 0);
		newline();
		if (z<0) return;
	}

	moetnr=atoi(moete)+1;

	if (moetnr == 1)
	{
		moetnr=getmoetnumber(moete, 2);
	}

	if (moetnr <= 1)
	{
		fpr(NOMEET);
		return;
	}

	if (moetnr < 1 || moetnr > moeten) moetnr=0;

	z=getgomoete(moetnr, moeten);

/*	Eftersom du bytte mte kan du inte kommentera
	texten som du sist lste. */

	lasttext=0L;

	switch (z)
	{
		case 0 : sprintf(fotxt, NOW_IN_MEET, meetinf.namn,
				meetinf.firsttext+meetinf.texts-
					user.memberinfo[moetnumber].lastread); 
				fpr(fotxt); break;
		case 1 : sprintf(fotxt, WRONGMEET);
				fpr(fotxt); break;
		case 2 : sprintf(fotxt, NOTMEMBER);
				fpr(fotxt); break;
		case 3 : sprintf(fotxt, DELETEDMEET);
				fpr(fotxt); break;
	}
}

/*	G till nsta mte som innehller texter. */

void	nastamoete()
{
	int		moeten, tmp, retry;
	unsigned int	mem;

	moeten=getmoeten();

	if (moetnumber < 2) moetnumber=2;
	mem=moetnumber;

	retry=0;

/*	Se frst efter om det mtet du r i r frdiglst. */

	tmp=getgomoete(moetnumber, moeten);

/*	Om det fanns texter kvar hoppar vi ur. */

	if (tmp == 0 && msgdefault == 1) return;

/*	Leta efter ett mte som har olsta texter. */

	while (tmp == 0 && msgdefault == 2 || tmp == 2 || tmp == 3)
	{
		moetnumber++;
		tmp=getgomoete(moetnumber, moeten);
	}

/*	Om det var texter vi hittade s hoppar vi ur. */

	if (tmp == 0 && msgdefault == 1)
	{
/*	Eftersom du bytte mte kan du inte kommentera
	texten som du sist lste. */

		lasttext=0L;

		sprintf(fotxt, NOW_IN_MEET, meetinf.namn,
				meetinf.firsttext+meetinf.texts-
					user.memberinfo[moetnumber].lastread); 
		fpr(fotxt);

		return;
	}

/*	Om frsta mtet kollades frst skall vi hoppa ut hr. */

	if (tmp == 1 && mem == 2)
	{
		tmp=getgomoete(mem, moeten);
		msgdefault=0;
		return;
	}

/*	Brja om med frsta mtet. */

	moetnumber=2;

	tmp=getgomoete(moetnumber, moeten);

/*	Om vi hittade texter i frsta mtet s hoppar vi ur. */

	if (tmp == 0 && msgdefault == 1)
	{
/*	Eftersom du bytte mte kan du inte kommentera
	texten som du sist lste. */

		lasttext=0L;

		sprintf(fotxt, NOW_IN_MEET, meetinf.namn); 
		fpr(fotxt);

		return;
	}

	while (moetnumber < mem &&
		(tmp == 0 && msgdefault == 2 || tmp == 2 || tmp == 3))
	{
		moetnumber++;
		tmp=getgomoete(moetnumber, moeten);
	}

/*	Kolla om det var texter som vi hittade. Var det inte det
	s stll om fr detta, och byt inte mte. */

	if (tmp == 1 || tmp == 2 || tmp == 3 || tmp == 0 && msgdefault == 2)
	{
		tmp=getgomoete(mem, moeten);
		msgdefault=0;
		return;
	}

/*	Eftersom du bytte mte kan du inte kommentera
	texten som du sist lste. */

	lasttext=0L;
}

/*	Ls en text, eller nsta text. */

void	readtext(param)
char	*param;
{
	int		tmp, moeten, brev, i, autoread, extended;
	long int	textno, logtextnr;
	unsigned int	mem;

	while (strcmp(param, "") == 0)
	{
		tmp=lineed(param, READTEXTPROMPT, "", 10, 0);
		newline();
		if (tmp<0) return;
	}

	moeten=getmoeten();
	textno=atoi(param);
	if (textno < 0) textno = 0;

/*	Om du just har brjat, r mtesnumret =0, stt det d till 2 */

	if (moetnumber < 2 && *param != MAILSHORT1 &&
		*param != MAILSHORT2) nastamoete();

/*	Kom ihg mtesnumret, om vi brjar bka med brevldan. */

	mem=moetnumber;

	brev=0;
	extended=0;

/*	Om parametern brjar p 'B' r det ett brev som skall lsas. */

	if (*param == MAILSHORT1 || *param == MAILSHORT2)
	{
		moetnumber=1;
		textno=atoi(comndpar.par[1]);
		if (textno < 0) textno = 0;
		brev=-1;
		if (textno == 0) autoread=-1; else autoread=0;
		if (*comndpar.par[2] == 'x' || *comndpar.par[2] == 'X')
			extended=1;
	}

	if (*param == 'X' || *param == 'x')
	{
		extended=1;
		textno=atoi(comndpar.par[1]);
		if (textno < 0) textno = 0;
		autoread=0;
	}

	if (textno == 0 && *param != '0' &&
		*param != MAILSHORT1 && *param != MAILSHORT2)
	{
		sprintf(fotxt, READPARS);
		fpr(fotxt);
		return;
	}

/*	Spara det logiska textnumret. */

	logtextnr=textno;

/*	Vi skall frska hlla oss till fysiskt textnummer internt,
	fr att inte blanda ihop korten alltfr mycket. */

	tmp=getmaxtext(moetnumber);
	textno=textno-(unsigned int)meetinf.firsttext;

/*	Kolla om du har rtt att lsa ngon text i det hr mtet. */

	if ((meetinf.parameters & NO_READ) != 0 &&
		(user.memberinfo[moetnumber].moetstatus & READ) == 0 &&
		brev == 0)
	{
		user.memberinfo[moetnumber].lastread=
			meetinf.texts+meetinf.firsttext;
		nastamoete();
		sprintf(fotxt, NOREADPRIV);
		newline();
		fpr(fotxt);
		newline();
		logg(fotxt, 2);
		return;
	}

/*	Om det har tagits bort texter som du inte har lst, hoppa d fram. */

	if (user.memberinfo[moetnumber].lastread < meetinf.firsttext)
		user.memberinfo[moetnumber].lastread=meetinf.firsttext;

/*	Om ingen parameter angivits, och det finns texter att lsa,
	tar vi fram frsta fysiska texten att lsa i textno. */

	if (logtextnr == 0 &&
		user.memberinfo[moetnumber].lastread <
		meetinf.texts+meetinf.firsttext)
		    textno = ++user.memberinfo[moetnumber].lastread-
		    	meetinf.firsttext;

/*	Om det inte fanns ngot att lsa i mtet, eller du frskte
	lsa fel text, s ramlar vi ur igen. */

	if (meetinf.texts == 0 ||
		(textno > meetinf.texts || textno < 0L)
		&& logtextnr == 0)
	{
		msgdefault=2;
		return;
	}

	if (logtextnr != 0 && (textno <= 0L ||
		textno > meetinf.texts))
	{
		sprintf(fotxt, ILLEGALTEXTNO);
		fpr(fotxt);
		return;
	}

	tmp=gettextindex(moetnumber, (unsigned int)textno);

/*	Om texten var en frga skall vi stlla om oss till att automatiskt
	besvara denna. */

/*	Offentlig frga. */

	if ((textindex.type & 2) == 2 &&
		logtextnr == 0 &&
		textindex.creator != usernumber &&
		((textindex.type & 4) != 4 ||
		textindex.kommusr == usernumber)) msgdefault=3;

/*	Privat frga. */

	if ((textindex.type & 16) == 16 &&
		logtextnr == 0 &&
		(unsigned int)textindex.creator != usernumber &&
		((textindex.type & 4) != 4 ||
		textindex.kommusr == usernumber)) msgdefault=5;

/*	Ls ett brev eller en text. */

	if ((textindex.type & 1) != 0)
	{

/*	Ls ett mtesinlgg (Allmn text. ) */

		if ((textindex.type & 4) == 0 &&
			(textindex.creator != usernumber ||
			logtextnr != 0))
		{
			lasttext=textno + meetinf.firsttext;
			newline();
			showtext((unsigned int)textno, extended);

			i=0;
			tmp=0;
			if (textindex.commlist[i] != 0L)
			{
				fpr(COMMENTINTEXTS);
				while(textindex.commlist[i] != 0L && i < 80)
				{
					sprintf(fotxt, "%ld ",
						textindex.commlist[i]);
					fpr(fotxt);

					tmp=tmp+strlen(fotxt);

					if (tmp > (int)user.columns)
					{
						fpr(":");
						newline();
						tmp=0;
					}

					i++;
				}
			}
		}
			
/*	Inget brev. - Normal text. */

		if ((textindex.type & 4) == 0 &&
			textindex.creator == usernumber &&
			logtextnr == 0)
		{
			fpr(OWNTEXT);
			if (msgdefault == 3 || msgdefault == 5) msgdefault=1;
		}
			
/*	Personligt brev. */

		if ((textindex.type & 4) == 4 &&
			(textindex.destpoint == sysdata.point &&
			textindex.kommusr == usernumber ||
			textindex.creator == usernumber &&
			logtextnr != 0))
		{
			lasttext=textno + meetinf.firsttext;
			newline();
			showtext((unsigned int)textno, 0);

			if (inputemails > 0 && autoread == -1 &&
				moetnumber == 1 &&
				textindex.kommusr == usernumber)
				{
					inputemails--;
				}
		}
			
/*	Inte ditt brev. Varken skickat eller mottaget. */

		if ((textindex.type & 4) == 4 &&
			textindex.destpoint == sysdata.point &&
			textindex.kommusr != usernumber &&
			textindex.creator != usernumber &&
			logtextnr != 0)
		{
			fpr(NOTYOURMAIL);
			logg(NOTRIGHTMAIL, 2);
		}
	}

/*	Raderad text. */

	if ((textindex.type & 1) == 0)
	{
		fpr(DELETEDTEXT);
		if (msgdefault == 3 || msgdefault == 5) msgdefault=1;
	}


	if (user.memberinfo[moetnumber].lastread >=
		meetinf.texts + meetinf.firsttext &&
		msgdefault != 3 &&
		msgdefault != 5 &&
		(textindex.type & 18) == 0 &&
		logtextnr == 0) msgdefault=2;

	if (mem != moetnumber)
	{
		moetnumber=mem;
		tmp=getmaxtext(moetnumber);
	}

	updateuser(1);

	if (*param != MAILSHORT1 && *param != MAILSHORT2)
		lastreadmail=0; else lastreadmail=1;

	if (msgdefault == 4 && inputemails == 0) msgdefault=2;

	newline();
}

int	writetextpriv(texttype)
int	texttype;
{
	if ((texttype & 14) == 2 &&
		(meetinf.parameters & NO_QUESTION) != 0 &&
		(user.memberinfo[moetnumber].moetstatus & QUESTION) == 0)
	{
		sprintf(fotxt, NOQUESTPRIV);
		logg(NOTQUESTPRV, 1);
		fpr(fotxt);
		return(-1);
	}

	if ((texttype & 141) == 1 &&
		((meetinf.parameters & NO_WRITE) != 0 &&
		(user.memberinfo[moetnumber].moetstatus & WRITE) == 0 ||
		(user.textprivs & MSG_WRTXT) == 0))
	{
		sprintf(fotxt, NOWRITEPRIV);
		logg(NOTWRITEPRV, 1);
		fpr(fotxt);
		return(-1);
	}

	if ((texttype & 7) == 7 && (user.textprivs & MSG_PQUEST) == 0)
	{
		sprintf(fotxt, NOQUESTPRIV);
		logg(NOTQUESTPRV, 1);
		fpr(fotxt);
		return(-1);
	}

	if ((texttype & 133) == 129 &&
		((meetinf.parameters & NO_COMMENT) != 0 &&
		(user.memberinfo[moetnumber].moetstatus & COMMENT2) == 0 ||
		(user.textprivs & MSG_REPTXT) == 0))
	{
		sprintf(fotxt, NOWRITEPRIV);
		fpr(fotxt);
		return(-1);
	}

	return(0);
}

int	lockarea()
{
	int	lockf, lockcnt;
	char	slask[80];

	env=getenv("ADATA");
	sprintf(slask, "%sM%d.LCK", env, moetnumber);
	lockcnt=0;

	while((lockf=sopen(slask,
		O_CREAT | O_RDONLY, SH_DENYRW, S_IWRITE | S_IREAD)) == -1)
	{
		if (lockcnt++ > 100)
		{
			sprintf(fotxt,
				"Sharing error area %d!\n",
				moetnumber);
			return(-1);
		}
	}

	return(lockf);
}

void	texthead(headarea, textnumber, texttype, uttid)
char	*headarea, *uttid;
int	textnumber, texttype;
{
	if ((texttype & 2) == 0)
	{
		sprintf(headarea, TEXTHEAD1,
			textnumber + meetinf.firsttext,
			meetinf.namn, uttid);
	}
	else
	{
		sprintf(headarea, TEXTHEAD2,
			textnumber + meetinf.firsttext,
			meetinf.namn, uttid);
	}
}

void	textinfohead(headarea, subject, userno, usertext)
char	*headarea, *subject, *usertext;
int	userno;
{
	int	z;

	if (userno == 0)
	{
		if(strcmp(usertext, "") == 0)
		sprintf(headarea, TEXTINFOHEAD1,
			user.username, usernumber, subject);
		else
		sprintf(headarea, TEXTINFOHEAD3,
			user.username, usernumber, usertext,
			subject);
	}
	else
	{
		z=getuserinfo(userno);
		sprintf(headarea, TEXTINFOHEAD2,
			user.username, usernumber,
			user2.username, userno, subject);
	}
}

void	kludgeadd(headarea, textnumber, texttype, msgid, reply,
	zone, net, node, point)
char	*headarea, *msgid, *reply;
int	textnumber, texttype, zone, net, node, point;
{
	char	slask[80];
	int	i;

	sprintf(slask, "%02x%06lx", moetnumber,
		textnumber + meetinf.firsttext);

	if (sysdata.point != 0 && moetnumber == 1)
	{
		i=0;
		while(*(headarea + i) !=0) i++;

		sprintf((headarea+i),
			"\001FMPT: %d\r\n", sysdata.point);
	}

	if (point != 0 && moetnumber == 1)
	{
		i=0;
		while(*(headarea + i) !=0) i++;

		sprintf((headarea+i),
			"\001TOPT: %d\r\n", point);
	}

	i=0;
	while(*(headarea + i) !=0) i++;

/*	Hr ger vi texten ett MSGID bestende av 2 bytes mtesnummer
	och 6 bytes textnummer i HEX-format. Detta leder till att vi
	kan hantera upp till 16 miljoner texter i varje mte,
	och upp till 255 mten. Detta lr rcka inom verskdlig tid... */

	if (sysdata.point == 0)
	{
		sprintf(msgid, "%d:%d/%d %s\r\n",
			sysdata.zone, sysdata.net,
			sysdata.node, slask);
	}
	else
	{
		sprintf(msgid, "%d:%d/%d.%d %s\r\n",
			sysdata.zone, sysdata.net,
			sysdata.node, sysdata.point, slask);
	}

	sprintf((headarea+i), "\001MSGID: %s", msgid);

/*	Om texten vi kommenterar har ett MSGID, s omvandlar vi det till
	ett REPLY! */

	if (*reply != 0)
	{
		i=0;
		while(*(headarea + i) !=0) i++;

		sprintf((headarea+i),
			"\001REPLY: %s\r\n", reply);
	}

	if (moetnumber == 1 &&
		(unsigned int)zone != sysdata.zone)
	{
		i=0;
		while(*(headarea + i) !=0) i++;

		sprintf((headarea+i),
			"\001INTL: %d:%d/%d %d:%d/%d\r\n",
			zone, net, node,
			sysdata.zone, sysdata.net, sysdata.node);
	}

/*	Hr lgger vi p en kludge som skall finnas om det r en
	speciell typ av text som skrivs. Normala texter och
	normala brev har inte denna kludge, men alla specialtexter
	har den. */

	if ((texttype & 32722) != 0)
	{
		i=0;
		while(*(headarea + i) !=0) i++;

		sprintf((headarea+i), "\001AUR: %x\r\n",
			texttype);
	}
}

void	textend(textarea)
char	*textarea;
{
	int	i;

	sprintf(textarea, TEARLINE, SYSTEMVERSION);

	if (moetnumber != 1)
	{
		i=0;
		while(*(textarea + i) !=0) i++;

		if (sysdata.point == 0)
			sprintf((textarea + i), ORIGINLINE,
				sysdata.systemname,
				sysdata.zone, sysdata.net,
				sysdata.node);
		else
			sprintf((textarea + i), ORIGINLINE2,
				sysdata.systemname,
				sysdata.zone, sysdata.net,
				sysdata.node, sysdata.point);
	}
}

void	concattext(headarea, textarea)
char	*headarea, *textarea;
{
	int	i, j, z;

/*	Leta upp slutet p texthuvudet. */

	j=0;
	while(*(headarea + j) !=0) j++;

/*	Leta upp textslutet. */

	i=0;
	while(*(textarea + i) !=0) i++;

	z=i+1;
	while(z>=0)
	{
		*(textarea + j + z)=*(textarea + z);
		z--;
	}

	z=j-1;

	while(z>=0)
	{
		*(textarea + z)=*(headarea + z);
		z--;
	}
}

/*	Denna rutin har 2 parametrar som beskriver texten.
	Parameter 1: (texttype)
	Bit
	0. 1	1. Giltig text.		0. Raderad text.
	1. 2	1. Skall kommenteras.	0. Fritt att kommenteras eller ej.
	2. 4	1. Personligt brev.	0. Allmn text.
	3. 8	1. Skickas ECHO-mail.	0. Lokal text.
	4. 16	1. Skall ha pers.komm.	0. Normal text. (Denna skall utesluta
							typ 2.)
	5. 32	1. Crash Mail.		0. Normal.

	7. 128  1. Kommentar		0. Ursprunglig text. (Endast internt)

	(Plats fr fler funktioner.)
	
	Parameter 2: (userno)
	Om bit 2 r ett-stlld, r detta anvndaren som skall ta emot brevet,
	annars r detta vrde 0.
	
*/

void		tempstoreold(oldarea)
unsigned char	*oldarea;
{
	char		tmp[80], tmp2[80];
	int		i, j, n, eol;
	unsigned int	c;
	FILE		*f;

	env=getenv("ADATA");
	strcpy(tmp, env);
	strcat(tmp, "OUT");

	unlink(tmp);

	i=0;
	j=0;
	while(*(textindex.creuser + i) != 0)
	{
		while(*(textindex.creuser + i) == ' ' ||
			*(textindex.creuser + i) == '-' ||
			*(textindex.creuser + i) == '/') i++;

		*(tmp2+j)=*(textindex.creuser+i);

		i++;
		j++;

		while(*(textindex.creuser + i) != 0 &&
			*(textindex.creuser + i) != ' ' &&
			*(textindex.creuser + i) != '-' &&
			*(textindex.creuser + i) != '/') i++;
	}

	*(tmp2+j)=0;
	strcat(tmp2, "> ");

	i=0;
	if (oldarea != NULL)
	{
		if ((f=fopen(tmp, "wt")) == NULL)
		{
			perror(tmp);
			logg(tmp,0);
			exit(9);
		}

/*	Print user initials of user that we quote. */

		n=0;
		while(*(tmp2+n) != 0)
		{
			c=*(tmp2+n);
			if (baud > 0 ) c=(unsigned int)transchar((unsigned char)c, BASECHARSET, user.charset);
			if (c<32)
			{
				fputc('^', f);
				fputc(c+64, f);
			}
			else
			{
				fputc(c, f);
			}
			n++;
		}

/*		fputs(tmp2, f);
		j=strlen(tmp2); */

		while(*(oldarea + i) != 0)
		{
			eol=0;
			while(*(oldarea + i + eol) != 0 &&
				*(oldarea + i + eol) != '\r' &&
				eol < 70) eol++;

			n=eol;
			while(*(oldarea + i + eol) != '\r' &&
				*(oldarea + i + eol) != ' ' &&
				eol > 55) eol--;

			if (eol <= 55) eol=n;
			n=0;
			while(n<eol)
			{
				c=*(oldarea + i + n);
				if (baud > 0 ) c=(unsigned int)transchar((unsigned char)c, BASECHARSET, user.charset);
				if (c<32)
				{
					fputc('^', f);
					fputc(c+64, f);
				}
				else
				{
					if (c != 0x8d) fputc(c, f);
				}

				n++;
			}

			i=i+eol;

/*			if (c >= 32) fputc(c, f); */

/*	Print user initials of user that we quote. */
/*			if (c == '\r' || j >= 70 || (j >= 55 && c == ' '))
			{
				fputc('\n', f);
				fputs(tmp2, f);
				j=strlen(tmp2);
			} */

			fputc('\n', f);
			fputs(tmp2, f);
			j=strlen(tmp2);

			i++;
			j++;
			if (*(oldarea + i) == '\r') i++;
			if (*(oldarea + i) == '\n') i++;
		}

/*		fwrite(oldarea, sizeof(char), strlen(oldarea), f); */

		fclose(f);
	}
}

/*	Skriv in en ny text i systemet. */

void	dowritetext(texttype, userno, usertxt, typeflag, textid)
int	texttype, userno, typeflag;
char	*usertxt, *textid;
{
	int	textnumber, i, z, lockf, creator,
			temptype, tempzone, tempnet, tempnode, temppoint,
			temptexts, mem, tempmoet, wrmeet;
	long int	klocka[1], textnr, tempfirsttext;
	char	*textarea, uttid[20], subject[80], slask[80], tempmeet[80],
		msgid[40], *buffarea[MAXLINES], headarea[4096], reply[80],
		tempsubject[80], *oldarea, usertext[80];

	mem=moetnumber;

	strcpy(usertext, usertxt);

	oldarea=NULL;

	if (typeflag == 0)
	{
		if (writetextpriv(texttype) != 0) return;
		strcpy(reply, "");
		creator=userno;
		strcpy(tempsubject, "");
	}
	else
	{
		if (writetextpriv(texttype | 128) != 0) return;

#ifdef MSDOS
		oldarea=halloc((unsigned long int)MAXLINES *
			(unsigned long int)LINELENGTH, sizeof(char));
#else
		oldarea=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

		if (oldarea == NULL)
		{
			printf(ALLOCERROR);
			logg(ALLOCERROR, 0);
			exit(9);
		}

		textnr=atoi(textid);

		if (textnr == 0L) textnr=lasttext;

		if (lastreadmail != 0)
		{
			moetnumber=1;
			getmaxtext(moetnumber);
		}

		textnr=textnr-meetinf.firsttext;

		if (textnr > 0L && textnr <= meetinf.texts)
		{
/*	Hmta data om texten som skall kommenteras i mtet */
			i=gettextindex(moetnumber, (unsigned int)textnr);

/*	Ladda texten fr visning! */
			gettxt(oldarea, (unsigned int)textnr);

/*	Spara diverse flaggor och parametrar. */
			temptype=textindex.type & 12; /* Nttext (8)
							 och brev (4) */

/*	Om det r uppenbart att det r kommentar till text frn en annan nod
	skall vi aktivera flaggan fr echomail, s att vi inte tappar texten */

			if(sysdata.zone != textindex.crezone ||
				sysdata.net != textindex.crenet ||
				sysdata.node != textindex.crenode ||
				sysdata.point != textindex.crepoint)
					temptype=(temptype | 8);

			tempzone=textindex.crezone;
			tempnet=textindex.crenet;
			tempnode=textindex.crenode;
			temppoint=textindex.crepoint;
			tempmoet=moetnumber;
			creator=textindex.creator;

			temptexts=(unsigned int)meetinf.texts;
			tempfirsttext=meetinf.firsttext;

			strcpy(tempmeet, meetinf.namn);
			strcpy(usertext, textindex.creuser);
			strcpy(reply, textindex.msgid);
			strcpy(tempsubject, textindex.subject);

			if ((texttype & 8) == 8)
			{
				moetnumber=1;
				textnumber=getmaxtext(moetnumber);
			}

			if ((temptype & 8) == 0 && moetnumber == 1 ||
				(unsigned int)tempzone == sysdata.zone &&
				(unsigned int)tempnet == sysdata.net &&
				(unsigned int)tempnode == sysdata.node)
			{
				z=getuserinfo(creator);
			}

		}
		else
		{
			moetnumber=mem;
			getmaxtext(mem);
#ifdef MSDOS
			hfree(oldarea);
#else
			free(oldarea);
#endif
			return;
		}
	}

	tempstoreold(oldarea);

#ifdef MSDOS
	if (oldarea != NULL) hfree(oldarea);
#else
	if (oldarea != NULL) free(oldarea);
#endif

#ifdef MSDOS
	textarea=halloc((unsigned long int)MAXLINES *
		(unsigned long int)LINELENGTH, sizeof(char));
#else
	textarea=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

	if (textarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	sprintf(fotxt, NEWTEXT, meetinf.namn);
	fpr(fotxt);

	if (lineed(subject, SUBJECTPROMPT, tempsubject, 60, 2) >= 0)
	{
/*	Editera texten! */

		newline();

		for (i=0;i<MAXLINES;i++)
		{
			buffarea[i]=calloc(2, sizeof(char));
			if (buffarea[i] == NULL)
			{
				printf(ALLOCERROR);
				logg(ALLOCERROR, 0);
				exit(9);
			}
			*buffarea[i]=0;
		}

		z=edittext(textarea, (MAXLINES*LINELENGTH/user.columns)-10,
			 buffarea);

		for (i=0;i<MAXLINES;i++) free(buffarea[i]);

		if (z >= 0)
		{
			time(klocka);
			tidkonv(klocka, uttid);

			if ((texttype & 4) != 0) moetnumber=1;

			wrmeet=moetnumber;

/*	Ls mtet! */
			if ((lockf=lockarea()) == -1)
			{
				textnumber=getmaxtext(moetnumber);
#ifdef MSDOS
				hfree(textarea);
#else
				free(textarea);
#endif

				return;
			}

/*	Hmta sista fysiska texten i mtet */
			textnumber=getmaxtext(moetnumber);

/*	Hmta data om sista texten i mtet */
			i=gettextindex(moetnumber, textnumber);

			textnumber++;

			texthead(headarea, textnumber, texttype, uttid);

			if (typeflag != 0)
			{
				i=0;
				while(*(headarea + i) !=0) i++;

				if ((texttype & 4) == 0)
					sprintf((headarea + i), KOMMHEAD,
						textnr + meetinf.firsttext);
				else sprintf((headarea + i), PKOMMHEAD,
					textnr + tempfirsttext, tempmeet);
			}

			i=0;
			while(*(headarea + i) !=0) i++;

			textinfohead(headarea+i, subject, creator, usertext);

			i=0;
			while(*(headarea + i) != 0) i++;

			if (typeflag == 0)
			{
/*	Originaltext */
				kludgeadd((headarea + i), textnumber,
					texttype, msgid, reply,
					nodecode.zone,
					nodecode.net,
					nodecode.node,
					nodecode.point);
			}
			else
			{
/*	Kommentar */
				kludgeadd((headarea + i), textnumber,
					texttype, msgid, reply,
					tempzone,
					tempnet,
					tempnode,
					temppoint);
			}

/*	Lnka ihop texthuvud och text med utdata i textarea. */

			i=0;
			while(*(headarea + i) != 0) i++;

			concattext(headarea, textarea);

			i=0;
			while(*(textarea + i) !=0) i++;

/*	Lgg p Tear-line och Origin-rad. */

			textend((textarea + i));

			i=0;
			while(*(textarea + i) !=0) i++;

/*	Fixa alla tillggsdata om texten. */

			textindex.startpos=sistatextpos;
			textindex.cretime=*klocka;
			textindex.kommptr=0;
			textindex.len=i;
			textindex.creator=usernumber;

			if (typeflag == 0)
			{
				if ((texttype & 4) != 0 &&
					(user2.status & POINT) != 0)
				{
					textindex.type=texttype | 8;
				}
				else
				{
					textindex.type=texttype;
				}
			}
			else
			{
/*	temptype kan innehlla flagga fr nttext samt personlig text. */
				textindex.type=(texttype | temptype);
			}

			textindex.destzone=nodecode.zone;

			if (textindex.destzone == 0)
				textindex.destzone=sysdata.zone;

			textindex.destnet=nodes.net;
			textindex.destnode=nodes.node;

			if (nodecode.point == 0 &&
				(user2.status & POINT) != 0)
			{
				textindex.destpoint=creator;
			}
			else
			{
				textindex.destpoint=nodecode.point;
			}

			if (typeflag != 0)
			{
				textindex.kommptr=textnr + meetinf.firsttext;
				textindex.destzone=tempzone;

				if (textindex.destzone == 0)
					textindex.destzone=sysdata.zone;

				textindex.destnet=tempnet;
				textindex.destnode=tempnode;
				textindex.destpoint=temppoint;
			}

			textindex.kommusr=creator;
			textindex.crezone=sysdata.zone;
			textindex.crenet=sysdata.net;
			textindex.crenode=sysdata.node;
			textindex.crepoint=sysdata.point;
			textindex.fromnet=sysdata.net;
			textindex.fromnode=sysdata.node;

			for (i=0;i<80;i++) textindex.commlist[i]=0L;

			strcpy(textindex.msgid, msgid);
			strcpy(textindex.tclinfo, "");

			strcpy(textindex.subject, subject);

/*			Lagra textskapare och adressat i index
			med maxlngd enligt FIDO-net.
			(Vi bara kapar...) */

			strcpy(slask, user.username);
			*(slask + 35)=0;
			strcpy(textindex.creuser, slask);
			strcpy(slask, usertext);
			*(slask + 35)=0;
			strcpy(textindex.touser, slask);

			sprintf(fotxt, SAVETEXT,
				textnumber + meetinf.firsttext);
			fpr(fotxt);

			storetext(textarea);

			puttextindex(textnumber);

			putmaxtext(moetnumber, textnumber);

			if (user.memberinfo[moetnumber].lastread ==
				textnumber+meetinf.firsttext-1 &&
				moetnumber > 1)
					user.memberinfo[moetnumber].lastread=
						textnumber+meetinf.firsttext;

/*			if (typeflag != 0) msgdefault=2; */

			if (typeflag != 0 && wrmeet==tempmoet)
			{
/*	Rkna efter antalet befintliga kommentarer till texten. */
				i=gettextindex(moetnumber,
					(unsigned int)textnr);

				i=0;
				while( textindex.commlist[i] != 0L &&
					i < 80) i++;
				textindex.commlist[i]=textnumber+
					meetinf.firsttext;
				puttextindex((unsigned int)textnr);
			}

/*	Frigr lset igen! */

			close(lockf);
		}
		else
		{
			sprintf(fotxt, DISCARDTEXT);
			fpr(fotxt);
		}
	}
	else
	{
		sprintf(fotxt, DISCARDTEXT);
		fpr(fotxt);
	}

#ifdef MSDOS
	hfree(textarea);
#else
	free(textarea);
#endif

	moetnumber=mem;
	if (wrmeet == 1 && tempmoet == 1) nastamoete();
	getmaxtext(mem);

	if (msgdefault == 3 || msgdefault == 5) msgdefault=1;
}

/*	Skriv en vanlig text. */

void	writetext()
{

/*	Nr vi skriver en offentlig text, s skall det inte dirigeras hr
	vart den skall. */

	nodes.zone=sysdata.zone;
	nodes.net=sysdata.net;
	nodes.node=sysdata.node;
	nodecode.point=sysdata.point;

	if (moetnumber > 1) dowritetext(1, 0, "", 0, "");
	else
	{
		sprintf(fotxt, NOT_IN_MEET);
		fpr(fotxt);
	}
}
