/* TEXT2.C - Rutiner fr att hmta och lagra texter. */
/* (c) 1989, 1990 Nils Hammar */

/*	Programmet fr anvndas av vem som helst, helt eller delvis
	under frutsttning att kllan anges.
	Om koden anvnds i kommersiella programsystem gller det att
	kllan skall anges i dokumentationen.
*/

#include <stdio.h>

#ifndef __TURBOC__
#include <malloc.h>
#endif

#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <io.h>

#include "global.h"
#include "privs.h"

#ifndef MSDOS
#include <unistd.h>
#endif

/*	Inlgg som skall besvaras (Rundfrga) */
void	questiontext()
{
	nodes.zone=sysdata.zone;
	nodes.net=sysdata.net;
	nodes.node=sysdata.node;
	nodecode.point=sysdata.point;


	if (moetnumber > 1) dowritetext(3, 0, "", 0 , "");
	else
	{
		sprintf(fotxt, NOT_IN_MEET);
		fpr(fotxt);
	}
}

/*	Inlgg som skall besvaras (Publikfrga) */

void	pubquest()
{
	nodes.zone=sysdata.zone;
	nodes.net=sysdata.net;
	nodes.node=sysdata.node;
	nodecode.point=sysdata.point;

	if (moetnumber > 1) dowritetext(17, 0, "", 0, "");
	else
	{
		sprintf(fotxt, NOT_IN_MEET);
		fpr(fotxt);
	}
}

/*	Personligt brev som inte behver besvaras. */

void	personaltext2(userid)
char	*userid;
{
	int	usernr, mem, z, i, uxmail, netmail, crash;
	char	netuser[80];

	netmail=-1;
	strcpy(netuser,"");

	nodes.zone=sysdata.zone;
	nodes.net=sysdata.net;
	nodes.node=sysdata.node;
	nodecode.point=sysdata.point;

	crash=0;

	if ((instring("/C", userid) == 0) && (user.textprivs & MSG_SEEHM) != 0)
	{
		crash=32;
		while(*userid != ' ' && *userid != 0) userid++;
		while(*userid == ' ' && *userid != 0) userid++;
		if (*userid == 0) return;
	}

	if (instring("SYSOP", userid) == 0)
	{
		sprintf(fotxt, TOSYSOP);
		fpr(fotxt);
		strcpy(userid, "1");
	}

	uxmail=0; /* Om det r ett ntbrev till en UNIX-nod. */

	if (sscanf(userid, "%d", &usernr) != 1 &&
		strcmp(userid, "") != 0)
	{
		i=getmnodeinfo(userid);

		if (i != 0)
		{
			usernr=userfind(userid);
		}
		else
		{
			netmail=getnode();

			if (netmail < 0)
			{
				sprintf(fotxt, BADNODEID,
					nodecode.zone, nodecode.net,
					nodecode.node);

				fpr(fotxt);
			}

			i=0;
			while(*(userid + i) != 0 && uxmail == 0)
			{
				if (*(userid + i) == '') *(userid + i) = '@';

				if (*(userid + i) == '@' ||
					*(userid + i) == '.' ||
					*(userid + i) == '%' ||
					(*(userid + i) == ':' && 
					*(userid + i + 1) == ':')) uxmail=-1;
				i++;
			}

			i=0;
			while (*(userid + i) != ' ' && *(userid + i) != 0)
				i++;
			while (*(userid + i) == ' ' && *(userid + i) != 0)
				i++;

			z=0;

			if (uxmail == 0) z=nameconv(netuser, (userid + i));
			else strcpy(netuser, (userid + i));

			if (z==1) strcpy(netuser, (userid + i));

			sprintf(fotxt,MAILTONODE,
				nodes.zone, nodes.net, nodes.node,
				netuser);

			fpr(fotxt);

			if (strcmp(netuser, "") == 0)
			{
				fpr(NOUSERNAME);
				return;
			}
		}
	}

	if (netmail != 0)
	{
		if (usernr < 0 || (unsigned int)usernr > users) usernr=0;

		z=getuserinfo(usernr);
		strcpy(netuser, "");
	}

	if ((user2.status & POINT) != 0 && netmail != 0)
	{
		nodes.net=sysdata.net;
		nodes.node=sysdata.node;
		nodecode.point=usernr;
		strcpy(netuser, user2.username);
	}

	mem=moetnumber;

	moetnumber=1;
	z=getmaxtext(moetnumber);

	if (netmail == 0)
	{
		dowritetext((13 | crash), 0, netuser, 0, "");
	}
	else
	{
		if (usernr > 0)
		{
			sprintf(fotxt, MAILTOUSER, user2.username);
			fpr(fotxt);
			dowritetext(5, usernr, netuser, 0, "");
		}
		else
		{
			sprintf(fotxt, WRONG_USER);
			fpr(fotxt);
		}
	}

	moetnumber=mem;
	z=getmaxtext(moetnumber);
}

void	personaltext(userid)
char	*userid;
{
	int	usernr, mem, z, i, crash;
	char	slask[80], touser[80];

	if (strcmp(userid, "") != 0)
	{
		personaltext2(userid);
		return;
	}

	mem=moetnumber;

	moetnumber=1;
	getmaxtext(moetnumber);

	i=-1;
	while(i)
	{
		z=lineed(slask, "Nodnummer fr mottagande nod : ", "", 30, 0);
		newline();
		if (z<0) return;

		i=-1;

		if (strcmp(slask, "") == 0)
		{
			i=0;
			nodecode.zone=sysdata.zone;
			nodecode.net=sysdata.net;
			nodecode.node=sysdata.node;
			nodecode.point=sysdata.point;
		}
		else
		{
			if (getnodeinfo(slask) == 0)
			{
				z=getnode();
				if (z == 0) i=0;
			}
		}
	}

	if (nodecode.zone != sysdata.zone ||
		nodecode.net != sysdata.net ||
		nodecode.node != sysdata.node ||
		nodecode.point != sysdata.point)
	{
		sprintf(fotxt, "Mottagande nod : %d:%d/%d.%d\n",
				nodecode.zone, nodecode.net,
				nodecode.node, nodecode.point);
		fpr(fotxt);
	}

	z=lineed(touser, "Till vem : ", "", 36, 0);
	newline();
	if (z<0) return;

	if (nodecode.zone != sysdata.zone ||
		nodecode.net != sysdata.net ||
		nodecode.node != sysdata.node ||
		nodecode.point != sysdata.point)
	{
		crash=0;

		if ((user.textprivs & MSG_SEEHM) != 0)
		{
			z=lineed(slask, "r brevet brdskande ? (J/N) : ",
					"", 20, 0);
			newline();
			if (z<0) return;
			if (*slask == 'J' || *slask == 'j') crash=32;
		}

		dowritetext((13 | crash), 0, touser, 0, "");
	}
	else
	{
		usernr=0;
		if (sscanf(touser, "%d", &usernr) != 1)
			usernr=userfind(touser);

		if (usernr > 0 && strcmp(touser, "") != 0)
		{
			z=getuserinfo(usernr);
			sprintf(fotxt, MAILTOUSER, user2.username);
			fpr(fotxt);
			z=nameconv(slask, user2.username);
			dowritetext(5, usernr, slask, 0, "");
		}
		else
		{
			sprintf(fotxt, WRONG_USER);
			fpr(fotxt);
		}
	}

	moetnumber=mem;
	getmaxtext(moetnumber);
}

/*	Personligt brev som skall besvaras */

void	persquesttext2(userid)
char	*userid;
{
	int	usernr, mem, z, i, uxmail, netmail, crash;
	char	netuser[80];

	netmail=-1;
	strcpy(netuser,"");

	nodes.zone=sysdata.zone;
	nodes.net=sysdata.net;
	nodes.node=sysdata.node;
	nodecode.point=sysdata.point;

	crash=0;

	if ((instring("/C", userid) == 0) && (user.textprivs & MSG_SEEHM) != 0)
	{
		crash=32;
		while(*userid != ' ' && *userid != 0) userid++;
		while(*userid == ' ' && *userid != 0) userid++;
		if (*userid == 0) return;
	}

	if (instring("SYSOP", userid) == 0)
	{
		sprintf(fotxt, TOSYSOP);
		fpr(fotxt);
		strcpy(userid, "1");
	}

	uxmail=0; /* Om det r ett ntbrev till en UNIX-nod. */

	if (sscanf(userid, "%d", &usernr) != 1 &&
		strcmp(userid, "") != 0)
	{
		i=getmnodeinfo(userid);

		if (i != 0) usernr=userfind(userid);
		else
		{
			netmail=getnode();

			if (netmail < 0)
			{
				sprintf(fotxt, BADNODEID,
					nodecode.zone, nodecode.net,
					nodecode.node);

				fpr(fotxt);
			}

			i=0;
			while(*(userid + i) != 0 && uxmail == 0)
			{
				if (*(userid + i) == '') *(userid + i) = '@';

				if (*(userid + i) == '@' ||
					*(userid + i) == '.' ||
					*(userid + i) == '%') uxmail=-1;
				i++;
			}

			i=0;
			while (*(userid + i) != ' ' && *(userid + i) != 0)
				i++;
			while (*(userid + i) == ' ' && *(userid + i) != 0)
				i++;

			if (uxmail == 0) z=nameconv(netuser, (userid + i));
			else strcpy(netuser, (userid + i));

			if (z==1) strcpy(netuser, (userid + i));

			sprintf(fotxt,MAILTONODE,
				nodes.zone, nodes.net, nodes.node,
				netuser);

			fpr(fotxt);

			if (strcmp(netuser, "") == 0)
			{
				fpr(NOUSERNAME);
				return;
			}
		}
	}

	if (netmail != 0)
	{
		if (usernr < 0 || (unsigned int)usernr > users) usernr=0;

		z=getuserinfo(usernr);
		strcpy(netuser, "");
	}

	if ((user2.status & POINT) != 0 && netmail != 0)
	{
		nodes.net=sysdata.net;
		nodes.node=sysdata.node;
		nodecode.point=usernr;
		strcpy(netuser, user2.username);
	}

	mem=moetnumber;

	moetnumber=1;
	z=getmaxtext(moetnumber);

	if (netmail == 0)
	{
		dowritetext((15 | crash), 0, netuser, 0, "");
	}
	else
	{
		if (usernr > 0)
		{
			sprintf(fotxt, MAILTOUSER, user2.username);
			fpr(fotxt);
			dowritetext(7, usernr, netuser, 0, "");
		}
		else
		{
			sprintf(fotxt, WRONG_USER);
			fpr(fotxt);
		}
	}

	moetnumber=mem;
	z=getmaxtext(moetnumber);
}

void	persquesttext(userid)
char	*userid;
{
	int	usernr, mem, z, i, crash;
	char	slask[80], touser[80];

	if (strcmp(userid, "") != 0)
	{
		persquesttext2(userid);
		return;
	}

	mem=moetnumber;

	moetnumber=1;
	getmaxtext(moetnumber);

	i=-1;
	while(i)
	{
		z=lineed(slask, "Nodnummer fr mottagande nod : ", "", 30, 0);
		newline();
		if (z<0) return;

		i=-1;

		if (strcmp(slask, "") == 0)
		{
			i=0;
			nodecode.zone=sysdata.zone;
			nodecode.net=sysdata.net;
			nodecode.node=sysdata.node;
			nodecode.point=sysdata.point;
		}
		else
		{
			if (getnodeinfo(slask) == 0)
			{
				z=getnode();
				if (z == 0) i=0;
			}
		}
	}

	if (nodecode.zone != sysdata.zone ||
		nodecode.net != sysdata.net ||
		nodecode.node != sysdata.node ||
		nodecode.point != sysdata.point)
	{
		sprintf(fotxt, "Mottagande nod : %d:%d/%d.%d\n",
				nodecode.zone, nodecode.net,
				nodecode.node, nodecode.point);
		fpr(fotxt);
	}

	z=lineed(touser, "Till vem : ", "", 36, 0);
	newline();
	if (z<0) return;

	if (nodecode.zone != sysdata.zone ||
		nodecode.net != sysdata.net ||
		nodecode.node != sysdata.node ||
		nodecode.point != sysdata.point)
	{
		z=lineed(slask, "r brevet brdskande ? (J/N) : ", "", 20, 0);
		newline();
		if (z<0) return;

		crash=0;
		if (*slask == 'J' || *slask == 'j') crash=32;

		dowritetext((15 | crash), 0, touser, 0, "");
	}
	else
	{
		usernr=0;
		if (sscanf(touser, "%d", &usernr) != 1)
			usernr=userfind(touser);

		if (usernr > 0 && strcmp(touser, "") != 0)
		{
			z=getuserinfo(usernr);
			sprintf(fotxt, MAILTOUSER, user2.username);
			fpr(fotxt);
			z=nameconv(slask, user2.username);
			dowritetext(7, usernr, slask, 0, "");
		}
		else
		{
			sprintf(fotxt, WRONG_USER);
			fpr(fotxt);
		}
	}

	moetnumber=mem;
	getmaxtext(moetnumber);
}

/*	Begrnsa antalet lsta texter. */

void	endast(antal)
char	*antal;
{
	int	tmp, z;

	tmp=getmaxtext(moetnumber);

	while(strcmp(antal, "") == 0)
	{
		z=lineed(antal, ENDASTPAR, "", 70, 0);
		newline();
		if (z<0) return;
	}

	tmp=atoi(antal);

	if (tmp < 0)
	{
		sprintf(fotxt, ILLEGALTEXT);
		fpr(fotxt);
		return;
	}
	
	if (tmp <= (int)meetinf.texts)
	{
		user.memberinfo[moetnumber].lastread=
			meetinf.texts+meetinf.firsttext-tmp;

		if (tmp > 0) msgdefault=1;
		else msgdefault=2;
	}
	else
	{
		sprintf(fotxt, ILLEGALTEXT);
		fpr(fotxt);
	}
}

/*	Kommentera en text. */

void	kommtext(intext)
char	*intext;
{
	int	flag;
	char	text[80], *ff=" ";

	strcpy(text, intext);
	flag=0;

	if ((instring("/C", intext) == 0) && (user.textprivs & MSG_SEEHM) != 0)
	{
		strcpy(text, comndpar.par[1]);
		flag=32;
	}

	if (moetnumber > 1 || lastreadmail != 0)
	{
		if (lastreadmail == 0) dowritetext((1 | flag), 0, "", 1, text);
		else
		{
			dowritetext((5 | flag), 0, "", 1, text);
			msgdefault=2;
		}

		if (msgdefault == 3) msgdefault=1;

		if (meetinf.texts+meetinf.firsttext<=
			user.memberinfo[moetnumber].lastread) msgdefault=2;

		if (inputemails > 0) msgdefault=4;
	}
	else
	{	sprintf(fotxt, NOT_IN_MEET);
		fpr(fotxt);
	}
}

void	perskommtext(intext)
char	*intext;
{
	int	flag;
	char	text[80], *ff=" ";

	strcpy(text, intext);
	flag=0;

	if ((instring("/C", intext) == 0) && (user.textprivs & MSG_SEEHM) != 0)
	{
		strcpy(text, comndpar.par[1]);
		flag=32;
	}

	if (moetnumber > 1 || lastreadmail != 0)
	{
		dowritetext((5 | flag), 0, "", 1, text);
		msgdefault=1;

		if (meetinf.texts+meetinf.firsttext<=
			user.memberinfo[moetnumber].lastread) msgdefault=2;

		if (inputemails > 0) msgdefault=4;
	}
	else
	{
		sprintf(fotxt, NOT_IN_MEET);
		fpr(fotxt);
	}
}

/*	Radera ett mte. */

void	deletemoete(moete)
char	*moete;
{
	int	tmp, moetnr, moeten, i, z;
	char	text[80];

	while(strcmp(moete, "") == 0)
	{
		z=lineed(moete, DELMEETPAR, "", 70, 0);
		newline();
		if (z<0) return;
	}

	moetnr=atoi(moete)+1;

	if (moetnr == 1)
	{
		moetnr=getmoetnumber(moete, 2);
	}

	if (moetnr <= 2)
	{
		newline();
		fpr(WRONGMEET);
		return;
	}

	if ((user.textprivs & (MSG_DELAM | MSG_DELM)) == 0 ||
		(user.memberinfo[moetnr].moetstatus & ADMINISTRATOR) == 0)
	{
		fpr(NOKILLPRIV);
		logg(NOTKILLPRV, 1);
		return;
	}

	moeten=getmoeten();

	if (moetnr <= 1 || moetnr > moeten) moetnr=0;

	tmp=getmaxtext(moetnr);

	if (moetnr > 1)
	{
		sprintf(fotxt, OK_TO_DELMEET, meetinf.namn);
		fpr(fotxt);
		tmp=lineed(text, OKPROMPT, "", 5, 0);
		if (tmp != 0 || (*text != YES1 && *text != YES2)) moetnr=0;
	}

	if (moetnr > 1)
	{
		tmp=getmaxtext(moetnr);
		logg(MEETDELETED, 2);

		*meetinf.namn=0;
		*meetinf.echoarea=0;
		*meetinf.typ=0;
		*meetinf.dummy=0;
		meetinf.texts=0;
		meetinf.firsttext=0;
		meetinf.creator=0;
		meetinf.parameters=0;

		putmaxtext(moetnr, 0);

		user.memberinfo[moetnr].moetstatus=0;
		user.memberinfo[moetnr].lastread=0;

		updateuser(1);

		users=getusers();

		i=1;
		while (i<=(int)users)
		{
			getuserinfo(i);
			user2.memberinfo[moetnr].moetstatus=0;
			user2.memberinfo[moetnr].lastread=0;
			putuserinfo(i);
			i++;
		}

		if (moetnr == moeten)
		{
			moeten--;
			putmoeten(moeten);
		}

		sprintf(fotxt, DELETEDMEET);
		fpr(fotxt);
	}
}

/*	Radera en text. */

void	deletetext(text) /* text innehller logiskt textnummer. */
char	*text;
{
	int	textnr, tmp, z;

	while(strcmp(text, "") == 0)
	{
		z=lineed(text, DELTXTPAR, "", 70, 0);
		newline();
		if (z<0) return;
	}

	textnr=atoi(text);

/*	Konvertera till fysiskt textnummer. */

	tmp=getmaxtext(moetnumber);

	textnr=textnr-(unsigned int)meetinf.firsttext;

	if (textnr <= 0 || textnr > tmp)
	{
		sprintf(fotxt, ILLEGALTEXT);
		fpr(fotxt);
	}
	else
	{
		sprintf(fotxt, OK_TO_DELTEXT, textnr+meetinf.firsttext,
			meetinf.namn);
		fpr(fotxt);
		tmp=lineed(text, OKPROMPT, "", 5, 0);
		if (tmp != 0 || (*text != YES1 && *text != YES2)) textnr=0;

		tmp=gettextindex(moetnumber, textnr);

		if ((user.textprivs & (MSG_DELTXT | MSG_DELALL)) == 0 ||
			textindex.creator != usernumber &&
			(user.memberinfo[moetnumber].moetstatus & 2) == 0 &&
			(user.textprivs & MSG_DELALL) == 0)
		{
			sprintf(fotxt, NODELTXTPRIV);
			logg(NOTDELTXTPRV, 1);
			fpr(fotxt);
			return;
		}

		if (tmp == 0)
		{
			textindex.type = (textindex.type & 126);
			tmp=puttextindex(textnr);
			sprintf(fotxt, DELETEDTEXT);
			fpr(fotxt);
		}
	}
}

/*	Kolla brevldan, om det finns ngra nya brev. */

void	scanmail(userid)
char	*userid;
{
	int	i, z, n, usernr;

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	if (usernr < 0 || (unsigned int)usernr > users) usernr=0;

	if (usernr > 0)
	{
		z=getuserinfo(usernr);
		i=getmaxtext(1);

/*	Om brevldan har blivit rensad sedan du senast var inne, kan
	vi behva korrigera pekaren. */

		if ((unsigned int)usernr == usernumber)
			if (user.memberinfo[1].lastread < meetinf.firsttext)
				user.memberinfo[1].lastread=meetinf.firsttext;
		else
			if (user2.memberinfo[1].lastread < meetinf.firsttext)
				user2.memberinfo[1].lastread=meetinf.firsttext;

		n=0;

/*	Ta fram antal fysiskt okontrollerade texter. */

		if ((unsigned int)usernr == usernumber)
			i=(unsigned int)(user.memberinfo[1].lastread-
				meetinf.firsttext)+1;
		else
			i=(unsigned int)(user2.memberinfo[1].lastread-
				meetinf.firsttext)+1;

		while(i <= (int)meetinf.texts)
		{
			z=gettextindex(1, i);
			if ((int)textindex.kommusr == usernr &&
				textindex.destpoint == sysdata.point) n++;

			if ((unsigned int)usernr == usernumber && n == 0)
				user.memberinfo[1].lastread=
					i+meetinf.firsttext-1;

			if ((unsigned int)usernr != usernumber && n == 0)
				user2.memberinfo[1].lastread=
					i+meetinf.firsttext;

			i++;
		}

		if ((unsigned int)usernr != usernumber) putuserinfo(usernr);

		i=n;

		if (i == 1 && (unsigned int)usernr != usernumber)
		{
			sprintf(fotxt, MAILTOREAD, user2.username);
			fpr(fotxt);
		}

		if (i > 1 && (unsigned int)usernr != usernumber)
		{
			sprintf(fotxt, MAILSTOREAD, user2.username, i);
			fpr(fotxt);
		}

		if (i == 1 && (unsigned int)usernr == usernumber)
		{
			sprintf(fotxt, EMAILTOREAD);
			fpr(fotxt);
			inputemails=i;
		}

		if (i > 1 && (unsigned int)usernr == usernumber)
		{
			sprintf(fotxt, EMAILSTOREAD, i);
			fpr(fotxt);
			inputemails=i;
		}
	}
}

/*	Ls ett brev. */

void	readmail()
{
	int		counter;
	unsigned int	mail;

	textindex.type=0;
	lastreadmail=0;

/*	Vi lgger in en rknare ocks, fr att frhindra eventuella
	lsningar. */
	mail=inputemails;
	counter=0;

	strcpy(comndpar.par[1], "0");

	while (mail == inputemails && inputemails != 0 && counter < 100)
	{
		readtext(MAILING);
		counter++;
		lastreadmail=1;
	}

	if (inputemails == 0 &&
		(textindex.type & 2) == 0 && (textindex.type & 16) == 0)
		msgdefault=2;
}

/*	Lista rendena med det senaste frst. */
void	subjectlist()
{
	int		maxtext, z, moeten;
	unsigned int	rad;
	char		slask[40];

	newline();
	newline();

	moeten=getmoeten();
	rad=0;

	if (moetnumber < 2 || moetnumber > (unsigned int)moeten)
	{
		fpr(NOT_IN_MEET);
		return;
	}

	maxtext=getmaxtext(moetnumber);

	while (maxtext > 0)
	{
		z=gettextindex(moetnumber, maxtext);
		if (textindex.kommptr == 0)
		{
			sprintf(fotxt,
				"%6ld          %s\n                %s -> %s\n",
				maxtext+meetinf.firsttext, textindex.subject,
				textindex.creuser, textindex.touser);
			fpr(fotxt);
		}
		else
		{
			sprintf(fotxt,
				"%6ld  %6ld  %s\n                %s -> %s\n",
				maxtext+meetinf.firsttext,
				textindex.kommptr, textindex.subject,
				textindex.creuser, textindex.touser);
			fpr(fotxt);
		}

		rad++;
		rad++;

		if (rad > user.lines - 4)
		{
			strcpy(slask, PRESSRETURN);
			if (ansi == 1) sprintf(slask, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

			if (ansi == 2) sprintf(slask, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			z=lineed(fotxt, slask, "", 20, 1);
			newline();
			if (z < 0 || *fotxt != 0)
			{
				newline();
				return;
			}
			rad=0;
		}

		maxtext--;
	}
	newline();
}

void	statuser(userid)
char	*userid;
{
	int		usernr, i, z;
	unsigned int	rad;
	char		slask[80];

	updateuser(1);

	usernr=atoi(userid);

	if (usernr == 0 && strcmp(userid, "") != 0) usernr=userfind(userid);

	if (usernr < 0 || (unsigned int)usernr > users) usernr=0;

	if (usernr != 0) z=getuserinfo(usernr);
	if (usernr == 0)
	{
		fpr(WRONGUSERID);
		return;
	}

	if ((unsigned int)usernr != usernumber &&
		(user.maintprivs & SYS_SHOWUSR) == 0)
	{
		fpr(NOSHOWUSER);
		logg(NOTSHOWUSER, 1);
		return;
	}

	sprintf(fotxt, USERINFO1, user2.username, usernr, user2.lastlogin);
	fpr(fotxt);
	fpr(USERINFO2);

	rad=5;
	for (i=1;i<256;i++)
	{
		if ((user2.memberinfo[i].moetstatus & 1) != 0)
		{
			z=getmaxtext(i);
			sprintf(fotxt,"%6ld   %s\n",
				meetinf.firsttext + meetinf.texts -
				user2.memberinfo[i].lastread,
				meetinf.namn);
			fpr(fotxt);
			rad++;

			if (rad > user.lines - 4)
			{
				strcpy(slask, PRESSRETURN);
				if (ansi == 1) sprintf(slask, "%s%s%s",
							ansicol[14],
							PRESSRETURN,
							ansicol[7]);
				if (ansi == 2) sprintf(slask, "%s%s%s",
							ansicol[21],
							PRESSRETURN,
							ansicol[20]);
				z=lineed(fotxt, slask, "", 20, 1);
				newline();
				if (z < 0 || *fotxt != 0)
				{
					newline();
					return;
				}
				rad=0;
			}
		}
	}
}

void	statmeet(moete)
char	*moete;
{
	int		moeten, moetnr, z, i;
	unsigned int	rad;
	char		tmp[10], slask[80];

	updateuser(1);

	moeten=getmoeten();

	moetnr=atoi(moete)+1;

	if (moetnr == 1)
	{
		moetnr=getmoetnumber(moete, 2);
	}

	if (moetnr <= 1)
	{
		fpr(NOMEET);
		return;
	}

	if (moetnr < 1 || moetnr > moeten) moetnr=0;

	if (moetnr == 0)
	{
		fpr(ILLPARAM);
		return;
	}

	z=getmaxtext(moetnr);

	sprintf(fotxt, MEETINFO1, meetinf.namn, moetnr - 1);
	fpr(fotxt);
	sprintf(fotxt, MEETINFO2, meetinf.texts);
	fpr(fotxt);
	fpr(MEETINFO3);

	rad=5;
	for (i=1;i<=(int)users;i++)
	{
		z=getuserinfo(i);

		if ((user2.memberinfo[moetnr].moetstatus & 3) != 0)
		{
			strcpy(tmp,"     ");

			if ((user2.memberinfo[moetnr].moetstatus & 3) == 2)
				*tmp='a';

			if ((user2.memberinfo[moetnr].moetstatus & 3) == 3)
				*tmp='A';

			if ((user2.memberinfo[moetnr].moetstatus & 4) == 4)
				*(tmp + 1)='R';

			if ((user2.memberinfo[moetnr].moetstatus & 8) == 8)
				*(tmp + 2)='W';

			if ((user2.memberinfo[moetnr].moetstatus & 16) == 16)
				*(tmp + 3)='C';

			if ((user2.memberinfo[moetnr].moetstatus & 32) == 32)
				*(tmp + 4)='Q';

			if (ansi == 0)
			{
				sprintf(fotxt,"%6ld %s (%d) %s\n",
					meetinf.firsttext + meetinf.texts -
					user2.memberinfo[moetnr].lastread,
					tmp,
					i,
					user2.username);
			}

			if (ansi == 1 && *tmp == 'a')
			{
				sprintf(fotxt,"%s%6ld %s (%d) %s%s\n",
					ansicol[11],
					meetinf.firsttext + meetinf.texts -
					user2.memberinfo[moetnr].lastread,
					tmp,
					i,
					user2.username,
					ansicol[7]);
			}

			if (ansi == 1 && *tmp == 'A')
			{
				sprintf(fotxt,"%s%6ld %s (%d) %s%s\n",
					ansicol[12],
					meetinf.firsttext + meetinf.texts -
					user2.memberinfo[moetnr].lastread,
					tmp,
					i,
					user2.username,
					ansicol[7]);
			}

			if (ansi == 1 && *tmp != 'a' && *tmp != 'A')
			{
				sprintf(fotxt,"%s%6ld %s (%d) %s%s\n",
					ansicol[13],
					meetinf.firsttext + meetinf.texts -
					user2.memberinfo[moetnr].lastread,
					tmp,
					i,
					user2.username,
					ansicol[7]);
			}

			if (ansi == 2 && *tmp == 'a')
			{
				sprintf(fotxt,"%s%6ld %s (%d) %s%s\n",
					ansicol[22],
					meetinf.firsttext + meetinf.texts -
					user2.memberinfo[moetnr].lastread,
					tmp,
					i,
					user2.username,
					ansicol[20]);
			}

			if (ansi == 2 && *tmp == 'A')
			{
				sprintf(fotxt,"%s%6ld %s (%d) %s%s\n",
					ansicol[21],
					meetinf.firsttext + meetinf.texts -
					user2.memberinfo[moetnr].lastread,
					tmp,
					i,
					user2.username,
					ansicol[20]);
			}

			if (ansi == 2 && *tmp != 'a' && *tmp != 'A')
			{
				sprintf(fotxt,"%s%6ld %s (%d) %s%s\n",
					ansicol[18],
					meetinf.firsttext + meetinf.texts -
					user2.memberinfo[moetnr].lastread,
					tmp,
					i,
					user2.username,
					ansicol[20]);
			}

			fpr(fotxt);
			rad++;

			if (rad > user.lines - 4)
			{
				strcpy(slask, PRESSRETURN);
				if (ansi == 1) sprintf(slask, "%s%s%s",
							ansicol[14],
							PRESSRETURN,
							ansicol[7]);

				if (ansi == 2) sprintf(slask, "%s%s%s",
							ansicol[21],
							PRESSRETURN,
							ansicol[20]);

				z=lineed(fotxt, slask, "", 20, 1);
				newline();
				if (z < 0 || *fotxt != 0)
				{
					newline();
					return;
				}
				rad=0;
			}
		}
	}
}

void	statmail()
{
	int		z, i;
	unsigned int	rad;
	char		tmp[80], slask[80];

	z=getmaxtext(1);

	fpr(YOURMAILSTATUS);

	rad=5;

	for (i=(unsigned int)meetinf.texts;i>=1;i--)
	{
		z=gettextindex(1, i);

		tidkonv((long int *)&textindex.cretime, tmp);

		z=getuserinfo(textindex.kommusr);

/*	Skickat, men nnu ej lst lokalt brev. */

		if (textindex.creator == usernumber &&
			user2.memberinfo[1].lastread <
			i + meetinf.firsttext &&
			textindex.kommusr > 0)
		{
			sprintf(fotxt, "%6ld %s >   %s (%d)\n",
				i+meetinf.firsttext,
				tmp,
				user2.username,
				textindex.kommusr);

			if (ansi == 1)
				sprintf(fotxt, "%s%6ld %s >   %s (%d)%s\n",
					ansicol[11],
					i+meetinf.firsttext,
					tmp,
					user2.username,
					textindex.kommusr,
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt, "%s%6ld %s >   %s (%d)%s\n",
					ansicol[21],
					i+meetinf.firsttext,
					tmp,
					user2.username,
					textindex.kommusr,
					ansicol[20]);

			fpr(fotxt);
			rad++;
		}

/*	Skickat och lst lokalt brev. */

		if (textindex.creator == usernumber &&
			user2.memberinfo[1].lastread >=
			i + meetinf.firsttext &&
			textindex.kommusr > 0)
		{
			sprintf(fotxt, "%6ld %s > * %s (%d)\n",
				i+meetinf.firsttext,
				tmp,
				user2.username,
				textindex.kommusr);

			if (ansi == 1)
				sprintf(fotxt, "%s%6ld %s > * %s (%d)%s\n",
					ansicol[12],
					i+meetinf.firsttext,
					tmp,
					user2.username,
					textindex.kommusr,
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt, "%s%6ld %s > * %s (%d)%s\n",
					ansicol[21],
					i+meetinf.firsttext,
					tmp,
					user2.username,
					textindex.kommusr,
					ansicol[20]);

			fpr(fotxt);
			rad++;
		}

/*	Skickat ntbrev till huvudnod. */

		if (textindex.creator == usernumber &&
			textindex.kommusr == 0 &&
			textindex.destpoint == 0)
		{
			sprintf(fotxt,
				"%6ld %s > * (%d:%d/%d) %s\n",
				i+meetinf.firsttext,
				tmp,
				textindex.destzone,
				textindex.destnet,
				textindex.destnode,
				textindex.touser);

			if (ansi == 1)
				sprintf(fotxt,
					"%s%6ld %s > * (%d:%d/%d) %s%s\n",
					ansicol[15],
					i+meetinf.firsttext,
					tmp,
					textindex.destzone,
					textindex.destnet,
					textindex.destnode,
					textindex.touser,
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s%6ld %s > * (%d:%d/%d) %s%s\n",
					ansicol[21],
					i+meetinf.firsttext,
					tmp,
					textindex.destzone,
					textindex.destnet,
					textindex.destnode,
					textindex.touser,
					ansicol[20]);

			fpr(fotxt);
			rad++;
		}

/*	Skickat ntbrev till point. */

		if (textindex.creator == usernumber &&
			textindex.kommusr == 0 &&
			textindex.destpoint != 0)
		{
				sprintf(fotxt,
					"%6ld %s > * (%d:%d/%d.%d) %s\n",
					i+meetinf.firsttext,
					tmp,
					textindex.destzone,
					textindex.destnet,
					textindex.destnode,
					textindex.destpoint,
					textindex.touser);

			if (ansi == 1)
				sprintf(fotxt,
					"%s%6ld %s > * (%d:%d/%d.%d) %s%s\n",
					ansicol[15],
					i+meetinf.firsttext,
					tmp,
					textindex.destzone,
					textindex.destnet,
					textindex.destnode,
					textindex.destpoint,
					textindex.touser,
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s%6ld %s > * (%d:%d/%d.%d) %s%s\n",
					ansicol[21],
					i+meetinf.firsttext,
					tmp,
					textindex.destzone,
					textindex.destnet,
					textindex.destnode,
					textindex.destpoint,
					textindex.touser,
					ansicol[20]);

			fpr(fotxt);
			rad++;
		}

/*	Mottaget lokalt brev. */

		if (textindex.kommusr == usernumber &&
			textindex.creator > 0)
		{
			z=getuserinfo(textindex.creator);

			sprintf(fotxt, "%6ld %s <   %s (%d)\n",
				i+meetinf.firsttext,
				tmp,
				user2.username,
				textindex.creator);

			if (ansi == 1)
				sprintf(fotxt, "%s%6ld %s <   %s (%d)%s\n",
					ansicol[16],
					i+meetinf.firsttext,
					tmp,
					user2.username,
					textindex.creator,
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt, "%s%6ld %s <   %s (%d)%s\n",
					ansicol[21],
					i+meetinf.firsttext,
					tmp,
					user2.username,
					textindex.creator,
					ansicol[20]);

			fpr(fotxt);
			rad++;
		}

/*	Mottaget ntbrev frn huvudnod. */

		if (textindex.kommusr == usernumber &&
			textindex.creator == 0 &&
			textindex.crepoint == 0)
		{
			sprintf(fotxt,
				"%6ld %s <   (%d:%d/%d) %s\n",
				i+meetinf.firsttext,
				tmp,
				textindex.crezone,
				textindex.crenet,
				textindex.crenode,
				textindex.creuser);

			if (ansi == 1)
				sprintf(fotxt,
					"%s%6ld %s <   (%d:%d/%d) %s%s\n",
					ansicol[16],
					i+meetinf.firsttext,
					tmp,
					textindex.crezone,
					textindex.crenet,
					textindex.crenode,
					textindex.creuser,
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s%6ld %s <   (%d:%d/%d) %s%s\n",
					ansicol[21],
					i+meetinf.firsttext,
					tmp,
					textindex.crezone,
					textindex.crenet,
					textindex.crenode,
					textindex.creuser,
					ansicol[20]);

			fpr(fotxt);
			rad++;
		}

/*	Mottaget ntbrev frn point. */

		if (textindex.kommusr == usernumber &&
			textindex.creator == 0 &&
			textindex.crepoint != 0)
		{
			sprintf(fotxt,
				"%6ld %s <   (%d:%d/%d.%d) %s\n",
				i+meetinf.firsttext,
				tmp,
				textindex.crezone,
				textindex.crenet,
				textindex.crenode,
				textindex.crepoint,
				textindex.creuser);

			if (ansi == 1)
				sprintf(fotxt,
					"%s%6ld %s <   (%d:%d/%d.%d) %s%s\n",
					ansicol[16],
					i+meetinf.firsttext,
					tmp,
					textindex.crezone,
					textindex.crenet,
					textindex.crenode,
					textindex.crepoint,
					textindex.creuser,
					ansicol[7]);

			if (ansi == 2)
				sprintf(fotxt,
					"%s%6ld %s <   (%d:%d/%d.%d) %s%s\n",
					ansicol[21],
					i+meetinf.firsttext,
					tmp,
					textindex.crezone,
					textindex.crenet,
					textindex.crenode,
					textindex.crepoint,
					textindex.creuser,
					ansicol[20]);

			fpr(fotxt);
			rad++;
		}

		if (rad > user.lines - 4)
		{
			strcpy(slask, PRESSRETURN);
			if (ansi == 1) sprintf(slask, "%s%s%s",
						ansicol[14],
						PRESSRETURN,
						ansicol[7]);

			if (ansi == 2) sprintf(slask, "%s%s%s",
						ansicol[21],
						PRESSRETURN,
						ansicol[20]);

			z=lineed(fotxt, slask, "", 20, 1);
			newline();
			if (z < 0 || *fotxt != 0)
			{
				newline();
				return;
			}
			rad=0;
		}
	}
}

void	stattext(val, param)
char	*val, *param;
{
	long int	text;
	int		moetnr, mem, moeten, z;
	char		*moete, tmp[80];

	newline();
	newline();

	updateuser(1);

	mem=moetnumber;

	text=atoi(val);

	moete=getuserid(param, 1);

	if (text == 0)
	{
		fpr(ILLPARAM);
		newline();
		return;
	}

	moeten=getmoeten();

	moetnr=atoi(moete)+1;

/*	if (moetnr == 1)
	{
		moetnr=getmoetnumber(moete, 0);
	}

	if (moetnr <= 1)
	{
		fpr(NOMEET);
		return;
	}

	if (moetnr < 1 || moetnr > moeten) moetnr=0;

	if (moetnr == 0)
	{
		fpr(ILLPARAM);
		return;
	} */

	moetnumber=moetnr;

	z=getmaxtext(moetnr);

	text=text-meetinf.firsttext;

	z=gettextindex(moetnumber, (unsigned int)text);

	tidkonv(&textindex.cretime, tmp);

	sprintf(fotxt, TEXTINFO10, meetinf.namn, meetinf.echoarea);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO20, meetinf.typ,
		meetinf.texts, meetinf.firsttext);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO30, meetinf.creator, meetinf.parameters);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO40, meetinf.defcharset);
	fpr(fotxt);
	fpr(TEXTINFO50);
	sprintf(fotxt, TEXTINFO60, textindex.startpos,
		textindex.len, textindex.type);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO70, textindex.creuser, textindex.creator);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO80, textindex.kommptr,
		textindex.touser, textindex.kommusr);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO90, tmp);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO100, textindex.subject);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO110, textindex.msgid, textindex.tclinfo);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO120,
		textindex.crezone, textindex.crenet,
		textindex.crenode, textindex.crepoint);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO130, textindex.fromnet, textindex.fromnode);
	fpr(fotxt);
	sprintf(fotxt, TEXTINFO140,
		textindex.destzone, textindex.destnet,
		textindex.destnode, textindex.destpoint);
	fpr(fotxt);

	moetnumber=mem;
	getmaxtext(moetnumber);
}

void	status(val, val2, parameters)
char	*val, *val2, *parameters;
{
	int	i;
	char	*tmppar;

	i=0;
	newline();

	tmppar=getuserid(parameters, 1);

	if (strcmp(val, "") == 0)
	{
		while (i < 4)
		{
			sprintf(fotxt, "%s\n", stattypes[i]);
			fpr(fotxt);
			i++;
		}
		return;
	}

	while (i < 4 && instring(val, stattypes[i]) != 0) i++;

	if (i >= 4)
	{
		fpr(ILLPARAM);
		return;
	}

	switch (i)
	{
		case 0 : statuser(tmppar); break;
		case 1 : statmeet(tmppar); break;
		case 2 : statmail(); break;
		case 3 : stattext(val2, tmppar); break;
	}
}

void	movetext(param)
char	*param;
{
	unsigned int		mem, moetnr, moeten;
	int			z;
	char			*textarea, tmp[80];
	unsigned long int	startpos;

	newline();

	moeten=getmoeten();

	if ((user.textprivs & MSG_DELALL) == 0)
	{
		fpr(NOPRIV);
		return;
	}

	if (lasttext==0L)
	{
		fpr(NOTREAD);
		return;
	}

	while(strcmp(param, "") == 0)
	{
		z=lineed(param, MOVETEXTPAR, "", 70, 0);
		newline();
		if (z<0) return;
	}

#ifdef MSDOS
	textarea=halloc((unsigned long int)MAXLINES *
		(unsigned long int)LINELENGTH, sizeof(char));
#else
	textarea=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

	if (textarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	mem=moetnumber;

	moetnr=atoi(param)+1;

	if (moetnr <= 1) moetnr=getmoetnumber(param, 1);

	if (moetnr <= 1 || moetnr > moeten)
	{
		fpr(NOMEET);
		return;
	}

	z=getmaxtext(moetnr);

	sprintf(tmp, MOVEDTOAREA, meetinf.firsttext+meetinf.texts,
		meetinf.namn);

	strcpy(textarea, tmp);

	z=gettextindex(moetnr, (unsigned int)meetinf.texts);
	startpos=textindex.startpos+textindex.len;

	z=getmaxtext(moetnumber);
	z=gettextindex(moetnumber, (unsigned int)(lasttext-meetinf.firsttext));


	gettxt((textarea + strlen(tmp)),
		(unsigned int)(lasttext-meetinf.firsttext));
	textindex.len=textindex.len+strlen(tmp);
	textindex.startpos=startpos;

	moetnumber=moetnr;
	z=getmaxtext(moetnumber);
	meetinf.texts++;

	storetext(textarea);
	puttextindex((unsigned int)meetinf.texts);
	putmaxtext(moetnumber, (unsigned int)meetinf.texts);

	sprintf(fotxt, MOVEDTEXT, meetinf.namn);
	fpr(fotxt);

	moetnumber=mem;
	getmaxtext(moetnumber);

#ifdef MSDOS
	hfree(textarea);
#else
	free(textarea);
#endif
}

void	savetext(textid)
char	*textid;
{
	unsigned char		*textarea, tmp[80];
	unsigned int		i;
	long int		textnr;
	FILE			*f;

	textnr=atoi(textid);

	if (textnr == 0L) textnr=lasttext;

	if (lastreadmail != 0)
	{
		moetnumber=1;
		getmaxtext(moetnumber);
	}

	textnr=textnr-meetinf.firsttext;

	if (textnr < 0 || textnr > meetinf.texts)
	{
		fpr(ILLPARAM);
		return;
	}

#ifdef MSDOS
	textarea=halloc((unsigned long int)MAXLINES *
		(unsigned long int)LINELENGTH, sizeof(char));
#else
	textarea=calloc(MAXLINES * LINELENGTH, sizeof(char));
#endif

	if (textarea == NULL)
	{
		printf(ALLOCERROR);
		logg(ALLOCERROR, 0);
		exit(9);
	}

	gettxt(textarea, (int)textnr);

	if (lastreadmail == 0)
	{
		sprintf(tmp, "T%02x%05u.TXT", moetnumber,
			textnr+meetinf.firsttext);
	}
	else
	{
		sprintf(tmp, "T01%05u.TXT", lasttext);
	}

	f=fopen(tmp, "at");

	if (f == NULL)
	{
		perror(tmp);
		exit(9);
	}

	i=0;
	while(*(textarea + i) != 0)
	{
		if (*(textarea + i) == '\n') i++; /* LF */
		if (*(textarea + i) == 0x8d) i++; /* Soft CR */
		if (*(textarea + i) == '\r') *(textarea + i)='\n'; /* CR */
		if (*(textarea + i) == 1) i++; /* Kludge */

		fputc(*(textarea + i), f);
		i++;
	}

#ifdef MSDOS
	hfree(textarea);
#else
	free(textarea);
#endif

	fclose(f);
}
