/* TIDEN.C - Rutiner fr hantering av tiden. */
/* "AURORA" (c) 1989, 1990 Nils Hammar */

/*	This code may be used complete or partly by anyone as long as
	i am credited for being involved in the source.
	The credits MUST appear possible to read when starting the derived
	program, and in the documentation and manual in the form:
	"Contains code (c) 1990 Nils Hammar" in any language of:
	Swedish, English or German preferably.

	It is free to spread this code and programs hereof both free
	and if code is added for money as long as i am credited for it.
	Excluding of code MUST be by comments, and when code is included
	there MUST be a comment which describes WHO has done it, WHY,
	and WHEN. All changes and additions should be reported to me
	to determine if they should be included in further versions.

	All necessary text translations will be in GLOBAL.H and
	possibly in PRIVS.H if translation to another language is necessary.

	Extensions of H-files in different languages:
	.SWE	Swedish
	.ENG	English
	.SUO	Finnish
	.GER	German

	Adding code to one file MUST be added to the others, in
	at least english.
*/

#include <stdio.h>
#include <time.h>

#ifdef MSDOS
#include <dos.h>
#endif

#include <string.h>
#include "global.h"

/*	Bde mnadslistan och veckolistan mste ha en "extra" post
	som r tom, ifall veckodag eller mnad inte hittas! */

char	*monthslst[13]={"Jan","Feb","Mar","Apr","May","Jun",
			"Jul","Aug","Sep","Oct","Nov","Dec",""},
	*weeklst[8]={"Mon","Tue","Wed","Thu","Fri","Sat","Sun",""};

int	monthdays[12]={31,28,31,30,31,30,31,31,30,31,30,31};

/*	Ta fram aktuell tidpunkt. Datum och klockslag. */

void	tidkonv(klocka,uttid)
long int	*klocka;
char	*uttid;
{
	int	i;

/*	tid=localtime(klocka); */
	tid=gmtime(klocka);

	sprintf(uttid,"%4d-%2d-%2d %2d:%2d:%2d",
		1900+tid->tm_year,
		tid->tm_mon + 1,
		tid->tm_mday,
		tid->tm_hour,
		tid->tm_min,
		tid->tm_sec);

	for (i=0;i<=18;i++)
	{
		if (*(uttid + i) == ' ' && i != 10) *(uttid + i) = '0';
	}
}

void	ftidkonv(klocka,uttid)
long int	*klocka;
char	*uttid;
{
	unsigned int	i, month, year;

/*	tid=localtime(klocka); */
	tid=gmtime(klocka);

	year=tid->tm_year;
	month= tid->tm_mon;

	while (year > 100) year=year-100;

	sprintf(uttid,"%2d %s %2d %2d:%2d:%2d",
		tid->tm_mday,
		monthslst[month],
		year,
		tid->tm_hour,
		tid->tm_min,
		tid->tm_sec);

	for (i=0;i<=18;i++)
	{
		if (*(uttid + i) == ' ' && i != 2 && i != 6 && i != 9)
			*(uttid + i) = '0';
	}
}

void		dtidkonv(tid, dat, uttid)
unsigned int	tid, dat;
char		*uttid;
{
	unsigned int	yr, mon, day, hr, min, sec, tdat, ttid;

	tdat=dat;
	ttid=tid;

	yr=tdat/512;
	tdat=tdat-yr*512;

	mon=tdat/32;
	day=tdat-mon*32;

	hr=ttid/2048;
	ttid=ttid-hr*2048;

	min=ttid/32;
	sec=(ttid-min*32)*2;	

	sprintf(uttid, "%4d-%02d-%02d %02d:%02d:%02d",
		yr+1980, mon, day, hr, min, sec);
}

/*	Redovisa tiden i lokalt format, med hnsyn till TZ. */

void	tidkonvl(klocka,uttid)
long int	*klocka;
char	*uttid;
{
	int	i;

	tid=localtime(klocka);

	sprintf(uttid,"%4d-%2d-%2d %2d:%2d:%2d",
		1900+tid->tm_year,
		tid->tm_mon + 1,
		tid->tm_mday,
		tid->tm_hour,
		tid->tm_min,
		tid->tm_sec);

	for (i=0;i<=18;i++)
	{
		if (*(uttid + i) == ' ' && i != 10) *(uttid + i) = '0';
	}
}

void	ftidkonvl(klocka,uttid)
long int	*klocka;
char	*uttid;
{
	unsigned int	i, month, year;

	tid=localtime(klocka);

	year=tid->tm_year;
	month= tid->tm_mon;

	while (year > 100) year=year-100;

	sprintf(uttid,"%2d %s %2d %2d:%2d:%2d",
		tid->tm_mday,
		monthslst[month],
		year,
		tid->tm_hour,
		tid->tm_min,
		tid->tm_sec);

	for (i=0;i<=18;i++)
	{
		if (*(uttid + i) == ' ' && i != 2 && i != 6 && i != 9)
			*(uttid + i) = '0';
	}
}

/*	Fixa till tiden i textformat. */

void	tiden(uttid)
char	*uttid;
{
	long int	klocka[1];

	time(klocka);
	tidkonv(klocka,uttid);
}

void	ftiden(uttid)
char	*uttid;
{
	long int	klocka[1];

	time(klocka);
	ftidkonv(klocka, uttid);
}

void	tidenl(uttid)
char	*uttid;
{
	long int	klocka[1];

	time(klocka);
	tidkonvl(klocka,uttid);
}

void	ftidenl(uttid)
char	*uttid;
{
	long int	klocka[1];

	time(klocka);
	ftidkonvl(klocka, uttid);
}

#ifndef __TURBOC__

void	sleep(tid)
int	tid;
{
	long int	klocka[1], tid1;

	tid1=time(klocka);

	while((tid1 + tid) > time(klocka));
}

#endif

/*	Redovisa tiden i lite annat format. Ange antal dagar i stllet
	fr ett datum. (En relativ tidsredovisning.) */

void	tidkonv2(intid, uttid)
unsigned long int	intid;
char	*uttid;
{
	unsigned long int	days, hrs, mins, i;

	days=intid/86400;
	intid=intid - 86400*days;

	hrs=intid/3600;
	intid=intid - 3600*hrs;

	mins=intid/60;
	intid=intid - 60*mins;

	sprintf(uttid,"%5ld %2ld:%2ld:%2ld", days, hrs, mins, intid);

	for (i=6;i<=13;i++)
	{
		if (*(uttid + i) == ' ') *(uttid + i) = '0';
	}
}

unsigned long int	ftimetol(timestr)
char	*timestr;
{
	unsigned int		year, day, month, hour, min, sec, i;
	char			tmp[80], tmp2[80];
	unsigned long int	testa, z;

	sscanf(timestr, "%3s %2d %3s %2d %2d:%2d:%2d",
		tmp2, &day, tmp, &year, &hour, &min, &sec);

	i=0;
	while(strcmp(tmp2, weeklst[i]) != 0 && i<7) i++;

	if (i == 7)
	{
		sscanf(timestr, "%2d %3s %2d %2d:%2d:%2d",
			&day, tmp, &year, &hour, &min, &sec);
	}

	if (year < 70) year=year+100;

	month=0;
	i=-1;
	upper(tmp2, tmp);
	while(i != 0 && month <= 11)
	{
		upper(tmp, monthslst[month]);
		i=strcmp(tmp2, tmp);
		month++;
	}

	if (month > 12) return(0L);

	i=0;
	z=0L;
	while (i < (month-1))
	{
		z=z + monthdays[i];
		i++;
	}

	i=70;

/*	En nstan riktig skottrsberkning. */

	while(i<year)
	{
		if (i % 4 == 0) z++;
		i++;
	}

	if (year % 4 == 0 && month>2) z++;

/*	Fixa s att det blir sedan 1970! */

	year=year-70;

	day--;

	testa=(unsigned long int)sec+
		60       * (unsigned long int)min+
		3600     * (unsigned long int)hour+
		86400    * (unsigned long int)day+
		86400    * z+
		31536000 * (unsigned long int)year;
		
	return(testa);
}

unsigned long int	itimetol(timestr)
char	*timestr;
{
	unsigned int		year, day, month, hour, min, sec, i;
	unsigned long int	testa, z;

	sscanf(timestr, "%4d-%2d-%2d %2d:%2d:%2d",
		&year, &month, &day, &hour, &min, &sec);

	if (year > 99) year=year-1900;
	if (year < 70) year=year+100;

	i=0;
	z=0L;
	while (i < (month-1))
	{
		z=z + monthdays[i];
		i++;
	}

	i=70;

/*	En nstan riktig skottrsberkning. */

	while(i<year)
	{
		if (i % 4 == 0) z++;
		i++;
	}

	if (year % 4 == 0 && month>2) z++;

/*	Fixa s att det blir sedan 1970! */

	year=year-70;

	day--;

	testa=(unsigned long int)sec+
		60       * (unsigned long int)min+
		3600     * (unsigned long int)hour+
		86400    * (unsigned long int)day+
		86400    * z+
		31536000 * (unsigned long int)year;
		
	return(testa);
}

unsigned long int	dtimetol(tid, dat)
unsigned int		tid, dat;
{
	unsigned int		yr, mon, day, hr, min, sec, tdat, ttid, i;
	unsigned long int	z, testa;

	tdat=dat;
	ttid=tid;

	yr=tdat/512;
	tdat=tdat-yr*512;

	mon=tdat/32;
	day=tdat-mon*32;

	hr=ttid/2048;
	ttid=ttid-hr*2048;

	min=ttid/32;
	sec=(ttid-min*32)*2;	

	i=0;
	z=0L;
	while (i < (mon-1))
	{
		z=z + monthdays[i];
		i++;
	}

	yr=yr+80;

	i=70;

/*	En nstan riktig skottrsberkning. */

	while(i<yr)
	{
		if (i % 4 == 0) z++;
		i++;
	}

	if (yr % 4 == 0 && mon>2) z++;

	yr=yr-70;

	day--;

	testa=(long)sec+
		60L       * (long)min+
		3600L     * (long)hr+
		86400L    * (long)day+
		86400L    * z+
		31536000L * (long)yr;

	return(testa);
}

/*	Den hr funktionen lgger skillnaden mellan lokal tid och GMT
	i variabeln "tzdiff". Detta fr att man skall kunna hantera bde
	GMT och lokal tid i systemet om man vill. Nu kr vi dock med
	enbart GMT, men stter systemklockan till lokal tid, s
	det blir verkligen lokal tid. GMT-funktionen kan dock vara intressant
	om man kr med tv system i olika tidszoner. D fr man dock tnka p
	att texterna mellan systemen skall vara GMT, medan de lokalt skall
	vara lokal tid! Detta r dock inte implementerat. */

void	timediff()
{
	char			tids[80];
	unsigned long int	tidn, tidr[1];

	ftidenl(tids);
	tidn=ftimetol(tids);
	time(tidr);
	tzdiff=(unsigned int)(tidn-*tidr);
}

int	dayofweek()
{
	long int	klocka[1];

	time(klocka);
	tid=gmtime(klocka);

	return(tid->tm_wday);
}

int	dayofyear()
{
	long int	klocka[1];

	time(klocka);
	tid=gmtime(klocka);

	return(tid->tm_yday);
}

int	hourofday()
{
	long int	klocka[1];

	time(klocka);
	tid=gmtime(klocka);

	return(tid->tm_hour);
}
