/* Top level entry point of bison,
   Copyright (C) 1984, 1986, 1989 Free Software Foundation, Inc.

This file is part of Bison, the GNU Compiler Compiler.

Bison is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Bison is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Bison; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdio.h>
#include "system.h"
#include "machine.h"	/* JF for MAXSHORT */

extern	int lineno;
extern	int verboseflag;

/* Nonzero means failure has been detected; don't write a parser file.  */
int failure;

/* The name this program was run with, for messages. */
char *program_name;

extern void getargs(), openfiles(), reader(), reduce_grammar();
extern void set_derives(), set_nullable(), generate_states();
extern void lalr(), initialize_conflicts(), verbose(), terse();
extern void output(), done();
extern void dummy();

/* The following was added by FS to allow the directory where
** bison.exe was found to be added to the search path for the
** parser (see also files.c)
*/
#ifdef MSDOS
#include <dos.h>
#include <string.h>

char *parser_dir;	/* if needed, look here for parser file */

static char drive[3];
static char dir[128];
static char fname[9];
static char ext[4];
static char path_buffer[128];

char * get_bison_path(char * bison_full_path_name)
{
	_splitpath(bison_full_path_name, drive, dir, fname, ext);
	_makepath(path_buffer, drive, dir, "", "");
	return(strdup(path_buffer));
}
#endif

/* VMS complained about using `int'.  */
int
main(argc, argv)
int argc;
char *argv[];
{
	program_name = argv[0];
#ifdef MSDOS
	parser_dir = get_bison_path(program_name);
#endif
	failure = 0;
	lineno = 0;
	dummy();	/* force gram to be included */
	getargs(argc, argv);
	openfiles();

  /* read the input.  Copy some parts of it to fguard, faction, ftable and fattrs.
     In file reader.c.
     The other parts are recorded in the grammar; see gram.h.  */
	reader();

  /* find useless nonterminals and productions and reduce the grammar.  In
     file reduce.c */
	reduce_grammar();

  /* record other info about the grammar.  In files derives and nullable.  */
	set_derives();
	set_nullable();

  /* convert to nondeterministic finite state machine.  In file LR0.
     See state.h for more info.  */
	generate_states();

  /* make it deterministic.  In file lalr.  */
	lalr();

  /* Find and record any conflicts: places where one token of lookahead is not
     enough to disambiguate the parsing.  In file conflicts.
     Currently this does not do anything to resolve them;
     the trivial form of conflict resolution that exists is done in output.  */
	initialize_conflicts();

  /* print information about results, if requested.  In file print. */
	if (verboseflag)
		verbose();
else
	terse();

  /* output the tables and the parser to ftable.  In file output. */
output();
done(failure);
}

/* functions to report errors which prevent a parser from being generated */

void
fatal(s)
char *s;
{
	extern char *infile;

	if (infile == 0)
		fprintf(stderr, "fatal error: %s\n", s);
else
	fprintf(stderr, "\"%s\", line %d: %s\n", infile, lineno, s);
done(1);
}

#if (defined MS_DOS || defined USE_STD_ARGS)
#include <stdargs.h>
void
fatals(char *fmt, ...)
{
	char buffer[200];
	va_list arg_ptr;

	va_start(arg_ptr,fmt);
	vsprintf(buffer, fmt, arg_ptr);
	va_end(arg_ptr);
	fatal(buffer);
}
 
#else

/*VARARGS1*/

void
fatals(fmt,x1,x2,x3,x4,x5,x6,x7,x8)
char *fmt;
{
	char buffer[200];

	sprintf(buffer, fmt, x1,x2,x3,x4,x5,x6,x7,x8);
	fatal(buffer);
}
#endif


void
toomany(s)
char *s;
{
	char buffer[200];

	/* JF new msg */
	sprintf(buffer, "limit of %d exceeded, too many %s", MAXSHORT, s);
	fatal(buffer);
}


void
berror(s)
char *s;
{
	fprintf(stderr, "internal error, %s\n", s);
	abort();
}
