/*--------------------------------------------------------------------------
Module Name: BITS.C

Created By:  David Bernazzani

Create Date: 10/27/90

Purpose:     This module contains BIT manipulation routines.

===========================================================================
                          Revision History
===========================================================================
Version    Date     Person		 Description of Change
-------  --------   ------   ----------------------------------------------
 1.0     10/27/90    DSB     Initial Release.
--------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include "utils.h"
#include "bits.h"

/*=========================================================================
Function Name:  Bit_Test(...)

Purpose:  This routine will test to see if a particular bit is set
          in a byte.

Inputs:   UBYTE val   --> Value to test bit in.
          UBYTE bit   --> Bit to test (0-7).

Returns:  FLAG status --> TRUE if bit set, FALSE if not.

Version    Date     Person		 Description of Change
-------  --------   ------   ----------------------------------------------
 1.0     10/27/90    DSB     Initial Release.
--------------------------------------------------------------------------*/
FLAG Bit_Test(UBYTE val, UBYTE bit)  /* bits range 0-7 */
{
   FLAG status = TRUE;
   UBYTE test_val = 0x01;

   test_val = (test_val << bit);     /* Shift the bit into position */
   if ((val & test_val) == 0)
      status = FALSE;
   return(status);
}


/*=========================================================================
Function Name:  Bit_Set(...)

Purpose:  This routine set a particular bit in a byte.

Inputs:   UBYTE *val  --> Value to set bit in.   Updated for caller.
          UBYTE bit   --> Bit to set (0-7).

Returns:  FLAG status --> TRUE.

Version    Date     Person		 Description of Change
-------  --------   ------   ----------------------------------------------
 1.0     10/27/90    DSB     Initial Release.
--------------------------------------------------------------------------*/
FLAG Bit_Set(UBYTE *val, UBYTE bit)  /* bits range 0-7 */
{
   FLAG status = TRUE;
   UBYTE test_val = 0x01;

   test_val = (test_val << bit);     /* Shift the bit into position */
   *val = (*val | test_val);         /* Set that bit */
   return(status);
}



/*=========================================================================
Function Name:  Bit_Clear(...)

Purpose:  This routine clear a particular bit in a byte.

Inputs:   UBYTE *val  --> Value to clear bit in.   Updated for caller.
          UBYTE bit   --> Bit to clear (0-7).

Returns:  FLAG status --> TRUE.

Version    Date     Person		 Description of Change
-------  --------   ------   ----------------------------------------------
 1.0     10/27/90    DSB     Initial Release.
--------------------------------------------------------------------------*/
FLAG Bit_Clear(UBYTE *val, UBYTE bit)  /* bits range 0-7 */
{
   FLAG status = TRUE;
   UBYTE test_val = 0x01;

   test_val = (test_val << bit);     /* Shift the bit into position */
   *val = (*val & (~test_val));      /* Clear that bit */
   return(status);
}

