/*
	file : bitstrg.c			June  1, 1989

	programm to test bit manipulation procedures

*/

#define debug

/* standard include */

#include <stdio.h>

/* specific include */

#include "bitstrg.h"

/* constant definition */

#define BITLIMIT 450000			/* max number of bits */

/*
	print bytes of an array of bits

	Warning : the elements of the array are considered 1 byte long
		( printf("%02X",ptrbit[ind-1]) )

*/
void printbitarray(ptr)
	struct SPARRAY * ptr;		/* pointer on structure */
{

	unsigned ind;

	ELEBAR*	ptrbit;

	printf("\n");
	ind = (((long)ptr->numlbit + 1) / SIZE)
		 + ((((long)ptr->numlbit + 1) & (SIZE - 1)) ? 1 : 0);

	for (ptrbit = ptr -> pntarray ;ind > 0;--ind) {
		printf(" %02X",ptrbit[ind-1]);	
	}
}

main ()
{

	unsigned long	value;
	unsigned long	bitnumb;
	
	int			ch;

	unsigned char*	ptr;

	LBITARRAY	array;

	printf("\nPlease enter number of bits needed [1 to %lu] : ",BITLIMIT);
	scanf("%lu",&value);
	getchar();

#ifdef debug
	printf("BITLIMIT = %lu  value = %lu \n",BITLIMIT,value);
#endif

	if ( 0 < value && value <= BITLIMIT) {

				/* bit array generation */
		if((array = lcrebitarray(value-1)) == NULL) {
			printf("\nout of memory\n");
			exit(1);
		}
		while(1) {
			printf("\n\nCMD> ");			/* ask for command */
			ch = getchar();					/* obtain user command */
			getchar();
			switch(tolower(ch)) {
				case 'c' :					/* reset bit */
						printf("\nreset specified bit\n");
						printf("\nbit number [0 to %lu] : ",value-1);
						scanf("%lu",&bitnumb);
						getchar();
						if(!lclearbit(array,bitnumb)) {
							printf("bit out of map\n");
						}
						else {
							printf("\nbit %lu is at %ul\n",bitnumb
								,(ltestbit(array,bitnumb)==0) ? 0 : 1);
						}
						break;
				case 'd' :					/* declare a memory field as
												an array of bits */
						lfreebitarray(array);
						printf("\ndeclare a memory field\n");
						printf("\nnumber of unsigned [1 to %lu] : "
								,(BITLIMIT)/SIZE);
						scanf("%lu",&bitnumb);
						getchar();

						if((ptr = (unsigned char*) calloc(bitnumb
								,sizeof(unsigned char))) == NULL) {
							printf("\nout of memory\n");
						}
						else {
							if((array = ldecarbit(ptr,bitnumb)) == NULL) {
								printf("\nout of memory\n");
							}
							else {
								value = bitnumb * SIZE;
							}
						}
						break;
				case 'e' :					/* exit to system */
						exit (0);
						break;
				case 'i' :					/* invert bit */
						printf("\ninvert specified bit\n");
						printf("\nbit number [0 to %lu] : ",value-1);
						scanf("%lu",&bitnumb);
						getchar();
						if(!linvertbit(array,bitnumb)) {
							printf("bit out of map\n");
						}
						else {
							printf("\nbit %lu is at %ul\n",bitnumb
								,(ltestbit(array,bitnumb)==0) ? 0 : 1);
						}
						break;
				case 's' :					/* set bit */
						printf("\nset specified bit\n");
						printf("\nbit number [0 to %lu] : ",value-1);
						scanf("%lu",&bitnumb);
						getchar();
						if(!lsetbit(array,bitnumb)) {
							printf("bit out of map\n");
						}
						else {
							printf("\nbit %lu is at %ul\n",bitnumb
								,(ltestbit(array,bitnumb)==0) ? 0 : 1);
						}
						break;
				case 'p' :					/* print array */
						printbitarray(array);
						break;
				case 'r' :					/* clear all bits */
						printf("\nclear all bits\n");
						lclrbitarray(array);
						break;
				case 't' :					/* reset bit */
						printf("\ntest specified bit\n");
						printf("\nbit number [0 to %lu] : ",value-1);
						scanf("%lu",&bitnumb);
						getchar();
						printf("\nbit %lu is at %ul\n",bitnumb
							,(ltestbit(array,bitnumb)==0) ? 0 : 1);
						break;
				default :
						printf(" %c, unknown command",ch);
						printf("\n Usage C-clear, E-exit, I-invert, P-print, R-reset, S-set, T-test\n");
						break;
			}
		}
	}	
	else {
		printf("\n Value entered is out of range.\n");
	}
}

