/*	C level interface to user programs for dos 2.00
*/

#include "stdio.h"
#include "fileio2.h"

#define MAXARG 32

FILE *stdin, *stdout, *stderr;
extern unsigned char *calloc();
extern int _sysvers;
extern unsigned int _BUFSIZE;

_main(cl_ptr)
unsigned char *cl_ptr;
{
  struct regval srv;
  unsigned char qchar,*cp,**argv,*alst[MAXARG+1],*aptrlst[MAXARG+1];
  extern char *filedir(),*strchr();
  int j,argc,acnt;
  long ftell();

/*	check that that the OS is DOS 2.0 or better
*/

  if (!_sysvers) {
    bdos(9,"NEEDS DOS 2.0$");
    _exit(0x800f);
  }

  cp=cl_ptr; qchar = 0;			/* get address of command line */
  for( j = *cp++; j--; ++cp )
  {
    if( !qchar )			/* not in quote */
    {
      if( *cp == '"' || *cp == '\'' )
      {
	qchar = *cp;			/* make qchar that char */
	/* leave quote for flag later */
      }
      else if( *cp == ' ' || *cp == '\t' )
	*cp = 0;			/* set spaces and tabs to null */
    }
    else if( *cp == qchar )		/* at end of quote */
      qchar = *cp = 0;			/* end it all */
  }
  if ( qchar )
  {
    bdos( 9, "ERROR:  unmatched quote in command line\r\n$" );
    exit( 0x800f );
  }
  *cp=0;				/* a final terminator */

/*	build the arg lists
*/

  cp=cl_ptr;
  argc=1;
  for(j=*cp++ + 1;j--;++cp){
    if(!*cp)continue;			/* skip leading nulls */
    aptrlst[argc] = alst[argc] = NULL;	/* make sure no bogus pointers */
    if (*cp == '"' || *cp == '\'')
	alst[argc++]=cp+1;		/* skip leading quote */
    else if (!(strchr(cp,'*') || strchr(cp,'?')))
	alst[argc++]=cp;
    else
	if ((aptrlst[argc++] = filedir(cp,1)) == NULL)
	{
	    *(cp + strlen(cp)) = '$';	/* terminate for bdos call */
	    bdos(9, cp);
	    bdos(9, ":  not found\r\n$");
	    _exit(0x8082);
	}
    if(argc>=MAXARG)break;
    while(*cp){++cp;--j;}		/* and skip the data */
  }

/*	check if too many args
*/
    if(argc>=MAXARG){ 
      bdos(9,"\r\nTOO MANY ARGS\r\n$");
      _exit(0x8082);
    }

  acnt=1;
  for(j=1; j < argc;j++)
    if (alst[j] != NULL)
	acnt++;
    else
	for (cp = aptrlst[j]; cp != NULL && *cp; cp += strlen(cp)+1)
	    acnt++;		/* count the filename */
  argv = calloc(acnt+1,sizeof(char *));
  if (argv == NULL)
  {
    bdos(9, "Unable to allocate memory for argv\r\n$");
    _exit(0x8082);
  }
  for(acnt=1,j=1; j < argc; j++)
    if (alst[j] != NULL)
	argv[acnt++] = alst[j];
    else
	for (cp = aptrlst[j]; cp != NULL && *cp; cp += strlen(cp)+1)
	    argv[acnt++] = cp;
  argc = acnt;
  argv[argc]=NULL;

/* if _BUFSIZE >0x800 set to 0x8000   */

  if (_BUFSIZE > 0x8000) _BUFSIZE=0x8000;

/*	set up stdin, stdout, & stderr
*/

  /* stdin */ 
  stdin=_opentab[0]=calloc(1,(sizeof(struct bufstr)+136));
  stdin->bufflag=(BF_CDEV|BF_ASCII|BF_WRITE);
  stdin->buffull=stdin->bufsize=136;
  stdin->bufhand=stdin->buffild=0;

   /* stdout */ 
   srv.ax=0x4400;
   srv.bx=1;
   sysint21(&srv,&srv);
   if (srv.dx&128) {	/* console (device) */
      stdout=_opentab[1]=calloc(1,(sizeof(struct bufstr)+1));
      stdout->bufflag=(BF_CDEV|BF_ASCII|BF_READ);
      stdout->buffull=stdout->bufsize=stdout->bufhand=1;
   } else {           /* redirected disk file */
      srv.ax=0x4500;        /* duplicate file handle */
      srv.bx=1;
      sysint21(&srv,&srv);
      stdout=_opentab[1]=calloc(1,(sizeof(struct bufstr)+_BUFSIZE));
      stdout->bufflag=(BF_ASCII|BF_READ);
      stdout->bufsize=_BUFSIZE;
      stdout->bufsync=(ftell(stdout)%_BUFSIZE); /* for append & create */
      stdout->buffull=_BUFSIZE-(stdout->bufsync);
      stdout->bufhand=srv.ax;
    } 
    stdout->buffild=1;

    /* stderr */ 
    stderr=_opentab[2]=calloc(1,(sizeof(struct bufstr)+1));
    stderr->bufflag=(BF_CDEV|BF_ASCII|BF_READ);
    stderr->buffull=stderr->bufsize=1;
    stderr->bufhand=stderr->buffild=2;


#ifdef DEBUG
write(2,"before print in debug for redirection\n\r",39);
fprintf(stderr,"fild = %d,hand=%d, size=%d, flag=%d, sync=%d, full=%d, tell=%ld\n",
   stdout->buffild,stdout->bufhand,stdout->bufsize,stdout->bufflag,stdout->bufsync,
   stdout->buffull,
	ftell(stdout));
#endif
/*	now execute the program
*/

  argv[0]="c";				/* don't know program name */
  exit(main(argc,argv));
}
