; This routine computes a 16-bit CRC of a block of memory using the
; CRC computation method used by XMODEM/CRC programs.

crc	proc	near	; Returns 16-bit CRC of CX bytes at DS:BX in AX
	xor	ax,ax
crcnz:	xor	dl,dl	; using crcnz doesn't zero crc before beginning -
			; use for cumulative CRC on more than one block
			; of data
	mov	si,1021h	;1021h represents x^16+x^12+x^5+1
				;1021h=0001000000100001
	mov	di,cx

crc1:	mov	dh,[bx]
	xor	ax,dx
	mov	cx,8

crc2:	shl	ax,1
	jnc	crc3
	xor	ax,si
crc3:	loop	crc2

	inc	bx
	dec	di
	jnz	crc1
	ret
crc	endp
