   /* (Extracted from a document edited by Chuck Forsberg of
    * Omen Technology in Portland, Oregon)
    *
    * This function calculates the CRC used by the XMODEM/CRC Protocol
    * The first argument is a pointer to the message block.
    * The second argument is the number of bytes in the message block.
    * The function returns an integer which contains the CRC.
    * The low order 16 bits are the coefficients of the CRC.
    */

   int calcrc(ptr, count)
   char *ptr;
   int count;
   {
       int crc, i;

       crc = 0;

       while (--count >= 0) {
           crc = crc ^ (int)*ptr++ << 8;

           for (i = 0; i < 8; ++i)
               if (crc & 0x8000)
                   crc = crc << 1 ^ 0x1021;
               else
                   crc = crc << 1;
           }
       return (crc & 0xFFFF);
   }
