/* calculat.c
   an onscreen calculator
   compiled with: 'cc calculat.c -lcurses -ocalculator' 
*/ 
#include <stdio.h> 
#include <stdlib.h> 
#include "curses.h" 
#include <errno.h> 

FILE *filein; 

unsigned char inchar; 
unsigned char operator; 
unsigned char precision; 
unsigned char i, j, k; 

int entryrow = 0; 
int entrycolumn = 29; 
int operatorcolumn = 53; 
int resultcolumn = 57; 
int firstline = 2;
int lastline = 23;
int currentrow; 

double decimalplace;

double current; 
double total; 
double history[25];
unsigned char ophistory[25];

void docalc(void); 
void displayhistory(void);
void title(void); 
void display(int row, int column, double number, char precision); 

main(int argc, char *argv[]) 
{ 
  initscr(); 
  nodelay(stdscr,TRUE); 
  cbreak(); 
/*  noecho(); */ 
  refresh(); 
  /* intialize variables */
  inchar = '\0'; current = 0; decimalplace = 0; 
  operator = '\0'; precision = 'r'; currentrow = firstline;
  title(); 
  /* main loop */ 
  while (inchar != 'q' && inchar != 'Q') 
   { 
     move(entryrow, operatorcolumn); refresh(); 
     inchar = getch(); 
     inchar = toupper(inchar); 
     if (currentrow > lastline - 1) /* set sceen limit */
        { 
         move(lastline,0);
         printw("Max rows reached 'z' to clear",inchar);
         refresh(); 
         /* only accept these operations when screen is full */
         if (inchar != 'Z' && inchar != 'Q' && inchar != 'U' &&
             inchar != 'R' && inchar != 'S' && inchar != 'T' &&
             inchar != 'L' && inchar != 'X' && inchar != 'O') inchar = '\0';
        } 
     /* see what to do with input */
     switch(inchar){ 
         case ('.') : if (decimalplace == 0 && precision != 'h' &&
                          precision != 'o'  && precision != 'i')
                          decimalplace = 10; 
                      break;
         /* if octal, place in current */
         case ('0') :  
         case ('1') : 
         case ('2') : 
         case ('3') :  
         case ('4') : 
         case ('5') :  
         case ('6') : 
	 case ('7') : if (precision == 'o')
                         current = (current*8)+(inchar-48);
                         else if (precision == 'h') 
                              current = (current*16)+(inchar-48);
                              else if (decimalplace == 0) 
                                   current = (current*10)+(inchar-48);
                                   else {
                                 current = current + (inchar-48)/decimalplace;
                                   decimalplace = decimalplace * 10;
                                   }
                         attron(A_REVERSE);
		         display(entryrow,entrycolumn,current,precision); 
                         break; 
         /* if decimal, place in current */
	 case ('8') : 
	 case ('9') : if (precision != 'o')
                      { if (precision == 'h') 
                        current = (current*16)+(inchar-48);
                        else if (decimalplace == 0) 
                             current = (current*10)+(inchar-48);
                             else {
                             current = current + (inchar-48)/decimalplace;
                             decimalplace = decimalplace * 10;
                             }
                         attron(A_REVERSE);
		         display(entryrow,entrycolumn,current,precision); 
                      }
                         break; 
         /* if in hex, place in current */
	 case ('A') : 
	 case ('B') : 
	 case ('C') : 
	 case ('D') : 
	 case ('E') : 
         case ('F') : if (precision == 'h') 
		      { current = (current*16)+(inchar-55);
                        attron(A_REVERSE);
		        display(entryrow,entrycolumn,current,precision); 
		      } 
		      break; 
         /* check for operator, perform if more than one entry available */
	 case ('+') : 
	 case ('-') : 
	 case ('*') : 
         case ('/') : if (operator != '\0' && current != 0) 
                      { history[currentrow-firstline] = current;
                        ophistory[currentrow-firstline] = operator;
                        docalc(); current = 0; decimalplace = 0; 
                      }
                 else { if (currentrow == firstline && current != 0)
                        { /* first entry */ 
                          total = current; 
                          history[0] = current;
                          display(currentrow,entrycolumn,total,precision); 
                          display(currentrow,resultcolumn,total,precision); 
                          currentrow++; current = 0; decimalplace =0;
                        }
                      }
                      operator = inchar;
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      break; 
         /* just do an equals */
         case (0x0A) : 
         case ('=') : if (operator != '\0' && current != 0) 
                      { history[currentrow-firstline] = current;
                        ophistory[currentrow-firstline] = operator;
                        docalc(); current = 0; decimalplace = 0;
                        attron(A_REVERSE);
                        display(entryrow,entrycolumn,current,precision);
                        operator = '\0';
                      }
                      break;
         /* negate entry */
         case ('N') : current = -current; 
                      displayhistory();
                      attron(A_REVERSE);
                      display(entryrow,entrycolumn,current,precision);
                      break;
         /* change output 'precision' */
	 case ('R') : precision = 'r'; 
                      displayhistory();
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      break; 
         case ('S') : precision = 's'; 
                      displayhistory();
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      break; 
         case ('T') : precision = 't'; 
                      displayhistory();
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      break; 
         case ('P') : precision = 'p'; 
                      displayhistory();
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      break; 
         case ('I') : precision = 'i'; 
                      displayhistory();
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      break; 
         case ('H') : precision = 'h'; 
                      displayhistory();
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      break; 
         case ('O') : precision = 'o'; 
                      displayhistory();
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      break; 
         /* quit */
	 case ('Q') : break; 
         /* undo last entry */
         case ('U') : if (currentrow > firstline )
                      { currentrow--;
                        move(currentrow,entrycolumn);
                        clrtoeol(); refresh();
                        displayhistory();
                        attron(A_REVERSE);
                        display(entryrow,entrycolumn,current,precision);
                        }
                       if (currentrow == firstline)
                          { total = 0; operator = '\0';}
                       break;
         /* clear entry line only */
         case ('Y') : current = 0; decimalplace = 0; 
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
                      break;
         /* clear all totals */
         case ('Z') : current = 0; decimalplace = 0; total = 0;
                      attron(A_REVERSE);
		      display(entryrow,entrycolumn,current,precision); 
		      move(1,0); clrtobot(); refresh(); 
		      title(); 
		      operator = '\0'; 
		      currentrow = firstline; 
		      break; 
	 case (0x08) : break; 
	 case (0x00) : break; 
	 case (0xFF) : break; 
              default: move(lastline,0);
                      printw("unrecognized operand '%c' <%0.2X>",inchar,inchar);
                       refresh(); 
     } 
  } 
clrtobot(); refresh(); 
endwin(); 
system("stty sane tab3"); 
} 

void docalc(void) /* everything is global, total and display */ 
{ 
     switch(operator){ 
	 case ('+') : total = total + current; break; 
	 case ('-') : total = total - current; break; 
	 case ('*') : total = total * current; break; 
	 case ('/') : total = total / current; break; 
             default: move(lastline,0);
                     printw("unrecognized operator '%c' <%0.2X>",inchar,inchar);
                      refresh(); 
     } 
display(currentrow,entrycolumn,current,precision); 
move(currentrow,operatorcolumn); printw("%c =",operator); 
display(currentrow,resultcolumn,total,precision); 
currentrow++; 
operator = '\0'; 
refresh(); 
} 

void displayhistory() /* everything is global, display history */
{
  unsigned char saveop;
  int di, savecurrentrow;
  double  savecurrent;

saveop = operator;
savecurrentrow = currentrow;
savecurrent = current;
if (currentrow != firstline)
{ /* only if a history is started */
  current = history[0];
  display(firstline,entrycolumn,current,precision);
  display(firstline,resultcolumn,current,precision);
  total = current;
  for (di = 1; di < (savecurrentrow - firstline); di++)
      { current = history[di];
        operator = ophistory[di];
        currentrow = di + firstline;
        docalc();
      } 
}
operator = saveop;
currentrow = savecurrentrow;
current = savecurrent;
}

void display(int drow, int dcol, double dnumber, char dprecision) 
{ /* display output in selected format */ 
    move(drow,dcol); 
    switch(dprecision) 
	{ 
	case ('r') : printw("%22.2f",dnumber); break; 
	case ('s') : printw("%22.5f",dnumber); break; 
	case ('t') : printw("%22.10f",dnumber); break; 
	case ('p') : printw("%22.14e",dnumber); break; 
	case ('i') : printw("%22.0f",dnumber); break;
	case ('h') : printw("%22lX",(long)dnumber); break;
	case ('o') : printw("%22lo",(long)dnumber); break;
          default  : move(lastline,0);
                   printw("unrecognized precision '%c' <%0.2X>",
                    dprecision,dprecision);
                   refresh();
	} 
    attron(A_REVERSE);
    move(2,12);
    if (operator == '\0') printw(" ");
       else printw("%c",operator);
    move(9,12);
    printw("%c",precision);
    attroff(A_REVERSE);
    move(entryrow,operatorcolumn); 
    addch(' ');
    /* clear error line */
    move(lastline,0); clrtoeol();
    refresh(); 
} 

void title(void) 
{ 
move(0,0); 
printw (" CALCULATOR \n\n"); 
printw (" Operators:\n"); 
printw (" + = add \n"); 
printw (" - = subtract \n"); 
printw (" * = multiply \n"); 
printw (" / = divide \n");
printw (" n = negate entry\n\n");
printw (" Precision:\n"); 
printw (" r = decimal 2 digit\n");
printw (" s = decimal 5 digit\n");
printw (" t = decimal 10 digit\n");
printw (" p = exponential notation\n");
printw (" i = integer notation\n");
printw (" o = octal notation\n");
printw (" h = hexadecimal notation\n\n");
printw (" u = undo last entry\n");
printw (" y = clear current entry\n");
printw (" z = clear all\n\n");
printw (" q = quit \n");
attron(A_REVERSE);
display(entryrow,entrycolumn,current,precision); 
refresh(); 
} 

