/****************************************************************

Name
	cal - display calendar

Synopsis
	cal [month-number] year

Description
	Display a calendar for a particular year. If month-number
	is supplied, only that month is displayed.

****************************************************************/


#include <stdio.h>


#define hdr_3_across "\t %.3s\t\t\t%.3s\t\t       %.3s\n%s   %s   %s\n"
#define hdr_1_across "   %s %u\n%s\n"


char *dayw = " S  M Tu  W Th  F  S";


char *smon[] = { "",
	"January",	"February",	"March", 
	"April",	"May",		"June",
	"July",		"August",	"September",
	"October",	"November",	"December"
};


int mon[] = { 0,
	31,		29,		31,
	30,		31,		30,
	31,		31,		30,
	31,		30,		31
};


#define WIDTH	72		/* max # of chars across for 3 months */
#define LENGTH	6		/* max # of lines in 1 month's display */
#define BUFSIZE	(LENGTH*WIDTH)


char	string[BUFSIZE];


main (argc, argv)
int argc;
char *argv[];
{
	register int y,m,j;

	if (argc == 2) {			/* display entire year */
		y = number (argv[1]);
		if (y < 1 || y > 9999)
			badarg (y);
		printf ("\n\t\t\t\t%u\n\n", y);
		for (m = 1; m <= 12; m += 3) {
			setmem (string, BUFSIZE, '\0');
			printf (hdr_3_across,
			    smon[m], smon[m+1], smon[m+2], dayw, dayw, dayw);
			cal (m, y, string, WIDTH);
			cal (m+1, y, string+23, WIDTH);
			cal (m+2, y, string+46, WIDTH);
			for (j=0; j < BUFSIZE; j += WIDTH)
				pstr (string+j, WIDTH);
		}
		putchar ('\n');
	}
	else if (argc == 3) {			/* display 1 month */
		m = number(argv[1]);
		if (m < 1 || m > 12)
			badarg (m);

		y = number (argv[2]);
		if (y < 1 || y > 9999)
			badarg (y);

		printf (hdr_1_across, smon[m], y, dayw);
		cal (m, y, string, 24);
		for (j = 0; j < LENGTH*24; j += 24)
			pstr (string+j, 24);
	}
	else
		puts ("usage: cal [month] year");
}


badarg (i)
int i;
{
	printf ("cal: bad argument '%d'\n", i);
	exit (0);
}


int number (str)
char *str;
{
	register n, c;
	register char *s;

	n = 0;
	s = str;
	while (c = *s++) {
		if (c < '0' || c > '9')
			return (0);
		n = (n*10) + (c-'0');
	}
	return (n);
}


pstr (str, n)
char *str;
int n;
{
	register int i;
	register char	*s;

	s = str;
	i = n;
	while (i--) {			/* replace '\0' w/spaces */
		if (*s == '\0')
			*s = ' ';
		++s;
	}
	i = n + 1;
	while (i--)			/* find last non-space char */
		if (*--s != ' ')
			break;
	*++s = '\0';	// EOS;
	puts (str);
}


cal (m, y, p, w)
int m,y,w;
char *p;
{
	register int d, i;
	register char	*s;

	s = p;
	d = jan1 (y);
	mon[9] = 30;

	switch ((jan1 (y+1) + 7 - d) % 7) {
	case 1:					/* rem non-leap year */
		mon[2] = 28;
		break;
	default:				/* 1752 */
		mon[9] = 19;
		/* fall thru */
	case 2:					/* leap year */
		mon[2] = 29;
		break;
	}
	for (i = 1; i < m; ++i)
		d += mon[i];
	d %= 7;
	s += 3*d;
	for (i = 1; i <= mon[m]; ++i) {
		if (i == 3 && mon[m] == 19) {
			i += 11;
			mon[m] += 11;
		}
		if (i > 9)
			*s = (i / 10) + '0';
		++s;
		*s++ = (i % 10) + '0';
		++s;
		if (++d == 7) {
			d = 0;
			s = p+w;
			p = s;
		}
	}
}


/*
 *	return day of the week of jan 1 of given year
 */


int jan1 (yr)
int yr;
{
	register int y, d;

/*
 *	normal gregorian calendar
 *	one extra day per four years
 */

	y = yr;
	d = 4 + y + ((y + 3) / 4);

/*
 *	julian calendar
 *	regular gregorian
 *	less three days per 400
 */

	if (y > 1800) {
		d -= (y - 1701) / 100;
		d += (y - 1601) / 400;
	}

/*
 *	great calendar changeover instant
 */

	if (y > 1752)
		d += 3;

	return (d % 7);
}
