#define data_type    int
#define name_of_list list_of_ints

struct node{data_type data; struct node *left,*right;};

struct list{struct node *head,*tail,*current_pos;};

typedef struct list name_of_list;

/*****************************************************************
 *initialize_list : usage 'initialize_list(&my_list);'           *
 *this must be done in order to use a newly declared list,       *
 *this function will also take an existing list and make it empty*
 *****************************************************************/
void initialize_list(name_of_list *a);

/*********************************************************************
 *goto_head : usage 'goto_head(&my_list);'                           *
 *this function will set the current position of the list to the head*
 *********************************************************************/
void goto_head(name_of_list *a);

/********************************************************************
 *got_tail : usage 'goto_tail(&my_list);'                           *
 *this function will set the current postion of the list to the tail*
 ********************************************************************/
void goto_tail(name_of_list *a);

/********************************************************************
 *goto_right : usage 'goto_right(&my_list);'                        *
 *this function will move the current position of the list one node *
 *to the right, if no nodes exist nothing will happen               *
 ********************************************************************/
void goto_right(name_of_list *a);

/*********************************************************************
 *goto_left : usage 'goto_left(&my_list));'                          *
 *this function will move the current position of the list one node  *
 *to the left, if no nodes exist nothing will happen                 *
 *********************************************************************/
void goto_left(name_of_list *a);

/*********************************************************************
 *insert_before_cur : usage 'insert_before_cur(&my_list,id_num);'    *
 *this function will insert a new node containing id_num into the    *
 *list before the current position                                   *
 *********************************************************************/
void insert_before_cur(name_of_list *a,data_type b);

/*********************************************************************
 *insert_after_cur : usage 'insert_after_cur(&my_list,id_num);'      *
 *this function will insert a new node containing id_num into the    *
 *list after the current position                                    *
 *********************************************************************/
void insert_after_cur(name_of_list *a,data_type b);

/*********************************************************************
 *retrieve_current : usage 'new_data=retrieve_current(&my_list);'    *
 *this function will return the data stored in the current node      *
 *********************************************************************/
data_type  retrieve_current(name_of_list *a);

/*********************************************************************
 *position : usage 'offset=position(&my_list,key);'                  *
 *this function will return the offset from the current position     *
 *where the desired key was found, if the end of list is reached the *
 *function returns -1                                                *
 *********************************************************************/
int  position(name_of_list *a,data_type b);

/*********************************************************************
 *size : usage 'length=size(&my_list);'                              *
 *this function returns the size/length of the list in question      *
 *a list with one node will return 1, with two nodes returns 2, etc  *
 *********************************************************************/
int  size(name_of_list *a);

/*********************************************************************
 *delete_at_current : usage 'delete_at_current(&my_list);'           *
 *this function deletes the current position node                    *
 *********************************************************************/
void delete_at_current(name_of_list *a);

