#include <windows.h>


struct RealModeFrame {
    DWORD m_EDI;
    DWORD m_ESI;
    DWORD m_EBP;
    DWORD m_Reserved;
    DWORD m_EBX;
    DWORD m_EDX;
    DWORD m_ECX;
    DWORD m_EAX;
    WORD m_CPUFlags;
    WORD m_ES;
    WORD m_DS;
    WORD m_FS;
    WORD m_GS;
    WORD m_IP;
    WORD m_CS;
    WORD m_SP;
    WORD m_SS;
};


int GetNumberOfCDROMDrives(char far *chFirstDrive)
{
    // Local variables
    RealModeFrame t_RealModeRegs;

    // Fill in the register block for the real mode interrupt
    t_RealModeRegs.m_EAX = 0x00001500;
    t_RealModeRegs.m_EBX = 0x00000000;

    asm {
        // Make ES:DI point to the register block
        mov     ax, seg t_RealModeRegs
        mov     es, ax
        mov     di, offset es:t_RealModeRegs

        // Set number of words to copy between stacks
        mov     cx, 0x0000

        // Set interrupt number to call
        mov     bx, 0x002F

        // Set DPMI "Simulate Real Mode Interrupt" function number
        mov     ax, 0x0300

        // Call DPMI host
        int     0x31

        // Carry clear if successful
        jnc       gnocrdSuccess
    }

    // If we get to here there was an error

    // Set number of drives as zero
    t_RealModeRegs.m_EBX = 0x00000000;

    // Set first drive letter as zero
    t_RealModeRegs.m_ECX = 0x00000000;

// Direct jump to this label if the DPMI call was successful
gnocrdSuccess:

    // Set the first drive letter return variable
    *chFirstDrive = LOBYTE(LOWORD(t_RealModeRegs.m_ECX));

    // Return the number of drives
    return LOWORD(t_RealModeRegs.m_EBX);
}