/* clock.c an onscreen ascii clock using curses and math libraries.
   Compiled with: cc clock.c -lm -lcurses -oclock
*/
   
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <curses.h>
#include <term.h>
#include <time.h>
#define PI 3.141592653

double a,b,c,x,y,z,maxx,maxy;
int i,j,k,offset,lastoff,delay,display;
char op,ik;
int current_hour,last_hour,current_min,last_min,current_sec,last_sec;

int logicx (int);
int logicy (int);
void sine(void);
void circle(void);
void spiral(void);
void unspiral(void);
void grid(void);
void hour(void);
void minute(void);
void second(void);
void clearclock(void);

main()
{  
  time_t clock;
  struct tm *current;
  last_hour=1;
  last_min=1;
  last_sec=1;
  system("stty sane tab3");
  initscr();
  refresh();
  nodelay(curscr,TRUE);
  noecho();
  cbreak();
  a=1000;
  b=500;
  c=500;
  maxx=79;
  maxy=23;
/*  grid(); */
  move(0,0); refresh(); addstr("c - clock");
  move(1,0); refresh(); addstr("s - spiral");
  move(2,0); refresh(); addstr("w - wave");
  move(3,0); refresh(); addstr("q - quit");
  op = '@';
  attron(A_BOLD);
  circle();
  attroff(A_BOLD);
  move(4,35); refresh();
  offset = 0;
  lastoff = 0;
  delay = 20;
  op = '*';
  display = 'c';
while(i=i)
{
/*  flushinp(); */
  time(&clock);
  current = localtime(&clock);
  current_hour = current->tm_hour;
  current_min  = current->tm_min;
  current_sec  = current->tm_sec;
  if (current_hour > 12) current_hour = current_hour - 12;
  move(4,35); refresh();
  if (display == 'c') 
     printf("%02i:%02i:%02i",current_hour,current_min,current_sec);
  current_hour = current_hour * 4;
  if (current_min > 45) current_hour = current_hour + 3;
    else if (current_min > 30) current_hour = current_hour + 2;
     else if (current_min > 15) current_hour = current_hour + 1;
  current_min = current_min * 4;
  if (current_sec > 45) current_min = current_min + 3;
    else if (current_sec > 30) current_min = current_min + 2;
     else if (current_sec > 15) current_min = current_min + 1;
  move(23,79);
  refresh();
  addch(' ');
  ik = (char)-1;
  ik = wgetch(curscr);
  ik = tolower(ik);
  if (ik != (char)-1 && ik != 13 && ik != 10) op = ik;
  if (op == 'q' || op == 27) break;
  if (op == '4') delay = delay + 1;
  if (op == '6') delay = delay - 1;
  if (op == 'w') { op = ' '; minute(); hour(); display = 'w';
                   clearclock(); }
  if (op == 's') { op = ' '; sine(); 
                   minute(); hour(); display = 's'; 
                   clearclock(); }
  if (op == 'c') { op = ' '; sine(); 
                   op = 'o'; minute(); 
                   op = '*'; hour(); display = 'c';
                   }
  if (display == 'c') 
  {
    if (current_hour != last_hour)
     { op = '*'; hour();
       last_hour = current_hour;}
    if (current_min != last_min)
     { op = 'o'; minute();
       op = '*'; hour();
       last_min = current_min;}
  }
  op = '*';
  if (display == 'w') 
     { sine(); }
  if (display == 's')
     { ik = op;
       spiral();
       op = ' ';
       unspiral();
       op = ik; 
     }
  offset = offset + 35;
  if (offset >2000) offset = 0; 
}
  move(22,78);
  refresh();
  system("stty sane tab3");
}

int logicx( int posx)
{ int xx;
  xx = (int)((maxx/a)*(double)posx) + (int)((maxx/a)*b);
  return(xx);
}

int logicy( int posy)
{ int yy;
  yy = (int)maxy - (int)((maxy/a)*(double)posy) -
(int)(((maxy)/a)*c);
  return(yy);
}

void grid()
{ for (i=-476.0;i<476.0;i+=12.0)
  { x=i; y=i;
    move(logicy(0),logicx(x));
    refresh();
    addch('-');
    move(logicy(y),logicx(0));
    refresh();
    addch('|');
  }
move(logicy(0),logicx(0));
refresh();
addch('+');
}

void circle()
{ for (i=0;i<1000;i++)
  { x=(sin(i*PI/180.0))*500.0;
    y=(cos(i*PI/180.0))*520.0;
    move(logicy(y),logicx(x));
    refresh();
    addch(op);
  }
}

void spiral()
{ for (i=0;i<474;i=i+1)
  { x=sin(i/22.0)*i;
    y=cos(i/22.0)*i;
    move(logicy(y),logicx(x));
    refresh();
    /* if (abs(x)>12 && abs(y)>44)  */ addch(op);
  }
}

void hour()
{ double theta;
  if (last_hour != current_hour)
  { if (last_hour != 48 && last_hour != 24 && last_hour != 0)
     {  theta = (48.0-last_hour)*(360.0/48.0) -270.0;
        theta = (theta*PI)/180.0; 
        for (i=0;i<500;i++)
        { x = i; y = tan(theta)*x;
          if (last_hour > 24) {x = -x; y = -y;}
          move(logicy(y),logicx(x)); refresh(); addch(' ');
          if ( (x*x + y*y) > 62500 ) i = 501;
        } 
     } else
       { for (i=0;i<500;i++)
         { x = 0; y = i;
           if (last_hour == 24) y = -y;
           move(logicy(y),logicx(x)); refresh(); addch(' ');
           if((x*x + y*y) > 62500) i = 501;
         }
       }
  }
  if (current_hour != 48 && current_hour != 24 && current_hour != 0)
  { theta = (48.0-current_hour)*(360.0/48.0) -270.0;
    theta = (theta*PI)/180.0; 
    for (i=0;i<500;i++)
    { x = i; y = tan(theta)*x;
      if (current_hour > 24) {x = -x; y = -y;}
      move(logicy(y),logicx(x)); refresh(); addch(op);
      if ( (x*x + y*y) > 62500 ) i = 501;
    }
  } else
    { for (i=0;i<500;i++)
      { x = 0; y = i;
        if (current_hour == 24) y = -y;
        move(logicy(y),logicx(x)); refresh(); addch(op);
        if ((x*x + y*y) > 62500) i = 501;
      }
    }
}

void minute()
{ double theta;
  if (last_min != current_min)
  { if (last_min != 0 && last_min != 120)
    { theta = (240.0-last_min)*(360.0/240.0) -270.0;
      theta = (theta*PI)/180.0; 
      for (i=0;i<500;i++)
      { x = i; y = tan(theta)*i;
        if (last_min > 120) { x = -x; y = -y;}
        move(logicy(y),logicx(x)); refresh(); addch(' ');
        if ( (x*x + y*y) > 202500 ) i = 501;
       } 
     } else
       { for (i=0;i<500;i++)
         { x = 0; y = i;
           if (last_min == 120) y = -y;
           move(logicy(y),logicx(x)); refresh(); addch(' ');
           if ((x*x + y*y) > 202500) i = 501;
          }
        }
  } 
  if (current_min != 0 && current_min != 120)
  { theta = (240.0-current_min)*(360.0/240.0) -270.0;
    theta = (theta*PI)/180.0; 
    for (i=0;i<500;i++)
    { x = i; y = tan(theta)*x;
      if (current_min > 120) { x = -x; y = -y;}
      move(logicy(y),logicx(x)); refresh(); addch(op);
      if ( (x*x + y*y) > 202500 ) i = 501;
    }
  } else
    { for (i=0;i<500;i++)
      { x = 0; y = i;
        if (current_min == 120) y = -y;
        move(logicy(y),logicx(x)); refresh(); addch(op);
        if ((x*x + y*y) > 202500) i = 501;
       }
     }
}

void clearclock()
{ move(4,35); refresh();
  printf("        "); 
}

void unspiral()
{ for (i=474;i>-1;i=i-1)
  { x=sin(i/22.0)*i;
    y=cos(i/22.0)*i;
    move(logicy(y),logicx(x));
    refresh();
    /* if (abs(x)>12 && abs(y)>44) */ addch(op);
  }
}

void sine()
{ for (i=-450.0;i<450.0;i+=12.0)
  { x=i;
    y=sin((i-lastoff)*PI/200.0)*200.0;
    move(logicy(y),logicx(x));
    refresh();
    /* if (abs(x) > 12 && abs(y) > 44) */ addch(' ');
    y=sin((i-offset)*PI/200.0)*200.0;
    move(logicy(y),logicx(x));
    refresh();
    /* if (abs(x) > 12 && abs(y) > 44) */ addch(op);
    /* if (delay > 0) delay_output(delay); */
  }  
  lastoff = offset;
}
