/*****************************************************************************
 *                                  B E S S E L
 *****************************************************************************
 *
 *   PROGRAM ID:        BESSEL.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This program test the Bessel functions generated by various
 *      routines against the routines built into the Microsoft compiler.
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: Number of iterations required for solution
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     This program is placed in the public domain and can be
 *                      used freely by anyone.
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/




#include <time.h>
#include <collins.h>


double bj( double p, double z );



int main()
{
long lTime;

FILE *pFile, *pFileL;
float a, b, x;
double al, bl;
double c, c1, c2, c3;
//double bj=0, by=0, dbj=0, dby=0,   x;
//void bjy( double x, double xnu, double *rj, double *ry, double *rjp, double *ryp );


  pFile= fopen( "t_bessel.dat", "wt+" );
//  pFile= fopen( "bessel.dat", "wt+" );
//  pFileL= fopen( "besselL.dat", "wt+" );

//  fprintf( pFile, "%5.5s %20.20s  %20.20s  %20.20s\n",
//          "x","bessy(2,x)", "yn(2,x)", "%diff" );
//  fprintf( pFileL, "%5.5s %20.20s  %20.20s  %20.20s\n",
//          "x","bjy(2,x..)", "_ynl(2,x)", "%diff" );


//  lTime= -clock();
//  for( x=0.20 ; x<= 15.0 ; x += 0.2 )
//  {
//      a= bessy( 2, x );
//      b= yn( 2, x );

//      bjy( x, 2, &bj, &al, &dbj, &dby );
////      bjy( x, 2, &bj, &by, &dbj, &dby );
//      bl= _ynl( 2, x );

//      fprintf( pFile,  "%8.4f %20.8e  %20.8e  %20.8e\n", x,  a,  b, fabs(1-a/b) );
//      fprintf( pFileL, "%8.4f %20.8e  %20.8e  %20.8e\n", x, al, bl, fabs(1-al/bl) );
//  }

//  lTime += clock();
//  fprintf( pFile, "Numerical Recipes took %20.10e sec\n", lTime/(double)CLOCKS_PER_SEC );


//  lTime= -clock();
//  for( x=0.20 ; x<= 15.0 ; x += 0.2 )
//  {
//      a= bessy( 2, x );
//      b= yn( 2, x );

//      bjy( x, 2, &bj, &al, &dbj, &dby );
////      bjy( x, 2, &bj, &by, &dbj, &dby );
//      al= by;
//      bl= _ynl( 2, x );

//      fprintf( pFile,  "%8.4f %20.8e  %20.8e  %20.8e\n", x,  a,  b, fabs(1-a/b) );
//      fprintf( pFileL, "%8.4f %20.8e  %20.8e  %20.8e\n", x, al, bl, fabs(1-al/bl) );
//  }

//  lTime += clock();
//  fprintf( pFile, "Microsoft builtin took %20.10e sec\n", lTime/(double)CLOCKS_PER_SEC );


//  lTime= -clock();
  for( x=0.20 ; x<= 15.0 ; x += 0.3 )
  {
//      a= jn( 0, x );
//      b= bj( 0, x );
//      a= jn( 2, x );
      b= bj( 10, x );
      //b= jn( 20, x );
//    bjy( x, 2, &bj, &al, &dbj, &dby );
      bjy( x, 10, &c, &c1, &c2, &c3 );

////      bjy( x, 2, &bj, &by, &dbj, &dby );
//      bl= _ynl( 2, x );

//      fprintf( pFile,  "%8.4f %20.8e  %20.8e  %20.8e  %20.8e  %20.8e\n",
//               x, a, b, c, fabs(1-a/b), fabs(1-c/b) );
      fprintf( pFile,  "%8.4f %20.8e  %20.8e  %20.8e\n",
                        x,    c,      b,      fabs(1-b/c) );
//      fprintf( pFileL, "%8.4f %20.8e  %20.8e  %20.8e\n", x, al, bl, fabs(1-al/bl) );
  }

//  lTime += clock();
  //fprintf( pFile, "Steed's Method    took %20.10e sec\n", lTime/(double)CLOCKS_PER_SEC );


//  lTime= -clock();
//  for( x=0.20 ; x<= 15.0 ; x += 0.2 )
//  {
//      a= bessy( 2, x );
//      b= yn( 2, x );

//      bjy( x, 2, &bj, &al, &dbj, &dby );
////      bjy( x, 2, &bj, &by, &dbj, &dby );
//      bl= _ynl( 2, x );

//      fprintf( pFile,  "%8.4f %20.8e  %20.8e  %20.8e\n", x,  a,  b, fabs(1-a/b) );
//      fprintf( pFileL, "%8.4f %20.8e  %20.8e  %20.8e\n", x, al, bl, fabs(1-al/bl) );
//  }

//  lTime += clock();
//  fprintf( pFile, "MS long double    took %20.10e sec\n", lTime/(double)CLOCKS_PER_SEC );




  fclose( pFile );
//  fclose( pFileL );
  return( 0 );
}

