/*****************************************************************************
 *                                  E R F
 *****************************************************************************
 *
 *   PROGRAM ID:        ERF.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      These routines use a Chebychev approximation to compute the error
 *      fxn and complementary error fxn.
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/




/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


// Uses chebychev approx:  fractional error <1.2e-7 everywhere!
double erfc( double x )
{
double z = ( x<0 ? -x : x );
double t = 1.0 / (1.0 + 0.5*z);

  t = t*exp(-z*z-1.26551223+t*(1.00002368+t*(0.37409196+t*(
  0.09678418+t*(-0.18628806+t*(0.27886807+t*(-1.13520398+t*(
  1.48851587+t*(-0.82215223+t*0.17087277)))))))));

  return( x<0 ? 2.0-t : t );
}



double erf( double x )
{
    return( 1. - erfc(x) );
}

