/*****************************************************************************
 *                             T S T F X N S
 *****************************************************************************
 *
 *   PROGRAM ID:        TSTFXNS.H
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:       This header file is used in conjunction with the C
 *                      source files <NLETEST.C> & <OPTTEST.C>.
 *
 *                      It is a collection of "classic", non-linear systems
 *                      of equations from the literature.
 *
 *
 *   COMPILE/LINK:      A Microsoft C 6.0 compatable compiler is needed
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



#include <math.h>
#include <float.h>
#include <stdio.h>
#include <stdlib.h>

#if defined( DOUBLE_PRECISION )
    #define float double
#endif

/* All these test functions are declared to conform to  */
/* the typedef NLFXNS in <collins.n>. However, some of  */
/* the test functions in this file are fixed dimension. */
/* These functions ignore the parameter n, as well as   */
/* any components of x and f beyond the intrinsic dim.  */



/* Global function call counter */
#if defined( DEF_EL_TSTCNT )
    long elTstCnt;
#else
    extern long elTstCnt;
#endif




// This fxn is due to Freudenstein and Roth.
// It is a fixed dim fxn, n=2.
// The solns are:
//       f.f= 0             at x= (5, 4)
//       f.f= 48.9842....   at x= (11.41..., -0.8968...)
//
// The recommended starting point is:
//       x= (0.5, -2)
void  Freud_Roth(int n, float *x, float *f);



// This fxn is due to MJD Powell.
// It is a fixed dim fxn, n=2.
// The solns are:
//       f.f= 0             at x= (1.098...e-5, 9.106...)
//
// The recommended starting point is:
//       x= (0, 1)
void  Powell2d(int n, float *x, float *f);



// I do not know who suggested this fxn.
// It is a fixed dim fxn, n=3.
// The solns are:
//       f.f= 0             at x= (1, 0, 0)
//
// The recommended starting point is:
//       x= (-1, 0, 0)
void  HelicalValley(int n, float *x, float *f);




// This fxn is due to the Research and Development Dept at Gulf Oil.
// It is a fixed dim fxn, n=3.
// The solns are:
//       f.f= 0             at x= (50, 25, 1.5)
//
// The recommended starting point is:
//       x= (5, 2.5, 0.15)
void  GulfRnD(int n, float *x, float *f);



// I do not know who suggested this fxn. (Box of Box-Keller fame?)
// It is a fixed dim fxn, n=3.
// The solns are:
//       f.f= 0             at x= (1, 10, 1)
//                     and  at x= (10, 1, -1)
//                     and  at x= (b, b, 0 ), b= arbitrary
//
// The recommended starting point is:
//       x= (0, 10, 20)
void  Box3d(int n, float *x, float *f);



// This fxn is due to MJD Powell.
// It is a fixed dim fxn, n=4.
// The solns are:
//       f.f= 0             at x= (0, 0, 0, 0)
//
// The recommended starting point is:
//       x= (3, -1, 0, 1)
void  Powell4d(int n, float *x, float *f);






// This fxn is due to HH Rosenbrock.
// n must be a multiple of 2 (ie even).
// The solns are:
//       f.f= 0             at x= (1, 1, ... , 1)
//
// The recommended starting point is:
//       x= (-1.2, 1, -1.2, 1, ... , -1.2, 1)
void  Rosenbrock(int n, float *x, float *f);



// This fxn is due to MJD Powell.
// n must be a multiple of 4.
// The solns are:
//       f.f= 0             at x= (0, 0, ... , 0)
//
// The recommended starting point is:
//       x= (3, -1, 0, 1, ... , 3, -1, 0, 1)
void  MJDPowell(int n, float *x, float *f);


// I do not know who suggested this fxn.
// There are no restrictions on n.
// The solns are:
//       f.f= 0             at x= (0, 0, ... , 0)
//
// The recommended starting point is:
//       x= (1/n, 1/n, ... , 1/n)
void  TrigFxn(int n, float *x, float *f);



// I do not know who suggested this fxn. (Brown is a pretty common name.)
// There are no restrictions on n.
// The solns are:
//       f.f= 0             at x= (a, a, ... , a), where a satisfies:  n*a^n -(n+1)*a^(n-1) +1= 0
//                                                                        a= 1 in particular
//       f.f= 1             at x= (0, 0, ... , 0, n+1)
//
// The recommended starting point is:
//       x= (1/2, 1/2, ... , 1/2)
void  Brown(int n, float *x, float *f);



// This fxn is due to JJ More', BS Garbow, & KE Hillstrom. It was in an
// article in ACM Trans. on Math. Software, Vol. 7, No. 1, March 1981.
// This article was the source for most of the functions in this module.
//
// There are no restrictions on n.
// The solns are:
//       f.f= 0             at x= (-1, -1, ... , -1))
//
// The recommended starting point is:
//       x= (1, 1, ... , 1)
void  More(int n, float *x, float *f);



