/*****************************************************************************
 *                                C S O R T
 *****************************************************************************
 *
 *   PROGRAM ID:        CSORT.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              January 11, 1995
 *
 *   DESCRIPTION:
 *
 *      This is the Combsort as described in:
 *          S Lacey & R Box, BYTE, April 1991, p315
 *
 *      It is an in-place sort that is as efficient as the Heapsort.  It shares
 *      another attractive quality of the Heapsort --- its worst case performance
 *      is not much worse than its average performance.  It is an N*log(N) method.
 *
 *      This is not true of the Quicksort, which is faster than Heapsort by a factor
 *      of 2 in the typical case (indeed in most cases), but whose worst case
 *      performance (for a list in reverse order) is dismal --- it actually becomes
 *      an N*N method like Bubblesort.
 *
 *
 *
 *   INPUT PARAMETERS:  Call csort() just as you would the ANSI C qsort().
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


void csort( char *pBase, unsigned nNum, unsigned nWidth, int (*compare)(char *p1, char *p2) )
{
int i, j, nTop, nGap= nNum;
int ii, jj, k;
char c;


  do
  {
    //nGap /= 1.3;
    nGap= (nGap*10)/13;

    switch( nGap )
    {
      case 0:  // smallest gap possible is 1
        nGap= 1;
        break;

      case 9:  // this stuff is
      case 10: // purely empirical
        nGap= 11;
        break;

      default:
        break;
    }

    jj= 0;  // assume sorted until proven otherwise
    nTop= nNum - nGap;
    for( i=0 ; i<nTop ; i++ )
    {
        j= i +nGap;
        if( compare(&pBase[i*nWidth], &pBase[j*nWidth]) > 0 )
        {
            // swap array elements
            for( ii=i*nWidth, jj=j*nWidth, k=0 ; k<nWidth ; k++ )
            {
                c= pBase[ii+k];
                pBase[ii+k]= pBase[jj+k];
                pBase[jj+k]= c;
            }
        }

    }

  } while( jj || nGap>1 );

}
