/*****************************************************************************
 *                                  N R U T I L
 *****************************************************************************
 *
 *   PROGRAM ID:        NRUTIL.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      These utility routines allocate vectors and matrices and were
 *      placed in the public domain by Numerical Recipes.
 *
 *      I have changed the matrix allocation/deallocation routines to use a
 *      single malloc() and a single free() -- I have left the integer "imatrix"
 *      routines unchanged so you have a pattern to convert back if you wish.
 *
 *      I also change from pointer+integer indexing to array-indexes.  Again, I
 *      have left the integer routines ("ivector" & "imatrix") unchanged.
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     This program is placed in the public domain and can be
 *                      used freely by anyone.
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/




/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


// Local definitions
#define NR_END 1
      // NR_END can probably be 0, but for strict ANSI compliance
      // it should be the size of the largest offset vector/matrix
      // that you plan to allocate. Most routines use either zero-
      // offset or unit-offset vectors/matrices.


void nrerror( char *sz )
{
  fprintf( stderr, "Numerical Runtime Error...\n" );
  fprintf( stderr, "%s\n", sz );
  fprintf( stderr, "...exiting to DOS.\n" );

  exit( 1 );
}


float *vector( WORD nl, WORD nh )
{
float *v;

  v= (float *)malloc( (WORD) (nh-nl+1+NR_END)*sizeof(float) );
  if( !v )
      nrerror( " vector() allocation failure" );

  return( &v[NR_END-nl] );
}

double *dvector( WORD nl, WORD nh )
{
double *v;

  v= (double *)malloc( (WORD) (nh-nl+1+NR_END)*sizeof(double) );
  if( !v )
      nrerror( " dvector() allocation failure" );

  return( &v[NR_END-nl] );
}

BYTE *bvector( WORD nl, WORD nh )
{
BYTE *v;

  v= (BYTE *)malloc( (WORD) (nh-nl+1+NR_END)*sizeof(BYTE) );
  if( !v )
      nrerror( " bvector() allocation failure" );

  return( &v[NR_END-nl] );
}


WORD *ivector( WORD nl, WORD nh )
{
WORD *v;

  v= (WORD *)malloc( (WORD) (nh-nl+1+NR_END)*sizeof(WORD) );
  if( !v )
      nrerror( " ivector() allocation failure" );

  return( v-nl+NR_END );
}

float **matrix( WORD nrl, WORD nrh, WORD ncl, WORD nch )
{
WORD i, nrow=nrh-nrl+1, ncol=nch-ncl+1;
float **m;

  // Allocate everything!
  m= (float **)malloc( (WORD) (nrow+NR_END)*sizeof(float *) +
                       (WORD) ((nrow*ncol)*sizeof(float)) );
  if( !m )
      nrerror( " matrix() allocation failure" );
  m= &m[NR_END-nrl];

  // Set first row pointer
  m[nrl]= (float *)&m[nrh+1];
  m[nrl]= &m[nrl][-ncl];

  // ....and set row pointers
  for( i=nrl+1 ; i<=nrh ; i++ )
      m[i]= &m[i-1][ncol];

  return( m );
}

double **dmatrix( WORD nrl, WORD nrh, WORD ncl, WORD nch )
{
WORD i, nrow=nrh-nrl+1, ncol=nch-ncl+1;
double **m;

  // Allocate everything!
  m= (double **)malloc( (WORD) (nrow+NR_END)*sizeof(double *) +
                        (WORD) ((nrow*ncol)*sizeof(double)) );
  if( !m )
      nrerror( " dmatrix() allocation failure" );
  m= &m[NR_END-nrl];

  // Set first row pointer
  m[nrl]= (double *)&m[nrh+1];
  m[nrl]= &m[nrl][-ncl];

  // ....and set row pointers
  for( i=nrl+1 ; i<=nrh ; i++ )
      m[i]= &m[i-1][ncol];

  return( m );
}


WORD **imatrix( WORD nrl, WORD nrh, WORD ncl, WORD nch )
{
WORD i, nrow=nrh-nrl+1, ncol=nch-ncl+1;
WORD **m;

  // Allocate pointers to rows
  m= (WORD **)malloc ( (WORD) (nrow+NR_END)*sizeof(WORD *) );
  if( !m )
      nrerror( " imatrix() allocation failure [row pointers]" );
  m += NR_END;
  m -= nrl;

  // Allocate rows in one contiguous block
  m[nrl]= (WORD *)malloc( (WORD) ((nrow*ncol+NR_END)*sizeof(WORD)) );
  if( !m[nrl] )
      nrerror( " imatrix() allocation failure [row elements]" );
  m[nrl] += NR_END;
  m[nrl] -= ncl;

  // ....and set row pointers
  for( i=nrl+1 ; i<=nrh ; i++ )
      m[i]= m[i-1] +ncol;

  return( m );
}

void free_vector( float *v, WORD nl, WORD nh )
{
   free( &v[nl-NR_END] );
}

void free_dvector( double *v, WORD nl, WORD nh )
{
   free( &v[nl-NR_END] );
}

void free_bvector( BYTE *v, WORD nl, WORD nh )
{
   free( &v[nl-NR_END] );
}

void free_ivector( WORD *v, WORD nl, WORD nh )
{
  free( (v+nl-NR_END) );
}

void free_matrix( float **m, WORD nrl, WORD nrh, WORD ncl, WORD nch )
{
  free( &m[nrl-NR_END] );
}
void free_dmatrix( double **m, WORD nrl, WORD nrh, WORD ncl, WORD nch )
{
  free( &m[nrl-NR_END] );
}

void free_imatrix( WORD **m, WORD nrl, WORD nrh, WORD ncl, WORD nch )
{
  free( (m[nrl]+ncl-NR_END) );
  free( (m+nrl-NR_END) );
}

