/*****************************************************************************
 *                                  R A N D O M
 *****************************************************************************
 *
 *   PROGRAM ID:        RANDOM.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      These routines generate random numbers by a variety of methods. Please
 *      see the individual functions headers for discussion.
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/




/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


static int  ir1= 11, jr1= 222, kr1= 3333;
static long ir2= 11L, jr2= 222L;
static float x3= 2.71;
static float fl4[55]=
{
  0.55365264f,   0.10399724f,   0.46925947f,   0.60810697f,   0.75481391f,
  0.12435142f,   0.51636797f,   0.82715213f,   0.88172346f,   0.26523313f,
  0.65979910f,   0.56424606f,   0.17593032f,   0.90091044f,   0.43373883f,
  0.58192056f,   0.81084532f,   0.79719955f,   0.06796779f,   0.55653334f,
  0.16383600f,   0.58619630f,   0.84687024f,   0.18288244f,   0.86371177f,
  0.32108563f,   0.50945848f,   0.81202340f,   0.76985008f,   0.14227940f,
  0.09666267f,   0.90354007f,   0.61291707f,   0.54486358f,   0.72929537f,
  0.07880871f,   0.78044486f,   0.73141408f,   0.68924230f,   0.74159670f,
  0.91251606f,   0.47709671f,   0.08093963f,   0.74203151f,   0.72868210f,
  0.27114138f,   0.33285773f,   0.72798687f,   0.09966461f,   0.94916403f,
  0.95656252f,   0.96859419f,   0.00573947f,   0.20262687f,   0.20095135f,
};
static long ir5= 11L, jr5= 222L;
static unsigned long ir6= 0UL;
static unsigned long l7[97]=
{
  1013904223UL,   1196435762UL,   3519870697UL,   2868466484UL,   1649599747UL,
  2670642822UL,   1476291629UL,   2748932008UL,   2180890343UL,   2498801434UL,
  3421909937UL,   3167820124UL,   2636375307UL,   3801544430UL,     28987765UL,
  2210837584UL,   3039689583UL,   1338634754UL,   1649346937UL,   2768872580UL,
  2254235155UL,   2326606934UL,   1719328701UL,   1061592568UL,     53332215UL,
  1140036074UL,   4224358465UL,   2629538988UL,   1946028059UL,    573775550UL,
  1473591045UL,     95141024UL,   1592739711UL,   1618554578UL,   4257218569UL,
  2685635028UL,   2617994019UL,    740185638UL,   4194465613UL,   2426187848UL,
   967350023UL,    366635194UL,   2557108433UL,   3503432700UL,    353185579UL,
   706247310UL,    408928405UL,   1855199472UL,   1263785871UL,   2223693730UL,
   594074265UL,    684458788UL,   3868161075UL,   1929325558UL,    166605533UL,
  2640352920UL,   1798252823UL,   2071081866UL,    171871585UL,   2087307084UL,
   698505787UL,   3647212126UL,    634580517UL,   1956956480UL,   2017242015UL,
  1181484146UL,   1221761321UL,   3441954932UL,    962199875UL,    571258310UL,
  3352760941UL,   3763818728UL,   1371701031UL,   1288172122UL,   2012225009UL,
  3960962716UL,   4082010443UL,   1249037870UL,   3840393141UL,   3947023760UL,
  3754607535UL,   2143919426UL,   1774599097UL,   1818014148UL,    136057427UL,
  2672030614UL,    798365181UL,   2575687480UL,    732141879UL,   2569577770UL,
  1449661057UL,   3853535724UL,   1541586011UL,   2732705278UL,   3432461637UL,
   320021984UL,   2287935423UL
};

/* static const float pi= 3.141592653589793; */
static const float pi= M_PI;
// static float ff= 1.0/4.294967296e9;
static float ff= 1.0/0xFFFFFFFF;




void seed1( float i, float j, float k )
{
    ir1= *( (unsigned *)&i ) % 30269;
    jr1= *( (unsigned *)&j ) % 30307;
    kr1= *( (unsigned *)&k ) % 30323;


    if( ir1 == 0 )
        ir1= 11;
    if( jr1 == 0 )
        jr1 = 222;
    if( kr1 == 0 )
        kr1 = 333;
}

float rand1( void )
{
/*
    This is a linear congruential pseudorandom number generator
    proposed by BA Wichmann & ID Hill in BYTE, March 1987, p. 127.
    It is very well tested by the authors.  It has a period of
    6.95e12.  It uses only integer math, so it's fairly fast.
    Another interesting point, it was developed especially for
    16 bit computers, ie 2^15 = 32000 or so
*/

    float t;

/* first generator  */
       ir1= 171 * (ir1%177) - 2 * (ir1/177);
       if ( ir1<0 )    ir1 += 30269;

/* second generator */
       jr1= 172 * (jr1%176) - 35 * (jr1/176);
       if ( jr1<0 )    jr1 += 30307;

/* third generator  */
       kr1= 170 * (kr1%178) - 63 * (kr1/178);
       if ( kr1<0 )    kr1 += 30323;

/* combine them to give really random value */
       t= ir1/30269.0 +jr1/30307.0 +kr1/30323.0;

    return ( t - (int)t );
}



void seed2( float i, float j, float dummy )
{
    ir2= *( (unsigned long *)&i ) % 2147483563UL;
    jr2= *( (unsigned long *)&j ) % 2147483399UL;

    if( ir2 == 0L )
        ir2= 11L;
    if( jr2 == 0L )
        jr2 = 222L;
}

float rand2( void )
{
/*
    This is another LC generator.  This one has a period of 2.31e18
    and was adopted by Bratley, Fox, & Schrage -- or so I hear.
    This one was developed for 32 bit computers, ie 2^31 = 2147483000
    or thereabouts.
*/

    long i;

    i= ir2 / 53668L;
    ir2= 40014L * (ir2-i*53668L) - i*12211L;
    if ( ir2<0L )    ir2 += 2147483563L;

    i= jr2 / 52774L;
    jr2= 40692L * (jr2-i*52774L) - i*3791L;
    if (jr2<0L )    jr2 += 2147483399L;

    i= ir2 - jr2;
    if ( i<1L )    i += 2147483562L;

    return ( i * 4.656613e-10 );
}



void seed3( float z, float dummy1, float dummy2 )
{
     x3= fabs(z);
     if ( x3>3e6 )  x3=127.0;
}

float rand3( void )
{
/*
    I found this random number generator in a book by Alan Miller.
    The only difference is that he uses an exponent of 5.04, whereas
    I just use 5 -- it runs faster than using pow().  I used an inline
    version of this generator to seed Knuth's generator below!
*/

    float y;

    y= x3 + pi;
    y= y*y*y*y*y;
    x3= y - floor(y);
    return ( x3 );
}



void seed4( float z, float dummy1, float dummy2 )
{
    float y;
    int i;

     z= fabs(z);
     if ( z>3e6 )  z=127.0;

    for (i=1 ; i<=55 ; i++ )
    {
        y= z + pi;
        y= y*y*y*y*y;
        z= y - floor(y);
        fl4[i]= z;
    }
}

float rand4( void )
{
/*
    This is probably the best of the random number generators. It is
    not an LC generator; it is in fact called a Fibonacci generator.
    It only requires one addition to generate a number.

         X[k+1] = X[k-j] + X[k-n],   (j,n) are an "index pair"

    Knuth says that the period of these generators is  (2^k -1)2^m
        where k= the larger of the index pair
        and   m= #bits in the array's base data type, eg 32-bits for float.

    This method does require the storage of a matrix of floats.  Not much
    is known about the theoretical properties (other than the fact that it
    has an extremely long period), but empirical results are quite good...
    at least according to DE Knuth.  Besides (24,55) other index pairs
    are widely used, most notably (103,250), (33,97), and (5,17).
*/
    static int i= 0;

    i= ++i%55;
    fl4[i] += fl4[(i+31)%55];   // 31 is (55-24)
    if( fl4[i] > 1.0f )
        fl4[i] -= 1.0f;

    return( fl4[i] );
}



void seed5( float i, float j, float dummy )
{
    ir5= *( (unsigned long *)&i ) % 2147483647UL;
    jr5= *( (unsigned long *)&j ) % 536870911UL;;

    if( ir5 == 0L )
        ir5= 11L;
    if( jr5 == 0L )
        jr5 = 222L;
}

float rand5( void )
{
/*
    This is called a combined Tausworthe generator.  I found it
    described in an article, ACM Transactions on Modelling and
    Computer Simulation, Vol. 1, No. 2, April 1991.  I didn't study
    the article much, except to see the claim that this is a fast
    generator with good stastical properties.
*/

static long  q1=    13L;
static long  q2=    2L;
static long  s1=    12L;
static long  s2=    17L;
static long  p1ms1= 19L;
static long  p2ms2= 12L;
static long  p1mp2= 2L;
static long  mask1= 2147483647L;
static long  mask2= 536870911L;
long b;

    b= ((ir5<<q1) ^ ir5) & mask1;
    ir5= ((ir5<<s1) ^ (b>>p1ms1)) & mask1;
    b= ((jr5<<q2) ^ jr5) & mask2;
    jr5= ((jr5<<s2) ^ (b>>p2ms2)) & mask2;

    return ( (ir5 ^ (jr5<<p1mp2)) / (float)mask1 );
}


void seed6( float i, float dummy1, float dummy2 )
{
    ir6= *( (unsigned long *)&i );
}

float rand6( void )
{
/*
    This is another LC generator.  It uses the built in wrap-around
    modulus in the UNSIGNED LONG type which make this one of the fastest
    generators in this module -- faster than rand2() or rand5().

    This generator was in an article by WH Press & SA Teukolsky in
    Computers in Physics, Sept/Oct 1992, p. 522.
*/

static unsigned long a= 1664525UL;
static unsigned long c= 1013904223UL;

    ir6= a*ir6 +c;
    return ( ir6 * ff );
}

void seed7( float i, float dummy1, float dummy2 )
{
static unsigned long a= 1664525UL;
static unsigned long c= 1013904223UL;
unsigned long ir6;
int j;

    ir6= *( (unsigned long *)&i );
    for( j=0 ; j<97 ; j++ )
        l7[j]=  ir6= a*ir6 +c;
}

float rand7( void )
{
/*
    This generator combines the UNSIGNED LONG trick with Knuth's
    Fibonacci method.  It is the fastest generator, slightly edging
    out rand6().  This time I used the pair (33,97) which has a period
    of  2^129 = 6.8e38.

    Another index pair that is particularly well-known in physics circles
    is (103,250), "the r250 generator."  They need an index pair this large
    because they use a trick to speed up the generator even more!! Instead
    of integer addition, they XOR the two numbers. This can be 3 or 4 times
    faster because you don't have to do the binary carries, but at the
    same time it reduces the period of the generator.

    I recently saw (somewhere) a generator using the pair (607,273),
    which implies a period of 2^639 = 2.3e192 (wow!).  But the storage
    starts getting significant (3 KB).

    If you're out for pure speed, eliminate the square brackets and
    use pointer notation: l7[i] --> *(l7+i).  Personally, I think the
    bracket notation is much more readable for complicated expressions
    ( besides a good compiler will make the changes for you! ).
*/
static int i= 0;

   i= ++i%97;
   l7[i] += l7[(i+64)%97];  // 64 is just (97-33)
   return( l7[i]*ff );
}

// This is the XOR version of rand7()
// It wasn't any faster than rand7()

/*
void seed8( float i, float dummy1, float dummy2 )
{
static unsigned long a= 1664525UL;
static unsigned long c= 1013904223UL;
unsigned long ir6;
int j;

    ir6= *( (unsigned long *)&i );
    for( j=0 ; j<97 ; j++ )
        l8[j]=  ir6= a*ir6 +c;
}
float rand8( void )
{
static int i= 0;

   i= ++i%97;
   l8[i] ^= l8[(i+64)%97];
//   *(l8+i) ^= *(l8+(i+64)%97);
//   return( *(l8+i)*ff );
   return( l8[i]*ff );
}
*/
