/*****************************************************************************
 *                             R A T P O W
 *****************************************************************************
 *
 *   PROGRAM ID:        RATPOW.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *
 *   DATE:              January 21, 1994
 *
 *   DESCRIPTION:
 *
 *      Given two integers bases (i,k), this program finds two integer
 *      exponents (e,g)  such that  i^e = k^g.  It make use of the fp2ratio.c
 *      routine which is from The C Users Journal, Feb 1993, p. 42
 *
 *      There is an short, interesting article by Mark Gingrich
 *      that preceeds this algorithm.
 *
 *
 *   INPUT PARAMETERS:  Floating point number to be approximated
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     This software is public domain.
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <math.h>


#define  MAX_SIG_DIGITS   9

typedef unsigned long Ulong;
typedef long double Ldouble;
void fp2ratio( double x, int sign );



int main( int iArgc, char *pszArgv[] )
{
int sign;
Ulong lu1, lu2;
double x1, x2, x;


  if( iArgc != 3 )
  {
      fprintf( stderr, "usage: ratpow  int1  int2\n" );
      exit( EXIT_FAILURE );  // THIS MACRO DEFINED IN MS C6.0 LIBRARIES
  }
  else
  {
//      lu1= strtoul( pszArgv[1], (char**)NULL, 10 );
//      lu2= strtoul( pszArgv[2], (char**)NULL, 10 );
//      x= log(lu1) / log(lu2);

      x1= strtod( pszArgv[1], (char**)NULL );
      x2= strtod( pszArgv[2], (char**)NULL );
      x= log(x1) / log(x2);

  }

  // Handle zero and negative arguments
  if( x < 0.0 )
  {
      sign= -1;
      x= -x;
  }
  else if( x == 0.0 )
  {
      puts( "\n0:\n" );
      puts( "          0 / 1           Exactly!" );
      exit( EXIT_SUCCESS );  // THIS MACRO DEFINED IN MS C6.0 LIBRARIES
  }
  else
  {
      sign= 1;
  }


  // Check for out-of-range arguments
  if( x >= pow(10.0, (double)MAX_SIG_DIGITS) )
  {
      fprintf( stderr, "%s: Magnitude is too large.\n", pszArgv[1] );
      exit( EXIT_FAILURE );  // THIS MACRO DEFINED IN MS C6.0 LIBRARIES
  }
  else if( x<= pow(10.0, (double)-MAX_SIG_DIGITS) / 2.0 )
  {
      fprintf( stderr, "%s: Magnitude is too small.\n", pszArgv[1] );
      exit( EXIT_FAILURE );  // THIS MACRO DEFINED IN MS C6.0 LIBRARIES
  }

  fp2ratio( x, sign );


  exit( EXIT_SUCCESS );
}






void fp2ratio( double x, int sign )
{
int   i, dec_digits, j, jMinus1, jMinus2, nArraySize;
Ulong n0, n, d0, d, temp;
Ulong p[]= { 0, 1 };
Ulong q[]= { 1, 0 };
Ldouble percent_err;


  nArraySize= sizeof(p)/sizeof(p[0]);

  // Determine the argument's radix-10 ratio
  d0= (Ulong)floor( 1.0 +log10(x) );
  d0= (Ulong)pow( 10.0, MAX_SIG_DIGITS -d0 );
  n0= (Ulong)(x*d0 +0.5);
  printf( "\n%.*g:\n\n", MAX_SIG_DIGITS, (double)n0 / (double)d0 );


  // Iteratively determine integer ratios
  for( i=2, d= d0, n= n0 ;
       j= jMinus2= i%nArraySize, jMinus1= (i-1)%nArraySize, 1 ;
       i++, temp= d, d= n%d, n= temp )
  {
      p[j]= n / d * p[jMinus1] + p[jMinus2];
      q[j]= n / d * q[jMinus1] + q[jMinus2];

      // Print ratios
      if( p[j] != 0 )
      {
          printf( "%11ld / %-10lu", sign*p[j], q[j] );
          if( n%d == 0 )
          {
              printf( "    Exactly!\n" );
              break;
          }

          // Compute percent error, taking care to avoid loss of
          // significant figures when subtracting nearly equal
          // values:
          //
          //   percent Error =
          //
          //      100 * ( p[j] *d0 - q[j] * n0 )
          //     --------------------------------
          //                  q[j] * n0
          //
          //
          percent_err  = (Ldouble)p[j] * (Ldouble)d0;
          percent_err -= (Ldouble)q[j] * (Ldouble)n0;
          percent_err *= 100.0L;
          percent_err /= (Ldouble)q[j] * (Ldouble)n0;

          dec_digits=
            ( fabs( (double)percent_err ) >= 10.0 ) ?
            1 : 1 + (int)(fabs( floor(
            log10( fabs( (double)percent_err )))));

          printf( "%+*.*Lf%%\n", dec_digits + 6,
                  dec_digits, percent_err );
      }
  }
}
