/*****************************************************************************
 *                                  S T I F F O D E
 *****************************************************************************
 *
 *   PROGRAM ID:        STIFFODE.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      These program tests the stiff and non-stiff ode solvers.
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/





#include <collins.h>

static unsigned long ulFxnCount;


static void f( int n, float t, float y[], float dy_dt[] )
{
// The following are stiff:
/*
  dy_dt[1]= -0.013*y[1] -1000.*y[1]*y[3];
  dy_dt[2]= -2500.*y[2]*y[3];
  dy_dt[3]= -0.013*y[1] -1000.*y[1]*y[3] -2500.*y[2]*y[3];
*/

// The following are NON-stiff:
  dy_dt[1]= y[2]*y[3];
  dy_dt[2]= -y[1]*y[3];
  dy_dt[3]= -0.51*y[1]*y[2];

  ulFxnCount++;
}



int main()
{
float dy_dy[]= { 0,0,0,0 };   // no ICs specified for dy_dt
float y[]=     { 0,1,1,0 };   // Initial Conditions on y
float t0= 0.0;                // IC on t
float tend= 50.0;             // go until this occurs
float eps= 1e-4;              // tolerance
float h= 2.9e-4;              // initial step size to try

  ulFxnCount= 0UL;

//  stiff( 3, f, y, t0, tend, eps, h, 0, 0 );
//  tainmin( 3, f, y, t0, tend, eps, h, 0, 0 );
//  inveuler( 3, f, y, t0, tend, eps, h, 0, 0 );
  usmani( 3, f, y, t0, tend, eps, h, 0, 0 );


  printf( "The solution is y(50)= <%e, %e, %e> \n", y[1], y[2], y[3] );
  printf( "It took %lu steps \n", enStep );
  printf( "   and  %lu f-evals \n", ulFxnCount );


  return( 0 );
}






