/*****************************************************************************
 *                                  N L E 1 D
 *****************************************************************************
 *
 *   PROGRAM ID:        NLE1D.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      The following is the Van Wijngaarden-Dekker-Brent method of solving
 *      a single nonlinear equation as reported in Numerical Recipes.
 *
 *      It is a combination of root bracketing, bisection, and inverse
 *      quadratic interpolation.
 *
 *      x1<x2 must bracket a root on input.
 *
 *
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: Number of iterations required for solution
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


/* Local prototypes & globals */
#define ITMAX  100
#define EPS 3.0e-8


float zbrent( FUNC1d f, float x1, float x2, float tol )
{
int iter;
float a=x1, b= x2, c, d, e, min1, min2;
float fa= f(a), fb= f(b), fc;
float p, q, r, s, tol1, xm;

   if( fb*fa > 0 )
      nrerror("Unbracketed root sent to zbrent()");

   fc= fb;

   for( iter=1 ; iter <= ITMAX ; iter++ )
   {
      if( fb*fc > 0 )
      {
         c= a; fc= fa;
         e= d= b-a;
      }

      if( fabs(fc) < fabs(fb) )
      {
         a= b;     b= c;    c= a;
         fa= fb;  fb= fc;  fc= fa;
      }

      tol1= 2*EPS*fabs(b) + tol/2;
      xm= (c-b)/2;

      if( fabs(xm) <= tol1  ||  fb == 0 )
         return( b );

      if( fabs(e) >= tol1  &&  fabs(fa) > fabs(fb) )
      {
         s= fb/fa;

         if( a==c )
         {
            p= 2*xm*s;
            q= 1-s;
         }
         else
         {
            q= fa/fc;
            r= fb/fc;
            p= s*( 2*xm*q*(q-r) - (b-a)*(r-1) );
            q= (q-1)*(r-1)*(s-1);
         }

         if( p > 0 )
            q= -q;

         p= fabs(p);
         min1= 3*xm*q -fabs(tol1*q);
         min2= fabs(e*q);

         if( 2*p < (min1<min2 ? min1:min2) )
         {
            e= d;
            d= p/q;
         }
         else
         {
            d= xm;
            e= d;
         }
      }
      else
      {
         d= xm;
         e= d;
      }

      a= b;
      fa= fb;

      if( fabs(d) > tol1 )
         b += d;
      else
         b += (xm>0 ? fabs(tol1) : -fabs(tol1) );

      fb= f(b);
   }

   nrerror("zbrent() failed -- max iterations");
}

