/*****************************************************************************
 *                                  N L E B B
 *****************************************************************************
 *
 *   PROGRAM ID:        NLEBB.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      According to Borwein & Barzilai their gradient method can
 *      be applied directly to NLEs. See the BANDB.C module in the
 *      OPTIM subdirectory.
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: Number of iterations required for solution
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


// locally global variables
static NLFXNS fxn;

static int nLoops;
static float *f;

// local functions and macros
#define TINY  1.0e-10
static void nle( int n, float x[], float tol, float df[], float dx[] );




/*
   ******* HERE IS THE ENTRY POINT INTO THIS MODULE *********
*/

int nlebb( int n, float x[], NLFXNS fUser, float tol )
/*
   This subroutine is just a dummy to allocate the (3*n)
   dimensional workspace w which is needed by the following
   subroutines. This is a holdover from the FORTRAN roots of
   this library. In FORTRAN, you can't dynamically allocate
   an array, so the calling program must create a "work array"
   of a certain size. Then you use clever function parameter
   mapping to divvy up this array into all of the vectors and
   matrices needed in the library module.

   This subroutine also assigns user defined functions to
   (locally) global pointers, so we don't have to keep passing
   them to each lower level.
*/
{
float **w;
  w= matrix( 1, 2, 1, n );
  f= vector( 1, n );
  fxn= fUser;

  if( tol <= 0.0 )
      tol= 1.0e-6;

  nle( n, x, tol, w[1], w[2] );

  free_matrix( w, 1, 2, 1, n );
  free_vector( f, 1, n );

  return( nLoops );
}








static void nle( int n, float x[], float tol, float df[], float dx[] )
{
int i, nLoopMax;
int bConverged;
float dfdf, dxdf, ff, ffLast;
float Cf;

// initializations
    nLoopMax= max( 4*n, 1000 );

    fxn( n, x, f );
    for( ff=0, i=1 ; i<=n ; i++ )
    {
        ff += f[i]*f[i];
        df[i]= f[i];
    }
    ffLast= ff;

    Cf= 1.0 / sqrt(1+ff);
    bConverged= 0;
    if( ff<= TINY )   bConverged= 2;



// main loop
    for( nLoops=1 ; bConverged<2 && nLoops<=nLoopMax ; nLoops++ )
    {
        printf( "%5d\r", nLoops );
        for( i=1 ; i<=n ; i++ )
        {
             dx[i]=  -Cf*f[i];
             x[i] += dx[i];
        }
        fxn( n, x, f );
        for( ff=0, i=1 ; i<=n ; i++ )
        {
            ff += f[i]*f[i];
        }



// exit test(s)
        if( 2*fabs(ff-ffLast) <= tol*(fabs(ff)+fabs(ffLast)+TINY) )
            bConverged++;
        else if( 2*fabs(ff-ffLast) <= tol*(2+fabs(ff)+fabs(ffLast)+TINY) )
            bConverged++;
        else if( ff<= TINY )
            bConverged= 2;
        else
        {
            bConverged= 0;

// oh well, keep going
            ffLast= ff;

// calculate dot products
            dfdf= dxdf= 0;
            for( i=1 ; i<=n ; i++ )
            {
                 df[i]= f[i] -df[i];  /* recall df contains last f */

                 dfdf += df[i]*df[i];
                 dxdf += dx[i]*df[i];
            }

// Borwein-Barzilai coeffs for the vector update formula
            Cf= dxdf / dfdf;
// Since values can change wildly, put safeguards on the coeff
            Cf /= sqrt(1+ff);

// Dump current f --> df
            for( i=1 ; i<=n ; i++ )
                 df[i]= f[i];


        } // endif-elseif-else

    } // end for(not converged)


  if( bConverged < 2 )
      nLoops= -nLoops;
}