/*****************************************************************************
 *                                  R I D D E R S
 *****************************************************************************
 *
 *   PROGRAM ID:        RIDDERS.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              October 11, 1994
 *
 *   DESCRIPTION:
 *
 *      The following is CJF Ridders' method of solving a single nonlinear
 *      equation as reported in:  IEEE Trans Circuits & Systems, (1979) p.979
 *
 *      The idea is very simple, and apparently very effective.
 *      quadratic interpolation.
 *
 *      x1<x2 must bracket a root on input.
 *
 *
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: Number of iterations required for solution
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


/* Local prototypes & globals */
#define ITMAX  100
#define EPS 3.0e-8
#define SIGN(a,b)  (b>0?fabs(a):-fabs(a))


float ridder( FUNC1d f, float x1, float x2, float tol )
{
int nIter, nMaxIter= 100;
float xlo=x1, xhi= x2, xmid, xtemp;
float flo,    fhi,     fmid, ftemp;

  flo= f(xlo);
  fhi= f(xhi);

  if( fhi*flo > 0 )
      nrerror("Unbracketed root sent to ridder()");

  for( nIter=0 ; nIter<nMaxIter ; nIter++ )
  {
      xmid= (xhi+xlo) * 0.5f;
      fmid= f(xmid);

      ftemp= sqrt( fmid*fmid - fhi*flo );
      if( ftemp == 0 )
          return( xmid );

      xtemp= 1.0f;
      if( flo < fhi )
          xtemp= -xtemp;

      xtemp= xmid + (xmid-xlo)*(xtemp*fmid)/ftemp;
      ftemp= f(xtemp);

      if( fabs(xtemp-xmid) < tol || ftemp == 0 )
          return( xtemp );

      if( SIGN(fmid,ftemp) != fmid )
      {
          xlo= xmid;
          flo= fmid;
          xhi= xtemp;
          fhi= ftemp;
      }
      else if( SIGN(flo,ftemp) != flo )
      {
          xhi= xtemp;
          fhi= ftemp;
      }
      else if( SIGN(fhi,ftemp) != fhi )
      {
          xlo= xtemp;
          flo= ftemp;
      }
  }

  nrerror("ridder() failed -- max iterations");
}
