/*****************************************************************************
 *                                  E U L E R
 *****************************************************************************
 *
 *   PROGRAM ID:        EULER.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This subroutine is a simple Euler ODE solver.
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>




/* Here's the entry point for this module */
void euler( int n, DERIV fxn, float y[], float x1, float x2,
            float eps, float h, int nPts, char *szFile )
{
int i;
float x, *dy;

  dy= vector(1,n);

  for( enStep=0, x=x1 ; x<x2 ; x += h )
  {
      enStep++;
// /****/printf( "Euler: x=%e, y=(%e %e), dy=(%e %e)\n",  x,  y[1],y[2],  dy[1],dy[2] );

      fxn( n, x, y, dy );
      for( i=1 ; i<=n ; i++ )
          y[i] += h*dy[i];
  }

  h= x2-x;
  x= x2;
  fxn( n, x, y, dy );
  for( i=1 ; i<=n ; i++ )
      y[i] += h*dy[i];

  free_vector( dy, 1, n );
}

