/*****************************************************************************
 *                                  P R E Y 2 3
 *****************************************************************************
 *
 *   PROGRAM ID:        PREY23.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This program runs a predator-prey simulation using the Runge-
 *      Kutta-Fehlberg algorithm of orders 2 and 3.
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



#include <collins.h>

/* local declarations */
static void deriv( int n, float t, float *p, float *dp );


/*
*/

int main( int nArgc, char *pszArgv[] )
{

     const int n= 2;
     float *p;
     float e, tend;
     float tstart= 0.0;
     float h, hmin;
     char szDataFile[40];
     char szFormat[]= "\nn= %d, \np[1]= %g, \np[2]= %g, \ntstart= %g, "
                      "\ntend= %g, \ne= %g, \nh= %g\n";

     p= vector( 1, n );

     printf( "Enter the initial populations (prey,predator)\n" );
     scanf( " %g %g", &p[1], &p[2] );

     printf( "Enter the fractional tolerance on the solution\n" );
     scanf( " %g", &e );

     printf( "Enter the time for the simulation to end\n" );
     scanf( " %g", &tend );

     printf( "Enter a filename where intermediate (x,y) values will be stored\n" );
     scanf( " %s", szDataFile );

     h= e*tend;

     printf( szFormat, n, p[1], p[2], tstart, tend, e, h, 50, szDataFile );

//      euler( n, deriv, p, tstart, tend, e, h, 50, szDataFile );
      rk23( n, deriv, p, tstart, tend, e, h, 50, szDataFile );
//      rk4( n, deriv, p, tstart, tend, e, h, 50, szDataFile );
//      rk44( n, deriv, p, tstart, tend, e, h, 50, szDataFile );
//      rk45( n, deriv, p, tstart, tend, e, h, 50, szDataFile );
//      bsode( n, deriv, p, tstart, tend, e, h, 50, szDataFile );
//      stiff( n, deriv, p, tstart, tend, e, h, 50, szDataFile );

     free_vector( p, 1, n );

     return( 0 );
}






static void deriv( int n, float t, float *p, float *dp )
{
/*  These are the model equations  */

     const float a= 1.0;
     const float g= 1.0;
     const float b= 0.01;
     const float e= 0.001;

     dp[1]= p[1] * (a-b*p[2]);
     dp[2]= p[2] * (e*p[1]-g);
}




