/*****************************************************************************
 *                                  H O M O
 *****************************************************************************
 *
 *   PROGRAM ID:        HOMO.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This module contains a couple of homotopy (Newton & Fixed Point )
 *      NLE solvers.  Both homotopies use Barwein & Barzilai and use a simple,
 *      discrete stepping algorithm.
 *
 *
 *      The name HomoNewt= Homotopy, Newton
 *      the name HomoFixP= Homotopy, Fixed Point
 *
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: Number of iterations required for solution
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
*/

/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of a subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>

// typedef  float (*OPTFXN)(int n, float x[]);
// typedef  void (*GRADF)(int n, float x[], float F0, float g[]);

// locally global variables
static OPTFXN F;
static GRADF grad;
static int nLoops;
static float u;   // homotopy parameter
static float *g0;

// local functions and macros
static void gradF( int n, float x[], float F0, float g[] );
static void gradHomo( int n, float x[], float F0, float g[] );



/*
   ********* HERE IS THE ENTRY POINT TO THIS MODULE *************
*/
int homopt( int n, float x[], OPTFXN FXN, GRADF DFXN, float tol )
{
int   i, imax, k;
float du, F0;

/*
------------------------VARIABLE KEY--------------------------------
   n       length of independent (vector) variable
   x       independent variable-- on input it contains
           the initial guess;  on output, the soln
   s       stores initial vector needed for homotopy fxn
   u       scalar needed for homotopy fxn
  du       change in u for each step

---------------------------------------------------------------------
*/
  g0= vector( 1, n );

  F= FXN;
  if( DFXN )
      grad= DFXN;
  else
      grad= gradF;

  F0= F( n, x );
  grad( n, x, F0, g0 );

  if ( tol <= 0.0 )   tol= 1.0e-6;


  // Extract stepping criteria from x[0]
  imax= (int)x[0];
  if( imax < 1 )
      imax= 1;
  du= 1.0/imax;

///****/printf( "homo: start x= (%e %e)\n", x[1], x[2] );
///****/printf( "\t s= (%e %e)\n", s[1], s[2] );

// main loop
  for( u=du, i=1; i<imax; u+=du, i++ )
  {
      bandb( n, x, F, gradHomo, tol );
///****/printf( "\t step=%d, u=%e, x= (%e %e)\n", i, u, x[1], x[2] );
  }

// final correction before returning
//  u= 1.0;
//  bandb( n, x, F, gradHomo, tol );
  bandb( n, x, F, grad, tol );

  nLoops= imax;

  free_vector( g0, 1, n );
  return( nLoops );
}


static void gradHomo( int n, float x[], float F0, float g[] )
{
int i;

  grad( n, x, F0, g );
  for( i=1 ; i<=n ; i++ )
      g[i] += (u-1) * g0[i];
}



static void gradF( int n, float x[], float F0, float g[] )
{
int i;
float a, t, e= G_EPS;

    for ( i=1 ; i<=n ; i++ )
    {
        a= fabs( x[i] );
        if ( a< 1.0 )  a= 1.0;
        a= a*e;
        t= x[i];
        x[i]= t+a;
        g[i]= ( F(n,x) -F0 ) / a;
        x[i]= t;
    }
}
