/*****************************************************************************
 *                                  L I N M I N 2
 *****************************************************************************
 *
 *   PROGRAM ID:        LINMIN2.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This routine does line searches, which are an integral part of most
 *      multi-dimensional optimizations.
 *
 *      This is a cut-back search of my own devising.
 *
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


/* locally global variables */
static OPTFXN F;
static GRADF grad;



/* local macros & functions */
static void gradF( int n, float x[], float F0, float g[] )
{
    int i;
    float a;
    float e= G_EPS;

    for ( i=1 ; i<=n ; i++ )
    {
        a= fabs( x[i] );
        if( a< 1.0 )  a= 1.0;
        a= a*e;
        x[i] += a;
        g[i]= ( F(n,x) -F0 ) / a;
        x[i] -= a;
    }
}

static float F1dim( int n, float x[], float s[], float t )
{
      int k;
      float a;

      for ( k=1 ; k<=n ; k++ )
          x[k]= x[k] +t*s[k];
      a= F( n, x );
      for ( k=1 ; k<=n ; k++ )
          x[k]= x[k] -t*s[k];
      return ( a );
}


/* *********** HERE IS THE ENTRY POINT FOR THIS MODULE ************* */

void linmin2( int n, float x0[], OPTFXN FXN, GRADF DFXN, float s[], float *F0 )
/*
   This subroutine starts at the point x0 and moves in the
   search direction s so as to minimize the objective function
   F.  On return, x0 is updated to x0+dx which minimizes F,
   s is set to the actual step (dx), and F0 is F(x+dx).
*/
{
const float alpha= 1e-4;
const float beta= 0.8;

int   i;
int   bDone= 0;
float *x, *g;
float t= 1.0, tmin= 1e-3;
float Fvalue, sg;

  F= FXN;
  if( DFXN )
      grad= DFXN;
  else
      grad= gradF;


  x= vector( 1, n );
  g= vector( 1, n );

/* initialize */
  grad( n, x0, F0[0], g );
  for( sg=0, i=1 ; i<=n ; i++ )
  {
       sg += s[i]*g[i];
       x[i]= x0[i];
  }
  Fvalue= F1dim( n, x, s, t );

/* main body */
  while(  Fvalue > F0[0]  &&  t > tmin  )
  {
      t *= 0.5;
      Fvalue= F1dim( n, x, s, t );
  }

  if( t < tmin )
  {
      t= -1.0;
      while(  Fvalue > F0[0]  &&  (-t) > tmin  )
      {
          t *= 0.5;
          Fvalue= F1dim( n, x, s, t );
      }
  }
  else if(  Fvalue > F0[0] +alpha*t*sg )
      t *= 0.5;



/* grab values to pass back and clean up */
  F0[0]= Fvalue;
  for( i=1 ; i<=n ; i++ )
  {
       x0[i]= x[i];
       s[i] *= t;
  }
// /****/printf( "linmin2: t= %e\n", t );
  free_vector( x, 1, n );
  free_vector( g, 1, n );
}

