/*****************************************************************************
 *                                  L I N M I N 3
 *****************************************************************************
 *
 *   PROGRAM ID:        LINMIN3.C
 *
 *   AUTHOR:            Glynne Casteel
 *                      GlynneC@ix.netcom.com
 *
 *                      This software IS copyrighted, BUT you may use it freely
 *                      PROVIDED THAT you send me a copy of any commercial or
 *                      shareware product that incorporates this code.
 *
 *
 *   DATE:              June 11, 1994
 *
 *   DESCRIPTION:
 *
 *      This routine does line searches, which are an integral part of most
 *      multi-dimensional optimizations.
 *
 *      This routine was outlined in an article by JE Dennis & RB Schnabel:
 *
 *
 *
 *   INPUT PARAMETERS:  None
 *
 *   RETURN/EXIT VALUE: None
 *
 *   INPUT FILES:       None
 *
 *   OUTPUT FILES:      None
 *
 *   COMPILE/LINK:      Microsoft C 6.0 compatable compiler
 *
 *
 *   SPECIAL NOTES:     None
 *
 *****************************************************************************
 *                           MODIFICATION LOG
 *
 *   DATE          NAME                DESCRIPTION
 *   ------------  ------------------  ----------------------------------
 *
 ******************************************************************************/



/*
   When the COLLINS_EXTERNS flag is turned on it puts the following
   types of definitions into the source:

    extern unsigned long enStep;

   In the application the flag isn't on so declaration occurs.
   These variables are used to communicate progress of the subroutine
   to the application.
*/
#define COLLINS_EXTERNS   1
#include <collins.h>


/* locally global variables */
static OPTFXN F;
static GRADF grad;



/* local macros & functions */
#define SHFT(a,b,c,d)  (a)=(b),(b)=(c),(c)=(d)
#define SIGN(a,b)      ((b)> 0.0 ? fabs(a) : -fabs(a))
static void gradF( int n, float x[], float F0, float g[] )
{
    int i;
    float a;
    float e= G_EPS;

    for ( i=1 ; i<=n ; i++ )
    {
        a= fabs( x[i] );
        if( a< 1.0 )  a= 1.0;
        a= a*e;
        x[i] += a;
        g[i]= ( F(n,x) -F0 ) / a;
        x[i] -= a;
    }
}

static float F1dim( int n, float x[], float s[], float t )
{
      int k;
      float a;

      for ( k=1 ; k<=n ; k++ )
          x[k]= x[k] +t*s[k];
      a= F( n, x );
      for ( k=1 ; k<=n ; k++ )
          x[k]= x[k] -t*s[k];
      return ( a );
}


/* *********** HERE IS THE ENTRY POINT FOR THIS MODULE ************* */

void linmin3( int n, float x0[], OPTFXN FXN, GRADF DFXN, float s[], float *F0 )
/*
   This subroutine starts at the point x0 and moves in the
   search direction s so as to minimize the objective function
   F.  On return, x0 is updated to x0+dx which minimizes F,
   s is set to the actual step (dx), and F0 is F(x+dx).
*/
{
#define alpha    0.0001
#define beta     0.8
#define infinity 1.0e33

int   i;
int   bDone= 0;
float *g, *g0, *glow;
float *x;
float t= 1.0, tlow= 0.0, tup= infinity;
float delta, temp;
float Fvalue, Fup, Flow, sg, sg0, sglow;

    F= FXN;
    if( DFXN )
        grad= DFXN;
    else
        grad= gradF;


    x= vector( 1, n );
    g0= vector( 1, n );
    g= vector( 1, n );
    glow= vector( 1, n );

    grad( n, x0, F0[0], g0 );
    for( sg0=0, i=1 ; i<=n ; i++ )
    {
         sg0 += s[i]*g0[i];
         g[i]= g0[i];
         glow[i]= g0[i];
         x[i]= x0[i];
    }
    Fup= Flow= F0[0];

/* start of main body */
    do
    {
      Fvalue= F1dim( n, x0, s, t );
      if( Fvalue < F0[0] + alpha*t*sg0 )
      {
          for( i=1 ; i<=n ; i++ )
               x[i]= x0[i] +t*s[i];
          grad( n, x, Fvalue, g );
          for( sg=0, i=1 ; i<=n ; i++ )
               sg += s[i]*g[i];

          if( sg >= beta*sg0 )
              bDone= 1;
          else
          {
              tlow= t;
              if( tup> 0.99*infinity )
                  t += t;
              else
              {
                  Flow= F1dim( n, x0, s, tlow );
                  for( i=1 ; i<=n ; i++ )
                       x[i]= x0[i] +tlow*s[i];
                  grad( n, x, Flow, glow );
                  for( sglow=0, i=1 ; i<=n ; i++ )
                       sglow += s[i]*glow[i];

                  delta= tup -tlow;
                  temp= Fup -Flow -delta*sglow;
                  temp= tlow- 0.5*delta*delta*sglow/temp;
                  t= min( max( temp, tlow+0.2*delta ), tup-0.2*delta );
              }
          }
      }
      else
      {
          tup= t;
          if( tlow< 1.0e-7 )
          {
              temp= Fvalue -F0[0] -t*sg;
              temp= -0.5*t*t*sg0 / temp;
              t= max( temp, 0.1*t );
          }
          else
          {
              Flow= F1dim( n, x0, s, tlow );
              for( i=1 ; i<=n ; i++ )
                   x[i]= x0[i] +tlow*s[i];
              grad( n, x, Flow, glow );
              for( sglow=0, i=1 ; i<=n ; i++ )
                   sglow += s[i]*glow[i];

              delta= tup -tlow;
              temp= Fup -Flow -delta*sglow;
              temp= tlow- 0.5*delta*delta*sglow/temp;
              t= min( max( temp, tlow+0.2*delta ), tup-0.2*delta );
          }

      }
    }  while( !bDone );


    F0[0]= Fvalue;
    for( i=1 ; i<=n ; i++ )
    {
         x0[i]= x[i];
         s[i] *= t;
    }

    free_vector( x, 1, n );
    free_vector( g0, 1, n );
    free_vector( g, 1, n );
    free_vector( glow, 1, n );
}

